

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCheckDDBOnlineStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCheckDDBOnlineStatus.sp,v $ $Id: MMCheckDDBOnlineStatus.sp,v 1.1.2.8 2018/09/23 00:23:36 pnara Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMCheckDDBOnlineStatus <<<'

IF EXISTS (select * from sysobjects where name='MMCheckDDBOnlineStatus')
	drop procedure MMCheckDDBOnlineStatus
IF EXISTS (select * from GxQscripts where name='MMCheckDDBOnlineStatus')
	delete from GxQscripts where name = 'MMCheckDDBOnlineStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckDDBOnlineStatus')
	delete from GXDBVersions where aliasname = 'MMCheckDDBOnlineStatus'
GO
print '... Creating Procedure: MMCheckDDBOnlineStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCheckDDBOnlineStatus
  @i_SIDBStoreId INTEGER,
  @i_copyId INTEGER,
  @i_CommCellId INTEGER
AS
  DECLARE @o_StoreId INT
  DECLARE @o_dedupeFlags INT
DECLARE @errorCode INTEGER = 0
DECLARE @l_MMConfig INTEGER = 0
DECLARE @l_StoreStatus INTEGER = 0
DECLARE @l_dedupeFlags INTEGER = 0
DECLARE @l_SIDBFlags INTEGER = 0
	SET @l_MMConfig = ISNULL((SELECT value from MMConfigs WITH (READUNCOMMITTED) where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_BACKUP_DURING_DDB_RECONSTRUCTION'), 0)
	SELECT	@l_SIDBFlags = Flags
	FROM	idxSIDBStore WITH (READUNCOMMITTED)
	WHERE	SIDBStoreId = @i_SIDBStoreId
	SELECT	@l_dedupeFlags = dedupeFlags
	FROM	archGroupCopy WITH (READUNCOMMITTED)
	WHERE	id = @i_copyId
    -- When reach this point, if option for "allow backup" is off, reservation logic should already take care everything.
    -- Job should always run in dedupe mode in this case. StoreStatus will remain as it is.
    -- When the "allow backup" if on, we do the following check in addtion to reseiliency setting.
    IF @l_MMConfig > 0
    BEGIN
        DECLARE @corruptLimit INT = ISNULL((SELECT AT.percentCorruptLimit FROM archGroupCopy AGC WITH (READUNCOMMITTED)
                                            INNER JOIN archTask AT WITH (READUNCOMMITTED) ON AGC.sealStoreTaskId = AT.id
											INNER JOIN archCopySIDBStore C2S WITH(READUNCOMMITTED) ON AGC.id = C2S.copyId
WHERE C2S.SIDBStoreId = @i_SIDBStoreId AND AGC.dedupeFlags & 134217728 = 0), 0)
        DECLARE @noOfCorruptAndOfflineStore INT = 0
        SELECT @noOfCorruptAndOfflineStore = Count (distinct idxss.SubStoreId)
        FROM    MMHost host with (READUNCOMMITTED), IdxCache idxc with (READUNCOMMITTED),
    			IdxAccessPath idxa with (READUNCOMMITTED), IdxSIDBSubStore idxss with (READUNCOMMITTED)
    	WHERE  idxss.SIDBStoreId = @i_SIDBStoreId
    	AND		idxss.CommCellId = @i_CommCellId
 		AND		idxss.ClientId = host.ClientId
    	AND		idxss.IdxCacheId = idxc.IdxCacheId
    	AND		idxss.IdxAccessPathId = idxa.IdxAccessPathId
 		AND	(
    			-- not corrupted
(idxss.Status = 1)
			-- ddb move is not running (dont why all the comments here say inverse of what it checks)
OR (idxss.Flags & 1024 = 1024)
    			-- Media Agent online
    			OR (host.mmhostsoftstate = 0 OR host.mmhostenabled = 0)
    			-- Index Cache online
    			OR (idxc.Enabled = 0 OR idxc.SoftState = 0)
    			-- Access Path online and enabled
    			OR (idxa.Enabled = 0 OR idxa.SoftState = 0)
    		)
        SET @l_StoreStatus = (SELECT CASE
                                -- if resiliency is on, and corrupt and offline store not greater than the setting, we allow dedupe job.
WHEN (@l_dedupeFlags & 8 > 0 AND @noOfCorruptAndOfflineStore <= @corruptLimit)
                                THEN 0
                                -- if resiliency is on, and corrupt and offline store greater than the setting, we allow regular job.
WHEN (@l_dedupeFlags & 8 > 0 AND @noOfCorruptAndOfflineStore > @corruptLimit)
                                THEN 1
                                -- if resiliency is off, and there is at least one corrupt or offline store, then backup must be regular.
WHEN (@l_dedupeFlags & 8 = 0 AND @noOfCorruptAndOfflineStore > 0)
                                THEN 1
                                ELSE 0
                                END)
        -- One additional case is that there is no online access path (not corrupted).
        -- It can happen when resiliency setting is greater than total number of substores.
        IF NOT EXISTS (
			select idxss.subStoreId
					from	MMHost host with (READUNCOMMITTED), IdxCache idxc with (READUNCOMMITTED),
							IdxAccessPath idxa with (READUNCOMMITTED), IdxSIDBSubStore idxss with (READUNCOMMITTED)
					where idxss.SIDBStoreId = @i_SIDBStoreId
					and		idxss.CommCellId = @i_commCellId
					-- not corrupted
and		idxss.Status != 1
					-- ddb move is not running
and		(idxss.Flags & 1024 = 0)
					-- Media Agent online
			and		idxss.ClientId = host.ClientId
			and		(host.mmhostsoftstate > 0 and host.mmhostenabled > 0)
					-- Index Cache online
			and		idxss.IdxCacheId = idxc.IdxCacheId
			and		( idxc.Enabled > 0 and idxc.SoftState > 0)
					-- Access Path online
			and		idxss.IdxAccessPathId = idxa.IdxAccessPathId
			and		(idxa.Enabled > 0 and idxa.SoftState > 0)
        )
        BEGIN
            SET @l_StoreStatus = 1
        END
		-- Also check if the store is in maintainenance mode. MR: 143540
IF (@l_SIDBFlags & 16777216) > 0
		BEGIN
			SET @l_StoreStatus = 1
		END
		--Another case is when DDB Upgrade is going on. But we have taken the store off maintenance so that recon can proceed.
		--To maintain consistency of behaviour during partial upgrades, disregard resiliency.
		ELSE IF EXISTS
		(
		select idxss.subStoreId
		from IdxSIDBSubStore idxss with (READUNCOMMITTED)
		join IdxSIDBStore st with (READUNCOMMITTED) on idxss.SIDBStoreId = st.SIDBStoreId
		where idxss.SIDBStoreId = @i_SIDBStoreId
		and		idxss.CommCellid = @i_commCellId
		and	((idxss.Version > st.Version)
or  (idxss.Flags & 8192 <> 0
and st.Flags & 8192 = 0))
		)
		BEGIN
			SET @l_StoreStatus = 1
		END
        IF (@l_StoreStatus > 0)
SET @l_dedupeFlags = @l_dedupeFlags | 1048576
    END -- @l_MMConfig > 0
CV_EXIT:
	SELECT @i_SIDBStoreId, @l_dedupeFlags
GO

IF EXISTS (select * from GxQscripts where name = 'MMCheckDDBOnlineStatus')
	delete from GxQscripts where name = 'MMCheckDDBOnlineStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckDDBOnlineStatus')
	delete from GXDBVersions where aliasname = 'MMCheckDDBOnlineStatus'
GO

insert into GXDBVersions values(2, 'MMCheckDDBOnlineStatus',  '00010001000200080000', 'MMCheckDDBOnlineStatus', '00010001000200080000')
GO

