

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCheckCloudVMCanPowerOFF.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCheckCloudVMCanPowerOFF.sp,v $ $Id: MMCheckCloudVMCanPowerOFF.sp,v 1.1.2.14 2018/10/25 02:24:39 chandru Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMCheckCloudVMCanPowerOFF"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
This will check idle time and return VM can power off.
1- VM can power off
0- VM can not power off
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCheckCloudVMCanPowerOFF')
BEGIN
	print '>>> Drop Stored Procedure: MMCheckCloudVMCanPowerOFF <<<'
	drop procedure MMCheckCloudVMCanPowerOFF
END
IF EXISTS (select * from GxQscripts where name='MMCheckCloudVMCanPowerOFF')
	delete from GxQscripts where name = 'MMCheckCloudVMCanPowerOFF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckCloudVMCanPowerOFF')
	delete from GXDBVersions where aliasname = 'MMCheckCloudVMCanPowerOFF'
GO
print '... Creating Procedure: MMCheckCloudVMCanPowerOFF'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCheckCloudVMCanPowerOFF
  @i_HostId Integer
AS
  DECLARE @o_retrunCode INTEGER
  DECLARE @o_minutesToPowerOff INTEGER
DECLARE @returnCode INTEGER = 0
DECLARE @minutesToPowerOff INTEGER = 0
-- Check idle time
DECLARE @MaxDPMALastBkpTime BIGINT = 0
DECLARE @MaxAuxCopyEndTime BIGINT = 0
DECLARE @MaxAdminEndTime BIGINT = 0
DECLARE @OperationLastAccessTime BIGINT = 0
DECLARE @LastAccessTime BIGINT = 0
DECLARE @LastPoweredOnTime BIGINT = 0
DECLARE @LastPMEnabledMDTime BIGINT = 0
DECLARE @MaxDDBMALastBkpTime BIGINT = 0
DECLARE @LastPowerStatusSyncTime BIGINT = 0
DECLARE @ProxyBkpEndTime BIGINT = 0
DECLARE @MaxJobTime BIGINT = 0
DECLARE @IdleTimeInMinTillNow INTEGER = 0
DECLARE @IdleTimeInMinSetByUser INTEGER = 0
DECLARE @isPowerMgmtEnabled INTEGER = 0
DECLARE @isVMRunning INTEGER = 0
SELECT @IdleTimeInMinSetByUser = value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_MA_IDLE_TIME'
IF EXISTS(SELECT 1 FROM MMHost WITH(NOLOCK) WHERE ClientId = @i_HostId AND (Attribute & 32768) = 32768)
BEGIN
	SET @isPowerMgmtEnabled = 1
END
IF EXISTS( SELECT 1 FROM MMPowerMgmtHost WITH (NOLOCK) WHERE HostId = @i_HostId AND PowerStatus IN (2, 3) )
BEGIN
	SET @isVMRunning = 1
END
IF @isPowerMgmtEnabled = 1 AND @isVMRunning = 1
BEGIN
	DECLARE @TimeBefore24Hrs BIGINT = 0
	SET @TimeBefore24Hrs = (dbo.GetUnixTime(GETUTCDATE()) - (24 * 60 * 60)) -- Max idle time is 24hours
	 IF OBJECT_ID('tempdb.dbo.#tmpJobInfoTbl') IS NOT NULL
		DROP TABLE #tmpJobInfoTbl
	CREATE TABLE #tmpJobInfoTbl (JobId INTEGER, commCellId INTEGER, appId INTEGER, appTypeId INTEGER, instanceId INTEGER, JobTime BIGINT, isCompletedJob INTEGER, primary key (JobId,commCellId))
	-- completed Jobs
	INSERT INTO #tmpJobInfoTbl
	SELECT DISTINCT JMBKP.jobId, JMBkp.commCellId, JMBKP.appId,JMBKP.appType, 0, JMBKP.servEndDate, 1 FROM JMBkpStats JMBKP WITH (NOLOCK)
	WHERE JMBKP.servEndDate > @TimeBefore24Hrs
	-- getting last time MA used as Datapath MA
	SELECT @MaxDPMALastBkpTime = ISNULL(MAX(JMBKP.JobTime),0) FROM #tmpJobInfoTbl JMBKP
	INNER JOIN JMJobResourceHistory JMH WITH (NOLOCK) ON JMH.jobId = JMBKP.jobId AND JMH.commCellId = JMBKP.commCellId AND JMH.ClientId = @i_HostId
	-- getting last time MA used as DDB MA
	SELECT @MaxDDBMALastBkpTime = ISNULL(MAX(JM.JobTime),0) FROM #tmpJobInfoTbl JM
	INNER JOIN archFile AF WITH (NOLOCK) ON AF.jobId= JM.JobId AND AF.commCellId = JM.commCellId
	INNER JOIN archFileCopyDedup AFD WITH (NOLOCK) ON AFD.archFileId = AF.id AND AF.commCellId = AFD.commCellId
	INNER JOIN IdxSIDBSUBStore SUB WITH (NOLOCK) ON AFD.SIDBStoreId = SUB.SIDBStoreId AND AFD.commCellId = SUB.commCellId AND SUB.clientId  = @i_HostId
	 -- suspend, waiting, pending jobs
	INSERT INTO #tmpJobInfoTbl
	SELECT DISTINCT JM.jobId,JM.commcellId, BKP.applicationId, 0, 0, JM.lastStartOrRun, 0 FROM JMJobInfo JM WITH (NOLOCK)
	INNER JOIN JMBkpJobInfo BKP WITH (NOLOCK) ON JM.JobId = BKP.JobId AND JM.commcellId = BKP.commcellId AND JM.state <> 1 AND JM.lastStartOrRun > @TimeBefore24Hrs
	LEFT OUTER JOIN #tmpJobInfoTbl TMP ON TMP.JobId = BKP.JobId AND TMP.commCellId = BKP.commcellId
	WHERE TMP.JobId IS NULL AND TMP.commCellId IS NULL
	-- getting last time MA used as DDB MA
	SELECT @MaxDDBMALastBkpTime = CASE WHEN MAX(TMP.JobTime) > @MaxDDBMALastBkpTime THEN MAX(TMP.JobTime) ELSE @MaxDDBMALastBkpTime END
	FROM #tmpJobInfoTbl TMP
	INNER JOIN APP_Application APP ON TMP.appId = APP.id AND TMP.isCompletedJob = 0
	INNER JOIN archGroupCopy AGC ON (AGC.archGroupId = APP.dataArchGrpID OR AGC.archGroupId = logArchGrpID)
INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON CS.copyID = AGC.id AND ((CS.Flags & 4) > 0)
	INNER JOIN IdxSIDBSubStore SUB ON CS.SIDBStoreId = SUB.SIDBStoreId AND SUB.ClientId = @i_HostId
	-- Handling suspended, pending and waiting jobs for Datapath MA
	SELECT @MaxDPMALastBkpTime = CASE WHEN MAX(JMH.ReleaseTime) > @MaxDPMALastBkpTime THEN MAX(JMH.ReleaseTime) ELSE @MaxDPMALastBkpTime END
	FROM JMJobResourceHistory JMH WITH (NOLOCK)
	INNER JOIN #tmpJobInfoTbl TMP ON TMP.jobId = JMH.jobId AND JMH.commCellId = TMP.commCellId AND TMP.isCompletedJob = 0
	WHERE JMH.ClientId = @i_HostId
	UPDATE TMP
	SET TMP.instanceId = APP.instance,
	TMP.appTypeId = APP.appTypeId
	FROM #tmpJobInfoTbl TMP
	INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.id = TMP.appId AND APP.appTypeId = 106
	-- getting last time MA used as Proxy
	-- subclient level
	SELECT @ProxyBkpEndTime = ISNULL(MAX(TMP.JobTime),0)
	FROM #tmpJobInfoTbl TMP
	INNER JOIN APP_subClientProp SPROP WITH (NOLOCK) ON SPROP.componentNameId = TMP.appId AND SPROP.attrName = 'Virtual Server Proxy Client List' and SPROP.modified = 0
AND SPROP.attrVal like '%clientId="' + CAST(@i_HostId AS VARCHAR(20)) + '"%' AND TMP.appTypeId = 106
	SELECT @ProxyBkpEndTime = CASE WHEN MAX(TMP.JobTime) > @ProxyBkpEndTime THEN MAX(TMP.JobTime) ELSE @ProxyBkpEndTime END
	FROM #tmpJobInfoTbl TMP
	INNER JOIN APP_subClientProp SPROP WITH (NOLOCK) ON SPROP.componentNameId = TMP.appId AND SPROP.attrName = 'Virtual Server Proxy Client List' and SPROP.modified = 0
	INNER JOIN APP_ClientGroupAssoc CLA WITH (NOLOCK) ON CLA.clientId = @i_HostId
WHERE SPROP.attrVal like '%clientGroupId="' + CAST(CLA.clientGroupId AS VARCHAR(20)) + '"%' AND TMP.appTypeId = 106
	--instance level
	SELECT @ProxyBkpEndTime = CASE WHEN MAX(TMP.JobTime) > @ProxyBkpEndTime THEN MAX(TMP.JobTime) ELSE @ProxyBkpEndTime END
	FROM #tmpJobInfoTbl TMP
	INNER JOIN APP_InstanceProp SPROP WITH (NOLOCK) ON SPROP.componentNameId = TMP.instanceId AND SPROP.attrName = 'Vs Member Servers' and SPROP.modified = 0
AND SPROP.attrVal like '%clientId="' + CAST(@i_HostId AS VARCHAR(20)) + '"%' AND TMP.appTypeId = 106
	SELECT @ProxyBkpEndTime = CASE WHEN MAX(TMP.JobTime) > @ProxyBkpEndTime THEN MAX(TMP.JobTime) ELSE @ProxyBkpEndTime END
	FROM #tmpJobInfoTbl TMP
	INNER JOIN APP_InstanceProp SPROP WITH (NOLOCK) ON SPROP.componentNameId = TMP.instanceId AND SPROP.attrName = 'Vs Member Servers' and SPROP.modified = 0
	INNER JOIN APP_ClientGroupAssoc CLA WITH (NOLOCK) ON CLA.clientId = @i_HostId
WHERE SPROP.attrVal like '%clientGroupId="' + CAST(CLA.clientGroupId AS VARCHAR(20)) + '"%' AND TMP.appTypeId = 106
	--Auxcopy job
	IF OBJECT_ID('tempdb.dbo.#CloudVMMgmtAuxCopyJobsList') IS NOT NULL
	DROP TABLE #CloudVMMgmtAuxCopyJobsList
	CREATE TABLE #CloudVMMgmtAuxCopyJobsList(JobId INTEGER, commCellId INTEGER)
	-- old style aux copy source and destination VMs, dashcopy destination VMs
	INSERT INTO #CloudVMMgmtAuxCopyJobsList
	SELECT DISTINCT jobId, commCellId FROM JMJobResourceHistory WITH (NOLOCK) WHERE ClientId = @i_HostId AND ReleaseTime > @TimeBefore24Hrs
	-- dash copy source VM
	INSERT INTO #CloudVMMgmtAuxCopyJobsList
	SELECT DISTINCT ArchSS.JobId, ArchSS.CommCellId FROM ArchJobStreamStatus ArchSS WITH (NOLOCK)
	LEFT OUTER JOIN #CloudVMMgmtAuxCopyJobsList TMP ON TMP.JobId = ArchSS.JobId AND TMP.commCellId = ArchSS.CommCellId AND ArchSS.SrcMAId = @i_HostId
	WHERE TMP.JobId IS NULL
	SELECT @MaxAuxCopyEndTime = MAX(servEnd) FROM JMAdminJobStatsTable JM WITH (NOLOCK)
	INNER JOIN #CloudVMMgmtAuxCopyJobsList TMP ON TMP.JobId = JM.JobId AND JM.commCellId = TMP.commCellId AND JM.opType IN (104,13) -- Auxcopy And Dash Copy
	IF OBJECT_ID('tempdb.dbo.#CloudVMMgmtAuxCopyJobsList') IS NOT NULL
	DROP TABLE #CloudVMMgmtAuxCopyJobsList
	--Get Job end time based on secondary table
	SELECT @MaxJobTime = ISNULL(MAX(JM.servEndDate),0) FROM MMPowerMgmtJobToVMMap VM WITH (NOLOCK)
INNER JOIN JMBkpStats JM WITH (NOLOCK) ON JM.jobId = VM.EntityId AND JM.commCellId = VM.EntityCommCellId AND VM.EntityType = 1 AND VM.HostId = @i_HostId
	SELECT @MaxJobTime = CASE WHEN MAX(JM.servEndTime) > @MaxJobTime THEN MAX(JM.servEndTime) ELSE @MaxJobTime END
	FROM MMPowerMgmtJobToVMMap VM WITH (NOLOCK)
INNER JOIN JMRestoreStats JM WITH (NOLOCK) ON JM.jobId = VM.EntityId AND JM.commCellId = VM.EntityCommCellId AND VM.EntityType = 1 AND VM.HostId = @i_HostId
	SELECT @MaxJobTime = CASE WHEN MAX(JM.servEnd) > @MaxJobTime THEN  MAX(JM.servEnd) ELSE @MaxJobTime END
	FROM MMPowerMgmtJobToVMMap VM WITH (NOLOCK)
INNER JOIN JMAdminJobStatsTable JM WITH (NOLOCK) ON JM.jobId = VM.EntityId AND JM.commCellId = VM.EntityCommCellId AND VM.EntityType = 1 AND VM.HostId = @i_HostId
	-- Get Powered On time
SELECT TOP 1 @LastPoweredOnTime = LastUpdateTime FROM MMVMPowerMgmtReq WITH (NOLOCK) WHERE HostId = @i_HostId AND RequestStatus = 3 order by LastUpdateTime desc
	SELECT @OperationLastAccessTime = 0  -- This will use for get last access time of MA for non job activities(Library configuration and deconfiuration)
	-- Getting power management enabled time
	SELECT @LastPMEnabledMDTime = LastPowerMgmtUpdateTime FROM MMPowerMgmtHost PH WITH (NOLOCK) WHERE PH.HostId = @i_HostId AND PH.isEnabled = 1
	-- Getting Power status sync time
SELECT @LastPowerStatusSyncTime = LastAccessTime FROM MMPowerMgmtHost PH WITH (NOLOCK) WHERE PH.HostId = @i_HostId AND PH.isEnabled = 1 AND PH.PowerStatus IN (2, 3)
	--Finding which is latest
	SELECT @LastAccessTime = MAX(time) FROM (VALUES(@MaxDPMALastBkpTime), (@MaxAuxCopyEndTime), (@OperationLastAccessTime), (@MaxDDBMALastBkpTime), (@LastPoweredOnTime), (@LastPowerStatusSyncTime), (@LastPMEnabledMDTime), (@ProxyBkpEndTime), (@MaxJobTime)) AS value(time)
	IF @LastAccessTime > 0
	SELECT @IdleTimeInMinTillNow = ((dbo.GetUnixTime(GetUTCDate()) - @LastAccessTime) / 60)
	IF @IdleTimeInMinTillNow >= @IdleTimeInMinSetByUser
	BEGIN
		SET @returnCode = 1
	END
	ELSE
	BEGIN
		SET @returnCode = 0
		SET @minutesToPowerOff = @IdleTimeInMinSetByUser - @IdleTimeInMinTillNow
	END
END
RETURN_EXIT:
SELECT  @returnCode, @minutesToPowerOff
IF OBJECT_ID('tempdb.dbo.#tmpJobInfoTbl') IS NOT NULL
		DROP TABLE #tmpJobInfoTbl
GO

IF EXISTS (select * from GxQscripts where name = 'MMCheckCloudVMCanPowerOFF')
	delete from GxQscripts where name = 'MMCheckCloudVMCanPowerOFF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckCloudVMCanPowerOFF')
	delete from GXDBVersions where aliasname = 'MMCheckCloudVMCanPowerOFF'
GO

insert into GXDBVersions values(2, 'MMCheckCloudVMCanPowerOFF',  '00010001000200140000', 'MMCheckCloudVMCanPowerOFF', '00010001000200140000')
GO

