

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCheckClientStatusForSecureErase.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCheckClientStatusForSecureErase.sp,v $ $Id: MMCheckClientStatusForSecureErase.sp,v 1.1.2.5 2018/10/25 02:24:36 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCheckClientStatusForSecureErase')
BEGIN
	print '>>> Drop Stored Procedure: MMCheckClientStatusForSecureErase <<<'
	drop procedure MMCheckClientStatusForSecureErase
END
IF EXISTS (select * from GxQscripts where name='MMCheckClientStatusForSecureErase')
	delete from GxQscripts where name = 'MMCheckClientStatusForSecureErase'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckClientStatusForSecureErase')
	delete from GXDBVersions where aliasname = 'MMCheckClientStatusForSecureErase'
GO
print '... Creating Procedure: MMCheckClientStatusForSecureErase'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCheckClientStatusForSecureErase
  @i_Id INTEGER,
  @i_inputType INTEGER
-- inputType = 0 means clientId
-- inputType = 1 means clientGroupId
AS
  DECLARE @o_clientId INT
  DECLARE @o_clientName NVARCHAR(512)
  DECLARE @o_pendingData INT
  DECLARE @o_mediaAgentId INT
  DECLARE @o_mediaAgentName NVARCHAR(512)
  DECLARE @o_mountPathName NVARCHAR(1024)
  DECLARE @o_deviceName NVARCHAR(128)
  DECLARE @o_folder VARCHAR(1024)
DECLARE @errorCode INTEGER = 0
if object_id('tempdb.dbo.#tblClient') is not null DROP TABLE #tblClient
CREATE TABLE #tblClient
        (ClientGroupId INT, ClientId INT, ClientName NVARCHAR(512), pendingPrunableData INT)
if object_id('tempdb.dbo.#tblSPCopy') is not null DROP TABLE #tblSPCopy
CREATE TABLE #tblSPCopy
        (ClientId INT, archGroupId INT, copyId INT, SIDBStoreId INT)
IF  @i_Id IS NULL OR @i_Id = 0
BEGIN
    PRINT 'Incorrect Id Input'
    RETURN -1
END
-- Step 1. : Get all the clients we are working with.
IF @i_inputType = 0
BEGIN
	INSERT INTO #tblClient
	SELECT 0, C.id, C.name, 0
	FROM APP_Client C WITH (READUNCOMMITTED)
	WHERE C.id = @i_Id
END
ELSE IF @i_inputType = 1
BEGIN
	INSERT INTO #tblClient
	SELECT  @i_Id, C.id, C.name, 0
	FROM    APP_Client C WITH (READUNCOMMITTED), APP_ClientGroupAssoc A WITH (READUNCOMMITTED)
	WHERE   C.id = A.clientId AND A.clientGroupId = @i_Id
END
-- Step 2. : Get all the storage policies / copies which are being used by the subclients on these clients.
INSERT INTO #tblSPCopy
SELECT T.ClientId, AG.id, AGC.id, CS.SIDBStoreId
FROM #tblClient T, APP_Application A WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED),
		archGroupCopy AGC WITH (READUNCOMMITTED) INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON AGC.id = CS.copyId
WHERE T.ClientId = A.clientId
AND (A.dataArchGrpID = AG.id OR A.logArchGrpID = AG.id)
AND AG.id = AGC.archGroupId
AND AGC.type IN (1, 2)
AND (AGC.flags & 524288) = 0
AND ((CS.Flags & 4) > 0)
-- Step 3. : Check if any data to be pruned for the above list of copies in MMDeletedAF
UPDATE TC
SET pendingPrunableData = 1
FROM #tblClient TC, #tblSPCopy TSP, MMDeletedAF MMDAF WITH (READUNCOMMITTED)
WHERE TC.ClientId = TSP.ClientId
AND TSP.copyId = MMDAF.copyId OR (TSP.SIDBStoreId = MMDAF.SIDBStoreId AND TSP.SIDBStoreId > 0)
-- Step 4. : Check if any zeroref (Dedup data only) for the above list of copies / stores / all partitions of the stores.
;WITH LatestStoreDataPicker (SIDBStoreId, SubStoreId, ZeroRef, rn)
AS
(
SELECT I.SIDBStoreId, I.SubStoreId, I.ZeroRefCount, row_number() over (partition by I.SIDBStoreId, I.SubStoreId ORDER BY I.ModifiedTime DESC) as rn
    FROM #tblSPCopy T, IdxSIDBUsageHistory I WITH (READUNCOMMITTED)
    WHERE T.SIDBStoreId = I.SIDBStoreId
)
UPDATE TC
SET pendingPrunableData = 1
FROM #tblClient TC, #tblSPCopy TSP, LatestStoreDataPicker P
WHERE TC.ClientId = TSP.ClientId AND TSP.SIDBStoreId = P.SIDBStoreId
AND P.rn = 1
AND P.ZeroRef > 0
AND TC.pendingPrunableData = 0
-- Step 5. : Get all the mountPaths for these copies along with clientId.
SELECT DISTINCT TC.ClientId, TC.ClientName, TC.pendingPrunableData, DC.ClientId, APPC.name, MP.MountPathName, D.AliasName, DC.Folder
FROM #tblClient TC, #tblSPCopy TSP, MMDataPath DP WITH (READUNCOMMITTED),
MMDrivePool DRP WITH (READUNCOMMITTED), MMMountPath MP WITH (READUNCOMMITTED),
MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED), MMDevice D WITH (READUNCOMMITTED), MMDeviceController DC WITH (READUNCOMMITTED),
APP_Client APPC WITH (READUNCOMMITTED)
WHERE TC.ClientId = TSP.ClientId
AND TSP.CopyId = DP.CopyId
AND DP.DrivePoolId = DRP.DrivePoolId
AND DRP.MasterPoolId = MP.MasterPoolId
AND MP.MountPathId = MPSD.MountPathId
AND MPSD.DeviceId = D.DeviceId
AND D.DeviceId = DC.DeviceId
AND DC.ClientId = APPC.Id
AND DC.DeviceAccessType & (16|32|128) = 0
AND MP.MountPathTypeId <> 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
CV_EXIT:
if object_id('tempdb.dbo.#tblClient') is not null DROP TABLE #tblClient
if object_id('tempdb.dbo.#tblSPCopy') is not null DROP TABLE #tblSPCopy
GO

IF EXISTS (select * from GxQscripts where name = 'MMCheckClientStatusForSecureErase')
	delete from GxQscripts where name = 'MMCheckClientStatusForSecureErase'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckClientStatusForSecureErase')
	delete from GXDBVersions where aliasname = 'MMCheckClientStatusForSecureErase'
GO

insert into GXDBVersions values(2, 'MMCheckClientStatusForSecureErase',  '00010001000200050000', 'MMCheckClientStatusForSecureErase', '00010001000200050000')
GO

