

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCheckAndTweakDDBPruning.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCheckAndTweakDDBPruning.sp,v $ $Id: MMCheckAndTweakDDBPruning.sp,v 1.1.2.9 2019/09/20 15:01:13 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCheckAndTweakDDBPruning')
BEGIN
	print '>>> Drop Stored Procedure: MMCheckAndTweakDDBPruning <<<'
	drop procedure MMCheckAndTweakDDBPruning
END
IF EXISTS (select * from GxQscripts where name='MMCheckAndTweakDDBPruning')
	delete from GxQscripts where name = 'MMCheckAndTweakDDBPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckAndTweakDDBPruning')
	delete from GXDBVersions where aliasname = 'MMCheckAndTweakDDBPruning'
GO
print '... Creating Procedure: MMCheckAndTweakDDBPruning'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMCheckAndTweakDDBPruning
  @i_CommCellId integer,
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
SET NOCOUNT ON
BEGIN TRANSACTION;
BEGIN TRY
	declare			@errCode integer
	set @errCode = 0
	declare			@spName varchar(1024)
	declare			@spArgs varchar(max)
	declare			@procId integer
	declare			@lastAttemptTime bigint
	declare			@lastRunOutput varchar(max)
	-- This table is to track what settings are changed as part of the DDB prune tweaking
	DECLARE @TblSettingMAMap table
	(
		MAId INT,
		MinPruneRequests INT,
		MaxPendingAfilesToPrune INT
	)
	DECLARE @maSettingMap      XML
	DECLARE @dedupBatchSetting INT
	DECLARE @nonDedupBatchSetting INT
	-- hide under config hook
	IF NOT EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MM_CONFIG_ENABLE_CHECKTWEAK_DDBPRUNING' AND value > 0)
		goto proc_exit
	set @spName = OBJECT_NAME (@@PROCID)
	set @spArgs = CONVERT(varchar,@i_CommCellId) +','+ CONVERT(varchar, @i_reserveParam)
	set @procId = isnull (checksum(@spName, @spArgs), 0)
	select @lastAttemptTime = ISNULL(lastAttemptTime, -1),
			@lastRunOutput = ISNULL(lastRunOut, '')
	from MMProcsToRun with (readuncommitted) where ProcId = @procId
	set @lastRunOutput = ( case when (@lastRunOutput = '') then '' else (LEFT(@lastRunOutput, LEN(@lastRunOutput) - 1)) end ) -- remove the last comma
	--
	-- Is it already time for me to run?
	--
	DECLARE			@currentTime INT = dbo.getUnixTime(GETUTCDATE())
	-- TBD: Need a config hook interval for this tweak
	declare			@intervalForTweakDDBPruningSeconds int = 0
set @intervalForTweakDDBPruningSeconds = (ISNULL((select value from MMConfigs with (readuncommitted) where name = 'MM_CONFIG_CHECKTWEAK_DDBPRUNING_INTERVAL_MINS'), 1440)) * 60
	if ( (@lastAttemptTime = -1) OR ( (@currentTime - @intervalForTweakDDBPruningSeconds) <= @lastAttemptTime) )
	begin
		-- nope
		goto proc_exit
	end
	else
	-- Update the attempt time before starting the main logic in the proc.. if any failure, it wont be tried again till interval has passed
	begin
		update MMProcsToRun
		set lastAttemptTime = @currentTime
		where ProcId = @procId
	end
	-- STEP 1:  Get the previous settings made
SET @maSettingMap = ISNULL((SELECT stringVal FROM MMEntityProp WITH (READUNCOMMITTED) WHERE EntityType = 12 AND propertyName = 'DDBMAPruneSettingMap'), '')
	INSERT INTO @TblSettingMAMap
	SELECT  T.c.value('@maId', 'int'), T.c.value('@minPruneReq', 'int'), T.c.value('@maxPendAFToPrune', 'int')
	FROM    @maSettingMap.nodes('/r/h') T(c)
SET @dedupBatchSetting = ISNULL((SELECT intVal FROM MMEntityProp WITH (READUNCOMMITTED) WHERE EntityType = 13 AND propertyName = 'DedupPruningBatchSize'), 0)
SET @nonDedupBatchSetting = ISNULL((SELECT intVal FROM MMEntityProp WITH (READUNCOMMITTED) WHERE EntityType = 13 AND propertyName = 'NonDedupPruningBatchSize'), 0)
	--
	-- Use this currentRunOutput variable to set a string in the mmprocstorun table after SP finishes so that
	-- next run of this can either undo the damage done in previous run or act according to what was done last
	--
	declare			@curRunOutput varchar(1024)
	declare			@listOfMAs varchar(1024)
	set @listOfMAs = ''
	--
	-- Hooks (TBD: have reg key strings be defined in cvpi header file and replace all uses with define instead)
	--
	declare			@RegKey_DDBMAKeyMinPruneRequests nvarchar (128)
	set @RegKey_DDBMAKeyMinPruneRequests = N'SIDBMinPruneRequests'
	declare			@RegKeyVal_DDBMAKeyMinPruneRequests nvarchar(32)
	set @RegKeyVal_DDBMAKeyMinPruneRequests = N'5'
	declare			@RegKey_DDBMaxPendingAfilesToPrune nvarchar(128)
	set @RegKey_DDBMaxPendingAfilesToPrune = N'SIDBMaxPendingAfilesToPrune'
	declare			@RegKeyVal_DDBMaxPendingAfilesToPrune nvarchar(32)
	set @RegKeyVal_DDBMaxPendingAfilesToPrune = N'20000'
	declare			@RegKey_DDBMaxPendingAfilesToPruneDefault	INT  = 5000
	declare			@RegKey_DDBMAKeyMinPruneRequestDefault		INT  = 1
	declare			@DMMAsForDDB table (MAClientId int)
	declare			@DDBMAsForDDB table (DDBMAClientId int)
	declare			@SettingsDDBMAs table (ClientId int, minPruneReqVal int, minPruneToUpdate int, maxPendAFVal int, maxPendAFToUpdate int)
	declare			@DeletedAFDDBs table (SIDBStoreId int, SIDBStoreName nvarchar(256), AGId integer, AGName nvarchar(256), CopyId integer, CopyName nvarchar (256), DelAfCount int)
	declare			@ZeroRefDDBs table (SIDBStoreId int, SubStoreId int, SIDBStoreName nvarchar(256), AGId int, AGName nvarchar(256), CopyId int, CopyName nvarchar (256), ZeroRefCount int, clientId int)
	declare			@NonDedupMPs table (MountPathId int, MountpathName nvarchar(256), DeviceId int, DeviceName nvarchar(256), DeletedAFCount int)
	declare			@nonDedupBatchIncrVal INT = 4000
	declare			@nonDedupBatchMaxVal  INT = 40000
	declare			@dedupBatchIncrVal INT	  = 1000
	declare			@dedupBatchMaxVal INT	  = 10000
	declare			@dedupBatchTweakFlag INT		  = 0		-- 0 - No Change, 1 - Increase, 2 - Decrease
	declare			@nonDedupBatchTweakFlag	INT	  = 0		-- 0 - No Change, 1 - Increase, 2 - Decrease
	declare			@intervalTweakFlag	INT	  = 0		-- 0 - No Change, 1 - Increase, 2 - Decrease
	declare			@dedupBatchChangeValue INT = 0
	declare			@nonDedupBatchChangeValue INT = 0
	declare			@pruneIntervalChangeValue INT = 0
	declare			@pruneIntervalDecrVal INT = 10 -- in minutes
declare			@pruneIntervalMax INT = 1440
declare			@pruneIntervalMin INT = 10
	declare 		@pruneIntervalCurrent INT = 0
	declare			@hasPruneBacklog INT = 0
	-------------------------------------------------------------------------------------------------------------------------------------------------------
	-- Increment non-dedup pruning batch count every 2K till we reach max of 30K ceiling
	-- Increment dedup pruning batch count every 1K till we reach max of 5K ceiling (dedup batch count is per AF and AF may have multiple chunks)
	-- If dedup or non-dedup batch count settings are increased, then change pruning interval also.
	-------------------------------------------------------------------------------------------------------------------------------------------------------
	SELECT @pruneIntervalCurrent = value,
	@pruneIntervalMin = nMin,
	@pruneIntervalMax = nMax
	FROM MMConfigs WITH (READUNCOMMITTED)
	WHERE name = 'MM_CONFIG_PRUNE_PROCESS_INTERVAL_MINS'
	INSERT INTO @DeletedAFDDBs
		EXEC MMGetDDBsOnPruningThreshold 2, 1
	INSERT INTO @ZeroRefDDBs
		EXEC MMGetDDBsOnPhysicalPruningThreshold 2, 0
	INSERT INTO @NonDedupMPs
	EXEC MMGetMPsOnNonDedupPruningThreshold 2, 1
	-- STEP 2: Get the current set of MAs where setting is needed.
	insert into @DDBMAsForDDB
	select distinct SUBSTORES.clientid
	from idxsidbsubstore SUBSTORES WITH (READUNCOMMITTED), @DeletedAFDDBs DDBS
	where SUBSTORES.SIDBStoreId = DDBS.SIDBStoreId
	and SUBSTORES.ClientId > 1
	insert into @DDBMAsForDDB
	select distinct DDBS.clientId
	from @ZeroRefDDBs DDBS
		LEFT OUTER JOIN @DDBMAsForDDB T ON DDBS.clientId = T.DDBMAClientId
	where T.DDBMAClientId IS NULL
	AND DDBS.ClientId > 1
	declare @mmConfigsVal INT = (SELECT value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_DEDUP_PRUNE_BATCH_SIZE')
	IF EXISTS (SELECT 1 FROM @DeletedAFDDBs)
	BEGIN
		SET @hasPruneBacklog = 1
		SET @dedupBatchChangeValue = @mmConfigsVal + @dedupBatchIncrVal
		-- if the computed value is going above the max then set it to max.
		IF (@dedupBatchChangeValue > @dedupBatchMaxVal)
		BEGIN
			SET @dedupBatchChangeValue = @dedupBatchMaxVal
		END
		-- Increase the pruning load
		UPDATE MMConfigs
		SET value = @dedupBatchChangeValue
		WHERE name = 'MMS2_CONFIG_DEDUP_PRUNE_BATCH_SIZE'
		AND value < @dedupBatchMaxVal
		IF @@ROWCOUNT > 0
			SET @dedupBatchTweakFlag = 1
	END
	ELSE
	BEGIN
		IF (@dedupBatchSetting > 0) -- we made previous setting, so revert it in step manner
		BEGIN
			SET @dedupBatchChangeValue = @mmConfigsVal - @dedupBatchIncrVal
			-- if the computed value is going below the default then set it to default.
IF (@dedupBatchChangeValue < 1000)
			BEGIN
SET @dedupBatchChangeValue = 1000
			END
			-- Revert to default
			UPDATE MMConfigs
			SET value = @dedupBatchChangeValue
			WHERE name = 'MMS2_CONFIG_DEDUP_PRUNE_BATCH_SIZE'
AND value > 1000
			IF @@ROWCOUNT > 0
				SET @dedupBatchTweakFlag = 2
		END
	END
	IF @dedupBatchTweakFlag > 0 -- some change, track it.
	BEGIN
		-- Keep track of how much we increased.
		UPDATE MMEntityProp
		SET intVal = @dedupBatchChangeValue,
		modified = @currentTime
WHERE EntityType = 13
AND propertyName = 'DedupPruningBatchSize'
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT  INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
SELECT 0, 13, 'DedupPruningBatchSize', 1, @dedupBatchChangeValue, 0, '', @currentTime, @currentTime, 2
		END
	END
	IF EXISTS (SELECT 1 FROM @ZeroRefDDBs) AND (@hasPruneBacklog = 0)
	BEGIN
		SET @hasPruneBacklog = 1
		-- For the case when theres no pruning backlog in MMDeletedAF, we need not increase the dedup batch count.
		--When the above is set, the pruning interval will be tweaked while keeping the batch count intact. We need to decrease the pruning interval though,
		--since that triggers pruning on the DDB side.
	END
	declare @mmConfigsNonDedupVal INT = (SELECT value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_NON_DEDUP_PRUNE_BATCH_SIZE')
	IF EXISTS (SELECT 1 FROM @NonDedupMPs)
	BEGIN
		SET @hasPruneBacklog = 1
		SET @nonDedupBatchChangeValue = @mmConfigsNonDedupVal + @nonDedupBatchIncrVal
		-- if the computed value is going above the max then set it to max.
		IF (@nonDedupBatchChangeValue > @nonDedupBatchMaxVal)
		BEGIN
			SET @nonDedupBatchChangeValue = @nonDedupBatchMaxVal
		END
		--Increase non-dedup pruning load
		UPDATE MMConfigs
		SET value = @nonDedupBatchChangeValue
		WHERE name = 'MMS2_CONFIG_NON_DEDUP_PRUNE_BATCH_SIZE'
		AND value < @nonDedupBatchMaxVal
		IF @@ROWCOUNT > 0
			SET @nonDedupBatchTweakFlag = 1
	END
	ELSE
	BEGIN
		IF (@nonDedupBatchSetting > 0) -- we made previous setting, so revert it
		BEGIN
			SET @nonDedupBatchChangeValue = @mmConfigsNonDedupVal - @nonDedupBatchIncrVal
			-- if the computed value is going below the default then set it to default.
IF (@nonDedupBatchChangeValue < 10000)
			BEGIN
SET @nonDedupBatchChangeValue = 10000
			END
			-- Revert to default
			UPDATE MMConfigs
			SET value = @nonDedupBatchChangeValue
			WHERE name = 'MMS2_CONFIG_NON_DEDUP_PRUNE_BATCH_SIZE'
AND value > 10000
			IF @@ROWCOUNT > 0
				SET @nonDedupBatchTweakFlag = 2
		END
	END
	IF @nonDedupBatchTweakFlag > 0
	BEGIN
		-- Keep track of how much we increased
		UPDATE MMEntityProp
		SET intVal = @nonDedupBatchChangeValue,
		modified = @currentTime
WHERE EntityType = 13
AND propertyName = 'NonDedupPruningBatchSize'
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT  INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
SELECT 0, 13, 'NonDedupPruningBatchSize', 1, @nonDedupBatchChangeValue, 0, '', @currentTime, @currentTime, 2
		END
	END
	IF (@hasPruneBacklog = 1) -- as long as some backlog keep the prune interval low.
	BEGIN
		SET @pruneIntervalChangeValue = @pruneIntervalCurrent - @pruneIntervalDecrVal
		-- if the computed value is going below the default then set it to min value allowed
		IF (@pruneIntervalChangeValue < @pruneIntervalMin)
		BEGIN
			SET @pruneIntervalChangeValue = @pruneIntervalMin
		END
		-- One of the parameters were tweaked. Reduce the pruning interval.
		UPDATE MMConfigs
		SET value = @pruneIntervalChangeValue
		WHERE name = 'MM_CONFIG_PRUNE_PROCESS_INTERVAL_MINS'
		AND value > @pruneIntervalMin
		IF @@ROWCOUNT > 0
			SET @intervalTweakFlag = 2
	END
	ELSE
	BEGIN
		-- No tweak. Reset the pruning interval.
		SET @pruneIntervalChangeValue = @pruneIntervalCurrent + @pruneIntervalDecrVal
		-- if the computed value is going above the default then set it to default.
IF (@pruneIntervalChangeValue > 60)
		BEGIN
SET @pruneIntervalChangeValue = 60
		END
		UPDATE MMConfigs
		SET value = @pruneIntervalChangeValue
		WHERE name = 'MM_CONFIG_PRUNE_PROCESS_INTERVAL_MINS'
AND value < 60
		IF @@ROWCOUNT > 0
			SET @intervalTweakFlag = 1
	END
	IF @intervalTweakFlag > 0
	BEGIN
		-- Keep track of how much and when we decrease
		UPDATE MMEntityProp
		SET intVal = @pruneIntervalChangeValue,
		modified = @currentTime
WHERE EntityType = 13
AND propertyName = 'PruningIntervalChange'
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT  INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
SELECT 0, 13, 'PruningIntervalChange', 1, @pruneIntervalChangeValue, 0, '', @currentTime, @currentTime, 2
		END
	END
	--
    	-- update the table with the damage done.
    	--
    	set @curRunOutput = cast(@intervalTweakFlag as varchar(10)) + ' ' + cast(@nonDedupBatchTweakFlag as varchar(10)) + ' ' + cast(@dedupBatchTweakFlag as varchar(10))
	update MMProcsToRun
	set lastRunOut = @curRunOutput
	where ProcId = @procId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode	= ERROR_NUMBER()
END CATCH
PROC_EXIT:
IF @errCode <> 0
BEGIN
    ROLLBACK TRANSACTION
END
ELSE
BEGIN
    COMMIT TRANSACTION
END
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMCheckAndTweakDDBPruning')
	delete from GxQscripts where name = 'MMCheckAndTweakDDBPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckAndTweakDDBPruning')
	delete from GXDBVersions where aliasname = 'MMCheckAndTweakDDBPruning'
GO

insert into GXDBVersions values(2, 'MMCheckAndTweakDDBPruning',  '00010001000200090000', 'MMCheckAndTweakDDBPruning', '00010001000200090000')
GO

