

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCheckAndSubmitMPDefragJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCheckAndSubmitMPDefragJob.sp,v $ $Id: MMCheckAndSubmitMPDefragJob.sp,v 1.1.2.7 2019/05/30 16:31:07 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCheckAndSubmitMPDefragJob')
BEGIN
	print '>>> Drop Stored Procedure: MMCheckAndSubmitMPDefragJob <<<'
	drop procedure MMCheckAndSubmitMPDefragJob
END
IF EXISTS (select * from GxQscripts where name='MMCheckAndSubmitMPDefragJob')
	delete from GxQscripts where name = 'MMCheckAndSubmitMPDefragJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckAndSubmitMPDefragJob')
	delete from GXDBVersions where aliasname = 'MMCheckAndSubmitMPDefragJob'
GO
print '... Creating Procedure: MMCheckAndSubmitMPDefragJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMCheckAndSubmitMPDefragJob
  @i_CommCellId integer,
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
SET NOCOUNT ON
BEGIN TRANSACTION;
BEGIN TRY
	declare			@errCode integer
	set @errCode = 0
	declare			@spName varchar(1024)
	declare			@spArgs varchar(max)
	declare			@procId integer
	declare			@lastAttemptTime bigint
	declare			@lastRunOutput varchar(max)
	set @spName = OBJECT_NAME (@@PROCID)
	set @spArgs = CONVERT(varchar,@i_CommCellId) +','+ CONVERT(varchar, @i_reserveParam)
	set @procId = isnull (checksum(@spName, @spArgs), 0)
	select @lastAttemptTime = ISNULL(lastAttemptTime, -1),
			@lastRunOutput = ISNULL(lastRunOut, '')
	from MMProcsToRun with (readuncommitted) where ProcId = @procId
	set @lastRunOutput = ( case when (@lastRunOutput = '') then '' else (LEFT(@lastRunOutput, LEN(@lastRunOutput) - 1)) end ) -- remove the last comma
	---------------------------------------------------
	-- Is it already time for me to run?
	---------------------------------------------------
	DECLARE			@currentTime INT = dbo.getUnixTime(GETUTCDATE())
	declare			@intervalForSubmitMPDefragSeconds int = 0
set @intervalForSubmitMPDefragSeconds = (ISNULL((select value from MMConfigs with (readuncommitted) where name = 'MM_CONFIG_CHECKTWEAK_MPDEFRAGJOBSUBMIT_INTERVAL_MINS'), 1440)) * 60
DECLARE		@l_lowWaterMarkPercent INTEGER = 50;
	SELECT		@l_lowWaterMarkPercent = value
	FROM		MMConfigs WITH (READUNCOMMITTED)
	WHERE		name = 'MMS2_CONFIG_LOW_WATERMARK_PERC_TO_SUBMIT_DEFRAG_JOB'
	DECLARE		@l_maxJobsAllowedToSubmit INTEGER = 1;
	SELECT		@l_maxJobsAllowedToSubmit = value
	FROM		MMConfigs WITH (READUNCOMMITTED)
	WHERE		name = 'MMS2_CONFIG_MAX_DEFRAG_JOBS_ALLOWED_TO_SUBMIT'
	DECLARE		@l_storeIntervalDays INTEGER = 30;
	SELECT		@l_storeIntervalDays = value
	FROM		MMConfigs WITH (READUNCOMMITTED)
	WHERE		name = 'MMS2_CONFIG_CHECKTWEAK_MPDEFRAGJOBSUBMITONSTORE_INTERVAL_DAYS'
	if ( (@lastAttemptTime = -1) OR (@intervalForSubmitMPDefragSeconds <= 0) OR ((@currentTime - @intervalForSubmitMPDefragSeconds) <= @lastAttemptTime) )
	begin
		-- nope
		goto proc_exit
	end
	else
	-- Update the attempt time before starting the main logic in the proc.. if any failure, it wont be tried again till interval has passed
	begin
		update MMProcsToRun
		set lastAttemptTime = [dbo].[GetUnixTime](GETUTCDATE())
		where ProcId = @procId
	end
	--
	-- Use this currentRunOutput variable to set a string in the mmprocstorun table after SP finishes so that
	-- next run of this can either undo the damage done in previous run or act according to what was done last
	--
	declare			@curRunOutput varchar(1024)
	---------------------------------------------------
	-- Ok, let's get on with the logic now...
	---------------------------------------------------
	--
	-- 1. Get libs with drill holes not supported
	--		1A. For Gluster FS Mount path check low water mark stored in MMConfig
	--		1B. For Non Gluster FS Mount Path check low water mark on library
	-- 2. Update for those having less than @i_threshold free space
	-- 3. For each of those ddbs/copies, insert into tm_request to start defrag job
	--
	declare @l_DefragJobLibs		table (libId int, capacityMB bigint, freebytesMB bigint)
	declare @l_DefragJobStores	table (DDBId int, CopyId int, lastDefragRunTime bigint, taskXml XML)
	insert into @l_DefragJobLibs
	select	mp.LibraryId, sum(ms.totalspacemb), sum(ms.freebytesmb)
	from	mmmountpath mp with (readuncommitted) inner join
			mmmediaside ms with (readuncommitted) ON MP.MediaSideId = MS.MediaSideId inner join
			MMLibrary ML with (readuncommitted) on MP.LibraryId = ML.LibraryId
	where	MP.IsEnabled = 1
AND (MP.Attribute & (1024|128)) = 1024
AND (MP.Attribute & 64) = 64
	group by mp.LibraryId, ML.LowWaterMarkMB
	having ((sum(ms.totalspacemb) > 0) AND ((sum(ms.FreeBytesMB) * 100)/sum(ms.totalspacemb) <= @l_lowWaterMarkPercent))
	insert into @l_DefragJobLibs
	select	mp.LibraryId, sum(ms.totalspacemb), sum(ms.freebytesmb)
	from	mmmountpath mp with (readuncommitted) inner join
			mmmediaside ms with (readuncommitted) ON MP.MediaSideId = MS.MediaSideId inner join
			MMLibrary ML with (readuncommitted) on MP.LibraryId = ML.LibraryId
	where	MP.IsEnabled = 1
AND (MP.Attribute & (1024|128)) = 1024
AND (MP.Attribute & 64) = 0
	group by mp.LibraryId, ML.LowWaterMarkMB
	having ((sum(ms.totalspacemb) > 0) AND ((sum(ms.FreeBytesMB) * 100)/sum(ms.totalspacemb) <= ML.LowWaterMarkMB))
	if not exists (select 1 from @l_DefragJobLibs)
	begin
		-- nothing to do
		goto proc_exit
	end
	INSERT INTO @l_DefragJobStores
	SELECT S.SIDBStoreId, C.CopyId, 0, ''
	FROM
		(SELECT	DISTINCT AGC.id CopyId
		FROM	@l_DefragJobLibs L
					INNER JOIN MMMasterPool MP  WITH (READUNCOMMITTED) ON L.libId = MP.LibraryId
					INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON MP.MasterPoolId = DP.MasterPoolId
					INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPath.DrivePoolId
INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON DPath.CopyId = AGC.id AND ((AGC.dedupeflags & 134217728) = 0)) C,
		archCopySIDBStore S
	WHERE	C.CopyId = S.CopyId
AND (S.flags & 4) > 0
	DELETE	S
	FROM	@l_DefragJobStores S
	WHERE	S.DDBId <= 0
	-- Remove the stores without any chunks
	DELETE T
	FROM @l_DefragJobStores T
	WHERE	NOT EXISTS (SELECT TOP 1 1
						FROM archFileCopyDedup AFCD WITH (READUNCOMMITTED), archChunkMapping ACM WITH (READUNCOMMITTED)
						WHERE AFCD.SIDBStoreId = T.DDBId
								AND AFCD.archFileId = ACM.archFileId
								AND AFCD.commCellId = ACM.commCellId
								AND AFCD.archCopyId = ACM.archCopyId)
	-- Remove the stores has Defrag jobs running
	DELETE	S
	FROM	JMAdminJobInfoTable J WITH (READUNCOMMITTED), @l_DefragJobStores S
	WHERE	J.OpType = 31
			AND J.CloudId = S.DDBId
AND dbo.GetJobOption(J.JobId, 1616894445) = 4 /*TMMsg::DDBVerificationLevel_DDB_DEFRAGMENTATION*/
	-- Remove the stores had Defrag jobs ran in last 30 days
	UPDATE	S
	SET		lastDefragRunTime = T.servStart
	FROM	@l_DefragJobStores S,
			(SELECT	S.DDBId, MAX(J.servStart) servStart
			FROM	@l_DefragJobStores S,
					JMAdminJobStatsTable J WITH (READUNCOMMITTED)
						LEFT OUTER JOIN  JMAdminJobAttemptStatsTable JA WITH (READUNCOMMITTED)
							ON	J.jobId = JA.JobId
								AND J.CommCellId = JA.CommCellId
								AND JA.attemptNum = 1
								AND JA.phaseNum = 4 /*DEFRAGMENT*/
			WHERE	S.DDBId = J.CloudId
					AND J.opType = 31
					AND (JA.JobId IS NOT NULL
OR dbo.GetJobOption(J.JobId, 1616894445) = 4 /*TMMsg::DDBVerificationLevel_DDB_DEFRAGMENTATION*/)
			GROUP BY S.DDBId) T
	WHERE	S.DDBId = T.DDBId
	DELETE	S
	FROM	@l_DefragJobStores S
	WHERE	S.lastDefragRunTime > (@currentTime - (@l_storeIntervalDays * 24 * 3600))
	-- Keep only max defrag jobs allowed to submit
	DELETE	S
	FROM	@l_DefragJobStores S
	WHERE	S.DDBId NOT IN (SELECT TOP (@l_maxJobsAllowedToSubmit)	DDBId FROM @l_DefragJobStores ORDER BY lastDefragRunTime)
	if not exists (select 1 from @l_DefragJobStores)
	begin
		-- nothing to do
		goto proc_exit
	end
    UPDATE D
    SET           taskXml =
		'<TMMsg_CreateTaskReq>
			<processinginstructioninfo/>
				<taskInfo>
					<task>
						<taskFlags>
							<disabled>false</disabled>
						</taskFlags>
							<policyType>DATA_PROTECTION</policyType>
							<taskType>IMMEDIATE</taskType>
							<initiatedFrom>SYSTEM</initiatedFrom>
					</task>
					<associations>
						<type>GALAXY</type>
						<consumeLicense>true</consumeLicense>
						<clientSidePackage>true</clientSidePackage>
						<copyId>' + CAST(D.CopyId AS VARCHAR(10)) +'</copyId>
						<storagePolicyId>' + CAST(AG.id AS VARCHAR(10)) +'</storagePolicyId>
						<copyName>' + AGC.name+'</copyName>
						<storagePolicyName>' + AG.name+'</storagePolicyName>
						<sidbStoreId>' + CAST(STORE.SIDBStoreId AS VARCHAR(10)) +'</sidbStoreId>
						<sidbStoreName>' + STORE.SIDBStoreName +'</sidbStoreName>
					</associations>
						<subTasks>
							<subTask>
								<subTaskType>ADMIN</subTaskType>
								<operationType>ARCHIVE_CHECK</operationType>
							</subTask>
							<options>
								<backupOpts>
								<mediaOpt>
									<auxcopyJobOption>
										<useMaximumStreams>true</useMaximumStreams>
										<maxNumberOfStreams>0</maxNumberOfStreams>
										<allCopies>true</allCopies>
										<mediaAgent>
										</mediaAgent>
										<useScallableResourceManagement>false</useScallableResourceManagement>
									</auxcopyJobOption>
								</mediaOpt>
								</backupOpts>
								<restoreOptions>
								<virtualServerRstOption>
									<isBlockLevelReplication>false</isBlockLevelReplication>
								</virtualServerRstOption>
								</restoreOptions>
								<adminOpts>
									<archiveCheckOption>
										<jobsToVerify>NEWLY_AVAILABLE</jobsToVerify>
										<allCopies>true</allCopies>
										<ddbVerificationLevel>DDB_DEFRAGMENTATION</ddbVerificationLevel>
										<sidbStore>
											<sidbStoreId>' + CAST(STORE.SIDBStoreId AS VARCHAR(10)) +'</sidbStoreId>
											<sidbStoreName>' + STORE.SIDBStoreName +'</sidbStoreName>
										</sidbStore>
										<backupLevel>FULL</backupLevel>
										<defragmentationPercentage>40</defragmentationPercentage>
									</archiveCheckOption>
									<contentIndexingOption>
										<subClientBasedAnalytics>false</subClientBasedAnalytics>
									</contentIndexingOption>
								</adminOpts>
								<commonOpts>
									<jobDescription>System initiated a space reclamation job after detecting low disk space</jobDescription>
								</commonOpts>
							</options>
							<subTaskOperation>OVERWRITE</subTaskOperation>
						</subTasks>
					</taskInfo>
					</TMMsg_CreateTaskReq>'
    FROM   @l_DefragJobStores D, archgroupcopy AGC with (readuncommitted), archgroup AG with (readuncommitted), IdxSIDBStore STORE with (readuncommitted)
    WHERE  D.copyId = AGC.id
		   AND AGC.archGroupId = AG.id
		   AND D.DDBId = STORE.SIDBStoreId
	--
	-- Now insert into TaskManager table to submit defrag job(s)
	--
	insert into TM_CreateTaskRequest
	select taskXml, 1, '', 0, 1, 0, dbo.getUnixTime(GETUTCDATE())
	from @l_DefragJobStores
	--
	-- update the table with the damage done.
	--
	SELECT
		@curRunOutput = COALESCE(@curRunOutput + ',', '') + cast (DDBs.DDBId as varchar(32))
	FROM @l_DefragJobStores DDBs
	update MMProcsToRun
	set lastRunOut = @curRunOutput
	where ProcId = @procId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode	= ERROR_NUMBER()
END CATCH
PROC_EXIT:
IF @errCode <> 0
BEGIN
    ROLLBACK TRANSACTION
END
ELSE
BEGIN
    COMMIT TRANSACTION
END
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMCheckAndSubmitMPDefragJob')
	delete from GxQscripts where name = 'MMCheckAndSubmitMPDefragJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckAndSubmitMPDefragJob')
	delete from GXDBVersions where aliasname = 'MMCheckAndSubmitMPDefragJob'
GO

insert into GXDBVersions values(2, 'MMCheckAndSubmitMPDefragJob',  '00010001000200070000', 'MMCheckAndSubmitMPDefragJob', '00010001000200070000')
GO

