

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCanDDBMoveRun.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  MMCanDDBMoveRun.sp                    					  */
/*  Author		:  Prasad Nara                                                */
/*  Description :  Stored procedure to check DDB move can be allowed or not	  */
/*																	 		  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCanDDBMoveRun.sp,v $ $Id: MMCanDDBMoveRun.sp,v 1.1.2.4 2020/06/10 15:01:47 shubhamagrawal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCanDDBMoveRun')
BEGIN
	print '>>> Drop Stored Procedure: MMCanDDBMoveRun <<<'
	drop procedure MMCanDDBMoveRun
END
IF EXISTS (select * from GxQscripts where name='MMCanDDBMoveRun')
	delete from GxQscripts where name = 'MMCanDDBMoveRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCanDDBMoveRun')
	delete from GXDBVersions where aliasname = 'MMCanDDBMoveRun'
GO
print '... Creating Procedure: MMCanDDBMoveRun'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMCanDDBMoveRun
  @i_xml xml
AS
  DECLARE @o_errCode INTEGER;
  DECLARE @o_errMsg NVARCHAR(1024);
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @o_errCode = 0
	SET @o_errMsg = N''
	DECLARE @l_userId int = 0
	DECLARE @l_localeId int = 0
	DECLARE @l_copyId int = 0
	DECLARE @l_StoreId int = 0
	DECLARE @l_SubStoreId int = 0
	DECLARE @l_SourceMAId int = 0
	DECLARE @l_TargetMAId int = 0
	DECLARE @l_TargetPath varchar(max) = ''
	SELECT 	@l_userId = ISNULL(ref.value('(processinginstructioninfo/user/@userId)[1]', 'int'), 0),
			@l_localeId = ISNULL(ref.value('(processinginstructioninfo/locale/@localeId)[1]', 'int'), 0),
			@l_StoreId = ISNULL(ref.value('@storeId', 'int'), 0),
			@l_SubStoreId = ISNULL(ref.value('@subStoreId', 'int'), 0),
			@l_SourceMAId = ISNULL(ref.value('@sourceMaId', 'int'), 0),
			@l_TargetMAId = ISNULL(ref.value('@targetMAId', 'int'), 0),
			@l_TargetPath = ISNULL(ref.value('@targetPath', 'varchar(max)'), '')
	FROM @i_xml.nodes('MediaManager_CanDDBMoveRunReq') R ( ref )
	IF RIGHT(@l_TargetPath, 1) IN ('/', '\')
	BEGIN
		SET @l_TargetPath = LEFT(@l_TargetPath, LEN(@l_TargetPath) - 1)
	END
	SELECT 	@l_copyId = C2S.copyId
	FROM	archGroupCopy C WITH(READUNCOMMITTED),
			archCopySIDBStore C2S WITh(READUNCOMMITTED)
	WHERE	C.id = C2S.copyId
AND C.dedupeFlags & 134217728 = 0
			AND C2S.SIDBStoreId = @l_StoreId
	-- if multiple DDBs configured on copy then don't allow moving DDB to MA lower than v11 SP15
IF (SELECT count(1) FROM archCopySIDBStore WHERE copyId = @l_copyId AND flags & 4 > 0) > 1
	AND EXISTS
	(
		SELECT 	1
		FROM	(
					SELECT  VC.PMClientId ClientId
					FROM 	APP_VMToPMMap VC
					WHERE 	VC.VMClientId = @l_TargetMAId
					UNION ALL
					SELECT @l_TargetMAId ClientId
				) C
				INNER JOIN App_Client CN ON CN.id = C.ClientId
				INNER JOIN simInstalledPackages PKG ON CN.id = PKG.ClientId
WHERE	PKG.simPackageID IN (51, 1301)
				AND (CN.releaseId < 16 OR (CN.releaseId = 16 AND PKG.HighestSP < 15))
	)
	BEGIN
SET @o_errCode = 1012
SELECT @o_errMsg = message FROM EvLocaleMsgs WHERE messageId = (1111 | (CAST(POWER(2, 24) AS BIGINT) * 62)) and localeId = @l_localeId
		GOTO PROC_EXIT
	END
	/*
		If source location also hosts another partition of same store and source MA < V11SP21
		Then Fail the Job
	*/
	IF	 EXISTS(
				SELECT 	1
				FROM 	IdxSIDBSubStore
				WHERE 	SubStoreId <> @l_SubStoreId AND SIDBStoreId = @l_StoreId
					AND IdxAccessPathId IN (SELECT IdxAccessPathId FROM IdxSIDBSubStore WHERE SIDBStoreId = @l_StoreId AND SubStoreId = @l_SubStoreId )
			)
	AND EXISTS
	(
		SELECT 	1
		FROM	(
					SELECT  VC.PMClientId ClientId
					FROM 	APP_VMToPMMap VC
					WHERE 	VC.VMClientId = @l_SourceMAId
					UNION ALL
					SELECT @l_SourceMAId ClientId
				) C
				INNER JOIN App_Client CN ON CN.id = C.ClientId
				INNER JOIN simInstalledPackages PKG ON CN.id = PKG.ClientId
WHERE	PKG.simPackageID IN (51, 1301)
				AND (CN.releaseId < 16 OR (CN.releaseId = 16 AND PKG.HighestSP < 21))
	)
	BEGIN
SET @o_errCode = 1012
SELECT @o_errMsg = message FROM EvLocaleMsgs WHERE messageId = (1111 | (CAST(POWER(2, 24) AS BIGINT) * 62)) and localeId = @l_localeId
		GOTO PROC_EXIT
	END
	/*
		If target location also hosts another partition of same store and target MA < V11SP21
		Then Fail the Job
	*/
	IF	 EXISTS(
				SELECT 	1
				FROM 	IdxSIDBSubStore
				WHERE 	SubStoreId <> @l_SubStoreId AND SIDBStoreId = @l_StoreId
					AND IdxAccessPathId IN (SELECT IdxAccessPathId FROM IdxAccessPath I WHERE I.ClientId = @l_TargetMAId AND I.Path LIKE @l_TargetPath)
			)
	AND EXISTS
	(
		SELECT 	1
		FROM	(
					SELECT  VC.PMClientId ClientId
					FROM 	APP_VMToPMMap VC
					WHERE 	VC.VMClientId = @l_TargetMAId
					UNION ALL
					SELECT @l_TargetMAId ClientId
				) C
				INNER JOIN App_Client CN ON CN.id = C.ClientId
				INNER JOIN simInstalledPackages PKG ON CN.id = PKG.ClientId
WHERE	PKG.simPackageID IN (51, 1301)
				AND (CN.releaseId < 16 OR (CN.releaseId = 16 AND PKG.HighestSP < 21))
	)
	BEGIN
SET @o_errCode = 1012
SELECT @o_errMsg = message FROM EvLocaleMsgs WHERE messageId = (1111 | (CAST(POWER(2, 24) AS BIGINT) * 62)) and localeId = @l_localeId
		GOTO PROC_EXIT
	END
PROC_EXIT:
	SELECT @o_errCode, @o_errMsg
GO

IF EXISTS (select * from GxQscripts where name = 'MMCanDDBMoveRun')
	delete from GxQscripts where name = 'MMCanDDBMoveRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCanDDBMoveRun')
	delete from GXDBVersions where aliasname = 'MMCanDDBMoveRun'
GO

insert into GXDBVersions values(2, 'MMCanDDBMoveRun',  '00010001000200040000', 'MMCanDDBMoveRun', '00010001000200040000')
GO

