

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCanAddDeviceController.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  MMCanAddDeviceController.sp                    */
/*                                                                            */
/*  Description :  Stored procedure to check if DDB or Mount Path is 		  */
/*					configured in Base directory of this MediaAgent 		  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCanAddDeviceController.sp,v $ $Id: MMCanAddDeviceController.sp,v 1.1.4.9 2020/08/24 14:12:12 pnara Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCanAddDeviceController')
BEGIN
	print '>>> Drop Stored Procedure: MMCanAddDeviceController <<<'
	drop procedure MMCanAddDeviceController
END
IF EXISTS (select * from GxQscripts where name='MMCanAddDeviceController')
	delete from GxQscripts where name = 'MMCanAddDeviceController'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCanAddDeviceController')
	delete from GXDBVersions where aliasname = 'MMCanAddDeviceController'
GO
print '... Creating Procedure: MMCanAddDeviceController'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMCanAddDeviceController
  @i_libraryId INTEGER,
  @i_deviceId INTEGER,
  @i_mediaAgentId INTEGER
AS
  DECLARE @r_retCode INTEGER;
  DECLARE @r_allowAddDeviceController INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @retVal int = 0
	SET @r_allowAddDeviceController = 1
	--
	-- DeviceId is passed then it's adding device controller
	-- Check for defrag
	--
	IF @i_deviceId > 0
	BEGIN
		DECLARE @hasCompactedChunks INT = 0
		DECLARE @l_allowDefragmentation INT = 0
		DECLARE @clientTable TABLE (ClientId INTEGER, PhysicalClientId INTEGER, ReleaseId INTEGER, SPMajor INTEGER, SPMinor INTEGER)
		SELECT	@hasCompactedChunks = 1
		FROm	MMMountPathToStorageDevice MSD,
				MMMountPath MP
		WHERE	MSD.DeviceId = @i_deviceId
				AND MSD.MountPathId = MP.MountPathId
				AND MP.Attribute & 512 /*MNTPTH_ATTRIB_HAS_COMPACTED_CHUNKS*/ > 0
		IF (@hasCompactedChunks = 1)
		BEGIN
			INSERT INTO @clientTable
			SELECT DISTINCT @i_mediaAgentId, 0, 0, 0, 0;
			WITH ClientSPLevel AS (
					SELECT
						C.ClientId AS ClientId,
						CLIENT.ReleaseId AS ReleaseId,
						PKG.HighestSP AS SPMajor,
						PKG.SpMinorVersion AS SPMinor,
						ROW_NUMBER() OVER (PARTITION BY C.ClientId
						ORDER BY C.ClientId, CLIENT.ReleaseId, PKG.HighestSP, PKG.SpMinorVersion) AS RowNum
					FROM
						@clientTable C
						LEFT OUTER JOIN APP_VMToPMMap MAP ON MAP.VMClientId = C.ClientId
						INNER JOIN SimInstalledPackages PKG ON PKG.ClientId = ISNULL(MAP.PMClientId, C.ClientId)
						INNER JOIN APP_Client CLIENT ON CLIENT.id = ISNULL(MAP.PMClientId, C.ClientId)
					WHERE
PKG.simPackageID in (51, 1301))
			UPDATE	@clientTable
			SET		ReleaseId = SPL.ReleaseId,
					SPMajor = SPL.SPMajor,
					SPMinor = SPL.SPMinor
			FROM	@clientTable C, ClientSPLevel SPL
			WHERE	SPL.RowNum = 1
					AND C.ClientId = SPL.ClientId
			IF NOT EXISTS (SELECT * FROM @clientTable C WHERE ReleaseId < 15
															  OR (ReleaseId = 15 AND SPMajor < 14)
															  OR (ReleaseId = 16 AND SPMajor < 4))
				SET	@l_allowDefragmentation = 1
		END
		IF (@hasCompactedChunks = 1 AND @l_allowDefragmentation = 0)
		BEGIN
SET @retVal = 530
			SET @r_allowAddDeviceController = 0
			GOTO PROC_EXIT
		END
	END
	--Get MA version
	DECLARE @lt_MAVersion TABLE (ReleaseId int, HighestSP int)
	INSERT INTO @lt_MAVersion
	EXEC MMS2GetMediaAgentVersion @i_mediaAgentId
	-- if multiple DDBs configured on a copy using current library then don't allow adding new MA lower than v11 SP15
	IF EXISTS
	(
		SELECT 	1
		FROM	@lt_MAVersion
		WHERE 	(releaseId < 16 OR (releaseId = 16 AND HighestSP < 15))
	)
	BEGIN
		--
		-- For adding mountpath we first add device and device controller
		-- so we can't find any library/copy using deviceId
		-- check if library is passed then use it to find copies
		--
		IF @i_libraryId > 0
		BEGIN
			IF EXISTS
			(
				SELECT 	1
				FROM	MMMasterPool MPool WITH(READUNCOMMITTED),
						MMDrivePool DPool WITH(READUNCOMMITTED),
						MMDataPath DPath WITH(READUNCOMMITTED),
						archCopySIDBStore C2S WITH(READUNCOMMITTED)
				WHERE	MPool.LibraryId = @i_libraryId
						AND MPool.MasterPoolId = DPool.MasterPoolId
						AND DPool.DrivePoolId = DPath.DrivePoolId
						AND DPath.CopyId = C2S.CopyId
AND (C2S.flags & 4) > 0
				GROUP BY C2S.copyId
				HAVING COUNT(DISTINCT C2S.SIDBStoreId) > 1
			)
			BEGIN
SET @retVal = 1012
				SET @r_allowAddDeviceController = 0
			END
		END
		ELSE IF EXISTS
		(
			SELECT 	1
			FROM	MMMountPathToStorageDevice MP2SD WITH(READUNCOMMITTED),
					MMMountPath MP WITH(READUNCOMMITTED),
					MMDrivePool DPool WITH(READUNCOMMITTED),
					MMDataPath DPath WITH(READUNCOMMITTED),
					archCopySIDBStore C2S WITH(READUNCOMMITTED)
			WHERE	MP2SD.DeviceId = @i_deviceId
					AND MP2SD.MountPathId = MP.MountPathId
					AND MP.MasterPoolId = DPool.MasterPoolId
					AND DPool.DrivePoolId = DPath.DrivePoolId
					AND DPath.CopyId = C2S.CopyId
AND (C2S.flags & 4) > 0
			GROUP BY C2S.copyId
			HAVING COUNT(DISTINCT C2S.SIDBStoreId) > 1
		)
		BEGIN
SET @retVal = 1012
			SET @r_allowAddDeviceController = 0
		END
	END
	-- For Metalic cloud library don't allow adding new MA lower than v11 SP20
	IF EXISTS
	(
		SELECT 	1
		FROM	@lt_MAVersion
		WHERE 	(releaseId < 16 OR (releaseId = 16 AND HighestSP < 20))
	)
	BEGIN
		DECLARE @lt_MetallicStorage TABLE
		(
			o_deviceId			INTEGER,
			o_licenseType		INTEGER,
			o_regionName		varchar(64),
			o_regionDisplayName	varchar(256),
			o_storageClass		INTEGER,
			o_replication		INTEGER,
			o_credentialId		INTEGER,
			o_container			varchar(64),
			o_storageAccount	varchar(64),
			o_applicationId		varchar(64)
		)
		INSERT INTO @lt_MetallicStorage
		EXEC MMGetMetallicStorage @i_deviceId, 0 /*licenseType*/, @i_libraryId
		IF @@ROWCOUNT > 0
		BEGIN
SET @retVal = 1012
			SET @r_allowAddDeviceController = 0
		END
	END
PROC_EXIT:
	SELECT @retVal ErrorCode, @r_allowAddDeviceController IsAllowed
GO

IF EXISTS (select * from GxQscripts where name = 'MMCanAddDeviceController')
	delete from GxQscripts where name = 'MMCanAddDeviceController'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCanAddDeviceController')
	delete from GXDBVersions where aliasname = 'MMCanAddDeviceController'
GO

insert into GXDBVersions values(2, 'MMCanAddDeviceController',  '00010001000400090000', 'MMCanAddDeviceController', '00010001000400090000')
GO

