

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCPCleanup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMCPCleanup <<<'

IF EXISTS (select * from sysobjects where name='MMCPCleanup')
	drop procedure MMCPCleanup
IF EXISTS (select * from GxQscripts where name='MMCPCleanup')
	delete from GxQscripts where name = 'MMCPCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCPCleanup')
	delete from GXDBVersions where aliasname = 'MMCPCleanup'
GO
print '... Creating Procedure: MMCPCleanup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCPCleanup
  @i_resId integer,
  @i_resCtrlId integer,
  @i_resType integer,
  @i_flag integer,
  @i_reserveField1 integer,
  @i_reserveField2 integer,
  @i_reserveField3 integer
AS
  DECLARE @o_returnCode integer
  DECLARE @o_returnString NVARCHAR (255)
  DECLARE @o_reserveParam1 integer
  DECLARE @o_reserveParam2 integer
  DECLARE @o_strReserveParam NVARCHAR (255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- Drive Controller Resource
	DECLARE @C_RESTYPE_DRIVE_CTRL	INTEGER
	SET @C_RESTYPE_DRIVE_CTRL	= 1
	-- Library Controller Resource
	DECLARE @C_RESTYPE_LIB_CTRL	INTEGER
	SET @C_RESTYPE_LIB_CTRL		= 2
	-- Constants for Resource Type
	DECLARE	@C_RESTYPE_DRIVE	INTEGER
	SET @C_RESTYPE_DRIVE		= 32
	DECLARE @C_RESTYPE_LIB		INTEGER
	SET @C_RESTYPE_LIB			= 64
	-- Return Code
	DECLARE @l_returnCode		INTEGER
	SET @l_returnCode			= 0
	-- Return String
	DECLARE @l_returnString		varchar (1024)
	SET @l_returnString			= N'Uninstall Succeeded'
	-- DriveControllerId for the Drive
	DECLARE @l_driveCtrlId		INTEGER
	SET @l_driveCtrlId			= 0
	-- LibraryControllerId for the Drive
	DECLARE @l_libraryCtrlId	INTEGER
	SET @l_libraryCtrlId		= 0
	-- DriveId of the Drive
	DECLARE @l_driveId			INTEGER
	SET @l_driveId				= 0
	-- DrivePoolId of the Drive
	DECLARE @l_drivePoolId		INTEGER
	SET @l_drivePoolId			= 0
	-- MasterPoolId of the Drive
	DECLARE @l_masterPoolId		INTEGER
	SET @l_masterPoolId			= 0
	-- LibraryId of the Library
	DECLARE @l_libraryId		INTEGER
	SET @l_libraryId			= 0
	-- Cleanup Done Flag
	DECLARE @l_cleanupDone		INTEGER
	SET @l_cleanupDone			= 0
	-- Uninstall of Drive Controller
	IF @i_resType = @C_RESTYPE_DRIVE_CTRL
	BEGIN
		SET @l_driveCtrlId = @i_resCtrlId
		-- Check whether the Driver Controller exists or not
		IF NOT EXISTS (SELECT * FROM MMDriveController WHERE DriveControllerId = @l_driveCtrlId)
		BEGIN
SET @l_returnCode = 476
			SET @l_returnString = N'No Drive Controller with Id [' + CAST(@l_driveCtrlId AS VARCHAR) + '] found.'
			GOTO PROC_ERROR
		END
		SELECT @l_driveId = DriveId, @l_drivePoolId = DrivePoolId FROM MMDriveController WHERE DriveControllerId = @l_driveCtrlId
		-- Remove the Drive Controller
		DELETE FROM MMDriveController WHERE DriveControllerId = @l_driveCtrlId
		IF @@ERROR != 0
		BEGIN
SET @l_returnCode = 477
			SET @l_returnString = N'Failed to remove DCP [' + CAST(@l_driveCtrlId AS VARCHAR) + N'].'
			GOTO PROC_ERROR
		END
		-- Check whether Drive Controller is the last one for that drive
		IF @l_driveId > 0
		BEGIN
			SELECT DriveControllerId FROM MMDriveController WHERE DriveId = @l_driveId
			IF @@ROWCOUNT = 0 AND @i_flag = 1
			BEGIN
				DELETE FROM MMDrive Where DriveId = @l_driveId
				IF @@ERROR != 0
				BEGIN
SET @l_returnCode = 477
					SET @l_returnString = N'Failed to remove orphaned Drive [' + CAST(@l_driveId AS VARCHAR) + N'] of DCP [' + CAST(@l_driveCtrlId AS VARCHAR) + '].'
					GOTO PROC_ERROR
				END
				UPDATE MMMasterPool SET TotalDrives = TotalDrives - 1
				WHERE MasterPoolId = (SELECT MasterPoolId FROM MMDrivePool WHERE DrivePoolId = @l_drivePoolId)
				IF @@ERROR != 0
				BEGIN
SET @l_returnCode = 477
					SET @l_returnString = N'Failed to decrement MasterPool TotalDrives count for orphaned Drive [' + CAST(@l_driveId AS VARCHAR) + N'] of DCP [' + CAST(@l_driveCtrlId AS VARCHAR) + '].'
					GOTO PROC_ERROR
				END
				SET @l_cleanupDone = 1
			END
		END
		SET @l_returnCode = 0
		IF @l_cleanupDone = 1
			SET @l_returnString = N'DCP [' + CAST(@l_driveCtrlId AS VARCHAR) + '] removed successfully and also the orphaned Drive [' + CAST(@l_driveId AS VARCHAR) + N'].'
		ELSE
			SET @l_returnString = N'DCP [' + CAST(@l_driveCtrlId AS VARCHAR) + '] removed successfully.'
	END
	ELSE
	-- Uninstall of Library Controller
	IF @i_resType = @C_RESTYPE_LIB_CTRL
	BEGIN
		SET @l_libraryCtrlId = @i_resCtrlId
		-- Check whether the Library Controller exists or not
		IF NOT EXISTS (SELECT * FROM MMLibraryController WHERE LibraryControllerId = @l_libraryCtrlId)
		BEGIN
SET @l_returnCode = 478
			SET @l_returnString = N'No Library Controller with Id [' + CAST(@l_libraryCtrlId AS VARCHAR) + '] found.'
			GOTO PROC_ERROR
		END
		SELECT @l_libraryId = LibraryId FROM MMLibraryController WHERE LibraryControllerId = @l_libraryCtrlId
		-- Remove the Library Controller
		DELETE FROM MMLibraryController WHERE LibraryControllerId = @l_libraryCtrlId
		IF @@ERROR != 0
		BEGIN
SET @l_returnCode = 479
			SET @l_returnString = N'Failed to remove LCP [' + CAST(@l_libraryCtrlId AS VARCHAR) + N'].'
			GOTO PROC_ERROR
		END
		-- Check whether Library Controller is the last one for that library
		IF @l_libraryId > 0
		BEGIN
			SELECT LibraryControllerId FROM MMLibraryController WHERE LibraryId = @l_libraryId
			IF @@ROWCOUNT = 0 AND @i_flag = 1
			BEGIN
				DELETE FROM MMLibrary Where LibraryId = @l_libraryId
				IF @@ERROR != 0
				BEGIN
SET @l_returnCode = 479
					SET @l_returnString = N'Failed to remove orphaned Library [' + CAST(@l_libraryId AS VARCHAR) + N'] of LCP [' + CAST(@l_libraryCtrlId AS VARCHAR) + '].'
					GOTO PROC_ERROR
				END
				SET @l_cleanupDone = 1
			END
		END
		SET @l_returnCode = 0
		IF @l_cleanupDone = 1
			SET @l_returnString = N'LCP [' + CAST(@l_libraryCtrlId AS VARCHAR) + '] removed successfully and also the orphaned Library [' + CAST(@l_libraryId AS VARCHAR) + N'].'
		ELSE
			SET @l_returnString = N'LCP [' + CAST(@l_libraryCtrlId AS VARCHAR) + '] removed successfully.'
	END
	ELSE
	-- Wrong Resource Type
	BEGIN
SET @l_returnCode = 475
		SET @l_returnString = N'Invalid Resource Type [' + CAST(@i_resType AS VARCHAR) + N'] for ResId [' + CAST(@i_resId AS VARCHAR) + N']'
		GOTO PROC_ERROR
	END
	SET @l_returnCode = 0
	SET @l_returnString = ''
PROC_ERROR:
PROC_EXIT:
	SELECT @l_returnCode, @l_returnString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMCPCleanup')
	delete from GxQscripts where name = 'MMCPCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCPCleanup')
	delete from GXDBVersions where aliasname = 'MMCPCleanup'
GO

insert into GXDBVersions values(2, 'MMCPCleanup',  '00000000000000000000', 'MMCPCleanup', '00000000000000000000')
GO

