

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCIPrunerGetWebServerUrl.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  MMCIPrunerGetWebServerUrl.sp	                              */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCIPrunerGetWebServerUrl.sp,v $ $Id: MMCIPrunerGetWebServerUrl.sp,v 1.1.4.2 2018/10/18 18:53:46 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCIPrunerGetWebServerUrl')
BEGIN
	print '>>> Drop Stored Procedure: MMCIPrunerGetWebServerUrl <<<'
	drop procedure MMCIPrunerGetWebServerUrl
END
IF EXISTS (select * from GxQscripts where name='MMCIPrunerGetWebServerUrl')
	delete from GxQscripts where name = 'MMCIPrunerGetWebServerUrl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCIPrunerGetWebServerUrl')
	delete from GXDBVersions where aliasname = 'MMCIPrunerGetWebServerUrl'
GO
print '... Creating Procedure: MMCIPrunerGetWebServerUrl'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMCIPrunerGetWebServerUrl
  @i_appId INTEGER
AS
  DECLARE @r_webServerUrl VARCHAR(max);
BEGIN TRY
DECLARE @webServerClientId INT = 0
DECLARE @hostname NVARCHAR(MAX)
DECLARE @portNum NVARCHAR(MAX)
DECLARE @webServerAlias NVARCHAR(MAX)
DECLARE @errorString VARCHAR(1024)
DECLARE @clientId int = 0
SELECT @clientId = clientId FROM App_Application WITH(NOLOCK) WHERE id = @i_appId
EXEC @webServerClientId = AppGetWebSearchServerClientId @clientId, 1, 0
IF @webServerClientId = 0
BEGIN
    SET @errorString = 'Failed to get a valid index server.'
    RAISERROR(@errorString, 16, 1)
END
-- DM2WebService Web Site Port
-- DM2WebService Search Web Alias
IF NOT EXISTS (SELECT 1 FROM APP_Client WITH (NOLOCK) WHERE id= @webServerClientId)
BEGIN
    SET @errorString = 'Invalid webserver client Id.'
    RAISERROR(@errorString, 16, 1)
END
SELECT @hostname = net_hostname
FROM APP_Client WITH(NOLOCK)
WHERE id = @webServerClientId
SET @portNum = (SELECT attrVal
                      FROM APP_ClientProp WITH (NOLOCK)
                      WHERE componentNameId = @webServerClientId
                      AND attrName = 'DM2WebService Web Site Port'
                      AND modified = 0)
SET @webServerAlias = (SELECT attrVal
                              FROM APP_ClientProp  WITH (NOLOCK)
                              WHERE componentNameId = @webServerClientId
                              AND attrName = 'DM2WebService Search Web Alias'
                              AND modified = 0)
SET @r_webServerUrl = 'http://' + @hostname + ':' + @portNum + '/' + @webServerAlias + '/'
IF(@r_webServerUrl IS NULL)
BEGIN
	SET @errorString = 'Failed to get web server url'
	RAISERROR(@errorString, 16, 1)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
THROW
END CATCH
SELECT @r_webServerUrl
GO

IF EXISTS (select * from GxQscripts where name = 'MMCIPrunerGetWebServerUrl')
	delete from GxQscripts where name = 'MMCIPrunerGetWebServerUrl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCIPrunerGetWebServerUrl')
	delete from GXDBVersions where aliasname = 'MMCIPrunerGetWebServerUrl'
GO

insert into GXDBVersions values(2, 'MMCIPrunerGetWebServerUrl',  '00010001000400020000', 'MMCIPrunerGetWebServerUrl', '00010001000400020000')
GO

