

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMAlertNonEncryptedMediaExported.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMAlertNonEncryptedMediaExported.sp,v $ $Id: MMAlertNonEncryptedMediaExported.sp,v 1.7.204.4 2020/05/11 15:32:38 cliu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMAlertNonEncryptedMediaExported')
BEGIN
	print '>>> Drop Stored Procedure: MMAlertNonEncryptedMediaExported <<<'
	drop procedure MMAlertNonEncryptedMediaExported
END
IF EXISTS (select * from GxQscripts where name='MMAlertNonEncryptedMediaExported')
	delete from GxQscripts where name = 'MMAlertNonEncryptedMediaExported'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAlertNonEncryptedMediaExported')
	delete from GXDBVersions where aliasname = 'MMAlertNonEncryptedMediaExported'
GO
print '... Creating Procedure: MMAlertNonEncryptedMediaExported'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMAlertNonEncryptedMediaExported
  @i_mediaIdList VARCHAR(MAX)
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MediaId integer
  DECLARE @o_LibraryId integer
  DECLARE @o_PartialEncrypted integer
  DECLARE @o_BarCode VARCHAR(255)
  DECLARE @o_ContainerName NVARCHAR(255)
  DECLARE @o_LocationName NVARCHAR(255)
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tblMediaList') IS NOT NULL DROP TABLE #tblMediaList
CREATE TABLE #tblMediaList(
	mediaId INT
)
IF object_id('tempdb.dbo.#tblMediaNoEnc') IS NOT NULL DROP TABLE #tblMediaNoEnc
CREATE TABLE #tblMediaNoEnc(
	mediaId INT
)
IF object_id('tempdb.dbo.#tblNonEncryptedMediaList') IS NOT NULL DROP TABLE #tblNonEncryptedMediaList
CREATE TABLE	#tblNonEncryptedMediaList (
		mediaId				INT,
		libraryId			INT,
		lastWriteLibraryId	INT,
		containerId			INT,
		mediaLocation		INT,
		exportLocationId	INT,
		partialEncrypted	INT,
		barcode				varchar(1024),
		containerName		nvarchar(1024),
		locationName		nvarchar(1024)
)
INSERT	INTO #tblMediaList
EXEC	('SELECT distinct MediaId FROM MMMedia(READUNCOMMITTED) WHERE MediaId IN (' + @i_mediaIdList + ')')
-- Get all media with non-encrypted data
INSERT INTO #tblMediaNoEnc
SELECT DISTINCT f.MediaId
FROM archfile a with (nolock), archFileCopy b with (nolock), archChunkMapping c with (nolock), archChunk d with (nolock), mmvolume e with (nolock), #tblMediaList f
WHERE a.id = b.archFileId and a.commCellId = b.commCellId
AND a.isValid = 1 and b.isValid = 1
AND a.fileType in (1, 4)
AND b.archFileId = c.archFileId and b.commCellId = c.commCellId
AND b.archCopyId = c.archCopyId
AND c.archChunkId = d.id AND c.commCellId = d.commCellId
AND d.volumeId = e.volumeId
AND e.mediaId = f.mediaId
AND b.encKeyType = 0
AND d.hwEncKey = ''
INSERT	INTO #tblNonEncryptedMediaList
SELECT	mediaId, libraryId, lastWriteLibraryId, containerId,
		mediaLocation, exportLocationId, 0, barcode, '', ''
FROM	MMMedia
WHERE	mediaId in (select mediaId from #tblMediaNoEnc)
UPDATE	#tblNonEncryptedMediaList
SET		containerName = b.containerName
FROM	#tblNonEncryptedMediaList a, MMContainer b
WHERE	a.containerId = b.containerId
AND		a.containerId > 0
UPDATE	#tblNonEncryptedMediaList
SET		libraryId = lastWriteLibraryId
WHERE	libraryId = 0
UPDATE	#tblNonEncryptedMediaList
SET		locationName = b.exportLocation
FROM	#tblNonEncryptedMediaList a, MMExportLocation b
WHERE	a.exportLocationId = b.exportLocationId
UPDATE	#tblNonEncryptedMediaList
SET		partialEncrypted = 1
FROM archfile a with (nolock), archFileCopy b with (nolock), archChunkMapping c with (nolock), archChunk d with (nolock), mmvolume e with (nolock), #tblNonEncryptedMediaList f
WHERE a.id = b.archFileId and a.commCellId = b.commCellId
AND a.isValid = 1 and b.isValid = 1
AND a.fileType in (1, 4)
AND b.archFileId = c.archFileId and b.commCellId = c.commCellId
AND b.archCopyId = c.archCopyId
AND c.archChunkId = d.id AND c.commCellId = d.commCellId
AND d.volumeId = e.volumeId
AND e.mediaId = f.mediaId
AND (b.encKeyType <> 0 OR d.hwEncKey <> '' OR d.flags & 1048576 /*CVA_CHUNK_IS_ENC_BY_MEDIA_KEY*/ > 0)
SELECT	MediaId, LibraryId, partialEncrypted, Barcode,
		ContainerName, LocationName
From	#tblNonEncryptedMediaList
IF object_id('tempdb.dbo.#tblMediaList') IS NOT NULL DROP TABLE #tblMediaList
IF object_id('tempdb.dbo.#tblMediaNoEnc') IS NOT NULL DROP TABLE #tblMediaNoEnc
IF object_id('tempdb.dbo.#tblNonEncryptedMediaList') IS NOT NULL DROP TABLE #tblNonEncryptedMediaList
GO

IF EXISTS (select * from GxQscripts where name = 'MMAlertNonEncryptedMediaExported')
	delete from GxQscripts where name = 'MMAlertNonEncryptedMediaExported'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAlertNonEncryptedMediaExported')
	delete from GXDBVersions where aliasname = 'MMAlertNonEncryptedMediaExported'
GO

insert into GXDBVersions values(2, 'MMAlertNonEncryptedMediaExported',  '00010007020400040000', 'MMAlertNonEncryptedMediaExported', '00010007020400040000')
GO

