

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMAlertMediaRecalled.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMAlertMediaRecalled.sp,v $ $Id: MMAlertMediaRecalled.sp,v 1.4.294.3 2018/09/11 16:47:04 rsivadas Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMAlertMediaRecalled <<<'

IF EXISTS (select * from sysobjects where name='MMAlertMediaRecalled')
	drop procedure MMAlertMediaRecalled
IF EXISTS (select * from GxQscripts where name='MMAlertMediaRecalled')
	delete from GxQscripts where name = 'MMAlertMediaRecalled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAlertMediaRecalled')
	delete from GXDBVersions where aliasname = 'MMAlertMediaRecalled'
GO
print '... Creating Procedure: MMAlertMediaRecalled'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMAlertMediaRecalled
  @i_destExportlocationId INTEGER,
  @i_destLibraryId INTEGER,
  @i_mediaIdList VARCHAR(MAX)
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MediaId integer
  DECLARE @o_LibraryId integer
  DECLARE @o_BarCode char(255)
  DECLARE @o_ContainerName NVARCHAR(255)
  DECLARE @o_CurrLocationName NVARCHAR(255)
  DECLARE @o_DestLocationName NVARCHAR(255)
	IF object_id('tempdb.dbo.#alertMediaIdList') is not null DROP TABLE #alertMediaIdList
	IF object_id('tempdb.dbo.#alertMediaRecalled') is not null DROP TABLE #alertMediaRecalled
	CREATE TABLE #alertMediaIdList (
			mediaId INT
	)
	CREATE	TABLE #alertMediaRecalled (
			mediaId				INT,
			libraryId			INT,
			lastWriteLibraryId	INT,
			containerId			INT,
			mediaLocation		INT,
			exportLocationId	INT,
			barcode				varchar(1024),
			containerName		nvarchar(1024),
			destLocationName	nvarchar(1024),
			currLocationName	nvarchar(1024),
			libraryTypeId		int
	)
	INSERT	INTO #alertMediaIdList
	EXEC	('SELECT distinct MediaId FROM MMMedia WHERE MediaId IN (' + @i_mediaIdList + ')')
	INSERT	INTO #alertMediaRecalled
	SELECT	distinct mediaId, libraryId, lastWriteLibraryId, containerId,
			mediaLocation, exportLocationId, barcode, '', '', '',0
	FROM	MMMedia
	WHERE	mediaId in (select mediaId from #alertMediaIdList)
	UPDATE	#alertMediaRecalled
	SET		containerName = b.containerName
	FROM	#alertMediaRecalled a, MMContainer b
	WHERE	a.containerId = b.containerId
	AND		a.containerId > 0
	UPDATE	#alertMediaRecalled
	SET		currLocationName = b.libraryName,
			libraryTypeId = b.LibraryTypeId
	FROM	#alertMediaRecalled a, MMLibrary b
	WHERE	a.libraryId = b.libraryId
	AND		(	a.mediaLocation in (1, 2)
			or	a.mediaLocation = 3
				and a.exportLocationId = 0
and b.libraryTypeId = 8
			)
	UPDATE	#alertMediaRecalled
	SET		libraryId = lastWriteLibraryId
	WHERE	libraryId = 0
OR (libraryTypeId = 8 AND lastWriteLibraryId <> 0)
	UPDATE	#alertMediaRecalled
	SET		currLocationName = b.exportLocation
	FROM	#alertMediaRecalled a, MMExportLocation b
	WHERE	a.exportLocationId = b.exportLocationId
	AND		a.currLocationName = ''
	AND		a.mediaLocation = 3
	IF @i_destExportlocationId > 0
	BEGIN
		-- Destination is an export location
		UPDATE	#alertMediaRecalled
		SET		destLocationName = exportLocation
		FROM	MMExportLocation a
		WHERE	a.exportLocationId = @i_destExportlocationId
	END
	ELSE IF @i_destLibraryId > 0
	BEGIN
		-- Destination is a shelf or library
		UPDATE	#alertMediaRecalled
		SET		destLocationName = AliasName
		FROM	MMLibrary a
		WHERE	a.libraryId = @i_destLibraryId
	END
	ELSE IF @i_destLibraryId = 0
	BEGIN
		-- Destination is any library
		UPDATE	#alertMediaRecalled
		SET		destLocationName = 'Any Library'
	END
	SELECT	MediaId, LibraryId, Barcode,
			ContainerName, CurrLocationName, DestLocationName
	From	#alertMediaRecalled
	IF object_id('tempdb.dbo.#alertMediaIdList') is not null DROP TABLE #alertMediaIdList
	IF object_id('tempdb.dbo.#alertMediaRecalled') is not null DROP TABLE #alertMediaRecalled
GO

IF EXISTS (select * from GxQscripts where name = 'MMAlertMediaRecalled')
	delete from GxQscripts where name = 'MMAlertMediaRecalled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAlertMediaRecalled')
	delete from GXDBVersions where aliasname = 'MMAlertMediaRecalled'
GO

insert into GXDBVersions values(2, 'MMAlertMediaRecalled',  '00010004029400030000', 'MMAlertMediaRecalled', '00010004029400030000')
GO

