

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMAddSIDBStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMAddSIDBStore.sp,v $ $Id: MMAddSIDBStore.sp,v 1.74.44.7 2019/05/31 19:50:36 anarulkar Exp $";
--
--  +========================================================================+
--  |      SP:  MMAddSIDBStore
--  |
--  | Description:  Create a new SIDB Store for giving copy
--  |
--  |       Input:  SIDBStoreName, ClientID, Path, Username, Password
--  |
--  |      Output:  always returns new SIDB Store id
--  |
--  |      Notes:	None at this time
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   	         cliu
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMAddSIDBStore')
BEGIN
	print '>>> Drop Stored Procedure: MMAddSIDBStore <<<'
	drop procedure MMAddSIDBStore
END
IF EXISTS (select * from GxQscripts where name='MMAddSIDBStore')
	delete from GxQscripts where name = 'MMAddSIDBStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAddSIDBStore')
	delete from GXDBVersions where aliasname = 'MMAddSIDBStore'
GO
print '... Creating Procedure: MMAddSIDBStore'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMAddSIDBStore
  @i_SIDBStoreName varchar(255),
  @i_SIDBStoreAliasName varchar(255),
  @i_SPName varchar(255),
  @i_SIDBStoreFlags integer,
  @i_commCellId integer,
  @i_copyId integer,
  @i_nDataInstance integer,
  @i_silosIncache integer,
  @i_siloRestoreMAClientId integer,
  @i_siloRestoreClientId integer,
  @i_blockCacheValidDays integer,
  @i_SIDBSnapIntervalHours integer,
  @i_clientId integer,
  @i_idxCacheId integer,
  @i_idxAPId integer,
  @i_defaultMinObjSizeKB bigint,
  @i_defaultObjArchiveTime integer,
  @i_diskFreeThresholdMB integer,
  @i_diskFreeWarningThreshholdMB integer
AS
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBStoreName varchar(255)
  DECLARE @o_SIDBStoreAliasName varchar(255)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- .. :PARAM input lines
	SET NOCOUNT ON
	DECLARE @l_releaseId				integer
	DECLARE @l_archGroupId				integer
	DECLARE @l_defaultCopyId			integer
	DECLARE @l_dedupeFlags				integer
	DECLARE @l_nDataInstance			integer
	DECLARE @l_silosIncache				integer
	DECLARE @l_lastMultiplexingJobTime	integer
	DECLARE @l_copyRetentionDays		integer
	DECLARE @l_oldestEligibleObjArchiveTime integer
	DECLARE @l_blockCacheValidDays		integer
	DECLARE @l_SIDBSnapIntervalHours	integer
	DECLARE @t_spName					nvarchar(256)
	DECLARE @t_copyName					nvarchar(256)
	DECLARE @l_90releaseId				integer
	DECLARE @l_version					integer
	SET	@l_copyRetentionDays = (SELECT retentionDays FROM ArchAgingRule WHERE copyId = @i_copyId)
	SET	@l_releaseId = (SELECT releaseId FROM APP_Client WHERE id = @i_clientId)
	SET @l_90releaseId = (SELECT id from simAllGalaxyRel where release = '9.0')
	-- Set oldestEligibleObjArchiveTime based on copy retentiondays if it is not inputted
	IF		@i_defaultObjArchiveTime > 0
		SET @l_oldestEligibleObjArchiveTime = @i_defaultObjArchiveTime
/*	ELSE IF	@l_copyRetentionDays = -1
		SET @l_oldestEligibleObjArchiveTime = 365
	ELSE IF @l_copyRetentionDays = 0
		SET @l_oldestEligibleObjArchiveTime = 1
	ELSE
		SET @l_oldestEligibleObjArchiveTime = @l_copyRetentionDays
*/
	ELSE
		SET @l_oldestEligibleObjArchiveTime = -1
	SELECT	@l_archGroupId = grp.id, @l_defaultCopyId = grp.defaultCopy, @l_dedupeFlags = copy.dedupeFlags
	FROM	ArchGroup as grp, ArchGroupCopy as copy
	WHERE	copy.Id = @i_copyId AND copy.ArchGroupId = grp.Id
	-- Set default SIDB store name if not given
	IF @i_SIDBStoreName = ''
	BEGIN
		SET	@t_spName = (SELECT name FROM ArchGroup WHERE id = @l_archGroupId)
		SET	@t_copyName = (SELECT name FROM ArchGroupCopy WHERE id = @i_copyId)
		SET	@i_SIDBStoreName = 'SIDB_' + @t_spName + '_' + @t_copyName
	END
	SET @i_SIDBStoreAliasName = @i_SIDBStoreName
	SET @i_SIDBStoreName = @i_SIDBStoreName + ' (' + CAST(GETDATE() AS VARCHAR(24)) + ')'
	IF	@l_releaseId < @l_90releaseId
SET	@l_dedupeFlags = (@l_dedupeFlags & ~(33554432|67108864))
	IF		@i_nDataInstance > 0
		SET	@l_nDataInstance = @i_nDataInstance
	ELSE
		SET	@l_nDataInstance = 1
IF		(@l_dedupeFlags & 4194304) = 0
		SET	@l_silosIncache = 0
	ELSE IF @i_silosIncache > 0
		SET	@l_silosIncache = @i_silosIncache
	ELSE
		SET	@l_silosIncache = 1
IF		(@l_dedupeFlags & 524288) = 0
		SET	@l_blockCacheValidDays = 0
	ELSE IF	@i_blockCacheValidDays > 0
		SET	@l_blockCacheValidDays = @i_blockCacheValidDays
	ELSE IF	@l_copyRetentionDays > 0
		SET @l_blockCacheValidDays = @l_copyRetentionDays
	ELSE
		SET @l_blockCacheValidDays = 90
IF		(@l_dedupeFlags & 33554432) = 0
		SET @l_SIDBSnapIntervalHours = 0
	ELSE IF @i_SIDBSnapIntervalHours > 0
		SET @l_SIDBSnapIntervalHours = @i_SIDBSnapIntervalHours
	ELSE
		SET @l_SIDBSnapIntervalHours = 8
	-- Silo can be enabled for Deduplication stores at any time started from 9.0
SET @i_SIDBStoreFlags = (@i_SIDBStoreFlags | 1048576)
IF	(@l_dedupeFlags & 2097152) <> 0
SET @i_SIDBStoreFlags = (@i_SIDBStoreFlags | 2097152)
  	-- Software compression is enable by default for primary copy
	IF	@l_defaultCopyId = @i_copyId
SET @i_SIDBStoreFlags = (@i_SIDBStoreFlags | 2)
IF	(@l_dedupeFlags & 268435456) <> 0
SET @i_SIDBStoreFlags = (@i_SIDBStoreFlags | 16)
	IF (@l_releaseId >= @l_90releaseId)
		SET @l_version = -1
	ELSE
		SET @l_version = 0
	-- create a new SIDB Store
	INSERT INTO IdxSIDBStore
	(
		SIDBStoreName, SIDBStoreAliasName, CommCellId,
		IdxCacheId, IdxAccessPathId, ClientId,
		FirstBackupTime,
		MinObjSizeKB,
		oldestEligibleObjArchiveTime,
		SignatureType, flags, TotalDataSizeBytes, InstancedDataSizeBytes, Status,
		LastAccessTime, CreatedTime, SealedTime, origCCSIDBStoreId, Version,
		SIDBSnapPath, LastSnapTime, LastRecoveryTime, SealedReason, SIDBSiloedTime, SIDBSiloStatus, SIDBSiloJobId, SubStoreCount,
		MaxAllowedConnections, MaxNumOfAFsInSecFile
	)
	VALUES
	(
		@i_SIDBStoreName, @i_SIDBStoreAliasName, @i_commCellId,
		@i_idxCacheId, @i_idxAPId, @i_clientId,
		-1,
		CASE @i_defaultMinObjSizeKB
			WHEN 0 THEN 50
			ELSE @i_defaultMinObjSizeKB
		END,
		@l_oldestEligibleObjArchiveTime,
		-- Jai - Tue Sep 12 15:48:14 EST 2006
		-- Default is created with MMS2_SIDB_SIGNATURE_TYPE_SHA512 signature - used to be MD5.
 		4, @i_SIDBStoreFlags, 0, 0, 0, 0, dbo.getUnixTime(GetUTCDate()), 0, 0, @l_version,
 		'', 0, 0, 0, 0, 0, 0, 1, 0, 0
	)
	SET @o_SIDBStoreId = SCOPE_IDENTITY()
	DECLARE @AFPerSec INT = 0 -- Set it to 0, older MAs anyway wont read that field.
	SELECT @AFPerSec = 1
		FROM APP_Client C WITH (NOLOCK)
		    LEFT OUTER JOIN APP_VMToPMMap MAP WITH (READUNCOMMITTED) ON MAP.VMClientId = C.Id
		    INNER JOIN SimInstalledPackages PKG WITH (READUNCOMMITTED) ON PKG.ClientId = ISNULL(MAP.PMClientId, C.Id)
WHERE (C.releaseId > 16) OR ((C.releaseId = 16)  AND (PKG.HighestSP >= 13))
	AND C.id = @i_clientId
	INSERT INTO IdxSIDBSubStore
           (SIDBStoreId, commCellId, GroupNumber, IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime
           ,flags, TotalDataSizeBytes, InstancedDataSizeBytes,Status, LastAccessTime
           ,CreatedTime, SealedTime, Version, SIDBSnapPath, LastSnapTime, origSubStoreId, ReconLevel, LastSnapJobId, DDBBackupCSGUID, PrimaryId, MemDbTimeStamp, CorruptionTime, ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence, MaxNumOfAFsInSecFile, ExtendedFlags, PageSize)
     	VALUES
           (@o_SIDBStoreId, @i_commCellId, 0, @i_idxCacheId, @i_idxAPId, @i_clientId, -1
           ,@i_SIDBStoreFlags, 0, 0, 0, 0
           ,dbo.getUnixTime(GetUTCDate()), 0, @l_version, '', 0, 0, 0, 0, '', 0, 0, 0, 0, '', '', '', @AFPerSec, 0, 0)
	INSERT INTO archCopySIDBStore
	(
		CopyId, SIDBStoreId, CommCellId, flags, TotalDataSizeBytes, InstancedDataSizeBytes
	)
	VALUES
	(
		@i_copyId, @o_SIDBStoreId, @i_commCellId, 0, 0, 0
	)
	-- If the primary copy has multipexing, with GUI side check this creation should never happen.
	-- However, if the multiplexing has been enabled before, then disabled, there may be jobs that
	-- need to be aux-copied still have multiplexing enabled. Here, we modify the copy start time
	-- to skip such jobs for single instance aux copy.
	SELECT	@l_lastMultiplexingJobTime = ISNULL(MAX(cTime), 0)
	FROM		ArchFile as af, ArchFileCopy as afc
	WHERE		af.Id = afc.ArchFileId AND af.commcellId = afc.commcellId
AND			afc.ArchCopyId = @l_defaultCopyId AND (afc.Flags & 64) > 0
	UPDATE	IdxCache
	SET			DiskFreeThresholdMB = @i_diskFreeThresholdMB,
					DiskFreeWarningThreshholdMB = @i_diskFreeWarningThreshholdMB
	WHERE		IdxCacheId = @i_idxCacheId
	UPDATE ArchGroupCopy
	SET	SIDBStoreId = @o_SIDBStoreId,
		nDataInstance = @l_nDataInstance,
		silosInCache = @l_silosInCache,
		siloRestoreMAClientId = @i_siloRestoreMAClientId,
		siloRestoreClientId = @i_siloRestoreClientId,
		blockCacheValidDays = @l_blockCacheValidDays,
		SIDBSnapIntervalHours = @l_SIDBSnapIntervalHours,
		maxMultiplex = 0,
dedupeFlags = @l_dedupeFlags | 262144,
		StartTime = CASE WHEN (	@l_lastMultiplexingJobTime = 0 OR
								@l_lastMultiplexingJobTime < StartTime) THEN StartTime
						 ELSE	@l_lastMultiplexingJobTime + 1
						 END
	WHERE	Id = @i_copyId
	IF @i_SPName <> ''
		UPDATE ArchGroup set name = @i_SPName
		WHERE id = (SELECT archGroupId FROM archGroupCopy WHERE id = @i_copyId)
IF (@l_dedupeFlags & 2097152) <> 0
	BEGIN
		DECLARE @l_DrivePoolID	integer
		DECLARE	@l_MediaTypeID	integer
		DECLARE	@l_RecFormatID	integer
		SET		@l_DrivePoolID	= 0
		SET		@l_MediaTypeID	= 0
		SET		@l_RecFormatID	= 0
		SELECT	@l_DrivePoolID = DrivePoolID
		FROM	MMDataPath
WHERE	CopyId = @i_CopyId AND (Flag & 8) <> 0
	END
	SELECT @o_SIDBStoreId, @i_SIDBStoreName, @i_SIDBStoreAliasName
	SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'MMAddSIDBStore')
	delete from GxQscripts where name = 'MMAddSIDBStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAddSIDBStore')
	delete from GXDBVersions where aliasname = 'MMAddSIDBStore'
GO

insert into GXDBVersions values(2, 'MMAddSIDBStore',  '00010074004400070000', 'MMAddSIDBStore', '00010074004400070000')
GO

