

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMAddMetallicStorage.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  MMAddMetallicStorage.sp                    				  */
/*                                                                            */
/*  Description :  Stored procedure to insert row into MMMetallicStorage	  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMAddMetallicStorage.sp,v $ $Id: MMAddMetallicStorage.sp,v 1.1.4.2 2020/08/24 14:15:04 pnara Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMAddMetallicStorage')
BEGIN
	print '>>> Drop Stored Procedure: MMAddMetallicStorage <<<'
	drop procedure MMAddMetallicStorage
END
IF EXISTS (select * from GxQscripts where name='MMAddMetallicStorage')
	delete from GxQscripts where name = 'MMAddMetallicStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAddMetallicStorage')
	delete from GXDBVersions where aliasname = 'MMAddMetallicStorage'
GO
print '... Creating Procedure: MMAddMetallicStorage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMAddMetallicStorage
  @i_libraryId INTEGER,
  @i_deviceId INTEGER,
  @i_licenseType INTEGER,
  @i_regionName varchar(64),
  @i_regionDisplayName varchar(256),
  @i_storageClass INTEGER,
  @i_replication INTEGER
AS
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	INSERT INTO MMMetallicStorage (DeviceId, MountPathId, LicenseType, RegionName, RegionDisplayName, StorageClass, ReplicationType, CredentialId)
	SELECT	MD.DeviceId, MP.MountPathId, @i_licenseType, @i_regionName, @i_regionDisplayName, @i_storageClass, @i_replication, MAX(CA.credentialId)
	FROM	MMDevice MD WITH(READUNCOMMITTED)
INNER JOIN MMDeviceController DC WITH(READUNCOMMITTED) ON MD.DeviceId = DC.DeviceId AND MD.DisplayDeviceTypeId = 400
			INNER JOIN MMMountPathToStorageDevice SD WITH(READUNCOMMITTED) ON MD.DeviceId = SD.DeviceId
			INNER JOIN MMMountPath MP WITH(READUNCOMMITTED) ON SD.MountPathId = MP.MountPathId
			INNER JOIN App_CredentialAssoc CA WITH(READUNCOMMITTED) ON DC.CredentialAssocId = assocId
	WHERE	(
				(@i_deviceId > 0 AND MD.DeviceId = @i_deviceId)
				OR (@i_deviceId <= 0 AND MP.LibraryId = @i_libraryId)
			)
			AND NOT EXISTS(SELECT 1 FROM MMMetallicStorage MS WITH(READUNCOMMITTED) WHERE MS.DeviceId = MD.DeviceId)
	GROUP BY MD.DeviceId, MP.MountPathId
GO

IF EXISTS (select * from GxQscripts where name = 'MMAddMetallicStorage')
	delete from GxQscripts where name = 'MMAddMetallicStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAddMetallicStorage')
	delete from GXDBVersions where aliasname = 'MMAddMetallicStorage'
GO

insert into GXDBVersions values(2, 'MMAddMetallicStorage',  '00010001000400020000', 'MMAddMetallicStorage', '00010001000400020000')
GO

