

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMAddDedupeRatioEntries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMAddDedupeRatioEntries.sp,v $ $Id: MMAddDedupeRatioEntries.sp,v 1.1.2.2 2018/05/22 23:54:09 lviswambharan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMAddDedupeRatioEntries <<<'

IF EXISTS (select * from sysobjects where name='MMAddDedupeRatioEntries')
	drop procedure MMAddDedupeRatioEntries
IF EXISTS (select * from GxQscripts where name='MMAddDedupeRatioEntries')
	delete from GxQscripts where name = 'MMAddDedupeRatioEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAddDedupeRatioEntries')
	delete from GXDBVersions where aliasname = 'MMAddDedupeRatioEntries'
GO
print '... Creating Procedure: MMAddDedupeRatioEntries'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMAddDedupeRatioEntries
AS
DECLARE @today DATETIME = CONVERT(DATE, GETUTCDATE())
DECLARE @yesterdayNight DATETIME = @today
DECLARE @yesterdayMorning DATETIME = DATEADD (DAY, -1, @yesterdayNight)
DECLARE @dayOfTheWeek INTEGER = DATEPART(WEEKDAY, @yesterdayMorning)
SET @dayOfTheWeek = (@dayOfTheWeek + @@DATEFIRST + 1) % 7 + 1 --use friday as start of the week, now friday = 1 and thursday = 7
DECLARE @lastWeekEnd   DATETIME = (CASE WHEN @dayOfTheWeek = 7 THEN @yesterdayNight ELSE DATEADD(DAY, -@dayOfTheWeek, @yesterdayNight) END)--last thursday Night
DECLARE @lastWeekStart DATETIME = DATEADD(DAY, - 7,  @lastWeekEnd) --the friday morning of that week (thursday night of previous week)
DECLARE @historyTypeDaily INTEGER = 1
DECLARE @historyTypeWeekly INTEGER = 2
DECLARE @version  INTEGER = 1
IF EXISTS (SELECT 1 FROM MMSIDBDedupeRatioHistory WHERE InsertTime = @yesterdayNight)
BEGIN
	GOTO SP_EXIT
END
IF object_id('tempdb.dbo.#tmpPerfEntries') IS NOT NULL DROP TABLE #tmpPerfEntries
CREATE TABLE #tmpPerfEntries (
    SIDBStoreId 	INTEGER,
    appId			INTEGER,
    totalAppSize    	BIGINT,
    totalDedupedSize 	BIGINT
    )
INSERT INTO #tmpPerfEntries
	SELECT	AFCD.SIDBStoreId, AF.appId, SUM(ACM.unCompSize), SUM(ACM.dedupedSize)
	FROM	archChunk AC WITH (NOLOCK)
			INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
			INNER JOIN archFileCopyDedup AFCD WITH (NOLOCK) ON ACM.archFileId = AFCD.archFileId AND ACM.commCellId = AFCD.commCellId AND ACM.archCopyId = AFCD.archCopyId
			INNER JOIN archFile AF WITH (NOLOCK) ON AF.id = AFCD.archFileId AND AF.commCellId = AFCD.commCellId
	WHERE	AC.createTime >=dbo.GetUnixTime(@yesterdayMorning) AND AC.createTime < dbo.GetUnixTime(@yesterdayNight)
	GROUP BY AFCD.SIDBStoreId, AF.appId
--insert daily entry(yesterday's)
INSERT INTO MMSIDBDedupeRatioHistory (SIDBStoreId, HistoryType, InsertTime, ClientId, AppType, ApplicationSizeBytes, NetworkTransferredBytes, SizeOnDisk, Version)
	SELECT	T.SIDBStoreId, @historyTypeDaily, @yesterdayNight, APP.clientId, APP.appTypeId, SUM(totalAppSize), 0, SUM(totalDedupedSize), @version
	FROM	#tmpPerfEntries T
			INNER JOIN APP_Application APP WITH (NOLOCK) ON T.appId = APP.id
	GROUP BY T.SIDBStoreId, APP.clientId, APP.appTypeId
--if we havent entered weekly entry for last week, aggregate last week's daily entries entries into weekly
IF NOT EXISTS (SELECT 1 FROM MMSIDBDedupeRatioHistory WHERE InsertTime = @lastWeekEnd AND HistoryType = @historyTypeWeekly)
BEGIN
	--insert last week entry
	INSERT INTO MMSIDBDedupeRatioHistory (SIDBStoreId, HistoryType, InsertTime, ClientId, AppType, ApplicationSizeBytes, NetworkTransferredBytes, SizeOnDisk, Version)
		SELECT 	SIDBStoreId, @historyTypeWeekly, @lastWeekEnd, clientId, appType,
				SUM(ApplicationSizeBytes),
				SUM(NetworkTransferredBytes),
				SUM(SizeOnDisk), @version
		FROM	MMSIDBDedupeRatioHistory
		WHERE	InsertTime > @lastWeekStart AND InsertTime <= @lastWeekEnd
				AND HistoryType = @historyTypeDaily
		GROUP BY SIDBStoreId, clientId, appType
END
SP_EXIT:
IF object_id('tempdb.dbo.#tmpPerfEntries') IS NOT NULL DROP TABLE #tmpPerfEntries
GO

IF EXISTS (select * from GxQscripts where name = 'MMAddDedupeRatioEntries')
	delete from GxQscripts where name = 'MMAddDedupeRatioEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAddDedupeRatioEntries')
	delete from GXDBVersions where aliasname = 'MMAddDedupeRatioEntries'
GO

insert into GXDBVersions values(2, 'MMAddDedupeRatioEntries',  '00010001000200020000', 'MMAddDedupeRatioEntries', '00010001000200020000')
GO

