

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMAddDataInterfacePairsWhileAddingDataPaths.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class MMAddDataInterfacePairsWhileAddingDataPaths .  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMAddDataInterfacePairsWhileAddingDataPaths')
BEGIN
	print '>>> Drop Stored Procedure: MMAddDataInterfacePairsWhileAddingDataPaths <<<'
	drop procedure MMAddDataInterfacePairsWhileAddingDataPaths
END
IF EXISTS (select * from GxQscripts where name='MMAddDataInterfacePairsWhileAddingDataPaths')
	delete from GxQscripts where name = 'MMAddDataInterfacePairsWhileAddingDataPaths'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAddDataInterfacePairsWhileAddingDataPaths')
	delete from GXDBVersions where aliasname = 'MMAddDataInterfacePairsWhileAddingDataPaths'
GO
print '... Creating Procedure: MMAddDataInterfacePairsWhileAddingDataPaths'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMAddDataInterfacePairsWhileAddingDataPaths
  @i_xml varchar(max)
AS
  DECLARE @sourceClientId int
  DECLARE @sourceClientName varchar(MAX)
  DECLARE @sourceClientInterface varchar(64)
  DECLARE @destClientId int
  DECLARE @destClientName varchar(MAX)
  DECLARE @destClientInterface varchar(64)
set nocount on
/* Sample input XML
set @i_xml ='<NewlyAddedDataPaths>
				<row DataPathId="2" />
				<row DataPathId="26" />
				<row DataPathId="29" />
			</NewlyAddedDataPaths>'
*/
DECLARE @doc INT
DECLARE @error INTEGER
DECLARE @defaultDataPathMa INTEGER = 0
DECLARE @copyId INTEGER = 0
EXEC sp_xml_preparedocument @doc output, @i_xml
SET @error = @@error
IF @error <> 0 GOTO FINISH
DECLARE @DataPathTable TABLE
(
	DataPathId int,
	maId int default 0
)
DECLARE @i_xmlString XML = @i_xml
INSERT @DataPathTable ( DataPathId)
SELECT ISNULL (ref.value('(@DataPathId)[1]', 'INT'), 0)
FROM @i_xmlString.nodes ('NewlyAddedDataPaths/row')  R(ref)
SET @error = @@error
IF @error <> 0 GOTO FINISH
UPDATE @DataPathTable SET  maId=dp.HostClientId ,@copyId=dp.CopyId  FROM @DataPathTable dpt, MMDataPath  (NOLOCK) dp WHERE  dpt.DataPathId  = dp.DataPathId
SET @defaultDataPathMa= (SELECT HostClientId FROM MMDataPath  (NOLOCK) dp WHERE dp.CopyId = @copyId AND  (flag & (1 |2 |4)) = (1 |2 |4)  )
DECLARE @DataInterfacePairConfigTbl TABLE
(
	srcClientId INT,
	sourceClientName varchar(MAX),
srcInterface VARCHAR(64),
	destClientId INT,
	destClientName varchar(MAX),
destInterface VARCHAR(64)
)
INSERT INTO @DataInterfacePairConfigTbl (srcClientId,destClientId)
SELECT t1.srcID,t2.destID
FROM  (SELECT DISTINCT maId AS srcID from @DataPathTable) AS t1  ,
      (SELECT DISTINCT ClientId AS destID FROM IdxSIDBSubStore  (NOLOCK) AS idx INNER JOIN  archCopySIDBStore CS WITH (NOLOCK)
ON idx.SIDBStoreId = CS.sidbStoreid WHERE CS.CopyId=@copyId AND ((CS.Flags & 4) > 0)) AS t2
WHERE  t1.srcID <> t2.destId
UPDATE  @DataInterfacePairConfigTbl
SET srcInterface = ac.net_hostname ,destInterface='',sourceClientName=ac.name
FROM APP_Client (NOLOCK) AS ac
WHERE srcClientId =ac.id
UPDATE  @DataInterfacePairConfigTbl
SET destClientName = ac.name
FROM APP_Client (NOLOCK) AS ac
WHERE destClientId = ac.id
UPDATE  @DataInterfacePairConfigTbl
SET destInterface = (SELECT TOP 1 arch.destInterface)
FROM @DataInterfacePairConfigTbl dp INNER JOIN archPipeline arch (NOLOCK)
ON dp.destClientId = arch.destClientId AND arch.srcClientId= @defaultDataPathMa AND isActive > 0
--Delete all DIPS, which are already configured
DELETE FROM @DataInterfacePairConfigTbl where destInterface IS NULL OR RTrim(LTrim(destInterface))=''
DELETE FROM @DataInterfacePairConfigTbl
FROM archPipeline AS arch (NOLOCK) , @DataInterfacePairConfigTbl ip
WHERE arch.srcClientId = ip.srcClientId  AND arch.destClientId = ip.destClientId
--Check if any rows exists
IF NOT EXISTS ((SELECT COUNT(*) FROM @DataInterfacePairConfigTbl) )
BEGIN
 GOTO FINISH
END
INSERT INTO archPipeline (srcClientId, srcInterface, destClientId, destInterface, isActive, srcIp, destIP, useCount_h, useCount_l,srcGroupId, destGroupId)
SELECT p.srcClientId, p.srcInterface, p.destClientId, p.destInterface, 1, '', '', 0, 0,0,0  FROM @DataInterfacePairConfigTbl p
DECLARE @dipId INTEGER = SCOPE_IDENTITY()
/*
*	When archPipeline table is modified, we also need to handle entries in archPipelineFirewall table so that commvault network configuration is updated.
*	Here the inserted dips are from client to client and do not have any wildcards involved. So we are doing a direct insert into the archPipelineFirewall table.
*	Otherwise we should be constructing the following xml and call AppProcessDips.sp
*
*	<App_WildcardDIPWorkqueueParams requestType="1" archpipelineID="1">
*		<newDIP srcInterface="172*" destInterface="172.16.26.53" srcType="2" destType="0" isActive="1">
*			<srcClientGroup clientGroupId="5"/>
*			<destClient clientId="2"/>
*		</newDIP>
*	</App_WildcardDIPWorkqueueParams>
*/
DECLARE @createTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
INSERT INTO archPipelineFirewall (srcClientId, destClientId, srcInterface, destInterface, created, modified, archPipelineId)
SELECT p.srcClientId, p.destClientId, p.srcInterface, p.destInterface, @createTime, 0, @dipId
FROM @DataInterfacePairConfigTbl p
FINISH:
IF @error <> 0 delete from @DataInterfacePairConfigTbl
IF @doc <> 0 exec sp_xml_removedocument @doc
SELECT srcClientId,sourceClientName,srcInterface,destClientId,destClientName,destInterface FROM @DataInterfacePairConfigTbl
GO

IF EXISTS (select * from GxQscripts where name = 'MMAddDataInterfacePairsWhileAddingDataPaths')
	delete from GxQscripts where name = 'MMAddDataInterfacePairsWhileAddingDataPaths'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMAddDataInterfacePairsWhileAddingDataPaths')
	delete from GXDBVersions where aliasname = 'MMAddDataInterfacePairsWhileAddingDataPaths'
GO

insert into GXDBVersions values(2, 'MMAddDataInterfacePairsWhileAddingDataPaths',  '00000000000000000000', 'MMAddDataInterfacePairsWhileAddingDataPaths', '00000000000000000000')
GO

