

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_UpdateSmartStateOfMAInDB.sp] ---------- 

/********************************************************************
Updates the operation performed by smart state MA in AppClientProp
INPUT: xmlInput XML
	<TMMsg_EntityListResp>
		<entities id1="2" id2="1" />
		<entities id1="3" id2="2" />
	</TMMsg_EntityListResp>
	Here id1 denotes the mediaagentid and id2 denotes the operation performed
	It could be
	 NO_ACTION_REQUIRED 0
	 RESTART_SERVICES 1
	 SOFTSTATE_DISABLE 2
	 SOFTSTATE_ENABLE 3
	 MONITOR 4
	 SOFTSTATE_DISABLE_RESTART_JOBS 5
*********************************************************************/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ML_UpdateSmartStateOfMAInDB')
BEGIN
	print '>>> Drop Stored Procedure: ML_UpdateSmartStateOfMAInDB <<<'
	drop procedure ML_UpdateSmartStateOfMAInDB
END
IF EXISTS (select * from GxQscripts where name='ML_UpdateSmartStateOfMAInDB')
	delete from GxQscripts where name = 'ML_UpdateSmartStateOfMAInDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_UpdateSmartStateOfMAInDB')
	delete from GXDBVersions where aliasname = 'ML_UpdateSmartStateOfMAInDB'
GO
print '... Creating Procedure: ML_UpdateSmartStateOfMAInDB'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ML_UpdateSmartStateOfMAInDB
  @xmlInput XML
AS
BEGIN
	DECLARE @currTime INT = dbo.GetUnixTime(getutcdate())
	IF OBJECT_ID('tempdb.dbo.#newStates') IS NOT NULL
		DROP TABLE #newStates
	CREATE TABLE #newStates(maId INT,newState INT)
	INSERT INTO #newStates
	SELECT ISNULL(T.C.value('@id1','int'),0) , ISNULL(T.C.value('@id2','int'),0)
	FROM @xmlInput.nodes('TMMsg_EntityListResp/entities') T(C)
	-- save the last action taken for future references
	-- do not overwrite if it was softstate disabled and if the ma is not getting new state
	UPDATE App_ClientProp SET modified = @currTime
WHERE attrName = 'Smart MA State last Action' AND modified = 0 AND attrVal NOT IN ( CAST( 2 AS VARCHAR),CAST( 5 AS VARCHAR))
	--update the softstate disabled entries if they are getting new state
	UPDATE App_ClientProp SET modified = @currTime
WHERE attrName = 'Smart MA State last Action' AND modified = 0 AND attrVal IN ( CAST( 2 AS VARCHAR),CAST( 5 AS VARCHAR))
	AND componentNameId IN (SELECT maId FROM #newStates)
	--Update the current state
	INSERT INTO App_ClientProp(componentNameId, attrname, attrType, attrVal, created, modified)
SELECT ISNULL(T.C.value('@id1','int'),0) , 'Smart MA State last Action', 7 , ISNULL(T.C.value('@id2','int'),0), @currTime, 0
	FROM @xmlInput.nodes('TMMsg_EntityListResp/entities') T(C)
	IF OBJECT_ID('tempdb.dbo.#newStates') IS NOT NULL
		DROP TABLE #newStates
END
GO

IF EXISTS (select * from GxQscripts where name = 'ML_UpdateSmartStateOfMAInDB')
	delete from GxQscripts where name = 'ML_UpdateSmartStateOfMAInDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_UpdateSmartStateOfMAInDB')
	delete from GXDBVersions where aliasname = 'ML_UpdateSmartStateOfMAInDB'
GO

insert into GXDBVersions values(2, 'ML_UpdateSmartStateOfMAInDB',  '00000000000000000000', 'ML_UpdateSmartStateOfMAInDB', '00000000000000000000')
GO

