

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_SetSmartMAStateMgmtProperties.sp] ---------- 

/********************************************************************************************************************************
ProcName: ML_SetSmartMAStateMgmtProperties
Input	:	1. userId
			2. localeId
			3. inputXml
			<CVGui_SetSmartMAStateManagementReq enabled = "1" listOpType = "1">
				<entities>
					<associations _type_="16"/>
					<associations _type_="17" storagePolicyId="3" >
						<flags exclude = "1"/>
					</associations>
				</entities>
			</CVGui_SetSmartMAStateManagementReq>
Output	:	<CVGui_GenericEntityResponse errorCode="0" errorString = "Success"/>
1. To disable this feature completely, the user should have Administrative Management capabilities in the commcell level
2. To enable or disable an SP, user should have Administrative Management on the particular SP
3.
*********************************************************************************************************************************/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ML_SetSmartMAStateMgmtProperties')
BEGIN
	print '>>> Drop Stored Procedure: ML_SetSmartMAStateMgmtProperties <<<'
	drop procedure ML_SetSmartMAStateMgmtProperties
END
IF EXISTS (select * from GxQscripts where name='ML_SetSmartMAStateMgmtProperties')
	delete from GxQscripts where name = 'ML_SetSmartMAStateMgmtProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_SetSmartMAStateMgmtProperties')
	delete from GXDBVersions where aliasname = 'ML_SetSmartMAStateMgmtProperties'
GO
print '... Creating Procedure: ML_SetSmartMAStateMgmtProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ML_SetSmartMAStateMgmtProperties
  @userId INT,
  @localeId INT,
  @inputXml XML
AS
  DECLARE @outputXml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @propertyExists INT = 0
	DECLARE @enabledOld INT = 0
	DECLARE @enabledNew INT = 0
	DECLARE @listOpType INT = 0
	DECLARE @xmlEntitiesOld XML
	DECLARE @xmlEntitiesNew XML
	DECLARE @isAdmin INT = 0
	DECLARE @isAllowed INT = 0
	DECLARE @entitiesNotAllowed NVARCHAR(MAX)
	DECLARE @userName NVARCHAR(510) = (SELECT login FROM UMUsers WHERE id = @userId)
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @curTime INT = DATEDIFF(SECOND,'19700101',getutcdate())
	DECLARE @oldSelectedMAs TABLE(maId INT)
	DECLARE @newSelectedMAs TABLE(maId INT)
	DECLARE @changedMAs  TABLE(maId INT,value varchar(10))
	DECLARE @outTable TABLE (keyId INT,maId INT)
	DECLARE @NewSelections TABLE(entityType INT,entityId INT,exclude INT)
	DECLARE @OldSelections TABLE(entityType INT,entityId INT,exclude INT)
	INSERT INTO @OldSelections
	SELECT longVal, longlongVal ,CAST(stringVal AS INT)
	FROM app_componentprop
WHERE componentType=1 AND componentid=2 AND propertyTypeId = 21
	INSERT INTO @NewSelections
	SELECT	ISNULL(T.C.value('@_type_','int'),0) entityType,
			ISNULL(T.C.value('@storagePolicyId','int'),0) entityId,
			ISNULL(T.C.value('(flags/@exclude)[1]','int') ,0) exclude
			FROM @inputXml.nodes('CVGui_SetSmartMAStateManagementReq/entities/associations') T(C)
	INSERT INTO @oldSelectedMAs
	EXEC ML_GetMAsForSmartStateMgmt 1
	SET @enabledNew = @inputXml.value('(/CVGui_SetSmartMAStateManagementReq/@enabled)[1]','int')
	SET @listOpType = ISNULL(@inputXml.value('(/CVGui_SetSmartMAStateManagementReq/@listOpType)[1]','int'),1) /*1 overwrte */
	SET @xmlEntitiesNew = @inputXml.query('/CVGui_SetSmartMAStateManagementReq/entities')
	SET @xmlEntitiesNew = REPLACE(CAST(@xmlEntitiesNew AS NVARCHAR(MAX)),'entities','CVGui_CommCellTreeNode')
SELECT @propertyExists = 1,@enabledOld = longVal,  @xmlEntitiesOld = stringVal FROM App_ComponentProp WHERE componentType = 1
AND componentId = 2 AND propertytypeId = 20 AND modified=0
	SET @xmlEntitiesOld = (SELECT(
								SELECT entityType '@_type_',
									   entityId '@storagePolicyId',
									   nullif(exclude,0)  'flags/@exclude'
								FROM @OldSelections
								FOR XML PATH('associations'),TYPE)
								FOR XML PATH(''),ROOT('CVGui_CommCellTreeNode'))
	-- feature disabling - can be done only by admin user
	IF @enabledNew = 0
	BEGIN
EXEC DBO.sec_checkPermissionOnEntity @userId , 1, @isAdmin OUTPUT, 1, 2
        IF @isAdmin = 0
        BEGIN
SET @errorCode = (2047 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2047 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
            GOTO ERROR_EXIT
        END
DELETE FROM App_ComponentProp WHERE componentType=1 AND componentId=2 AND propertyTypeId=20
    END
	ELSE
	BEGIN
		IF @listOpType = 2 OR @listOpType = 3				/* ADD OR DELETE - User should have permission on the new list */
		BEGIN
EXEC sec_checkPermissionOnEntityList @userId, @localeId, @xmlEntitiesNew, '', 1 , @isAllowed OUTPUT, @entitiesNotAllowed OUTPUT
		END
		ELSE IF @listOpType = 4								/* CLEAR - User should have permission on the old list */
		BEGIN
EXEC sec_checkPermissionOnEntityList @userId, @localeId, @xmlEntitiesOld, '', 1 , @isAllowed OUTPUT, @entitiesNotAllowed OUTPUT
		END
		ELSE IF @listOpType = 1								/* OVERWRITE - User should have permission on the old and new list */
		BEGIN
EXEC sec_checkPermissionOnEntityList @userId, @localeId, @xmlEntitiesOld, '', 1 , @isAllowed OUTPUT, @entitiesNotAllowed OUTPUT
			IF @isAllowed = 1
EXEC sec_checkPermissionOnEntityList @userId, @localeId, @xmlEntitiesNew, '', 1 , @isAllowed OUTPUT, @entitiesNotAllowed OUTPUT
		END
		IF @isAllowed = 0
		BEGIN
SET @errorCode = (1157 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1157 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
			SET @errorString = REPLACE(@errorString,'^1%s',@userName)
			SET @errorString = REPLACE(@errorString,'^2%s',@entitiesNotAllowed)
			GOTO ERROR_EXIT
		END
		ELSE
		BEGIN
	   			--	NONE=0,	OVERWRITE=1,	ADD=2,	DELETE=3,	CLEAR=4
			IF @listOpType = 1	/*OVERWRITE*/
				BEGIN
DELETE FROM App_ComponentProp WHERE componentType=1 AND componentId=2 AND propertyTypeId=21 AND modified=0
					INSERT INTO App_ComponentProp(componenttype,componentid,propertytypeid,dataType,longVal,longlongVal,stringVal,created,modified)
SELECT 1, 2, 21, 7,	entityType, entityId, exclude, @curTime, 0
					FROM @NewSelections
				END
			ELSE IF @listOpType = 2	/*ADD*/
				BEGIN
					MERGE App_ComponentProp AS TARGET
					USING (SELECT entityType, entityId, exclude FROM @NewSelections) AS SOURCE
ON (TARGET.componentType = 1 AND TARGET.componentId = 2 AND TARGET.propertyTypeId = 21
						AND TARGET.longVal = Source.entityType AND TARGET.longlongval = SOURCE.entityId)
					WHEN MATCHED THEN
						UPDATE SET TARGET.stringVal = SOURCE.exclude
					WHEN NOT MATCHED BY TARGET THEN
						INSERT (componenttype,componentid,propertytypeid,dataType,longVal,longlongVal,stringVal,created,modified)
VALUES (1,2,21,7,SOURCE.entityType, SOURCE.entityId, SOURCE.exclude, @curTime, 0);
				END
			ELSE IF @listOpType = 3	/*DELETE*/
				BEGIN
					DELETE ACP
					FROM App_ComponentProp ACP
INNER JOIN @NewSelections SE ON componentType=1 AND componentId=2 AND propertyTypeId=21 AND modified=0
								AND ACP.longVal= SE.entityType AND ACP.longlongVal =  SE.entityId AND ACP.stringval =  SE.exclude
				END
			ELSE IF @listOpType = 4	/*CLEAR*/
				BEGIN
DELETE FROM App_ComponentProp WHERE componentType=1 AND componentId=2 AND propertyTypeId=21 AND modified=0
				END
			IF @propertyExists = 0
				INSERT INTO App_ComponentProp(componenttype,componentid,propertytypeid,dataType,longVal,longlongVal,stringVal,created,modified)
VALUES(1,2,20,1,@enabledNew,0,'',DATEDIFF(SECOND,'19700101',getutcdate()),0   )
			ELSE
UPDATE App_ComponentProp SET longVal = @enabledNew WHERE componenttype=1 AND componentId=2 AND propertytypeId=20 AND  modified = 0
		END
	END
	INSERT INTO @newSelectedMAs
	EXEC ML_GetMAsForSmartStateMgmt 1
	INSERT INTO @changedMAs
	SELECT maId, 'true' FROM @newSelectedMAs
	EXCEPT
	SELECT maId, 'true' FROM @oldSelectedMAs
	INSERT INTO @changedMAs
	SELECT maId, 'false' FROM @oldSelectedMAs
	EXCEPT
	SELECT maId, 'false' FROM @newSelectedMAs
	INSERT INTO @outTable
    SELECT id, maId FROM
    (
        MERGE APP_AdvanceSettings as Target
USING (SELECT maId as entityID , 3 as entityType ,'bEnableSmartMAStateMgmt' as keyName, 'BOOLEAN' as type, 'MediaAgent' as relativePath, value FROM @changedMAs ) Source
        ON Target.entityId = Source.entityID AND Target.entityType = Source.entityType AND Target.KeyName = Source.keyName AND Target.type = Source.type AND Target.relativePath = Source.relativePath AND Target.sourceId = 0 AND Target.sourceEntityType = 0
        WHEN MATCHED THEN UPDATE SET Target.value = Source.value
        WHEN NOT MATCHED AND Source.value = 'true' THEN
        INSERT VALUES(entityID, keyName, type, relativePath, value, 1, 0, entityType, 0, 0)
        OUTPUT $action, Inserted.id, Inserted.entityId
    ) AS Temp(MergeAction, id, maId)
    MERGE APP_AdvanceSettingsEx Target
    USING (SELECT keyId FROM @outTable) AS Source
    ON Source.keyId = Target.keyId
    WHEN MATCHED THEN UPDATE SET Target.hidden = 1
    WHEN NOT MATCHED THEN INSERT VALUES(Source.keyId,'',1);
	INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
      SELECT maId, -1, 6, '', @curTime, 0, 0, 0 FROM @outTable--WORK_TOKEN_REGISTRY
	-- do audit
	DECLARE @entitiesAdded      NVARCHAR(MAX)
	DECLARE @entitiesRemoved    NVARCHAR(MAX)
	-- all entities
	DECLARE @allEntitiesSelectedOld INT = 0
	DECLARE @allEntitiesSelectedNew INT = 0
	-- audit change in association only when there are entries in @NewSelections,  else it coould be just enable/disable
	-- feature with no change in entity associations
	IF EXISTS (SELECT 1 FROM @NewSelections)
	BEGIN
IF EXISTS(SELECT 1 FROM @NewSelections WHERE entityType = 16)
			SET @allEntitiesSelectedNew = 1
IF EXISTS(SELECT 1 FROM @OldSelections WHERE entityType = 16)
			SET @allEntitiesSelectedOld = 1
		IF @allEntitiesSelectedNew = 1 AND @allEntitiesSelectedOld = 0
			SET @entitiesAdded = 'All Storage Policies'
		SELECT @entitiesAdded  = 	CASE(exclude)
									WHEN 1 THEN COALESCE(@entitiesAdded + ', ' + name + '(exclude)',name + '(exclude)')
									ELSE COALESCE(@entitiesAdded + ', ' + name ,name )
									END
		FROM archGroup INNER JOIN
		(
		 SELECT * FROM @NewSelections
		 EXCEPT
		 SELECT * FROM @OldSelections
		 )Diff ON Diff.entityId  = archGroup.id
		IF @allEntitiesSelectedOld = 1 AND @allEntitiesSelectedNew = 0
			SET @entitiesRemoved = 'All Storage Policies'
		SELECT @entitiesRemoved  =  CASE(exclude)
									WHEN 1 THEN COALESCE(@entitiesRemoved + ', ' + name + '(exclude)',name + '(exclude)')
									ELSE COALESCE(@entitiesRemoved + ', ' + name ,name )
									END
		FROM archGroup INNER JOIN
		(
		 SELECT * FROM @OldSelections
		 EXCEPT
		 SELECT * FROM @NewSelections
		 )Diff ON Diff.entityId  = archGroup.id
	END
	DECLARE @opMsgId            INTEGER
	DECLARE @opEvMsgId          INTEGER
	DECLARE @opId               INTEGER
	DECLARE @paramMsgId         INTEGER
	DECLARE @paramData          NVARCHAR(1024)
	-- audit only if something is changed
	IF @enabledNew <> @enabledOld OR LEN(@entitiesAdded) >  0 OR LEN(@entitiesRemoved) >  0
	BEGIN
SET @opMsgId = (693 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
		IF @enabledNew <> @enabledOld
		BEGIN
SET @paramMsgId = IIF(@enabledNew = 1, (220 | (CAST(POWER(2, 24) AS BIGINT) * 85)), (221 | (CAST(POWER(2, 24) AS BIGINT) * 85)))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		IF LEN(@entitiesAdded) >  0
		BEGIN
SET @paramMsgId = (1843 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParamData @opId, @entitiesAdded, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		IF LEN(@entitiesRemoved) >  0
		BEGIN
SET @paramMsgId = (1844 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParamData @opId, @entitiesRemoved, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
	END
	ERROR_EXIT:
		SELECT @errorCode as '@errorCode', @errorString as '@errorString'
		FOR XML PATH('App_GenericEntityResponse')
END
GO

IF EXISTS (select * from GxQscripts where name = 'ML_SetSmartMAStateMgmtProperties')
	delete from GxQscripts where name = 'ML_SetSmartMAStateMgmtProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_SetSmartMAStateMgmtProperties')
	delete from GXDBVersions where aliasname = 'ML_SetSmartMAStateMgmtProperties'
GO

insert into GXDBVersions values(2, 'ML_SetSmartMAStateMgmtProperties',  '00000000000000000000', 'ML_SetSmartMAStateMgmtProperties', '00000000000000000000')
GO

