

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_PredictSLA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ML_PredictSLA.sp,v $ $Id: ML_PredictSLA.sp,v 1.1.2.16.6.1 2021/01/08 11:33:11 snandhini Exp $";
/*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
     ML_PredictSLA - Predict if SLA would succeed/fail
	 Returns clients where SLA is expected to fall
	 Input :	1. localeid
				2. subClient (with nextshedule time information)
				3. in_clientId
	 Output:    clientId
				clientName
				reason
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ML_PredictSLA')
BEGIN
	print '>>> Drop Stored Procedure: ML_PredictSLA <<<'
	drop procedure ML_PredictSLA
END
IF EXISTS (select * from GxQscripts where name='ML_PredictSLA')
	delete from GxQscripts where name = 'ML_PredictSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_PredictSLA')
	delete from GXDBVersions where aliasname = 'ML_PredictSLA'
GO
print '... Creating Procedure: ML_PredictSLA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ML_PredictSLA
  @localeId INT,
  @subClients VARCHAR(MAX),
  @in_clientid INT
AS
  DECLARE @clientId INT
  DECLARE @clientName NVARCHAR(510)
  DECLARE @reason NVARCHAR(MAX)
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	IF OBJECT_ID('tempdb.dbo.#tempSubClient') IS NOT NULL DROP TABLE #tempSubClient
	IF OBJECT_ID('tempdb.dbo.#discoveredVMs') IS NOT NULL DROP TABLE #discoveredVMs
	IF OBJECT_ID('tempdb.dbo.#UrlTbl') IS NOT NULL DROP TABLE #UrlTbl
	DECLARE @SLAMissedClients TABLE(clientId int, reason nvarchar(MAX),clientName nvarchar(510))
	DECLARE @SLAMissedIda TABLE(idaId int,reason nvarchar(MAX))
	DECLARE @SLAMissedInstance TABLE(instanceId int,reason nvarchar(MAX))
	DECLARE @OpWindows TABLE(opId int, startTime int, endTime int, donotSubmitJob int)
	CREATE TABLE #tempSubClient
	(
		subclientId						int,
		clientId						int,
		appType							int,
		idaId							int,
		instanceId						int,
		backupsetId						int,
		jobId							int,
		subclientName					NVARCHAR(256),
		lastBackupTime					int default(0),
		createdTime						int default(0),
		nextSchedule					int default(0),
		skipSubclient					int default(0),
		nextScheduleBkpLvl				int,
		nextScheduleOpType				int,
		subTaskId						int default(0),
		forecastPropertyName			varchar(64),
		plainForecastTime		int default(0),
		jobCompletionTime	    int default(0),
		successiveFailedJobs			int default(0),
		isRunning						int default(0),
		isAnomalous						int default(0),
		slaDays							int default(0),
		jobShouldCompleteBefore			int,
		jobShouldCompleteBeforeCellTime datetime,
		slaStatus						int default(0),
		lastBackupday					int,
		missReason						int default(0),
		missReasonParam					NVARCHAR(256) default(NULL),
		jobUrlParam         			NVARCHAR(256) default(NULL),
		reason							NVARCHAR(MAX),
		PRIMARY KEY(subclientId, clientId)
	)
	CREATE TABLE #discoveredVMs
	(
		clientId int,
		version int  default(1),
		lastbackupTime int
	)
	DECLARE @clientSLA TABLE
	(
		clientId INT,
		sla INT
	)
	CREATE TABLE #UrlTbl
	(
		clientId INT,
		url NVARCHAR(512)
	)
	DECLARE @allowRunningJobsToCompletePastOPWindow INT = ISNULL((SELECT value FROM GxGlobalParam WHERE name = 'JobsCompletePastOperationalWindow' AND modified = 0), 0)
	DECLARE @alertMissedSLAAlso INT = ISNULL((SELECT value FROM GxGlobalParam WHERE name = 'AlertMissedSLAAlso' AND modified = 0), 0)
	DECLARE @currTime INT = DBO.getUnixTime(GETUTCDATE())
	DECLARE @currDate   DATETIME = CONVERT(DATE,GETUTCDATE())
	DECLARE @utcdiff INT = DATEDIFF(SECOND, GETUTCDATE(), dbo.UTCToCellLocalTime(GETUTCDATE(),2))
	DECLARE @SkipWeekend INT = 0
	DECLARE @GracePeriodDays INT = 0
	DECLARE @adminConsoleUrl NVARCHAR(512)
	DECLARE @jobUrl NVARCHAR(512)
	SET @adminConsoleUrl = (SELECT TOP 1 value FROM GxGlobalParam WHERE name='WebConsoleURL' and modified = 0)
	IF @adminConsoleUrl IS NOT NULL
	BEGIN
		SET @adminConsoleUrl = REPLACE(@adminConsoleUrl, 'webconsole/clientDetails/fsDetails.do?clientName=CLIENTNAME','adminconsole')
	END
	ELSE
	BEGIN
		INSERT INTO #UrlTbl
		EXEC APPGetWebConsoleURL
		SELECT @adminConsoleUrl = url FROM #UrlTbl
		--path could be http:--webconsole1:80/webconsole so not replacing webconsole with adminconsole
		IF  @adminConsoleUrl IS NOT NULL AND LEN( @adminConsoleUrl) > 9
			SELECT @adminConsoleUrl =  SUBSTRING(@adminConsoleUrl,0,LEN(@adminConsoleUrl)-9) +'adminconsole'
	END
	IF @adminConsoleUrl IS NOT NULL
	BEGIN
		SET @jobUrl = '<a href=' + @adminConsoleUrl + '#/jobs/[jobid]' + '>[jobid]'+ '</a>'
	END
	ELSE
		SET @jobUrl = '[jobid]'
	SELECT  @SkipWeekend = longVal
	FROM    APP_ComponentProp WITH (NOLOCK)
WHERE   componentType = 1 AND componentId = 2 AND propertyTypeId = 3319 AND modified = 0
	SELECT  @GracePeriodDays = longVal
	FROM    APP_ComponentProp WITH (NOLOCK)
WHERE   componentType = 1 AND componentId = 2 AND propertyTypeId = 3309 AND modified = 0
	-- Get SLA days for each client based on value from clientgroup
	INSERT INTO @clientSLA
	SELECT clientId, MIN(longVal) FROM APP_ComponentProp CP
INNER JOIN APP_ClientGroupAssoc CG ON CG.clientGroupId = CP.componentId AND CP.componentType = 8 AND propertyTypeId = 3300 AND modified = 0
	GROUP BY CG.clientid
	--  GetSubClients for which SLA has to be calculated
	INSERT INTO #tempSubClient(subclientId, sladays, clientId, idaId, appType, instanceId, backupsetId, subclientName, createdTime, skipSubClient)
	SELECT DISTINCT RPT.appId, RPT.slaDays, RPT.clientId, IDA.id, APP.appTypeId, APP.instance, APP.backupset, APP.subclientname, APP.refTime, IIF(APP.subclientstatus & (64|4096) = 0 /*(CV_STATUS_CMD_LINE)(CV_STATUS_LOGCMD_LINE)*/, 0, 1)
	FROM RptSlaSubclient RPT
	INNER JOIN App_Application APP ON RPT.appId = APP.id
	INNER JOIN App_idaName IDA ON IDA.clientId = APP.clientId AND APP.appTypeId = IDA.appTypeId
	WHERE RPT.status <> 3 /*EXCLUDED*/ AND RPT.fulljobsonly=0 AND @in_clientId IN  (0, RPT.clientId)
	UPDATE SC SET lastBackupTime = CONVERT(int, attrVal)
	FROM #tempSubClient SC
	INNER JOIN App_SubClientProp SCP ON SCP.componentNameId =  SC.subclientId AND SCP.attrName = 'Last Data Protected Time' AND modified = 0
	-- get discovered vms
	INSERT INTO #discoveredVMs(clientId)
	SELECT componentNameId
	FROM App_ClientProp
	WHERE attrName = 'Virtual Server Discovered Clients' AND attrval = '1' and modified = 0 and @in_clientId in (0, componentnameid)
	EXCEPT
	SELECT componentNameId
	FROM App_clientprop
	WHERE attrname='Virtual Machine Deletion Time' AND modified = 0 AND attrval<>'0'
	-- check if they are v1 or v2
	UPDATE VM SET version = 2
	FROM #discoveredVMs VM
	INNER JOIN App_ClientProp Prop ON VM.clientId = Prop.componentNameId AND Prop.attrName = 'IndexingV2_VSA'
	WHERE Prop.attrVal='1' AND Prop.modified = 0
	-- get the last back up time
	UPDATE VM SET lastbackupTime = ISNULL(LastBackup.backupTime,0)
	FROM #discoveredVMs VM
	LEFT JOIN
	(
	 SELECT MAX(CAST(attrval AS INT))backupTime , componentNameId clientId
	 FROM App_ClientProp
	 WHERE attrName = 'Last VM Backup Start Time' AND modified = 0
	 GROUP BY componentNameId
	 )LastBackup
	 ON VM.clientId = LastBackup.clientId
	--update the last backup time , subclientid
	UPDATE TSC SET lastBackupTime = VM.lastBackupTime, subclientId = IIF(version = 2, App.id, TSC.subclientId)
	FROM #tempSubClient TSC
	INNER JOIN #discoveredVMs VM ON TSC.clientId = VM.clientId
	LEFT JOIN App_Application App ON VM.clientId = App.clientId
WHERE App.apptypeid = 106 and TSC.apptype = 106
	--update the created time for discovered VMs
	UPDATE TSC SET createdTime = C.reftime
	FROM #tempSubClient TSC
	INNER JOIN #discoveredVMs VM ON TSC.clientId = VM.clientId
	INNER JOIN App_Client C ON C.id = VM.clientId
	-- if grace  period is set, that overrides sladays in new clients
	-- cliet created time cannot be  obtained from app_clienttable as it doesnot have created time value for clientid 2
	IF @GracePeriodDays <> 0
	BEGIN
		UPDATE TSC SET sladays = @GracePeriodDays
		FROM #tempSubClient TSC
		INNER JOIN
		(
			SELECT componentnameid clientId FROM app_clientprop GROUP BY componentNameId
			HAVING MIN(created) > @currTime - (@GracePeriodDays*24*60*60)
			INTERSECT
			SELECT clientId FROM #tempsubclient GROUP BY clientId
			HAVING MAX(lastbackuptime)=0
		)NewClientsWithoutBackup ON NewClientsWithoutBackup.clientId = TSC.clientId
	END
	/*
	sunday - 1
	monday - 2
	tuesda - 3
	wedesd - 4
	thursd - 5+1
	friday - 6
	saturd - 7
	weekday+sladay >= 7  +2
	if weekday = saturday then  +1
	*/
	IF @SkipWeekEnd = 0
		UPDATE #tempSubClient  SET jobShouldCompleteBeforeCellTime = DATEADD(DAY, sladays, dbo.getdatetime(IIF(lastbackuptime>0, lastbackuptime + @utcdiff, createdTime + @utcdiff)))
	ELSE
		BEGIN
			UPDATE #tempSubClient  SET jobShouldCompleteBeforeCellTime =  dbo.getdatetime(IIF(lastbackuptime>0, lastbackuptime + @utcdiff, createdTime + @utcdiff))
			-- jobs that ran before 8AM are considered to be jobs of the previous day
			UPDATE #tempSubClient
			SET lastbackupday = IIF(DATEPART(HOUR,jobShouldCompleteBeforeCellTime)>=8, DATEPART(WEEKDAY,jobShouldCompleteBeforeCellTime), IIF(DATEPART(WEEKDAY,jobShouldCompleteBeforeCellTime) = 1, 7, DATEPART(WEEKDAY, jobShouldCompleteBeforeCellTime)-1))
			-- if job ran on saturday, increment by one day
			-- if sla period has weekends in it, increment by 2
			UPDATE #tempSubClient
			SET jobShouldCompleteBeforeCellTime = CASE
													WHEN lastbackupday = 7 THEN DATEADD(DAY, sladays+1, jobShouldCompleteBeforeCellTime)
													WHEN lastbackupday + sladays >= 7 THEN DATEADD(DAY,sladays + 2,jobShouldCompleteBeforeCellTime)
													ELSE DATEADD(DAY,sladays + 2,jobShouldCompleteBeforeCellTime)
												  END
			WHERE sladays < 7
			UPDATE #tempSubClient
			SET jobShouldCompleteBeforeCellTime = DATEADD(DAY, sladays, dbo.getdatetime(IIF(lastbackuptime>0, lastbackuptime + @utcdiff, createdTime + @utcdiff)))
			WHERE sladays >= 7
	END
	UPDATE #tempSubClient  SET jobShouldCompleteBeforeCellTime = IIF(DATEPART(HOUR, jobShouldCompleteBeforeCellTime) >= 8 , DATEADD(HOUR, 32, CAST(CAST(jobShouldCompleteBeforeCellTime AS DATE) AS DATETIME)), DATEADD(HOUR, 8, CAST(CAST(jobShouldCompleteBeforeCellTime AS DATE) AS DATETIME)))
	UPDATE #tempSubClient  SET jobShouldCompleteBefore = dbo.GetUnixTime(jobShouldCompleteBeforeCellTime) - @utcdiff
	UPDATE SC SET nextSchedule = RB.jobstarttime , SC.nextScheduleOpType = RB.opType, SC.nextScheduleBkpLvl = RB.bkpLevel, isRunning = 1, jobId = RB.jobId, isAnomalous = CASE WHEN RB.guiAlertColorLevel >= 100000 THEN 1 ELSE 0 END-- (JMGUIAlertColorLevel::GUI_ALERT_COLOR_ANOMALOUS)
	FROM #tempSubClient SC
	INNER JOIN RunningBackups RB ON SC.subclientId = RB.applicationId
 	AND RB.bkpLevel <> 64 /*CVBkpLevel_SYNTHETIC_FULL*/
	-- get runing job of discoverd VM, it doesnt come in previous query  as runningbackups doesnt have it
	UPDATE SC SET nextSchedule = J.jobstarttime , SC.nextScheduleOpType = J.opType, SC.nextScheduleBkpLvl = B.bkpLevel, isRunning = 1, jobId = J.jobid
	FROM #tempSubClient SC
	INNER JOIN #discoveredVMs VM ON SC.clientId = VM.clientId AND VM.version = 2
	INNER JOIN JMBkpJobInfo B ON SC.subclientId = B.applicationId
	INNER JOIN JMJobInfo J  ON J.jobId=B.jobId
 	AND B.bkpLevel <> 64 /*CVBkpLevel_SYNTHETIC_FULL*/
	--get the scheduled run time if there are no jobs running currently
	IF OBJECT_ID('tempdb.dbo.#NextSchTime') IS NOT NULL
		DROP TABLE #NextSchTime
	CREATE TABLE #NextSchTime(subtaskId INT, subclientId INT, nextScheduleTime INT, bkpLevel INT, opType INT, clientId INT)
	DECLARE @hdoc int
	EXEC sp_xml_preparedocument @hdoc OUTPUT, @subClients
	INSERT INTO #NextSchTime(subtaskId , subclientId, clientId, nextScheduleTime, bkpLevel)
	SELECT ISNULL(subtaskId,0) , subclientId, clientId, ISNULL(nextScheduleTime,0), bkpLevel
	FROM OPENXML (@hdoc, '/TMMsg_BackupEntityInfoList/subclientInfo' , 2)
	WITH(
		subtaskId INT 'schedules/scheduleEntity/@subtaskId',
		subclientId INT 'subclient/@subclientId',
		clientId INT 'subclient/@clientId',
		nextScheduleTime INT 'schedules/@nextScheduleTime',
		bkpLevel INT 'schedules/@backupLevel'
		)
	EXEC sp_xml_removedocument @hdoc
	DELETE FROM #NextSchTime WHERE  nextScheduleTime = 0 AND subtaskid = 0
    /* From managedbforjm.cpp CVManageDBForJM::GetJmOperationType*/
	UPDATE NST SET opType = CASE SUB.operationType
WHEN 3 THEN 51 /*CVOpType_CREATERECOVERYPOINT*/
WHEN 4 THEN 50 /*CVOpType_CREATECONSISTENCYPOINT*/
WHEN 5 THEN 58 /*CVOpType_SRMOPTYPE*/
WHEN 6 THEN 76 /*CVOpType_ARCHIVEOPTYPE */
WHEN 4034 THEN 75 /*CVOpType_FDCOPTYPE*/
WHEN 4033 THEN 78 /*CVOpType_FDCPREPARATION*/
WHEN 10 THEN 87 /*CVOpType_TURBO_NAS*/
							ELSE 4 /*CVOpType_BACKUP*/
							END
	FROM #NextSchTime NST
	INNER JOIN TM_Subtask SUB ON NST.subtaskId = SUB.subtaskId
	UPDATE SC SET nextSchedule = NST.nextScheduleTime, nextScheduleBkpLvl = bkpLevel, nextScheduleOpType = opType, subTaskId = NST.subTaskId
    FROM #tempSubClient SC
    INNER JOIN #NextSchTime NST ON NST.subclientId = SC.subclientId
    WHERE SC.nextSchedule = 0
	-- for discovered clients, get schedulttime based on clientid
	UPDATE SC SET nextSchedule = NST.nextScheduleTime, nextScheduleBkpLvl = bkpLevel, nextScheduleOpType = opType, subTaskId = NST.subTaskid
    FROM #tempSubClient SC
    INNER JOIN #NextSchTime NST ON NST.clientId = SC.clientId
	INNER JOIN #discoveredVMs VM ON VM.clientid = NST.clientId
    WHERE SC.nextSchedule = 0
	-- Generate the propertyname
	UPDATE #tempSubClient SET forecastPropertyName = CONCAT('Estimated Run Time_',nextScheduleOpType,'_',nextScheduleBkpLvl)
	-- Get ForecastTime
	UPDATE SC SET plainForecastTime = SCP.attrval
	FROM #tempSubClient SC
	INNER JOIN APP_SubClientProp SCP ON SCP.componentNameId = SC.subclientId AND SCP.attrName = SC.forecastPropertyName AND modified = 0
	-- Unset the foreast time in case of v1 discovered clients
	UPDATE TSC SET plainforecasttime = 0
	FROM #tempSubClient TSC
	INNER JOIN #discoveredVMs VM ON TSC.clientId = VM.clientId AND VM.version = 1
	/*call ml_calcopdelay to get the actual forecasted runtime*/
	IF OBJECT_ID('tempdb.dbo.#SubClientForecastInput') IS NOT NULL
		DROP TABLE #SubClientForecastInput
	CREATE TABLE #SubClientForecastInput
	(
		subclientId int,
		plainForecastTime int,
		jobStartTime int,
		forecastTime int,
		opType int,
		bkpLevel int
	)
	IF @allowRunningJobsToCompletePastOPWindow = 1
	BEGIN
		INSERT INTO #SubClientForecastInput (subclientId, jobStartTime, plainForecastTime, forecastTime, opType, bkpLevel)
		SELECT subClientId, nextSchedule, plainForecastTime, 0, nextScheduleOpType, nextScheduleBkpLvl
		FROM #tempSubClient WHERE nextSchedule > 0 AND plainForecastTime > 0 AND isRunning <> 1
		UPDATE #tempSubClient SET jobCompletionTime = nextSchedule + plainForecastTime
		WHERE isRunning = 1 AND plainForecastTime > 0
	END
	ELSE
	BEGIN
		INSERT INTO #SubClientForecastInput (subclientId,jobStartTime,plainForecastTime,forecastTime, opType, bkpLevel)
		SELECT subClientId, nextSchedule, plainForecastTime, 0, nextScheduleOpType, nextScheduleBkpLvl
		FROM #tempSubClient WHERE nextSchedule > 0 AND plainForecastTime > 0
	END
	EXEC ML_CalcOpWinDelay
	UPDATE SC SET jobCompletionTime = nextSchedule + forecastTime
	FROM #tempSubClient SC
	INNER JOIN #SubClientForecastInput SCF ON SC.subclientId = SCF.subclientId
	WHERE ISNULL(forecastTime,0) > 0
    -- Get the subclient that is expected to fail because it failed in the past 5 attempts consecutively
	UPDATE TSC SET successiveFailedJobs = cnt
	FROM #tempSubClient TSC
	INNER JOIN
	(
		SELECT SC.subclientId, COUNT(DISTINCT(jbs.jobid)) cnt
		FROM JMBkpStats JBS
		INNER JOIN #tempSubClient SC ON JBS.appId = SC.subclientId WHERE JBS.servStartDate > SC.lastBackupTime
		AND status IN (2,15) /* CVJobStatus - FAIL,SYSTEMFAILED */
		AND bkplevel <> 64 /*CVBkpLevel_SYNTHETIC_FULL*/
		GROUP BY SC.subclientId
	)Failed
	ON TSC.subclientId = Failed.subclientId
	-- where sla is already missed
	-- Never ran
	UPDATE #tempSubclient
	SET slaStatus = 2,--MISSED_SLA
missReason = (1643 | (CAST(POWER(2, 24) AS BIGINT) * 83))
	WHERE lastbackupTime =  0 and jobShouldCompleteBefore <  @currTime
	--Jobs didnot complete for past n days
	UPDATE #tempSubClient
	SET slaStatus = 2, /*MISSED_SLA*/
missReason = (1642 | (CAST(POWER(2, 24) AS BIGINT) * 83)),
		missReasonParam = (@currTime - lastBackupTime)/(3600*24)
	WHERE lastbackupTime > 0 AND jobShouldCompleteBefore < @currTime AND slaStatus = 0
	-- SLAis not missed  but might miss hereafter
	-- Get subclients where job is not scheduled
	UPDATE #tempSubClient
	SET slaStatus = 5, -- MIGHT_MISS_SLA
missReason = (1651 | (CAST(POWER(2, 24) AS BIGINT) * 83))
	WHERE nextSchedule = 0 AND subTaskId = 0 AND slaStatus = 0
	-- where the schedule will not start within the sla period
	-- subtaskid is there but nextschedule=0 ==> the job is scheduled after 90 days so scheduler is not sending time
	UPDATE #tempSubClient
	SET slaStatus = 5, -- MIGHT_MISS_SLA
missReason = (1652 | (CAST(POWER(2, 24) AS BIGINT) * 83))
	WHERE ((nextSchedule > jobShouldCompleteBefore) OR (nextSchedule = 0 AND subtaskid <> 0)) AND slaStatus = 0
	--where the scheduled job would not complete within the sla period
	--Might or might not be affected by operation Window
	UPDATE #tempSubclient
	SET slaStatus = 5,  --MIGHT_MISS_SLA
		missreason =  CASE  WHEN (jobCompletionTime - (nextSchedule + plainForecastTime) ) > 0 THEN
CASE WHEN isRunning = 1 THEN (1663 | (CAST(POWER(2, 24) AS BIGINT) * 83))
ELSE (1657 | (CAST(POWER(2, 24) AS BIGINT) * 83))
							END
					  ELSE
CASE WHEN isRunning = 1 THEN (1660 | (CAST(POWER(2, 24) AS BIGINT) * 83))
ELSE (1650 | (CAST(POWER(2, 24) AS BIGINT) * 83))
							END
					  END,
		missreasonparam = CASE WHEN (jobCompletionTime - (nextSchedule + plainForecastTime) ) > (24*3600) THEN CAST((jobCompletionTime - (nextSchedule + plainForecastTime) )/(24*3600)AS VARCHAR) + ' days'
                			   WHEN (jobCompletionTime - (nextSchedule + plainForecastTime) ) > (3600) THEN  CAST((jobCompletionTime - (nextSchedule + plainForecastTime) )/(3600)AS VARCHAR) + ' hours'
							   WHEN (jobCompletionTime - (nextSchedule + plainForecastTime) ) > (60) THEN  CAST((jobCompletionTime - (nextSchedule + plainForecastTime) )/(60)AS VARCHAR) + ' minutes'
						  END,
		joburlparam  = CASE WHEN  isRunning = 1 THEN REPLACE(@jobUrl,'[jobId]',jobId)
							END
	WHERE jobCompletionTime > jobShouldCompleteBefore AND slaStatus = 0
	-- where job is expected to fail
	UPDATE #tempSubClient
	SET slaStatus =  5, /*MIGHT_MISS_SLA*/
missreason = (1649 | (CAST(POWER(2, 24) AS BIGINT) * 83))
	WHERE  successiveFailedJobs >= 5 AND slaStatus = 0
	--if the job is running past the forecasttime runtime and is about to miss SLA
	-- and if we have <= 2 times the forecast time for the sla period
	UPDATE #tempSubClient
	SET slaStatus = 5,  --MIGHT_MISS_SLA
missreason = (1662 | (CAST(POWER(2, 24) AS BIGINT) * 83)),
		jobUrlParam = REPLACE(@jobUrl,'[jobid]',jobid)
	WHERE jobCompletionTime > 0 AND jobCompletionTime < @currTime AND jobShouldCompleteBefore - @currTime < 2*plainForecastTime AND isRunning = 1 AND slaStatus = 0
	--if the job is running beyond the anomalous runtime
	UPDATE #tempSubClient
	SET slaStatus = 5, --MIGHT_MISS_SLA
missReason = (1661 | (CAST(POWER(2, 24) AS BIGINT) * 83)),
		jobUrlParam = REPLACE(@jobUrl,'[jobid]',jobid)
	WHERE isAnomalous = 1  AND jobCompletionTime > 0 AND jobCompletionTime < @currTime AND jobShouldCompleteBefore - @currTime < 2*plainForecastTime AND slaStatus = 0
	UPDATE TSC SET reason = ELM.message
	FROM #tempSubClient TSC
	INNER JOIN EvLocaleMsgs ELM ON TSC.missReason = ELM.messageId AND ELM.localeId = @localeId
	UPDATE #tempSubClient SET reason = REPLACE(REPLACE(REPLACE(reason,'^1%s', jobUrlParam),'^2%s',missReasonParam),'^3%s',CONVERT(VARCHAR, jobShouldCompleteBeforeCellTime, 107))
	WHERE jobUrlParam IS NOT NULL AND missReasonParam IS NOT NULL
	UPDATE #tempSubClient SET reason = REPLACE(REPLACE(reason,'^1%s', jobUrlParam),'^2%s', CONVERT(VARCHAR, jobShouldCompleteBeforeCellTime, 107))
	WHERE jobUrlParam IS NOT NULL AND missReasonParam IS NULL
	UPDATE #tempSubClient SET reason = REPLACE(REPLACE(reason,'^1%s', missReasonParam),'^2%s', CONVERT(VARCHAR, jobShouldCompleteBeforeCellTime, 107))
	WHERE jobUrlParam IS NULL AND missReasonParam IS NOT NULL
	UPDATE #tempSubClient SET reason = REPLACE(reason,'^1%s', CONVERT(VARCHAR, jobShouldCompleteBeforeCellTime, 107))
	WHERE jobUrlParam IS NULL AND missReasonParam IS NULL
	INSERT INTO @SLAMissedIda(idaId, reason)
		SELECT TSC.idaid,
			   CAST((SELECT		reason AS '@mightMissReason',
								subclientId AS 'entity/@subclientId',
								subclientName AS 'entity/@subclientName'
						        FROM #tempSubClient WHERE idaid = TSC.idaid AND (slastatus = 5 OR (@alertMissedSLAAlso = 1 AND slastatus in(5,2)))  FOR XML PATH('reasonList'),ROOT('App_MightMissSLAList'),type) AS NVARCHAR(MAX))
		FROM #tempSubClient TSC
WHERE apptype NOT IN (3, 5, 22, 61, 79, 80, 81, 104, 125, 128,37, 62, 103, 135)
		GROUP BY TSC.idaid
	INSERT INTO @SLAMissedInstance(instanceId, reason)
		SELECT  TSC.instanceid,
			   CAST((SELECT		reason AS '@mightMissReason',
								subclientId AS 'entity/@subclientId',
								subclientName AS 'entity/@subclientName'
						        FROM #tempSubClient WHERE instanceId = TSC.instanceId AND (slastatus = 5 OR @alertMissedSLAAlso = 1)  AND skipSubclient = 0 FOR XML PATH('reasonList'),ROOT('App_MightMissSLAList'),type) AS NVARCHAR(MAX))
		FROM #tempSubClient TSC
WHERE apptype IN (3, 5, 22, 61, 79, 80, 81, 104, 125, 128)
		GROUP BY TSC.instanceid
		HAVING MIN(slaStatus) <> 0
		UNION
		SELECT TSC.instanceId,
			   CAST((SELECT		reason AS '@mightMissReason',
								subclientId AS 'entity/@subclientId',
								subclientName AS 'entity/@subclientName'
						        FROM #tempSubClient SubCli
								INNER JOIN
								(SELECT backupsetId
								 FROM #tempSubClient
								 GROUP BY backupsetId
								 HAVING MIN(slaStatus) <> 0
								 )ProbBkps ON ProbBkps.backupsetId = SubCli.backupsetId
								WHERE instanceId = TSC.instanceid  AND (slastatus = 5 OR @alertMissedSLAAlso = 1 )  AND skipSubclient = 0 FOR XML PATH('reasonList'),ROOT('App_MightMissSLAList'),type) AS NVARCHAR(MAX))
		FROM #tempSubClient TSC
WHERE apptype IN (37, 62, 103, 135)
		GROUP BY TSC.instanceId
		UNION
		SELECT  TSC.instanceid,
			   CAST((SELECT		reason AS '@mightMissReason',
								subclientId AS 'entity/@subclientId',
								subclientName AS 'entity/@subclientName'
						        FROM #tempSubClient WHERE instanceId = TSC.instanceId AND (slastatus = 5 OR (@alertMissedSLAAlso = 1 AND slastatus in(5,2)))  AND skipSubclient = 0 FOR XML PATH('reasonList'),ROOT('App_MightMissSLAList'),type) AS NVARCHAR(MAX))
		FROM #tempSubClient TSC
WHERE TSC.appType = 134
		GROUP BY TSC.instanceid
	INSERT INTO @SLAMissedClients(clientId, reason)
	SELECT clientid,
		  CAST((SELECT
				  reason AS '@mightMissReason',
				  subclientId AS 'entity/@subclientId',
				  subclientName AS 'entity/@subclientName',
				  IDA.displayName AS 'entity/@appName' ,
				  IDA.type AS 'entity/@applicationId'
		   FROM
				(
				SELECT subclientId, subclientname, reason, appType
				FROM #tempSubClient TSC
WHERE apptype NOT IN (3, 5, 22, 61, 79, 80, 81, 104, 125, 128,37, 62, 103, 135) and (slastatus = 5 OR (@alertMissedSLAAlso = 1 AND slastatus in(5,2))) AND B.clientId=TSC.clientId
				UNION
				SELECT subclientId, subclientname, reason, appType
				FROM #tempSubClient TSC
				INNER JOIN
				(
					SELECT instanceid from #tempSubClient
WHERE apptype in(3, 5, 22, 61, 79, 80, 81, 104, 125, 128)
					GROUP BY instanceid
					HAVING MIN(slastatus)<>0
				)ProbInstances ON ProbInstances.instanceid = TSC.instanceId AND B.clientId = TSC.clientId
				WHERE  (slastatus = 5 OR @alertMissedSLAAlso  =  1) AND skipSubclient = 0
				UNION
				SELECT subclientId, subclientname, reason, appType
				FROM #tempSubClient TSC
				INNER JOIN
				(
					SELECT backupsetID from #tempSubClient
WHERE apptype in(37, 62, 103, 135)
					GROUP BY backupsetID
					HAVING MIN(slastatus)<>0
				) ProbBKs ON ProbBKs.backupsetID = TSC.backupsetId AND B.clientId = TSC.clientId
				WHERE  (slastatus = 5 OR @alertMissedSLAAlso  =  1) AND skipSubclient = 0
				)A INNER JOIN App_idaType IDA ON IDA.type = A.appType
				for xml path('reasonList'), type, root('App_MightMissSLAList')) AS NVARCHAR(MAX))
	FROM #tempSubClient B
	GROUP BY clientId
	DELETE FROM @SLAMissedClients WHERE reason IS NULL
	DELETE FROM @SLAMissedInstance WHERE reason IS NULL
	DELETE FROM @SLAMissedIda WHERE reason IS NULL
	MERGE App_ComponentProp AS TARGET
	USING
	(
SELECT  clientId entityId, reason, 3 entityType FROM @SLAMissedClients
	UNION
SELECT  idaId entityId, reason, 4 entityType FROM @SLAMissedIda
	UNION
SELECT  instanceId entityId, reason, 21 entityType FROM @SLAMissedInstance
	)AS SOURCE
ON SOURCE.entityId = TARGET.componentId AND TARGET.componentType = SOURCE.entityType AND TARGET.propertyTypeId = 3625 AND modified = 0
	WHEN MATCHED THEN
		UPDATE SET stringVal = SOURCE.reason, created = @currTime
	WHEN NOT MATCHED THEN
		INSERT(componentType, componentId, propertyTypeId,  dataType, stringVal, longval,longlongval, created, modified)
VALUES(SOURCE.entityType, SOURCE.entityId, 3625, 1, SOURCE.reason, 0, 0, @currTime, 0);
	IF @in_clientId = 0
	BEGIN
		DELETE CP
		FROM App_ComponentProp CP
		LEFT JOIN
		(
SELECT  clientId entityId, reason, 3 entityType FROM @SLAMissedClients
		UNION
SELECT  idaId entityId, reason, 4 entityType FROM @SLAMissedIda
		UNION
SELECT  instanceId entityId, reason, 21 entityType FROM @SLAMissedInstance
		)Missed ON CP.componentType = Missed.entityType AND CP.componentId = Missed.entityId
WHERE CP.propertyTypeId = 3625 AND Missed.entityId IS NULL
	END
	ELSE
	BEGIN
	    -- Delete entities belonging to this client but are not affected
		DELETE CP FROM APP_ComponentProp CP
		INNER JOIN
		(
		(
SELECT clientId entityId, 3 entityType FROM #tempSubClient
		UNION
SELECT  idaId entityId, 4 entityType FROM #tempSubClient
		UNION
SELECT  instanceId entityId, 21 entityType FROM #tempSubClient
		)
		EXCEPT
		(
SELECT  clientId entityId, 3 entityType FROM @SLAMissedClients
		UNION
SELECT  idaId entityId, 4 entityType FROM @SLAMissedIda
		UNION
SELECT  instanceId entityId, 21 entityType FROM @SLAMissedInstance
		)
		)NonProblematicEntities ON
		NonProblematicEntities.entityId = CP.componentId AND NonProblematicEntities.entityType = CP.componentType AND
CP.propertyTypeId =  3625 AND CP.modified = 0
	END
	UPDATE MC SET clientName = C.name
	FROM @SLAMissedClients MC
	INNER JOIN App_Client C ON C.id = MC.clientId
	SELECT clientId, clientName, reason FROM @SLAMissedClients
END
GO

IF EXISTS (select * from GxQscripts where name = 'ML_PredictSLA')
	delete from GxQscripts where name = 'ML_PredictSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_PredictSLA')
	delete from GXDBVersions where aliasname = 'ML_PredictSLA'
GO

insert into GXDBVersions values(2, 'ML_PredictSLA',  'v1.1.2.16.6.1', 'ML_PredictSLA', 'v1.1.2.16.6.1')
GO

