

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_GetSubClientsForSLACalculation.sp] ---------- 

/**
	Sp to return Subclients applicable for SLA calculation
**/
/********************************************************************************************************************************
ProcName  : ML_GetSubClientsForSLACalculation
Descripion: Sp to return Subclients required for SLA calculation
Output    : <TMMsg_GetBackupEntityInfoReq>
										<subclientInfo subclientId="2" _type_="7"/>
										<subclientInfo subclientId="3" _type_="7"/>
										<subclientInfo clientId="5" _type_="3"/> (virtual client)
			</TMMsg_GetBackupEntityInfoReq>
*********************************************************************************************************************************/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ML_GetSubClientsForSLACalculation')
BEGIN
	print '>>> Drop Stored Procedure: ML_GetSubClientsForSLACalculation <<<'
	drop procedure ML_GetSubClientsForSLACalculation
END
IF EXISTS (select * from GxQscripts where name='ML_GetSubClientsForSLACalculation')
	delete from GxQscripts where name = 'ML_GetSubClientsForSLACalculation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetSubClientsForSLACalculation')
	delete from GXDBVersions where aliasname = 'ML_GetSubClientsForSLACalculation'
GO
print '... Creating Procedure: ML_GetSubClientsForSLACalculation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ML_GetSubClientsForSLACalculation
  @in_clientId INT
AS
  DECLARE @subclientXML XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	SELECT
	    (SELECT distinct APP.id AS '@subclientId',
		APP.backupSet AS'@backupsetId',
		APP.instance AS '@instanceId',
		APP.appTypeId AS '@applicationId',
		APP.clientId AS '@clientId',
7  AS '@_type_'
		FROM RptSLASubclient SLA INNER JOIN APP_Application APP ON SLA.appid = APP.id AND SLA.clientId = APP.clientId  AND @in_clientId IN (0, SLA.clientId)
		FOR XML PATH('subclientInfo'),type),
		(SELECT DISTINCT clientId AS '@clientId',
3  AS '@_type_'
		FROM RptSLAClient SLA
		INNER JOIN App_ClientProp Prop ON SLA.clientId = Prop.componentnameId AND  Prop.attrname = 'Virtual Server Discovered Clients'
		WHERE Prop.modified = 0 AND Prop.attrval = '1' AND status <> 3 /*EXCLUDED*/ AND @in_clientId IN (0, SLA.clientId)
		FOR XML PATH('subclientInfo'),type)
	FOR XML PATH('TMMsg_GetBackupEntityInfoReq')
END

IF EXISTS (select * from GxQscripts where name = 'ML_GetSubClientsForSLACalculation')
	delete from GxQscripts where name = 'ML_GetSubClientsForSLACalculation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetSubClientsForSLACalculation')
	delete from GXDBVersions where aliasname = 'ML_GetSubClientsForSLACalculation'
GO

insert into GXDBVersions values(2, 'ML_GetSubClientsForSLACalculation',  '00000000000000000000', 'ML_GetSubClientsForSLACalculation', '00000000000000000000')
GO

