

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_GetSmartMAStateMgmtProperties.sp] ---------- 

/********************************************************************************************************************************
ProcName: ML_GetSmartMAStateMgmtProperties
Input	:	1. userId
Output  :
			<CVGui_SmartMAStateManagementResp enabled = "1">
				<entities>
					<associations _type_="16" />
					<associations _type_="17" storagePolicyId="3" >
						<flags exclude = "1"/>
					</associations>
				</entities>
			</CVGui_SmartMAStateManagementResp>
*********************************************************************************************************************************/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ML_GetSmartMAStateMgmtProperties')
BEGIN
	print '>>> Drop Stored Procedure: ML_GetSmartMAStateMgmtProperties <<<'
	drop procedure ML_GetSmartMAStateMgmtProperties
END
IF EXISTS (select * from GxQscripts where name='ML_GetSmartMAStateMgmtProperties')
	delete from GxQscripts where name = 'ML_GetSmartMAStateMgmtProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetSmartMAStateMgmtProperties')
	delete from GXDBVersions where aliasname = 'ML_GetSmartMAStateMgmtProperties'
GO
print '... Creating Procedure: ML_GetSmartMAStateMgmtProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ML_GetSmartMAStateMgmtProperties
  @userId INT
AS
  DECLARE @outputXml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @enabled INT = 0
	DECLARE @xmlOut NVARCHAR(MAX)
	IF OBJECT_ID ('tempdb.dbo.#AllowedSP') IS NOT NULL
		DROP TABLE #AllowedSP
	CREATE TABLE #AllowedSP(spId INT)
	IF OBJECT_ID ('tempdb.dbo.#SelectedEntities') IS NOT NULL
		DROP TABLE #SelectedEntities
	CREATE TABLE #SelectedEntities(entityType INT, entityId INT, exclude varchar)
	SELECT @enabled = longVal
	FROM App_ComponentProp
WHERE componentType = 1 AND componentid = 2 AND propertyTypeId = 20
EXEC sec_getNonIdaObjectsForThisUser @userId, 17, 1, '#AllowedSP'
	INSERT INTO #SelectedEntities
	SELECT longVal, longlongVal, stringval
	FROM App_ComponentProp
WHERE componentType = 1 AND componentid = 2 AND propertyTypeId = 21
PROC_EXIT:
	SET @xmlOut=(SELECT @enabled '@enabled', (SELECT entityType as '@_type_',
				 entityId as '@storagePolicyId',
				 NULLIF(name , '') as '@storagePolicyName',
				 NULLIF(exclude, 0)  'flags/@exclude'
					FROM
					(
						SELECT SE.entityId, SE.entityType, SE.exclude , AG.name name
						FROM #AllowedSP  SP
INNER JOIN #SelectedEntities SE ON SE.entityType = 17 AND SE.entityId =  SP.spid
						INNER JOIN archGroup AG ON AG.id = SP.spid
						UNION
						SELECT SE.entityId, SE.entityType, SE.exclude , '' name
						FROM #SelectedEntities SE WHERE SE.entityId=0
					)A
				FOR XML PATH('associations'),ROOT('entities'),TYPE)
				FOR XML PATH('CVGui_SmartMAStateManagementResp'))
	DROP TABLE #AllowedSP
	DROP TABLE #SelectedEntities
	SELECT @xmlOut
END
GO

IF EXISTS (select * from GxQscripts where name = 'ML_GetSmartMAStateMgmtProperties')
	delete from GxQscripts where name = 'ML_GetSmartMAStateMgmtProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetSmartMAStateMgmtProperties')
	delete from GXDBVersions where aliasname = 'ML_GetSmartMAStateMgmtProperties'
GO

insert into GXDBVersions values(2, 'ML_GetSmartMAStateMgmtProperties',  '00000000000000000000', 'ML_GetSmartMAStateMgmtProperties', '00000000000000000000')
GO

