

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_GetSLAStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ML_GetSLAStatus.sp,v $ $Id: ML_GetSLAStatus.sp,v 1.1.2.1 2020/11/03 01:14:49 snandhini Exp $";
/*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
     ML_GetSLAStatus - Get the current SLA status
	 Input :    RefreshSLAReq xml eg. <App_RefreshSLAReq><entity _type_="3" clientId="2"/></App_RefreshSLAReq>
	 Output:    responseXML (RefreshSLAResp xml)
	    <App_RefreshSLAResp slaStatus="5" slaCategoryDescription="">
			<slaMissReasonList>
				<reasonList mightMissReason="The subclient does not have any backup jobs scheduled. The job has to be completed before Oct 22, 2020 for the SLA to be met.">
					<entity subclientId="438" subclientName="new45789908543_96" appName="File System" applicationId="33"/>
				</reasonList>
				<reasonList mightMissReason="The subclient does not have any backup jobs scheduled. The job has to be completed before Oct 23, 2020 for the SLA to be met.">
					<entity subclientId="441" subclientName="new2" appName="File System" applicationId="33"/>
				</reasonList>
			</slaMissReasonList>
		</App_RefreshSLAResp>
Test cases on refresh sla
1. verify passing an entity where user has no permission
2. verify for client, ida, instance mightmissla field is filled in response for slastatus=5
3. verify for discovered client, subclient slacategorydescription is populated for slastatus=5
4. verify for sla status<>5, slaCategoryDescription is populated
5. verify subclientname with wide  char
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ML_GetSLAStatus')
BEGIN
	print '>>> Drop Stored Procedure: ML_GetSLAStatus <<<'
	drop procedure ML_GetSLAStatus
END
IF EXISTS (select * from GxQscripts where name='ML_GetSLAStatus')
	delete from GxQscripts where name = 'ML_GetSLAStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetSLAStatus')
	delete from GXDBVersions where aliasname = 'ML_GetSLAStatus'
GO
print '... Creating Procedure: ML_GetSLAStatus'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ML_GetSLAStatus
  @requestXml XML,
  @userId INT
AS
  DECLARE @responseXml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @sla_entityLevel INT
DECLARE @componentType INT
DECLARE @_type_ INT
DECLARE @clientId INT
DECLARE @agentType INT
DECLARE @appTypeId INT
DECLARE @instanceId INT
DECLARE @backupsetId INT
DECLARE @subclientId INT
DECLARE @entityId INT
DECLARE @slaStatus INT
DECLARE @slaCategoryDescription NVARCHAR(MAX)
DECLARE @slaMissReasonList XML
DECLARE @localeId INT
DECLARE @entityFound INT = 0
IF object_id('tempdb.dbo.#SLA_EntityInfo') IS NOT NULL DROP TABLE #SLA_EntityInfo
CREATE TABLE #SLA_EntityInfo (
clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, -- entity IDs to set
status INT, category INT, slaDays INT)
SELECT @clientId = ISNULL(@requestXml.value('(App_RefreshSLAReq/entity/@clientId)[1]', 'int'),0),
	   @agentType = ISNULL(@requestXml.value('(App_RefreshSLAReq/entity/@applicationId)[1]', 'int'),0),
	   @instanceId = ISNULL(@requestXml.value('(App_RefreshSLAReq/entity/@instanceId)[1]', 'int'),0),
	   @backupsetId = ISNULL(@requestXml.value('(App_RefreshSLAReq/entity/@backupsetId)[1]', 'int'),0),
	   @subclientId = ISNULL(@requestXml.value('(App_RefreshSLAReq/entity/@subclientId)[1]', 'int'),0),
	   @_type_ = ISNULL(@requestXml.value('(App_RefreshSLAReq/entity/@_type_)[1]', 'int'),0),
       @localeId = ISNULL(@requestXml.value('(App_RefreshSLAReq/processinginstructioninfo/locale/@localeId)[1]', 'int'),0)
IF OBJECT_ID('tempdb.dbo.#SecurityCheck') IS NOT NULL
    DROP TABLE #SecurityCheck
CREATE TABLE #SecurityCheck
(
	returnedUserId  INT,
	nodeCapability  BIGINT,
	childCapability BIGINT
)
IF @_type_ = 7
BEGIN
	SELECT @entityFound = 1, @clientId = clientId, @agentType = appTypeId, @instanceId = instance, @backupsetId = backupset
	FROM APP_Application
	WHERE id = @subclientId
END
ELSE IF @_type_ = 6
BEGIN
	SELECT @entityFound = 1, @clientId = clientId, @agentType = appTypeId, @instanceId = instance
	FROM APP_Application
	WHERE backupset = @backupsetId
END
ELSE IF @_type_ = 5
BEGIN
	SELECT @entityFound = 1, @clientId = clientId, @agentType = appTypeId
	FROM APP_Application
	WHERE instance = @instanceId
END
ELSE IF @_type_ = 4
BEGIN
	SELECT @entityFound = 1, @appTypeId = id
	FROM App_idaName
	WHERE clientId = @clientId AND appTypeId = @agentType
END
ELSE IF @_type_ = 3
BEGIN
	SELECT @entityFound = 1
	FROM App_client
	WHERE Id = @clientId
END
IF @entityFound = 0
BEGIN
	SELECT 1 '@errorCode',
		   'Incorrect entity information' '@errorMessage'
	   FOR XML PATH('App_RefreshSLAResp')
	RETURN
END
INSERT INTO #SecurityCheck
EXEC   dbo.sec_iDaNodeAccess @userId, 2, @clientId, @agentType, @instanceId, @backupsetId, @subclientId
IF NOT EXISTS (select 1 FROM #SecurityCheck WHERE returnedUserId = @userId )
BEGIN
	SELECT 1 '@errorCode',
		   'User doesnot have permission' '@errorMessage'
	   FOR XML PATH('App_RefreshSLAResp')
	RETURN
END
-- values from RptGetSLAOfEntities.sp
SET @sla_entityLevel  = CASE @_type_
WHEN 3 THEN 1
WHEN 4 THEN 2
WHEN 5 THEN 3
WHEN 6 THEN 4
WHEN 7 THEN 5
						END
SET @componentType =	CASE @_type_
WHEN 3 THEN 3
WHEN 4 THEN 4
WHEN 5 THEN 21
WHEN 6 THEN 5
WHEN 7 THEN 6
						END
SET @entityId =  	CASE @_type_
WHEN 3 THEN @clientId
WHEN 4 THEN @appTypeId
WHEN 5 THEN @instanceId
WHEN 6 THEN @backupsetId
WHEN 7 THEN @subclientId
					END
INSERT INTO #SLA_EntityInfo(clientId, appTypeId, instanceId, backupsetId, appId)
VALUES(@clientId, @agentType, @instanceId, @backupsetId, @subclientId)
exec RptGetSLAOfEntities @sla_entitylevel
SELECT @slaStatus = status , @slaCategorydescription = dbo.WR_GetSLACategoryString(@localeId,Category) FROM #SLA_EntityInfo
-- now get 'may miss sla' status from app_componentprop
IF @_type_ IN (3,4,5)
BEGIN
IF @_type_ = 3 AND EXISTS (SELECT 1 FROM App_ClientProp WHERE componentNameId = @entityId AND attrName = 'Virtual Server Discovered Clients' AND attrVal = '1' AND modified = 0)
	BEGIN
		SELECT @slaStatus = 5, /*MIGHT_MISS_SLA*/
		       @slaCategoryDescription = cast(stringVal as xml).value('(App_MightMissSLAList/reasonList/@mightMissReason)[1]','nvarchar(1024)')
		FROM App_ComponentProp
WHERE propertyTypeId =  3625 AND componenttype = @componentType AND componentId = @entityId AND modified = 0
	END
	ELSE
	BEGIN
		SELECT @slaStatus = 5,/*MIGHT_MISS_SLA*/
		       @slaCategoryDescription = '',
		       @slaMissReasonList = stringval
		FROM App_ComponentProp
WHERE propertyTypeId =  3625 AND componenttype = @componentType AND componentId = @entityId AND modified = 0
	END
END
ELSE IF @_type_ = 7
BEGIN
	-- fetch property from client
	SELECT
        @slaStatus = 5,/*MIGHT_MISS_SLA*/
        @slaCategoryDescription = cast(stringVal as xml).value('(/App_MightMissSLAList[reasonList/entity/@subclientId=sql:variable("@entityId")]/reasonList/@mightMissReason)[1]','nvarchar(255)')
FROM APP_ComponentProp WHERE componentId = @clientId AND componentType =  3 AND propertyTypeId = 3625 AND modified = 0
        AND CAST(stringVal as xml).value('(/App_MightMissSLAList[reasonList/entity/@subclientId=sql:variable("@entityId")]/reasonList/@mightMissReason)[1]','nvarchar(255)') IS NOT NULL
END
SELECT @slaStatus '@slaStatus',
	   @slaCategoryDescription '@slaCategoryDescription',
	   @slaMissReasonList.query('App_MightMissSLAList/reasonList') slaMissReasonList
	   FOR XML PATH('App_RefreshSLAResp')
GO

IF EXISTS (select * from GxQscripts where name = 'ML_GetSLAStatus')
	delete from GxQscripts where name = 'ML_GetSLAStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetSLAStatus')
	delete from GXDBVersions where aliasname = 'ML_GetSLAStatus'
GO

insert into GXDBVersions values(2, 'ML_GetSLAStatus',  '00010001000200010000', 'ML_GetSLAStatus', '00010001000200010000')
GO

