

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_GetNewStateOfMA.sp] ---------- 

/**************************************************************************
Procnname: ML_GetNewStateOfMA
Input: mediaAgentId
Output: New state (Integer)
		0 - No change in state - MA is in a good condition
		1 - Restart services in MA
		2 - Mark MA Soft Disabled
State of an MA will not be changed if
1. it is the only data path for a storage policycopy
2. it is the only controller for a mount path
3. it is a DDB MA
4. if we have a data history of less than 30 days
***************************************************************************/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ML_GetNewStateOfMA')
BEGIN
	print '>>> Drop Stored Procedure: ML_GetNewStateOfMA <<<'
	drop procedure ML_GetNewStateOfMA
END
IF EXISTS (select * from GxQscripts where name='ML_GetNewStateOfMA')
	delete from GxQscripts where name = 'ML_GetNewStateOfMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetNewStateOfMA')
	delete from GXDBVersions where aliasname = 'ML_GetNewStateOfMA'
GO
print '... Creating Procedure: ML_GetNewStateOfMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ML_GetNewStateOfMA
  @maId INT
AS
  DECLARE @newState INT
  DECLARE @outXml XML
  DECLARE @debugLine VARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @currentTime DATETIME = getutcdate()
	DECLARE @currentTimeStamp INT = DATEDIFF(SECOND,'19700101',@currentTime)
	DECLARE @currentHr INT = ((@currentTimeStamp+3600)%(3600*24))/3600
	DECLARE @prevHr INT = DATEPART(HOUR, @currentTime)
	DECLARE @prevHrTimestamp INT = ((@currentTimeStamp/3600)*3600) - 3600
	DECLARE @currentDate DATE = DATEADD(DAY,(@currentTimeStamp+3600)/(3600*24),'19700101')
	DECLARE @anomJobsAvg INT = 0
	DECLARE @pendingJobsAvg INT = 0
	DECLARE @failedJobsAvg INT = 0
	DECLARE @anomJobsStd INT = 0
	DECLARE @pendingJobsStd INT = 0
	DECLARE @failedJobsStd INT = 0
	DECLARE @currPendingJobs INT = 0
	DECLARE @currRunningJobs INT = 0
	DECLARE @currAnomJobs INT = 0
	DECLARE @currFailedJobs INT = 0
	DECLARE @multiple FLOAT = 4.5
	DECLARE @criticality VARCHAR(128) = 'Medium'
	SELECT @criticality = value from GxGlobalParam WHERE name='AdminAlertSensitivity' and modified=0
	DECLARE @configurableFromDateTimestamp INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='FromTimeForAnomalyAlert' and modified=0),0)
	DECLARE @minCountforAnomaly INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name = 'nMinJobCountForAnomalyMAStateMgmt' and modified=0),100)
DECLARE @maxJPRsToConsider INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name = 'nMaxJPRsToConsiderForMAStateMgmt' and modified=0),10)
	DECLARE @skipHyperScaleMA INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name = 'nSkipHyperScaleMAForMAStateMgmt' and modified = 0),1)
	DECLARE @daysToConsider INT = 90
	IF (@currentTimeStamp - @configurableFromDateTimestamp)/(60*60*24)  < 90
		SET @daysToConsider = (@currentTimeStamp - @configurableFromDateTimestamp)/(60*60*24)
	DECLARE @earliestDate DATE = DATEADD(DAY, -@daysToConsider, @currentDate)
	DECLARE @localeId INT = 0
	DECLARE @minimumDaysRequired INT = 30
	DECLARE @dataPointsAvailable INT = (SELECT COUNT(1) FROM Historydb.dbo.ML_JobResourceAllocationSummary WHERE mediaagentId = @maId AND evDate > @earliestDate AND evHour = @currentHr)
	IF object_id('tempdb.dbo.#JobStateErr') IS NOT NULL DROP TABLE #JobStateErr
	CREATE TABLE #JobStateErr (maId INT, jobId INT,messageId INT,delayReasonId VARCHAR(MAX), message NVARCHAR(MAX),type INT, errorSubsystem INT)
	SET @debugLine = 'No Errors'
SET @newState = 0
	IF @criticality = 'Low'
	  SET @multiple = 5.5
	ELSE IF @criticality = 'High'
	  SET @multiple = 3.5
	--------------------------------------------------------------------------------------------------------------------
	------------------------			 DONOT CHANGE STATE ON MA UNDER CERTAIN CONDITIONS		------------------------
	--------------------------------------------------------------------------------------------------------------------
	/* do not change state of MA if that is the only MA(Datapath) of a SPCopy*/
	IF EXISTS(
				SELECT copyid FROM MMDataPath WHERE HostClientId = @maId
				EXCEPT
				SELECT copyid
				FROM MMDataPath DP
				INNER JOIN MMHost H
ON DP.HostClientId = H.ClientId AND H.MmHostEnabled = 1 AND H.MmHostSoftState = 1 AND H.attribute & 16 = 0
				INNER JOIN App_ClientProp P ON P.componentnameId = H.ClientId and P.modified = 0 and P.attrVal = cast(1 as nvarchar) and P.attrname = 'Idx: cache enabled'
				WHERE HostClientId <> @maId
			 )
	BEGIN
SET @newState = 0
		SET @debugLine = 'only MA(Datapath) of a SPCopy'
		GOTO END_PROC;
	END
	/* do not bring MA down when that is the only MA for pruning a mountpath ie. mount path is not shared with other MA*/
	IF EXISTS(
				SELECT DC.DeviceId FROM MMDeviceController DC
				INNER JOIN MMMountPathToStorageDevice MPSD ON  MPSD.DeviceId = DC.DeviceId
				WHERE ClientId = @maId
				EXCEPT
				SELECT DeviceId FROM MMDeviceController DC
				INNER JOIN MMHost H ON H.clientId = DC.ClientId WHERE
DC.clientId <> @maId	AND DeviceControllerEnabled = 1 AND MmHostEnabled = 1 AND MMhostSoftstate = 1 AND H.attribute & 16 = 0
			)
	BEGIN
SET @newState = 0
		SET @debugLine = 'only MA for pruning a mountpath ie. mount path is not shared with other MA'
		GOTO END_PROC;
	END
	/*Donot bring MA down if it is a Pruner MA*/
IF EXISTS (SELECT 1 FROM MMDeviceController WHERE clientId =  @maId AND useCount & 1 > 0
				UNION
SELECT 1 FROM MMDataPath WHERE hostClientId = @maId AND flag & 64 > 0)
	BEGIN
SET @newState = 0
		SET @debugLine = 'Pruner MA.'
		GOTO END_PROC;
	END
   /*Donot brig MA down if round robin is not selected in some copy*/
   IF EXISTS ( SELECT 1
				FROM archgroupcopy AGC
				INNER JOIN mmdatapath MMDP ON MMDP.copyId = AGC.id AND MMDP.hostClientId = @maId
WHERE AGC.flags & 512 = 0)
   BEGIN
SET @newState = 0
		SET @debugLine = 'MA belongs to copy where round robin is not selected'
		GOTO END_PROC;
   END
	/*Donot bring MA down if it is associated with DDB that doesnot have other partitions to take up job*/
	IF object_id('tempdb.dbo.#StoreResiliencySetting') IS NOT NULL DROP TABLE #StoreResiliencySetting
	CREATE TABLE #StoreResiliencySetting (SIDBStoreId INTEGER PRIMARY KEY, ResiliencyFlag BIT, percentCorruptLimit INTEGER)
	INSERT INTO #StoreResiliencySetting
SELECT	DISTINCT SS.SIDBStoreId, AGC.dedupeFlags& 8, ISNULL(AT.percentCorruptLimit, 0)
	FROM	IdxSIDBSubStore SS
			INNER JOIN archCopySIDBStore C2S ON SS.SIDBStoreId = C2S.SIDBStoreId
INNER JOIN archGroupCopy AGC ON AGC.id = C2S.CopyId AND AGC.dedupeFlags & 134217728 = 0
			LEFT JOIN  archTask AT ON AGC.sealStoreTaskId = AT.id
	WHERE	SS.ClientId = @maId
	/*do not bring MA down if any store having partition in this MA doesnt support resiliency*/
	IF EXISTS (SELECT 1 FROM #StoreResiliencySetting WHERE ResiliencyFlag = 0)
	BEGIN
SET @newState = 0
			SET @debugLine = 'MA is associated with DDB that doesnt support resiliency'
			GOTO END_PROC;
	END
	/*do not bring MA down if for any store(with partition in this MA), number of partitions in this MA + number of already offline partitions in other MAs is > maximum number of partitions that can go offline*/
	IF EXISTS
	(
		SELECT	1
		FROM	#StoreResiliencySetting S
				INNER JOIN IdxSIDBSubStore SS ON S.SIDBStoreId = SS.SIDBStoreId
				INNER JOIN MMHost H ON SS.ClientId = H.ClientId
				INNER JOIN IdxCache IC ON SS.IdxCacheId = IC.IdxCacheId
				INNER JOIN IdxAccessPath IAP ON SS.IdxAccessPathId = IAP.IdxAccessPathId
		WHERE	-- partition corrupted
(SS.Status = 1)
				-- ddb move is running
OR (SS.Flags & 1024 = 1024)
				-- Media Agent offline
				OR (H.MmHostSoftState = 0 OR H.MmHostEnabled = 0)
				-- Index Cache offline
				OR (IC.Enabled = 0 OR IC.SoftState = 0)
				-- Access Path offline
				OR (IAP.Enabled = 0 OR IAP.SoftState = 0)
				-- Media Agent is the one to be taken offine
				OR SS.ClientId = @maId
		GROUP BY S.SIDBStoreId, S.percentCorruptLimit
		HAVING COUNT (DISTINCT SS.SubStoreId) > S.percentCorruptLimit
	)
	BEGIN
SET @newState = 0
			SET @debugLine = 'MA is associated with DDB, where other partitions are not in a state to pickup jobs'
			GOTO END_PROC;
	END
	/* do not change state of MA when it is a hyperscale MA*/
	IF @skipHyperScaleMA = 1
	BEGIN
		IF EXISTS
			(SELECT 1
			 FROM MMSDSStoragePool SDS
			 INNER JOIN MMMountPath MP ON SDS.LibraryId = MP.LibraryId
			 INNER JOIN MMMountPathToStorageDevice MSD ON MP.MountPathId = MSD.MountPathId
			 INNER JOIN MMDiskHwInfo HW ON MSD.DeviceId = HW.deviceId
			 INNER JOIN MMScaleOutMAInfo MA ON HW.hostId = MA.ClientId
INNER JOIN MMEntityProp ME ON ME.EntityType = 10 AND  ME.propertyName = 'MediaAgentApplianceType' AND  HW.hostId = ME.EntityId AND ME.CommCellId = 2
WHERE HW.flags & 1 = 1
AND ME.intVal IN (1,2)
			 AND HW.hostId = @maId)
		BEGIN
SET @newState = 0
			SET @debugLine = 'MA is a HyperScale MA'
			GOTO END_PROC;
		END
	END
	/* do not bring MA down if the other available MAs are also over-loaded */
	IF object_id('tempdb.dbo.#StoragePolicyCopyMATable') IS NOT NULL DROP TABLE #StoragePolicyCopyMATable
	CREATE TABLE #StoragePolicyCopyMATable(copyId INT, maId INT,anomalous INT,enabled INT, softEnabled INT, indexCacheEnabled INT,markedForMaintanence INT, PRIMARY KEY (copyId , maId))
	/*List of other MAs whose health is to be checked*/
	/*Get list of copies served by this MA and the list of MAs which serve those copies*/
	INSERT INTO #StoragePolicyCopyMATable
SELECT DISTINCT A.copyId, A.hostclientId, 0, H.mmhostenabled, H.mmhostsoftstate, 0, H.attribute & 16
		FROM MMDataPath A
		INNER JOIN (SELECT copyId FROM MMDataPath WHERE hostclientid = @maId) B ON A.copyId = B.copyId
		INNER JOIN MMHost H ON H.clientid = A.hostclientId
	UPDATE SPC SET indexCacheEnabled = attrVal
	FROM #StoragePolicyCopyMATable SPC
	INNER JOIN App_ClientProp P
	ON P.componentNameId = SPC.maId AND P.attrName = 'Idx: cache enabled' AND modified = 0
	DECLARE @SummaryTable TABLE(maId INT,
							   anomJobsAvg FLOAT, pendingJobsAvg FLOAT, failedJobsAvg FLOAT,
							   anomJobsStd FLOAT, pendingJobsStd FLOAT, failedJobsStd FLOAT,
							   anomalyThreshold FLOAT, pendingThreshold FLOAT,failedThreshold FLOAT,
							   currPendingJobs INT, currAnomJobs INT, currFailedJobs INT, totalJobs INT)
	INSERT INTO @SummaryTable(maId, anomJobsAvg, pendingJobsAvg, anomJobsStd, pendingJobsStd)
		SELECT A.maId, AVG (anomalousJobs),  AVG(pendingJobs), STDEV(anomalousJobs), STDEV(pendingJobs)
		FROM Historydb.dbo.ML_JobResourceAllocationSummary S
		RIGHT JOIN (SELECT DISTINCT maId FROM #StoragePolicyCopyMATable)A
		ON A.maId = S.mediaAgentId
		WHERE (((evHour = @currentHr AND @currentDate <> evDate) OR (evHour < @currentHr AND @currentDate = evDate))
		AND evDate > @earliestDate) OR S.mediaAgentId  IS NULL
		GROUP BY A.maId
	UPDATE Summary SET failedJobsAvg = B.faiedJobsAvg, failedJobsStd = B.faiedJobsStd
	FROM @SummaryTable Summary
	INNER JOIN
	(
		SELECT A.maId, AVG(failedJobs) faiedJobsAvg, STDEV(failedJobs) faiedJobsStd
		FROM Historydb.dbo.ML_JobResourceAllocationSummary S
		INNER JOIN (SELECT DISTINCT maId FROM #StoragePolicyCopyMATable)A
		ON A.maId = S.mediaAgentId
		WHERE ((evHour = @prevHr AND @currentDate <> evDate) OR (evHour < @prevHr AND @currentDate = evDate))
		AND evDate > @earliestDate
		GROUP BY A.maId
	)B
	ON B.maId = Summary.maId
	UPDATE @SummaryTable SET anomalythreshold = dbo.ML_GetAnomalyThreshold(anomJobsAvg, anomJobsStd, @multiple),
							 pendingThreshold = dbo.ML_GetAnomalyThreshold(pendingJobsAvg, pendingJobsStd, @multiple),
							 failedThreshold =  dbo.ML_GetAnomalyThreshold(failedJobsAvg, failedJobsStd, @multiple)
	SELECT @anomjobsAvg = anomjobsAvg , @pendingJobsAvg = pendingJobsAvg ,
		   @anomJobsStd = anomJobsStd, @pendingJobsStd = pendingJobsStd,
		   @failedjobsAvg = failedjobsAvg , @failedjobsStd = failedjobsStd
	FROM @SummaryTable WHERE maId= @maId
    --get current pending or failed jobs
	INSERT INTO #JobStateErr
	SELECT DISTINCT H.clientId, B.jobid, F.messageId, D.Data, '', B.type,
			CASE WHEN (F.messageId & POWER(2,17)) <> 0 THEN  (F.messageId / (POWER(2,18)) & 0xFFFF)
			     ELSE (F.messageId / (POWER(2,24)) & 0xFF) END
			FROM
			(
SELECT jobId, failureReason, 4 type FROM JMBkpStats WHERE status = 2 /*CVJobStatus_FAIL*/ and servEndDate > @prevHrTimestamp
				UNION
				SELECT jobId, failureReason,
CASE WHEN guialertcolorlevel >= 100000  THEN 1
WHEN guialertcolorlevel < 100000 AND state IN (2,3) /*CVJobState_Pending_Waiting*/ THEN 2
ELSE 0 END type
				FROM RunningBackups WHERE state <> 5 /*CVJobState_Stopped*/
			) B
			INNER JOIN (SELECT jobId, clientId, ROW_NUMBER() OVER(PARTITION BY jobId ORDER BY reservationId DESC) rowNum
						FROM JMJobResourceHistory WHERE reservationtime > @prevHrTimestamp OR releasetime > @prevHrTimestamp OR releasetime = 0
						) H ON B.jobid = H.jobid
			INNER JOIN #StoragePolicyCopyMATable SM ON SM.maId = H.clientId
			CROSS APPLY dbo.split(B.failureReason,',')D
			LEFT JOIN JMFailureReasonMsg F on (D.Data = F.id)
			WHERE  ((D.Data='' AND D.Id = 1) OR F.id is not null) /*this is added so that jobs without errors are not missed*/
			AND (D.id <= @maxJPRsToConsider)
			AND H.rowNum = 1/*Consider only the last reservation held */
	/*Donot consider those jobs that are pending / long running due to non MA reasons*/
	DECLARE @ErrorMessagesUnrelatedToMA TABLE (messageId INT)
	INSERT INTO @ErrorMessagesUnrelatedToMA
VALUES ((968 | (CAST(POWER(2, 24) AS BIGINT) * 19))),					  --Backup job has been suspended by user ^1%s.
((2126 | (CAST(POWER(2, 24) AS BIGINT) * 19))),                     --Edge drive backup cannot run as it is in paused state.
((275 | (CAST(POWER(2, 24) AS BIGINT) * 14))),      --?Few valid archive files are missing in the Index Logs. Please check ArchiveIndex.log on the MediaAgent [^1%s].
((599 | (CAST(POWER(2, 24) AS BIGINT) * 19))),                    --Loss of control process ^1%s. Possible causes: 1. The control process has unexpectedly died. Check crash dump or core file. 2. The communication to the control process machine ^2%s might have gone down due to network errors. 3. If the machine ^3%s is a cluster, it may have failed over. 4. The machine ^4%s may have rebooted
((1131 | (CAST(POWER(2, 24) AS BIGINT) * 19))),              --Waiting for the services on the client [^1%s] to come online.
((977 | (CAST(POWER(2, 24) AS BIGINT) * 19))), 	    --Synthetic Full job has been suspended by user ^1%s.
((2166 | (CAST(POWER(2, 24) AS BIGINT) * 19))),     --This job was initiated by an Automatic schedule. It is ready to be resumed by the client.
((627 | (CAST(POWER(2, 24) AS BIGINT) * 19))),					--Data Management activity on the client [^1%s] has been disabled.
((754 | (CAST(POWER(2, 24) AS BIGINT) * 19))),	--Backup activity for subclient [^1%s] on Client [^2%s] and iDataAgent [^3%s] is disabled.
((1236 | (CAST(POWER(2, 24) AS BIGINT) * 19))),  --Backup activity for subclient [^1%s] on Client [^2%s], iDataAgent [^3%s] and Instance [^4%s] is disabled.
((740 | (CAST(POWER(2, 24) AS BIGINT) * 19))),         --All activity on CommServe is disabled.
((741 | (CAST(POWER(2, 24) AS BIGINT) * 19))),--Data Management activity on CommServe is disabled.
((424 | (CAST(POWER(2, 24) AS BIGINT) * 30))),--Failed to validate the credentials for instance [^1%s]. Please make sure the provided user [^2%s] has the sysadmin role.
((423 | (CAST(POWER(2, 24) AS BIGINT) * 30))), --Failed to validate the credentials for instance [^1%s]. Please make sure the provided user has the sysadmin role.
((1308 | (CAST(POWER(2, 24) AS BIGINT) * 19))),                --?Register job failure: [^1%s]
((487 | (CAST(POWER(2, 24) AS BIGINT) * 32))),					--^1%a Please check mount paths on the library [^2%s].
((1266 | (CAST(POWER(2, 24) AS BIGINT) * 19)))        --Full operation window for Client prevents the Backup from running right now.
	DELETE FROM #JobStateErr WHERE jobId IN
		(SELECT jobid FROM #JobStateErr J
			 INNER JOIN @ErrorMessagesUnrelatedToMA E ON E.messageId = J.messageId)
	UPDATE Summary SET currPendingJobs = A.pj, currAnomJobs =  A.aj, currFailedJobs = A.fj, totalJobs = A.tj
	FROM @SummaryTable Summary
	INNER JOIN
	(
	 SELECT maId,
			COUNT(DISTINCT jobId) tj,
COUNT(DISTINCT CASE WHEN type = 1 THEN jobId END) aj,
COUNT(DISTINCT CASE WHEN type = 2 THEN jobId END) pj,
COUNT(DISTINCT CASE WHEN type = 4 THEN jobId END) fj
	 FROM #JobStateErr
	 GROUP BY maId
	) A
	ON summary.maId = A.maId
	UPDATE SPMA SET anomalous = 1
	FROM #StoragePolicyCopyMATable SPMA
	INNER JOIN
	(
		SELECT maId FROM @SummaryTable
		WHERE (currAnomJobs + currPendingJobs + currFailedJobs) > @minCountforAnomaly AND
		(
			(anomalyThreshold < currAnomJobs) OR
			(pendingThreshold < currPendingJobs) OR
			(failedThreshold < currFailedJobs)
		)
	)A
	ON A.maId = SPMA.maId
	--Now we have the list of SPcopies served by this MA and the list of anomalous MAs
	--If there is some storage policy copy with no Alternative MA without anomaly, then we are not disturbing this MA
	IF EXISTS (
				SELECT copyId FROM #StoragePolicyCopyMATable SPMA WHERE anomalous = 1 AND maId <> @maId
				EXCEPT
				SELECT copyId FROM #StoragePolicyCopyMATable SPMA WHERE anomalous = 0 AND maId <> @maId AND enabled = 1 AND softEnabled = 1 AND indexCacheEnabled = 1 AND markedForMaintanence = 0
			  )
	BEGIN
SET @newState = 0
		SET @debugLine = 'alternative mas are also in a bad state/ ma serves other sp whose alternative mas are in bad state'
		GOTO END_PROC;
	END
	----------------------------------------------------------------------------------------------------------------
	------------ If MA can not reach the CS, the job stays in pending states with error 10:2 -----------------------
	------------ 			in this case,  disable the MA									------------------------
	----------------------------------------------------------------------------------------------------------------
	/*Unable to communicate with the remote machine [172.16.61.227] to start the Data Pipe.
	Please check the network connectivity between the local machine and the remote machine and
	verify this product's Communications Service is running on the remote machine.*/
  	DECLARE @totalErrors INT = 0
	DECLARE @maErrors INT = 0
	DECLARE @noErrors INT = 0
	DECLARE @connectionIssueCnt INT = 0
	SELECT @totalErrors = COUNT(1),
@maErrors = COUNT(CASE WHEN errorSubsystem IN (62,10) THEN 1 END),
		   @noErrors = COUNT(CASE WHEN messageId IS NULL THEN 1 END),
@connectionIssueCnt = COUNT(CASE WHEN messageId = (2 | (CAST(POWER(2, 24) AS BIGINT) * 10)) THEN 1 END)
FROM #JobStateErr WHERE maId = @maId and type IN (1, 2, 4)
	SELECT  @currRunningJobs = totalJobs,
			@currAnomJobs = currAnomJobs,
			@currPendingJobs = currPendingJobs,
			@currFailedJobs = currFailedJobs
			FROM @SummaryTable WHERE maId = @maId
	IF @connectionIssueCnt > @minCountforAnomaly
	BEGIN
		set @debugLine = 'Connection Issue'
set @newState = 5
		GOTO END_PROC
	END
	/*don't change state of ma if you dont have enough data*/
	IF @dataPointsAvailable < @minimumDaysRequired
	BEGIN
SET @newState = 0
		SET @debugLine = 'no enough past data'
		GOTO END_PROC;
	END
	-------------------------------------------------------------------------------------------------------------
	------------			       Figure out resource usage			              ---------------------------
	-------------------------------------------------------------------------------------------------------------
	/*Check resource usage in the MA for past 2 hrs*/
	IF object_id('tempdb.dbo.#ResourceUsage') IS NOT NULL DROP TABLE #ResourceUsage
	CREATE TABLE #ResourceUsage (cTime DATETIME, cpuUsage FLOAT, freeMemory INTEGER)
	INSERT INTO #ResourceUsage
	SELECT dbo.ClientLocalToUTCTime(creationdate,clientid), cpuusage, percentFreePhysicalMemory
	FROM historydb.dbo.mmperformancehistory
	WHERE clientId = @maId AND DATEDIFF(hour,dbo.ClientLocalToUTCTime(creationdate,clientid),@currentTime) <= 2
	DECLARE @totalEntries DECIMAL = 0
	DECLARE @cpuAbove90 DECIMAL = 0
	DECLARE @memoryBelow10 DECIMAL = 0
	DECLARE @highCpuUsage INT = 0
	DECLARE @highMemoryUsage INT = 0
	DECLARE @increasingMemory INT = 0
	DECLARE @increasingCPU INT = 0
	DECLARE @highResourceUsage INT = 0
	SELECT @totalEntries = COUNT(1),
		   @cpuAbove90 = COUNT(CASE  WHEN cpuusage > 90 THEN 1 END),
		   @memoryBelow10 = COUNT(CASE  WHEN freeMemory < 10 THEN 1 END)
	FROM #ResourceUsage
	--if we dont even have 5 data points in the last 2 hours, then we dont have enough info of the resource usage, so lets not change the state
	--this can also mean that ma could not push data to cs, ma down conncetivity issues etc-- should we just disable this MA??
	IF @totalEntries < 5
	BEGIN
		SET @newState = 0
		set @debugLine='no enough resource usage data'
		GOTO END_PROC;
	END
	SELECT @highCpuUsage = CASE WHEN @cpuAbove90/@totalEntries > .75 THEN 1 ELSE 0 END,
		   @highMemoryUsage = CASE WHEN @memoryBelow10/@totalEntries > .75 THEN 1 ELSE 0  END
	SELECT @increasingCPU = COUNT(increasingCPU), @increasingMemory = COUNT(increasingMemory)
	FROM
	(
	SELECT CASE WHEN LEAD(cpuusage) OVER(order by cTime) > cpuusage THEN 1 END increasingCPU,
		   CASE WHEN LEAD(freeMemory) OVER(order by cTime) < freeMemory THEN 1 END increasingMemory
	FROM #ResourceUsage
	)A
	IF @increasingCPU = @totalEntries-1
		SET @increasingCPU = 1
	ELSE
		SET @increasingCPU = 0
	IF @increasingMemory = @totalEntries-1
		SET @increasingMemory = 1
	ELSE
		SET @increasingMemory = 0
	IF (@highCpuUsage = 1 OR @highMemoryUsage = 1)
		SET @highResourceUsage = 1
    ----------------------------------------------------------------------------
	------   Figure out if most of jobs are pending due to MA errors    --------
	----------------------------------------------------------------------------
	IF @maErrors > @totalErrors * .75
		SET @maErrors = 1
	ELSE
		SET @maErrors = 0
	IF @noErrors > @totalErrors * .75
		SET @noErrors = 1
	ELSE
		SET @noErrors = 0
	-----------------------------------------------------------------------------------------
	----               |  MA Error       |   Non MA Error              | No Error			|
    -----------------------------------------------------------------------------------------
	---- High Resource | Take action     | Don't take action  (???)    | Take Action		|
	-----------------------------------------------------------------------------------------
	---- Low  Resource | Take action     | Don't take action	       | Don't take action	|
	-----------------------------------------------------------------------------------------
	IF (@highResourceUsage = 0 AND @maErrors = 0) OR (@highResourceUsage = 1 AND ( @maErrors = 0 AND @noErrors = 0))
	BEGIN
SET @newState = 0
		SET @debugLine='high resource and non ma errors / low resource and (non ma error or no error)'
		GOTO END_PROC;
	END
	------------------------------------------------------------------------------------------------------------------------------
	------------------         Pseudo code for changing states					--------------------------------------------------
	------------------------------------------------------------------------------------------------------------------------------
	/*
	IF THERE IS ANOMALY IN FAILED JOBS
		RECYCLE SERVICES , THERE IS NO HARM IN RECYCLING HERE AS JOBS ARE ANYWAY FAILING WE ARE NOT AFFECTING ANYTHING
	ELSE
	BEGIN
		IF THERE IS ANOMALY IN PENDING OR LONG RUNNING JOBS
		BEGIN
			IF THE RUNNING AND SUCCEEDED JOBS ARE MORE THAN PENDING AND LONG RUNNING JOBS
				THERE ARE JOBS SUCCEEDING AND RUNNING, SO LETS NOT DISTURB THIS MA
			ELSE (PENDING AND LONG RUNNING JOBS ARE MORE)
				BEGIN
					IF THE RESOURCE USAGE IS INCREASING CONSTANTLY AND FREE MEMORY IS LESS THAN 10 PERCENT
						THERE MIGHT BE MEMORY LEAK - SO RESTART THE SERVICES
					ELSE
						IF RESOURSE UTILIZATION IS AT ITS MAX (>90%)
							JUST DISABLE THE MA SO THAT NEW JOBS DON'T COME HERE
				END
		END
	END
	*/
	------------------------------------------------------------------------------------------------------------------------------
	IF (@currFailedJobs > dbo.ML_GetAnomalyThreshold(@failedJobsAvg, @failedJobsStd, @multiple)) AND  @currFailedJobs > @minCountforAnomaly
	BEGIN
		set @debugLine='Anomaly in failed jobs'
		GOTO RECYCLE_SERVICES
	END
	ELSE
	BEGIN
		IF ((@currAnomJobs >  dbo.ML_GetAnomalyThreshold(@anomJobsAvg, @anomJobsStd+1, @multiple)) OR (@currPendingJobs >  dbo.ML_GetAnomalyThreshold(@pendingJobsAvg, @pendingJobsStd+1, @multiple))) AND (@currPendingJobs+@currAnomjobs) > @minCountforAnomaly
		BEGIN
			DECLARE @nonPendingNonAnomalousJobs INT = @currRunningJobs - (@currPendingJobs+@currAnomjobs)
			DECLARE @succeededJobs INT = 0
			SELECT @succeededJobs = COUNT(DISTINCT S.JobId) FROM JmBkpStats S
			INNER JOIN (SELECT jobId, clientId, ROW_NUMBER() OVER(PARTITION BY jobId ORDER BY reservationId DESC) rowNum
						FROM JMJobResourceHistory WHERE reservationtime > @prevHrTimestamp OR releasetime > @prevHrTimestamp OR releasetime = 0
						) H ON S.jobId = H.jobId
			WHERE  servEndDate > @prevHrTimestamp AND H.rowNum = 1 AND H.clientId = @maId AND S.status IN (1,3,14,16) /*CVJobStatus_JMSUCCESS,PARTIALSUCCESS,JMSUCCESSWITHWARNINGS,COMMITTED*/
			IF ((@nonPendingNonAnomalousJobs + @succeededJobs) < (@currPendingJobs+@currAnomjobs))
			BEGIN
				IF (@increasingMemory = 1 OR @increasingCPU = 1) AND @highMemoryUsage = 1
				BEGIN
					SET @debugLine='Increasing resource and high memory usage'
					GOTO RECYCLE_SERVICES
				END
				ELSE IF @highResourceUsage = 1
				BEGIN
SET @newState = 2  --donot take up more jobs as the resources are used beyond limit
					SET @debugLine='donot take up more jobs as the resources are used beyond limit'
					GOTO END_PROC
				END
				ELSE
					SET @debugLine='jobs are in anomalous state , but resource is neither increasing nor high so no action'
			END
			ELSE
				SET @debugLine='some succeeding+progressing jobs > pending+anomalous jobs  or pending +anomalous count < ' + CAST(@minCountforAnomaly AS VARCHAR)
		END
		ELSE
			SET @debugLine='pending/anomalous job count is not anomalous'
	END
	GOTO END_PROC
RECYCLE_SERVICES:
	--------------------------------------------------------------------------------------------------------------------
	-------		States : Monitor -> Restart -> disable -> disable
	--------------------------------------------------------------------------------------------------------------------
	BEGIN
DECLARE @lastAction INT = (SELECT attrval FROM App_ClientProp WHERE componentNameId = @maId AND attrname = 'Smart MA State last Action'  AND modified = 0)
IF @lastAction = 2 OR @lastAction = 5
SET @newState = 2
ELSE IF @lastAction = 1
SET @newState = 2
ELSE IF @lastAction = 4
SET @newState = 1
		ELSE
SET @newState = 4
	END
	--------------------------------------------------------------------------------------------------------------------
END_PROC:
	IF object_id('tempdb.dbo.#StoreResiliencySetting') IS NOT NULL
		DROP TABLE #StoreResiliencySetting
IF @newState = 2 OR @newState = 1 OR @newState = 5
	BEGIN
		UPDATE #JobStateErr SET message = dbo.JMGetLocalizedMessageMaxFunc(@localeId,delayReasonId+',')
		;WITH cte AS
		(
			SELECT *,DENSE_RANK()  OVER(PARTITION BY A.type, A.message ORDER BY A.cnt DESC)R
			FROM (SELECT message, type, COUNT(DISTINCT jobid) AS cnt
					FROM #JobStateErr
WHERE LEN(message) > 0 AND type IN (1, 2, 4) AND maId = @maId
					GROUP BY message, type) A
		)
		SELECT @outXml = (SELECT @currPendingJobs '@pendingJobs',
									@currAnomJobs '@anomalousJobs',
									@currFailedJobs '@failedJobs',
									@currentTimeStamp '@timestamp',
									@newState '@newState',
								(
								SELECT
CASE WHEN type = 2 THEN message END 'pendingReason/@name',
CASE WHEN type = 2 THEN cnt END 'pendingReason/@id',
CASE WHEN type = 1 THEN message END 'longRunningReason/@name',
CASE WHEN type = 1 THEN cnt END 'longRunningReason/@id',
CASE WHEN type = 4 THEN message END 'failureReason/@name',
CASE WHEN type = 4 THEN cnt END 'failureReason/@id'
								FROM cte
								WHERE R <= 5
								ORDER BY R
								FOR XML PATH(''),type)
						FOR XML PATH('App_SmartMAStateMgmtJPR'))
	END
	SELECT @newState, @outXml,@debugLine
END
GO

IF EXISTS (select * from GxQscripts where name = 'ML_GetNewStateOfMA')
	delete from GxQscripts where name = 'ML_GetNewStateOfMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetNewStateOfMA')
	delete from GXDBVersions where aliasname = 'ML_GetNewStateOfMA'
GO

insert into GXDBVersions values(2, 'ML_GetNewStateOfMA',  '00000000000000000000', 'ML_GetNewStateOfMA', '00000000000000000000')
GO

