

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_GetMAsToBeEnabled.sp] ---------- 

/*
			Procedure which returns the list of MAs that are to be soft state enabled
			This does not return soft disabled MA if the resource usage is very high or if the MA is restarted more than twice in the past 24 hours
*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ML_GetMAsToBeEnabled')
BEGIN
	print '>>> Drop Stored Procedure: ML_GetMAsToBeEnabled <<<'
	drop procedure ML_GetMAsToBeEnabled
END
IF EXISTS (select * from GxQscripts where name='ML_GetMAsToBeEnabled')
	delete from GxQscripts where name = 'ML_GetMAsToBeEnabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetMAsToBeEnabled')
	delete from GXDBVersions where aliasname = 'ML_GetMAsToBeEnabled'
GO
print '... Creating Procedure: ML_GetMAsToBeEnabled'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ML_GetMAsToBeEnabled
AS
  DECLARE @maId INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @currentTime DATETIME = GETUTCDATE()
	DECLARE @currentTimeStamp INT = DATEDIFF(SECOND,'19700101',@currentTime)
	DECLARE @disabledMAs TABLE(maId INT,  disabledtime DATETIME)
	DECLARE @resourceUsage TABLE(maId INT, cpuUsage float, freeMemory float)
	DECLARE @maEnableInterval INT = ISNULL((SELECT CAST(value AS INT)
											FROM GxGlobalParam
											WHERE name = 'nSmartStateMAEnableInterval' AND modified = 0),15)
	-- set minimum value to 15 minutes
	IF @maEnableInterval < 15
		SET @maEnableInterval = 15
	INSERT INTO @disabledMAs (maId, disabledTime)
	SELECT componentnameId, dbo.getdatetime(created)
	FROM App_ClientProp
WHERE attrName = 'Smart MA State last Action' AND modified = 0
AND attrval IN ( CAST(2 as nvarchar), CAST(5 as nvarchar) )
	AND @currentTimeStamp - created > (@maEnableInterval*60)
	INSERT INTO @resourceUsage (maId,cpuusage,freeMemory)
	SELECT  Hist.clientId, Hist.cpuUsage, Hist.percentFreePhysicalMemory
	FROM @disabledMAs DMA
	INNER JOIN Historydb.dbo.mmperformancehistory Hist ON DMA.maId = Hist.clientId
	WHERE dbo.ClientLocalToUTCTime(creationdate,clientid) > disabledTime
	--donot enable MA if the resource usage is very high or if the MA is restarted more than twice in the past 24 hours
	SELECT maId
	FROM
	(
	SELECT maId, COUNT(1) totalEntries, COUNT(CASE WHEN cpuUsage > 90 THEN 1 END) highCPU, COUNT(CASE WHEN freeMemory < 10 THEN 1 END) highMemory
	FROM @resourceUsage
	GROUP BY maId
	)A
	WHERE highCPU/totalEntries < 0.25 and highMemory/totalEntries < 0.25
	EXCEPT
	SELECT componentNameId
	FROM App_ClientProp
WHERE attrname = 'Smart MA State last Action' AND attrVal in ( CAST(1 AS NVARCHAR), CAST(3 AS NVARCHAR)) AND created > (@currentTimeStamp - (24*60*60))
	GROUP BY componentNameId
	HAVING COUNT(1) > 2
END
GO

IF EXISTS (select * from GxQscripts where name = 'ML_GetMAsToBeEnabled')
	delete from GxQscripts where name = 'ML_GetMAsToBeEnabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetMAsToBeEnabled')
	delete from GXDBVersions where aliasname = 'ML_GetMAsToBeEnabled'
GO

insert into GXDBVersions values(2, 'ML_GetMAsToBeEnabled',  '00000000000000000000', 'ML_GetMAsToBeEnabled', '00000000000000000000')
GO

