

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_GetMAsForSmartStateMgmt.sp] ---------- 

/********************************************************************************************************************************
ProcName: ML_GetSmartMAStateMgmtProperties
Param   : @allApplicableMAs - supported values(1,0)
		  When set to 1, the proc returns all the MAs selected for smart state management
		  ie. MAs associated with storage policies in the smart state selection
		  - used for sending registry changes to applicable MAs
		  When set to 0, the proc returns the MAs which are selected and which are currently used by some jobs
		  -used for finding the problamatic MAs and changing their states
*********************************************************************************************************************************/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ML_GetMAsForSmartStateMgmt')
BEGIN
	print '>>> Drop Stored Procedure: ML_GetMAsForSmartStateMgmt <<<'
	drop procedure ML_GetMAsForSmartStateMgmt
END
IF EXISTS (select * from GxQscripts where name='ML_GetMAsForSmartStateMgmt')
	delete from GxQscripts where name = 'ML_GetMAsForSmartStateMgmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetMAsForSmartStateMgmt')
	delete from GXDBVersions where aliasname = 'ML_GetMAsForSmartStateMgmt'
GO
print '... Creating Procedure: ML_GetMAsForSmartStateMgmt'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ML_GetMAsForSmartStateMgmt
  @allApplicableMAs INT
AS
  DECLARE @maId INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @enabled INT = 0
	IF OBJECT_ID ('tempdb.dbo.#SelectedEntities') IS NOT NULL
		DROP TABLE #SelectedEntities
	CREATE TABLE #SelectedEntities(entityType INT, entityId INT, exclude varchar)
	IF OBJECT_ID ('tempdb.dbo.#SelectedMAs') IS NOT NULL
		DROP TABLE #SelectedMAs
	CREATE TABLE #SelectedMAs(maId INT)
	SELECT @enabled = longVal
	FROM App_ComponentProp
WHERE componentType = 1 AND componentid = 2 AND propertyTypeId = 20
	IF @enabled = 0
	 RETURN
	INSERT INTO #SelectedEntities
	SELECT longVal, longlongVal, stringval
	FROM App_ComponentProp
WHERE componentType = 1 AND componentid = 2 AND propertyTypeId = 21
	-- if all SPs are selected, get it from MMDataPath
IF EXISTS (SELECT 1 FROM #SelectedEntities WHERE entityType = 16 AND exclude = '0' )
		INSERT INTO #SelectedMAs
			SELECT DISTINCT P.hostClientId FROM MMDataPath P
			INNER JOIN archGroupCopy C on C.id = P.CopyId and C.copy = 1
			WHERE hostClientId <> 1
	ELSE
		INSERT INTO #SelectedMAs
			SELECT DISTINCT HostClientId
			FROM #SelectedEntities SE
INNER JOIN archGroupCopy AGC ON SE.entityId =  AGC.archGroupId AND SE.entityType = 17 AND exclude = '0' AND AGC.copy = 1
			INNER JOIN MMDataPath ON MMDataPath.CopyId =  AGC.id WHERE hostClientId <> 1
	-- remove the excluded entities
	DELETE SMA
	FROM #SelectedMAs SMA
	INNER JOIN
	(
		SELECT DISTINCT HostClientId maId
		FROM #SelectedEntities SE
INNER JOIN archGroupCopy AGC ON SE.entityId =  AGC.archGroupId AND SE.entityType = 17 AND exclude = '1'  AND AGC.copy = 1
		INNER JOIN MMDataPath ON MMDataPath.CopyId =  AGC.id WHERE hostClientId <> 1
	)ExcludedMAs ON SMA.maId = ExcludedMAs.maId
	-- remove MAs wits service pack less than v11 sp19
	DELETE SE
	FROM #SelectedMAs SE
	CROSS APPLY dbo.GetSpVersionInfo(SE.maId)
	WHERE releaseId < 11 OR (releaseId = 11 and spLevel < 19)
	-- delete the MAs that donot have resources allocated for any resources currently
	IF @allApplicableMAs = 0
	BEGIN
		DELETE SMA
		FROM #SelectedMAs SMA
		LEFT JOIN
		(
			SELECT clientId FROM JMJobResourcehistory Res
			INNER JOIN JmBkpJobInfo Bkp ON Bkp.jobId = Res.jobid
		)CurrentlyUsed
		ON CurrentlyUsed.clientId = SMA.maId
		WHERE CurrentlyUsed.clientID IS NULL
	END
	SELECT DISTINCT maId FROM #SelectedMAs
	IF OBJECT_ID ('tempdb.dbo.#SelectedEntities') IS NOT NULL
		DROP TABLE #SelectedEntities
	IF OBJECT_ID ('tempdb.dbo.#SelectedMAs') IS NOT NULL
		DROP TABLE #SelectedMAs
END
GO

IF EXISTS (select * from GxQscripts where name = 'ML_GetMAsForSmartStateMgmt')
	delete from GxQscripts where name = 'ML_GetMAsForSmartStateMgmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetMAsForSmartStateMgmt')
	delete from GXDBVersions where aliasname = 'ML_GetMAsForSmartStateMgmt'
GO

insert into GXDBVersions values(2, 'ML_GetMAsForSmartStateMgmt',  '00000000000000000000', 'ML_GetMAsForSmartStateMgmt', '00000000000000000000')
GO

