

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_GetJobsToForecastRunTime.sp] ---------- 

/********************************************************************************************************************************
ProcName		: ML_GetJobsToForecastRunTime
Output			: jobId,	commcellId,		subClientId,	bkplevel,	optype,		plainForecastTime, forecastPropName
Description		: Returns details of jobs without property 'Forecasted Job Running Time' in JmJobOptions table
				  plainForecastTime - obtained from APP_SubClientProp return NULL if not found
*********************************************************************************************************************************/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ML_GetJobsToForecastRunTime')
BEGIN
	print '>>> Drop Stored Procedure: ML_GetJobsToForecastRunTime <<<'
	drop procedure ML_GetJobsToForecastRunTime
END
IF EXISTS (select * from GxQscripts where name='ML_GetJobsToForecastRunTime')
	delete from GxQscripts where name = 'ML_GetJobsToForecastRunTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetJobsToForecastRunTime')
	delete from GXDBVersions where aliasname = 'ML_GetJobsToForecastRunTime'
GO
print '... Creating Procedure: ML_GetJobsToForecastRunTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ML_GetJobsToForecastRunTime
AS
  DECLARE @jobId INT
  DECLARE @commcellId INT
  DECLARE @subclientId INT
  DECLARE @bkpLevel INT
  DECLARE @opType INT
  DECLARE @plainForecastTime INT
  DECLARE @anomalyTime INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @currentTime INT = dbo.getUnixTime(GETUTCDATE())
	SELECT jobId, commcellId, applicationId, bkpLevel, optype, MAX(forecastVal), MAX(anomalyVal)
	FROM
	(
		SELECT BKP.jobId, BKP.commcellId, BKP.applicationId, BKP.bkpLevel, BKP.opType, ISNULL(CAST(Forecast.attrVal AS INT),-1) forecastVal, ISNULL(CAST(Anomaly.attrVal AS INT),-1)anomalyVal
		FROM
		(
			SELECT BJI.jobId, BJI.commcellId, BJI.applicationId, BJI.bkpLevel, JI.opType,
			'Estimated Run Time_' + CAST(JI.opType AS VARCHAR) + '_' + CAST(BJI.bkpLevel AS VARCHAR) forecastPropName,
			'Anomalous Run Time_' + CAST(JI.opType AS VARCHAR) + '_' + CAST(BJI.bkpLevel AS VARCHAR) anomalyPropName
			FROM JMBkpJobInfo BJI
			INNER JOIN JMJobInfo JI ON BJI.jobId = JI.jobId AND BJI.commcellId = JI.commcellId
LEFT JOIN JMJobOptions JO ON BJI.jobId = JO.jobId AND BJI.commcellId = JO.commcellId AND JO.attributeId = 77
			WHERE JO.attributeValueInt IS NULL
		)BKP
		LEFT JOIN APP_SubClientProp Forecast ON BKP.applicationId = Forecast.componentNameId AND BKP.forecastPropName = Forecast.attrName AND Forecast.modified = 0	AND @currentTime - Forecast.created < (3600*24)
		LEFT JOIN APP_SubClientProp Anomaly	ON BKP.applicationId = Anomaly.componentNameId AND BKP.anomalyPropName = Anomaly.attrName AND Anomaly.modified = 0	AND @currentTime - Anomaly.created < (3600*24)
	)BKP1
	GROUP BY jobId, commcellId, applicationId, bkpLevel, optype
END
GO

IF EXISTS (select * from GxQscripts where name = 'ML_GetJobsToForecastRunTime')
	delete from GxQscripts where name = 'ML_GetJobsToForecastRunTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_GetJobsToForecastRunTime')
	delete from GXDBVersions where aliasname = 'ML_GetJobsToForecastRunTime'
GO

insert into GXDBVersions values(2, 'ML_GetJobsToForecastRunTime',  '00000000000000000000', 'ML_GetJobsToForecastRunTime', '00000000000000000000')
GO

