

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_EvMoveResourceAllocationStatsToHistoryDB.sp] ---------- 

/*-------------------------------------------------------------------------
				ML_EvMoveResourceAllocationStatsToHistoryDB
			Moves data from jmjobresourcehistory to historydb
	Maintain 200 days (MaxDaysToRetainInJobResourceSummary) of data in historydb
					And prune every 10th day after that
-------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ML_EvMoveResourceAllocationStatsToHistoryDB')
BEGIN
	print '>>> Drop Stored Procedure: ML_EvMoveResourceAllocationStatsToHistoryDB <<<'
	drop procedure ML_EvMoveResourceAllocationStatsToHistoryDB
END
IF EXISTS (select * from GxQscripts where name='ML_EvMoveResourceAllocationStatsToHistoryDB')
	delete from GxQscripts where name = 'ML_EvMoveResourceAllocationStatsToHistoryDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_EvMoveResourceAllocationStatsToHistoryDB')
	delete from GXDBVersions where aliasname = 'ML_EvMoveResourceAllocationStatsToHistoryDB'
GO
print '... Creating Procedure: ML_EvMoveResourceAllocationStatsToHistoryDB'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ML_EvMoveResourceAllocationStatsToHistoryDB
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @earliestDate DATETIME
	DECLARE @latestDate DATETIME
	DECLARE @maxDaysJobStatusRetain INT = ISNULL((select value FROM GXGlobalParam with (nolock) WHERE name = 'MaxDaysToRetainInJobResourceSummary' and modified=0),200)
	SELECT @earliestDate = MIN(evDate), @latestDate = MAX(evDate) FROM historydb.dbo.ML_JobResourceAllocationSummary
	DECLARE @earliestRequired DATETIME = 0
	DECLARE @latestDataMovedHour INT = ISNULL((SELECT MAX(evhour)FROM HistoryDB.DBO.ML_JobResourceAllocationSummary WHERE evdate = @latestDate),0)
	DECLARE @latestDataMovedTime INT = 0
	DECLARE @currentTimeStamp INT = DATEDIFF(SECOND,'19700101',getutcdate())
	DECLARE @currentHr INT = ((@currentTimeStamp+3600)%(3600*24))/3600
	DECLARE @currentDate DATE = DATEADD(DAY,(@currentTimeStamp+3600)/(3600*24),'19700101')
	DECLARE @diff INT = 0
	IF @latestDate IS NOT NULL
	BEGIN
		SET @latestDataMovedTime = DATEDIFF(SECOND,'19700101',DATEADD(hour,@latestDataMovedHour-1,@latestDate))
		SET @diff = DATEDIFF(DAY,@earliestDate,@latestDate)
		SET @earliestRequired = DATEADD(DAY, -@maxDaysJobStatusRetain, @latestDate)
	END
	--using  + 3600  everywhere to put data in timespan 7-8 in 8
	IF object_id('tempdb.dbo.#jobstats') is not null
		DROP TABLE #jobstats
	create table #jobstats
	(
		mediaAgentId int,
		evdate date,
		evhour int,
		failedjobs int,
		succeededjobs int
	)
	INSERT INTO #jobstats
	 SELECT A.ClientId,
	 DATEADD(DAY,((releaseTime/3600)*3600+3600)/(3600*24),'19700101') evdate,(((releaseTime/3600)*3600+3600)%(3600*24))/3600 evhour,
	 COUNT(distinct CASE WHEN A.status NOT IN (1,14)/*--CVJobStatus_JMSUCCESS,CVJobStatus_JMSUCCESSWITHWARNINGS*/ THEN A.jobId END) failedJobs ,
	 COUNT(distinct CASE WHEN A.status IN (1,14) THEN A.jobId END) succeededJobs
	 FROM
	 (
		SELECT H.clientId,H.jobId,S.status,CASE H.releaseTime WHEN 0 THEN S.servEndDate ELSE H.ReleaseTime END releasetime FROM JMJobResourceHistory H
		INNER JOIN JMBkpStats S ON H.jobId =  S.jobId WHERE H.releaseTime>@latestDataMovedTime OR H.releaseTime = 0
	 )A
	GROUP BY A.clientId,releasetime/3600
	IF object_id('tempdb.dbo.#jobinfo') IS NOT NULL
		DROP TABLE #jobinfo
	CREATE TABLE #jobinfo
	(
		mediaAgentId int,
		evdate date,
		evhour int,
		runningjobs int,
		pendingjobs int,
		anomalousjobs int,
	)
	INSERT INTO #jobinfo
	     SELECT H.ClientId, @currentdate, @currentHr,
		 COUNT(DISTINCT H.jobId),
		 COUNT(DISTINCT CASE WHEN B.state IN (2,3) AND B.guiAlertColorLevel < 100000/*CVJobState_PENDING, CVJobState_WAITING, JMGUIAlertColorLevel::GUI_ALERT_COLOR_ANOMALOUS*/ THEN B.jobId END),
		 COUNT(DISTINCT CASE WHEN B.guiAlertColorLevel >=100000 /*(JMGUIAlertColorLevel::GUI_ALERT_COLOR_ANOMALOUS)*/ THEN B.jobId END)
			FROM JMJobResourceHistory H
			INNER JOIN RunningBackups B	ON H.jobId =  B.jobID
			WHERE H.ReleaseTime = 0 OR H.ReleaseTime/3600 = @currentTimeStamp/3600
			GROUP BY H.ClientId
	MERGE historyDB.dbo.ML_JobResourceAllocationSummary AS TARGET
	USING(
		SELECT mediaAgentId, evdate, evhour, failedjobs, succeededjobs
		FROM #jobstats
	) AS SOURCE
	ON (Source.mediaAgentId = Target.mediaAgentId AND Source.evdate=Target.evdate AND Source.evhour=Target.evhour)
	WHEN MATCHED THEN
	UPDATE SET Target.failedjobs = Source.failedjobs, Target.succeededjobs = Source.succeededjobs
	WHEN NOT MATCHED BY TARGET THEN
	INSERT (mediaagentid,evdate,evhour,runningjobs,pendingjobs,anomalousjobs,failedJobs,succeededJobs)
	VALUES(Source.mediaAgentId,Source.evdate,Source.evhour,0,0,0,Source.failedJobs,Source.succeededJobs);
	MERGE historyDB.dbo.ML_JobResourceAllocationSummary AS TARGET
	USING(
		SELECT mediaAgentId, evdate, evhour, runningJobs, pendingJobs, anomalousJobs
		FROM #jobinfo
	) AS SOURCE
	ON (Source.mediaAgentId = Target.mediaAgentId AND Source.evdate=Target.evdate AND Source.evhour=Target.evhour)
	WHEN MATCHED THEN
	UPDATE SET Target.runningJobs = Source.runningJobs, Target.pendingJobs = Source.pendingJobs, Target.anomalousJobs = Source.anomalousJobs
	WHEN NOT MATCHED BY TARGET THEN
	INSERT (mediaagentid,evdate,evhour,runningjobs,pendingjobs,anomalousjobs,failedJobs,succeededJobs)
	VALUES(Source.mediaAgentId,Source.evdate,Source.evhour,Source.runningJobs,Source.pendingJobs,Source.anomalousJobs,0,0);
	DROP TABLE #jobinfo
	DROP TABLE #jobstats
	-- maintain maxDaysJobStatusRetain days' data - prune every 10 days after that
	IF ( @diff > (@maxDaysJobStatusRetain + 10))
	BEGIN
		DELETE FROM historyDB.dbo.ML_JobResourceAllocationSummary	WHERE evDate < @earliestRequired
	END
GO

IF EXISTS (select * from GxQscripts where name = 'ML_EvMoveResourceAllocationStatsToHistoryDB')
	delete from GxQscripts where name = 'ML_EvMoveResourceAllocationStatsToHistoryDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_EvMoveResourceAllocationStatsToHistoryDB')
	delete from GXDBVersions where aliasname = 'ML_EvMoveResourceAllocationStatsToHistoryDB'
GO

insert into GXDBVersions values(2, 'ML_EvMoveResourceAllocationStatsToHistoryDB',  '00000000000000000000', 'ML_EvMoveResourceAllocationStatsToHistoryDB', '00000000000000000000')
GO

