

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_CalcOpWinDelayAndUpdateProps.sp] ---------- 

/********************************************************************************************************************************
ProcName		: ML_CalcOpWinDelayAndUpdateProps
Input			:  <JobManager_JobForecastDetailsList>
						<jobInfo jobId = "55651" commcellId = "2" subClientId = "428" opType = "4" bkpLvl = "1" plainForecastTime = "7200" anomalousRunTime = "18000" updateSubClientProp = "1" />
				   </JobManager_JobForecastDetailsList>
Description		: Calculates opwindow delay for the jobs and updates the forecastTime in JMJobOptions
				  JmJobOptions gets updated with value plainForecastTime + opwin delay
				  App_SubClientProp get updated with plainForecastTime if field updateSubclientProp is set
*********************************************************************************************************************************/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ML_CalcOpWinDelayAndUpdateProps')
BEGIN
	print '>>> Drop Stored Procedure: ML_CalcOpWinDelayAndUpdateProps <<<'
	drop procedure ML_CalcOpWinDelayAndUpdateProps
END
IF EXISTS (select * from GxQscripts where name='ML_CalcOpWinDelayAndUpdateProps')
	delete from GxQscripts where name = 'ML_CalcOpWinDelayAndUpdateProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_CalcOpWinDelayAndUpdateProps')
	delete from GXDBVersions where aliasname = 'ML_CalcOpWinDelayAndUpdateProps'
GO
print '... Creating Procedure: ML_CalcOpWinDelayAndUpdateProps'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ML_CalcOpWinDelayAndUpdateProps
  @xmlInput XML
AS
  DECLARE @errCode INT
  DECLARE @errString VARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @currentTime INT = dbo.GetUnixTime(GETUTCDATE())
	SET @errCode = 0
	SET @errString = 'Success'
	IF OBJECT_ID('tempdb.dbo.#JobInfo') IS NOT NULL
		DROP TABLE #JobInfo
	CREATE TABLE #JobInfo(jobId BIGINT, commcellId INT, subClientId INT, opType INT, bkpLvl INT, plainForecastTime INT DEFAULT 0, anomalyTime INT DEFAULT 0, updateSubClientProp INT, forecastTime INT, jobStartTime INT)
	DECLARE @doc int
	EXEC sp_xml_preparedocument @doc OUTPUT, @xmlInput
	INSERT INTO #JobInfo(jobId, commcellId, subClientId, opType , bkpLvl , plainForecastTime, anomalyTime, updateSubClientProp, forecastTime, jobStartTime)
	SELECT *, 0, 0
	FROM OPENXML (@doc, '/JobManager_JobForecastDetailsList/jobInfo' , 1)
	WITH
	(
		jobId BIGINT,
		commcellId INT,
		subClientId INT,
		opType INT,
		bkpLvl INT,
		plainForecastTime	FLOAT,
		anomalyTime	FLOAT,
		updateSubClientProp INT
	)
	EXEC sp_xml_removedocument @doc
	/*if there are multiple jobs for same subclientid, optype and bkplevel
		as it a property of subclientid for a specific optype and bkplevel,
		use the max plainforecasttime, anomaly
	*/
	UPDATE JI SET JI.plainforecasttime = JIMAX.plainforecasttime, JI.anomalyTime = JIMAX.anomalyTIme
	FROM #JobInfo JI INNER JOIN
	(
	 SELECT MAX(plainforecasttime) plainforecasttime, MAX(anomalyTime) anomalyTime, subclientId, opType, bkpLvl
	 FROM #JobInfo
	 GROUP BY subclientId, opType, bkpLvl
	 ) JIMAX
	 ON JI.subclientId = JIMAX.subclientId AND JI.opType = JIMAX.opType AND JI.bkpLvl = JIMAX.bkpLvl
	/*****************************************Calculate opwindow delay*********************************************************************/
	UPDATE JI SET jobStartTime =  JJI.jobstartTime
	FROM #JobInfo JI
	INNER JOIN JMJobInfo JJI ON JI.jobId = JJI.jobId
	IF OBJECT_ID('tempdb.dbo.#SubClientForecastInput') IS NOT NULL
		DROP TABLE #SubClientForecastInput
	CREATE TABLE #SubClientForecastInput
	(
		subclientId int,
		plainForecastTime int,
		jobStartTime int,
		forecastTime int,
		opType int,
		bkpLevel int
	)
	INSERT INTO #SubClientForecastInput (subclientId,jobStartTime,plainForecastTime,forecastTime,opType, bkpLevel)
	SELECT subClientId, jobStartTime, plainForecastTime, 0, opType, bkpLvl
	FROM #jobInfo
	EXEC ML_CalcOpWinDelay
	UPDATE JI SET forecastTime = SF.forecastTime
	FROM #jobInfo JI
	INNER JOIN #SubClientForecastInput SF ON JI.subclientId = SF.subclientId
	-- if estimation rutime is greater than the anomalous runtime, it could mean the estimation is incorrect
	-- so unset estimationtime in that case
	UPDATE #jobInfo
	SET forecastTime = 0, plainForecastTime = 0
	WHERE plainForecastTime > anomalyTime
	/********************************************** Update property in JmJobOptions and app_clientprop********************************************/
	BEGIN TRY
		BEGIN TRANSACTION
		DELETE JM
		FROM JMJobOptions JM
		INNER JOIN #JobInfo JI ON JM.jobId = JI.jobId AND JI.commcellId = JM.commcellId
AND attributeId IN (77, 76, 67)
		INSERT INTO JMJobOptions(jobId, commCellId, attributeid, attributeName, attributeValueInt, attributeValue)
SELECT DISTINCT jobId, commcellId, 77, 'Forecasted Job Running Time', forecastTime ,'' FROM #JobInfo
		INSERT INTO JMJobOptions(jobId, commCellId, attributeid, attributeName, attributeValueInt, attributeValue)
SELECT DISTINCT jobId, commcellId, 76, 'Job Running Threshold Time', anomalyTime ,'' FROM #JobInfo
		INSERT INTO JMJobOptions(jobId, commCellId, attributeid, attributeName, attributeValueInt, attributeValue)
SELECT DISTINCT jobId, commcellId, 67, 'Job Forecast information', 0 ,
		(SELECT forecastTime AS '@foreCastedRunTime',anomalyTime AS '@thresholdForAnomalousRunTime' FOR XML PATH('JobManager_ForeCastInfo'))
		FROM #JobInfo
		-- Update property in App_SubClientProp
		MERGE App_subclientprop AS  target
		USING (SELECT distinct subclientId, bkpLvl, opType, plainforecasttime FROM #JobInfo WHERE updateSubClientProp = 1)AS SOURCE
		ON(
			Target.modified =  0 AND
			SOURCE.subclientId = Target.componentnameid AND
			CHECKSUM('Estimated Run Time_' + CAST(SOURCE.opType AS NVARCHAR) + '_' + CAST(SOURCE.bkpLvl AS NVARCHAR)) = target.cs_attrname
		)
		WHEN MATCHED THEN
		UPDATE SET attrval = Source.plainforecasttime, created = @currentTime
		WHEN NOT MATCHED THEN
		INSERT (componentNameId,	attrName,	attrType,	attrVal,	created,	modified)
		VALUES(subClientId, 'Estimated Run Time_' + CAST(opType AS NVARCHAR) + '_' + CAST(bkpLvl AS NVARCHAR),
10, plainForecastTime, @currentTime, 0);
		MERGE App_subclientprop AS  target
		USING (SELECT distinct subclientId, bkpLvl, opType, anomalyTime FROM #JobInfo WHERE updateSubClientProp = 1)AS SOURCE
		ON(
			Target.modified =  0 AND
			SOURCE.subclientId = Target.componentnameid AND
			CHECKSUM('Anomalous Run Time_' + CAST(SOURCE.opType AS NVARCHAR) + '_' + CAST(SOURCE.bkpLvl AS NVARCHAR)) = target.cs_attrname
		 )
		 WHEN MATCHED THEN
		 UPDATE SET attrval=Source.anomalyTime, created=@currentTime
		 WHEN NOT MATCHED THEN
		 INSERT (componentNameId,	attrName,	attrType,	attrVal,	created,	modified)
		 VALUES(subClientId, 'Anomalous Run Time_' + CAST(opType AS NVARCHAR) + '_' + CAST(bkpLvl AS NVARCHAR),
10, anomalyTime, @currentTime, 0);
		COMMIT TRANSACTION
	END TRY
	BEGIN CATCH
		ROLLBACK TRANSACTION
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errCode = ERROR_NUMBER()
		SET @errString = ERROR_MESSAGE()
	END CATCH
	SELECT  @errCode,@errString
END
GO

IF EXISTS (select * from GxQscripts where name = 'ML_CalcOpWinDelayAndUpdateProps')
	delete from GxQscripts where name = 'ML_CalcOpWinDelayAndUpdateProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_CalcOpWinDelayAndUpdateProps')
	delete from GXDBVersions where aliasname = 'ML_CalcOpWinDelayAndUpdateProps'
GO

insert into GXDBVersions values(2, 'ML_CalcOpWinDelayAndUpdateProps',  '00000000000000000000', 'ML_CalcOpWinDelayAndUpdateProps', '00000000000000000000')
GO

