

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ML_CalcOpWinDelay.sp] ---------- 

/********************************************************************************************************************************
ProcName		: ML_CalcOpWinDelay
Input			:  temp table #SubClientForecastInput
							  (
								subclientId int,
								plainForecastTime int,
								jobStartTime int,
								forecastTime int,
								opType int,
								bkpLevel int
							  )
Description		: Calculates opwindow delay for the jobs and updates the forecasttime in #SubClientForecastInput
*********************************************************************************************************************************/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ML_CalcOpWinDelay')
BEGIN
	print '>>> Drop Stored Procedure: ML_CalcOpWinDelay <<<'
	drop procedure ML_CalcOpWinDelay
END
IF EXISTS (select * from GxQscripts where name='ML_CalcOpWinDelay')
	delete from GxQscripts where name = 'ML_CalcOpWinDelay'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_CalcOpWinDelay')
	delete from GXDBVersions where aliasname = 'ML_CalcOpWinDelay'
GO
print '... Creating Procedure: ML_CalcOpWinDelay'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ML_CalcOpWinDelay
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	IF OBJECT_ID('tempdb.dbo.#subClients') IS NOT NULL
		DROP TABLE #subClients
	CREATE TABLE #subClients(subClientId INT,jobStartTime INT, plainForecastTime INT, opType INT, bkpLevel INT, ran INT default(0),willCompleteAt INT default(0), forecastedRunTime INT default(0),rn int)
	IF OBJECT_ID('tempdb.dbo.#OpWindowSubClient') IS NOT NULL
		DROP TABLE #OpWindowSubClient
	CREATE TABLE #OpWindowSubClient(opIWinId INT,subClientId INT)
	IF OBJECT_ID('tempdb.dbo.#OpWindowSlots') IS NOT NULL
		DROP TABLE #OpWindowSlots
	CREATE TABLE #OpWindowSlots(opIWinId INT, slotsTill INT, startTime INT, endTime INT)
	INSERT INTO #subClients(subClientId , jobStartTime , plainForecastTime, opType, bkpLevel)
	SELECT subclientId, jobStartTime, plainForecastTime, opType, bkpLevel
	FROM #SubClientForecastInput
	WHERE plainforecastTime > 0
	DECLARE @ignoreHigherRules TABLE (entityType INT, entityId INT, ignoreHigherRules INT)
	INSERT INTO @ignoreHigherRules
		SELECT 7, componentNameId, attrVal FROM App_SubClientProp WHERE attrName='Ignore commcell operation rule' AND modified = 0
		UNION ALL
		SELECT 6, componentNameId, attrVal FROM App_BackupsetProp WHERE attrName='Ignore commcell operation rule' AND modified = 0
		UNION ALL
		SELECT 5, componentNameId, attrVal FROM App_InstanceProp WHERE attrName='Ignore commcell operation rule' AND modified = 0
		UNION ALL
		SELECT 4, componentNameId, attrVal FROM App_iDAProp WHERE attrName='Ignore commcell operation rule' AND modified = 0
		UNION ALL
		SELECT 3, componentNameId, attrVal FROM App_ClientProp WHERE attrName='Ignore commcell operation rule' AND modified = 0
	INSERT INTO #OpWindowSubClient
		SELECT DISTINCT OP.id, APP.id
		FROM #subClients ApplicableSC
		INNER JOIN APP_Application APP ON APP.id =  ApplicableSC.subClientId
		INNER JOIN APP_IdaName Ida ON Ida.clientId = App.clientId and Ida.appTypeId = App.appTypeid
		LEFT JOIN APP_ClientGroupAssoc CGA ON APP.clientId = CGA.clientId
		INNER JOIN APP_OpwindowRule OP ON
			(OP.subClientId = APP.id) OR
			(OP.subclientId = 0 AND OP.backupSetId = APP.backupSet ) OR
			(OP.subclientId = 0 AND OP.backupSetId = 0 AND OP.instanceId = APP.instance ) OR
			(OP.subclientId = 0 AND OP.backupSetId = 0 AND OP.instanceId = 0 AND OP.appTypeId = APP.appTypeId  AND OP.clientId = APP.clientId) OR
			(OP.subclientId = 0 AND OP.backupSetId = 0 AND OP.instanceId = 0 AND OP.appTypeId = 0 AND OP.clientId = APP.clientId) OR
			(OP.subclientId = 0 AND OP.backupSetId = 0 AND OP.instanceId = 0 AND OP.appTypeId = 0 AND OP.clientId = 0 AND OP.clientGroupId = CGA.clientGroupId ) OR
			(OP.appTypeId = 1000)
		WHERE OP.enable = 1
		AND OP.opType & 1048576 > 0 /*OPERATION_ALL*/ OR
		(
			(OP.opType & 1 > 0   /*OPERATION_FULL_DATA_PROTECTION*/   AND ApplicableSC.bkplevel = 1  /*CVBkpLevel_FULL*/ ) OR
			(OP.opType & 4 > 0    /*OPERATION_SYNTHETIC_FULL*/         AND ApplicableSC.bkplevel = 64 /*CVBkpLevel_SYNTHETIC_FULL*/ ) OR
(OP.opType & 8192 > 0 /*OPERATION_TRANSACTION_LOG_BACKUP*/ AND ApplicableSC.bkplevel = 2  /*CVBkpLevel_INCR*/ AND ( APP.appTypeId IN ( 126 , 5, 81 ))) OR
			(OP.opType & 2 > 0    /*OPERATION_NON_FULL_DATA_PROTECTION*/
AND NOT (ApplicableSC.bkplevel = 2 /*CVBkpLevel_INCR*/ AND ( APP.appTypeId IN ( 126 , 5, 81 )))
				AND ApplicableSC.bkplevel NOT IN ( 1 /*CVBkpLevel_FULL*/, 64 /*CVBkpLevel_SYNTHETIC_FULL*/)
			)
			--transaction log backups have incr bkplevel but a separate opwindow optype
		)
	-- remove the entites if ignore higher rules is selected
	DELETE OS
	FROM #OpWindowSubClient OS
	INNER JOIN APP_Application APP ON APP.id = OS.subclientId
	INNER JOIN APP_IdaName Ida ON Ida.clientId = App.clientId and Ida.appTypeId = App.appTypeid
	LEFT JOIN APP_OpWindowRule OP on OS.opIWinId = OP.id
	INNER JOIN @ignoreHigherRules IH ON
		(APP.Id=IH.entityId AND IH.entityType = 7) OR
		(APP.backupSet = IH.entityId AND IH.entityType = 6) OR
		(APP.instance = IH.entityId AND IH.entityType = 5) OR
		(Ida.id = IH.entityId AND IH.entityType = 4) OR
		(APP.clientId= IH.entityId AND IH.entityType = 3)
	WHERE IH.ignoreHigherRules=1 AND
	(
		( op.subclientId = 0 AND IH.entityType = 7) OR
		(op.backupsetId = 0 AND IH.entityType = 6) OR
		(op.instanceId = 0 AND IH.entityType = 5) OR
		((op.appTypeId = 0 OR op.appTypeId = 1000) AND IH.entityType = 4) OR
		((op.clientId = 0 OR op.appTypeId = 1000) AND IH.entityType = 3)
	)
	DECLARE @maxForecastTime INT = 0
	DECLARE @slotStart INT = 0
	DECLARE @slotEnd INT = 0
	SELECT @maxForecastTime = MAX(plainForecastTime), @slotStart = MIN(jobStartTime), @slotEnd = MAX(jobStartTime+plainForecastTime)
	FROM #subClients
	INSERT INTO #OpWindowSlots
	SELECT  OP.opIWinId, @slotEnd,Slots.* FROM
	(
		SELECT distinct opIWinId
		FROM #OpWindowSubClient
	)OP
	CROSS APPLY dbo.AppGetOpWindowIntervals(OP.opIWinId, @slotStart, @slotEnd)Slots
	-- update jobs that donot have a window set and are not afected by any
	UPDATE SC SET SC.forecastedRunTime =SC.plainForecastTime
	FROM #subClients SC
	LEFT JOIN
	(
		SELECT OSC.subClientId,MIN(OWS.startTime) opStart FROM  #OpWindowSubClient OSC
		INNER JOIN #OpWindowSlots OWS ON OSC.opIWinId=OWS.opIWinId
		GROUP BY OSC.subClientId
	)A
	ON A.subClientId = SC.subClientId
	WHERE (A.subClientId IS NULL)OR(SC.jobStartTime + SC.plainForecastTime <= A.opStart)
	-- 1. get op window slots for the forecasted duration of the job
	-- 2. verify if job could complete within that duration unaffected by op window
	-- 3. if the could not complete with in that period, get the opwindow slots for lastchecktime +forecasttime + 1 day
	-- 4. now check if job could complete
	-- 5. repeat steps 3, 4 until all jobs get the forecast time
	-- 6. sum of difference between the opwindow start time and max of prev opwindow end time will give us details on actual time the job will be able to run.
	DECLARE @n INT = 1
	DECLARE @loopCnt INT = 10
	WHILE @n > 0 AND @loopCnt > 0
	BEGIN
		-- loop around for a max of 10 times,
		-- ideally run time should be forecasted before it
		-- lets not endup in some infinite loop
		SET @loopCnt = @loopCnt - 1
		UPDATE SC SET RN = D.RN, ran = D.Ran1
		FROM #subClients SC
		INNER JOIN
		(
			SELECT C.subClientId, C.RN, C.Ran1, C.plainForecastTime, ROW_NUMBER() OVER (PARTITION BY C.subclientId ORDER BY C.RN) RN2 FROM
				(
					SELECT B.subClientId, SC.plainForecastTime, B.startTime, B.endTime, B.Ran1, B.diff, ROW_NUMBER() OVER (PARTITION BY B.subclientId ORDER BY B.startTime) RN FROM
					(
						SELECT A.startTime, endtime, A.subclientid,
						CASE WHEN diff > 0 THEN diff ELSE 0 END diff,
						SUM(CASE WHEN diff > 0 THEN diff ELSE 0 END) OVER(PARTITION BY subclientid ORDER BY starttime ) Ran1
						FROM
						(
							SELECT subclientId, starttime, endtime, starttime - LAG(endtime, 1, jobStartTime) OVER (PARTITION BY subclientid ORDER BY startTime) diff
							FROM
							(
								SELECT OSC.subclientId, jobStartTime, starttime, CASE WHEN MAX(endtime) OVER (PARTITION BY OSC.subclientId ORDER BY startTime)>jobStartTime THEN MAX(endtime) OVER (PARTITION BY OSC.subclientId ORDER BY startTime) ELSE jobStartTime END endTime
								FROM #OpWindowSlots OWS
								INNER JOIN #OpWindowSubClient OSC ON OSC.opIWinId = OWS.opIWinId
								INNER JOIN #subClients SC ON SC.subclientId = OSC.subClientId
							)A1
						)A
					)B
					INNER JOIN #subClients SC ON SC.subClientId = B.subClientId
				)C WHERE C.ran1 >= C.plainForecastTime
		)D ON D.subClientId = SC.subClientId WHERE D.RN2 = 1
		 SET @n = (SELECT count(1) FROM #subClients WHERE forecastedRunTime=0 AND  ran < plainForecastTime)
		 IF @n > 0
		 BEGIN
			SET @slotStart = @slotEnd
			SET @slotEnd = @slotStart + @maxforecastTime + (24*3600)
			INSERT INTO #OpWindowSlots
			SELECT  OP.opIWinId, @slotEnd ,Slots.* FROM
			(
				SELECT distinct opIWinId
				FROM #OpWindowSubClient
			)OP
			CROSS APPLY dbo.AppGetOpWindowIntervals(OP.opIWinId, @slotStart, @slotEnd)Slots
		END
	END
	UPDATE SC SET willCompleteAt = SC.plainForecastTime - D.Ran1 + D.endTime
	FROM #subClients SC
	INNER JOIN
	(
	SELECT C.subClientId, C.Ran1, C.endTime, ROW_NUMBER() OVER (PARTITION BY C.subClientId ORDER BY C.endTime DESC) RN FROM
	(
		SELECT B.subClientId, B.startTime, B.endTime, B.Ran1, B.diff, ROW_NUMBER() OVER (PARTITION BY B.subclientId ORDER BY B.startTime )RN FROM
		(
			SELECT A.startTime, endtime, A.subclientid,
			CASE WHEN diff>0 THEN diff ELSE 0 END diff,
			SUM(CASE WHEN diff>0 THEN diff ELSE 0 END) OVER(PARTITION BY subclientid ORDER BY starttime) Ran1
			FROM
			(
				SELECT subclientId, starttime, endtime, starttime - LAG(endtime, 1, jobStartTime) OVER (PARTITION BY subclientid ORDER BY startTime) diff
				FROM
				(
					SELECT OSC.subclientId, jobStartTime, starttime, CASE WHEN MAX(endtime) OVER (PARTITION BY OSC.subclientId ORDER BY startTime)>jobStartTime THEN MAX(endtime) OVER (PARTITION BY OSC.subclientId ORDER BY startTime) ELSE jobStartTime END endTime
					FROM #OpWindowSlots OWS
					INNER JOIN #OpWindowSubClient OSC ON OSC.opIWinId = OWS.opIWinId
					INNER JOIN #subClients SC ON SC.subclientId = OSC. subClientId
				)A1
			)A
		)B
	)C	INNER JOIN #subClients SC ON C.subClientId=SC.subClientId WHERE C.RN < SC.rn
	)D	ON SC.subclientId = D.subClientId AND D.RN = 1
	-- for jobs unaffected by opwindow
	UPDATE SF set forecastTime = SC.forecastedRunTime
	FROM #SubClientForecastInput SF
	INNER JOIN #subClients SC ON SC.subClientId = SF.subClientId where forecastedRunTime > 0
	-- for jobs delayed by opwindow
	UPDATE SF set forecastTime = SC.willCompleteAt - SF.jobStartTime
	FROM #SubClientForecastInput SF
	INNER JOIN #subClients SC ON SC.subClientId = SF.subClientId where SC.willCompleteAt > 0
	--if we had not figured forecasttime for some jobs, set plainforecasttime for them
	--UPDATE #SubClientForecastInput SET forecastTime = plainForecastTime WHERE forecastTime = 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'ML_CalcOpWinDelay')
	delete from GxQscripts where name = 'ML_CalcOpWinDelay'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ML_CalcOpWinDelay')
	delete from GXDBVersions where aliasname = 'ML_CalcOpWinDelay'
GO

insert into GXDBVersions values(2, 'ML_CalcOpWinDelay',  '00000000000000000000', 'ML_CalcOpWinDelay', '00000000000000000000')
GO

