

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MDM_SetPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MDM_SetPolicy.sp,v $ $Id: MDM_SetPolicy.sp,v 1.4.42.1 2017/02/10 20:21:34 sjohnson Exp $";
-- ======================================================================
-- Author:		Puneet Chadha
-- Create date: 10/09/2013
-- Description:	Insert policy info
-- ======================================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MDM_SetPolicy <<<'

IF EXISTS (select * from sysobjects where name='MDM_SetPolicy')
	drop procedure MDM_SetPolicy
IF EXISTS (select * from GxQscripts where name='MDM_SetPolicy')
	delete from GxQscripts where name = 'MDM_SetPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_SetPolicy')
	delete from GXDBVersions where aliasname = 'MDM_SetPolicy'
GO
print '... Creating Procedure: MDM_SetPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MDM_SetPolicy
  @in_Xml XML,
  @out_Xml XML OUTPUT
AS
DECLARE @operationType  INT
DECLARE @policyId INT
DECLARE @nowTime INT
DECLARE @errorCode INT=0
DECLARE @errorMessage NVARCHAR(MAX)=''
DECLARE @errorXML XML
DECLARE @policyName nvarchar(512)
DECLARE @attrTable TABLE
(
attrName nvarchar(512),
attrType int,
attrVal  nvarchar(512)
)
DECLARE @policyTable TABLE
(
policyId INT,
policyName nvarchar(512)
)
DECLARE @failedTable TABLE
(
policyId INT
)
BEGIN TRY
BEGIN TRAN
 INSERT INTO @policyTable (policyId,policyName)
	                        (SELECT
								ref.value('@policyId', 'int') ,
								ref.value('@policyName', 'nvarchar(512)')
								FROM    @in_Xml.nodes('MDM_SetPolicyRequest/policies') R(ref))
SET @operationType  = ISNULL((select ref.value('@operationType', 'int')
					FROM    @in_Xml.nodes('MDM_SetPolicyRequest') R ( ref )),0)
SET @policyName =   ( SELECT TOP 1 policyName from @policyTable)
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
INSERT INTO @attrTable(attrName , attrType , attrVal)
	   (SELECT  ref.value('@name', 'nvarchar(512)') ,
				ref.value('@valueType', 'int') ,
				ref.value('@value', 'nvarchar(512)')
        FROM    @in_Xml.nodes('MDM_SetPolicyRequest/policies/attributes') R(ref))
IF @operationType = 2
BEGIN
insert into MDM_Policy(name,refTime,modified,status)
values(@policyName,@nowTime,@nowTime,0)
Set @policyID=@@IDENTITY
INSERT INTO MDM_PolicyProp(componentNameId , attrName , attrType , attrVal , created , modified)
select  @policyID,attrname,attrType,attrVal,@nowTime,0 from @attrTable
END
ELSE IF @operationType = 1
BEGIN
SET @policyId = (SELECT TOP 1 policyId from @policyTable)
Delete newProp from @attrTable newProp  where newProp.attrVal=
(select oldProp.attrVal from MDM_PolicyProp oldProp where componentNameId=@policyID and oldProp.attrName=newProp.attrName
and oldProp.modified=0)
update MDM_PolicyProp set modified=@nowTime where componentNameId=@policyID and attrName in (select attrName from @attrTable)
select '1', @policyID,attrname,attrType,attrVal,@nowTime,0 from @attrTable
INSERT INTO MDM_PolicyProp(componentNameId , attrName , attrType , attrVal , created , modified)
select  @policyID,attrname,attrType,attrVal,@nowTime,0 from @attrTable
END
ELSE IF @operationType=3
BEGIN
insert into @failedTable (policyId)
(select policyId From @policyTable where policyId in (select attrVal from MDM_DeviceProp where attrName='policyId' and modified=0))
 if EXISTS (Select * From @failedTable)
		 BEGIN
		 SET @errorCode = -10
		 SET @errorMessage = ''
		 SELECT @errorMessage = @errorMessage + name +',' from MDM_policy where id in (Select policyId from @failedTable)
		 SET @errorMessage = 'Cannot delete policies: '+ @errorMessage + ' due to device association'
		 END
 DELETE MDM_deviceregistrationinfo where policyId in (select policyId from @policyTable) and policyId not in (select policyId from @failedTable)
 DELETE MDM_PolicyProp where componentNameId in (select policyId from @policyTable) and componentNameId not in (select policyId from @failedTable)
 DELETE MDM_Policy where id in (select policyId from @policyTable) and id not in (select policyId from @failedTable)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
 SET @errorCode = -1
 SET @errorMessage = 'SP failed to execute properly. Please check Logs for more details'
 GOTO EXIT_ERROR
END CATCH
EXIT_ERROR:
IF @errorCode<>0
   ROLLBACK TRAN
ELSE
   COMMIT TRAN
SET @errorXML = (select @errorCode as '@errorCode',
							@errorMessage as '@errorString'
					for xml path('error'))
SET @out_Xml = (select @errorXML  for xml path ('MDM_SetDeviceDetailsResponse'),type)
select @out_Xml
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'MDM_SetPolicy')
	delete from GxQscripts where name = 'MDM_SetPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_SetPolicy')
	delete from GXDBVersions where aliasname = 'MDM_SetPolicy'
GO

insert into GXDBVersions values(2, 'MDM_SetPolicy',  '00010004004200010000', 'MDM_SetPolicy', '00010004004200010000')
GO

