

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MDM_SetDeviceInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MDM_SetDeviceInfo.sp,v $ $Id: MDM_SetDeviceInfo.sp,v 1.8.40.1 2017/02/10 20:21:34 sjohnson Exp $";
-- ======================================================================
-- Author:		Apoorv Arora
-- Create date: 10/09/2013
-- Description:	OTP insertion, OTP verification, Device details insertion
-- ======================================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MDM_SetDeviceInfo <<<'

IF EXISTS (select * from sysobjects where name='MDM_SetDeviceInfo')
	drop procedure MDM_SetDeviceInfo
IF EXISTS (select * from GxQscripts where name='MDM_SetDeviceInfo')
	delete from GxQscripts where name = 'MDM_SetDeviceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_SetDeviceInfo')
	delete from GXDBVersions where aliasname = 'MDM_SetDeviceInfo'
GO
print '... Creating Procedure: MDM_SetDeviceInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MDM_SetDeviceInfo
  @in_Xml XML,
  @out_Xml XML OUTPUT
AS
DECLARE @operationType  INT
DECLARE @deviceId INT
DECLARE @nowTime INT
DECLARE @i_attrName NVARCHAR(MAX)
DECLARE @i_attrType INT
DECLARE @i_attrVal NVARCHAR(MAX)
DECLARE @ccId INT
DECLARE @errorCode INT
DECLARE @errorMessage NVARCHAR(MAX)
DECLARE @errorXML XML
DECLARE @passCodeXML XML
DECLARE @alternativeEmail NVARCHAR(MAX)
DECLARE @userId INT
DECLARE @userName NVARCHAR(MAX)
DECLARE @otpKey INT
DECLARE @policyId INT
DECLARE @phoneNumber NVARCHAR(255)
DECLARE @isCompanyDevice INT
DECLARE @deviceName nvarchar(max)
DECLARE @deviceType INT
DECLARE @attrTable TABLE
(
attrName nvarchar(512),
attrType int,
attrVal  nvarchar(MAX) NOT NULL
)
DECLARE @deviceTable TABLE
(
deviceId INT,
deviceName nvarchar(512)
)
BEGIN TRY
BEGIN TRAN
SET @i_attrName = ''
SET @i_attrType = 0
SET @i_attrVal  =''
SET @errorCode = 0
SET @errorMessage = ''
SET @alternativeEmail = ''
SET @phoneNumber = ''
SET @deviceType=0
SET @userId =    ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
                         FROM    @in_Xml.nodes('MDM_SetDeviceDetailsRequest/deviceEntities/mdmUser/user') R ( ref )),0)
IF @userId = 0
BEGIN
	SET @alternativeEmail =   ISNULL((SELECT  ref.value('@alternativeEmail', 'nvarchar(512)') AS Agent
                         FROM    @in_Xml.nodes('MDM_SetDeviceDetailsRequest/deviceEntities/mdmUser') R ( ref )),'')
    SET @userId = ISNULL((SELECT id from UMUsers where email like @alternativeEmail and password!='Password Disabled'),0)
END
SET @operationType  = ISNULL((select ref.value('@operationType', 'int')
					FROM    @in_Xml.nodes('MDM_SetDeviceDetailsRequest') R ( ref )),0)
IF @userId = 0 AND (@operationType=0 OR @operationType=2)
BEGIN
  SET @errorCode = 2
 SET @errorMessage = 'No such User Exists.Request cannot be generated'
 GOTO EXIT_ERROR
END
  INSERT INTO @deviceTable (deviceId,deviceName)
	                        (SELECT
								ref.value('@deviceId', 'int') ,
								ref.value('@deviceName', 'nvarchar(512)')
								FROM    @in_Xml.nodes('MDM_SetDeviceDetailsRequest/deviceEntities/device') R(ref))
SET @deviceId =   ( SELECT TOP 1 deviceId from @deviceTable)
SET @deviceName = ( SELECT TOP 1 deviceName from @deviceTable)
SET @policyId =    ISNULL((SELECT  ref.value('@policyId', 'int') AS Agent
                         FROM    @in_Xml.nodes('MDM_SetDeviceDetailsRequest/deviceEntities/policy') R ( ref )),0)
IF @policyId!=0
BEGIN
INSERT INTO @attrTable(attrName , attrType , attrVal)
		values ('policyId',1,@policyId)
END
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
INSERT INTO @attrTable(attrName , attrType , attrVal)
(SELECT  ref.value('@name', 'nvarchar(512)') ,
				ref.value('@valueType', 'int') ,
				ref.value('@value', 'nvarchar(MAX)')
        FROM    @in_Xml.nodes('MDM_SetDeviceDetailsRequest/deviceEntities/device/attributes') R(ref))
if (CAST(@in_Xml.query('MDM_SetDeviceDetailsRequest/deviceEntities/device/applications') AS NVARCHAR(MAX)) !='')
BEGIN
	INSERT INTO @attrTable(attrName , attrType , attrVal)
	(SELECT  'Applications' ,32 ,ISNULL(CAST (@in_Xml.query('MDM_SetDeviceDetailsRequest/deviceEntities/device/applications') AS NVARCHAR(MAX)),''))
END
if (CAST(@in_Xml.query('MDM_SetDeviceDetailsRequest/deviceEntities/device/runningServices') AS NVARCHAR(MAX)) !='')
BEGIN
	INSERT INTO @attrTable(attrName , attrType , attrVal)
	(SELECT  'RunningServices' ,64 ,ISNULL(CAST (@in_Xml.query('MDM_SetDeviceDetailsRequest/deviceEntities/device/runningServices') AS NVARCHAR(MAX)),''))
END
IF EXISTS(SELECT * FROM @attrTable WHERE attrName = 'otpKey' AND attrType = 1)
BEGIN
SET @otpKey =    ISNULL((SELECT attrVal FROM @attrTable WHERE attrName = 'otpKey' AND attrType = 1 ), 0)
DELETE FROM @attrTable where attrName='otpKey'
END
SET @isCompanyDevice =    ISNULL((SELECT attrVal FROM @attrTable WHERE attrName = 'isCompanyDevice' AND attrType = 1 ), 0)
IF EXISTS(SELECT * FROM @attrTable WHERE attrName = 'phoneNumber' AND attrType = 1)
 BEGIN
 SET @phoneNumber =    ISNULL((SELECT attrVal FROM @attrTable WHERE attrName = 'phoneNumber' AND attrType = 1 ), 0)
END
IF EXISTS(SELECT * FROM @attrTable WHERE attrName = 'gcmId' AND attrType = 1)
	BEGIN
		SELECT @i_attrName = attrName , @i_attrType = attrType , @i_attrVal = attrVal FROM @attrTable WHERE attrName = 'gcmId' AND attrType = 1
	END
SET @ccId = ISNULL( (SELECT origCCId FROM UMUsers WHERE id = @userId), 2)
IF @operationType = 0
	BEGIN
	IF EXISTS(SELECT * FROM @attrTable WHERE attrName = 'deviceType' AND attrType = 1)
	BEGIN
	SET @deviceType =    ISNULL((SELECT attrVal FROM @attrTable WHERE attrName = 'deviceType' AND attrType = 1 ), 0)
	END
	  SET @otpKey = ( SELECT CAST((RAND() * (899999) + 100000) as int) )
	WHILE (EXISTS (SELECT * FROM MDM_deviceRegistrationInfo with(nolock) WHERE otpKey = @otpKey))
	BEGIN
	  SET @otpKey = ( SELECT CAST((RAND() * (899999) + 100000) as int) )
	 END
	INSERT INTO MDM_deviceRegistrationInfo(userId,policyId,type,phoneNumber,isCompanyDevice, email ,commcellId , otpKey , created)
	 VALUES(@userId ,@policyId,@deviceType,@phoneNumber,@isCompanyDevice, @alternativeEmail ,@ccId , @otpKey , @nowTime)
	DELETE FROM MDM_deviceRegistrationInfo where @nowTime > created+1800
	SET @alternativeEmail=ISNULL((select email from UMUsers where id=@userId),'')
	SET @userName=ISNULL((select name from UMUsers where id=@userId),'')
    SET @passCodeXML =
						(select
								@otpKey as '@otpKey',
						(select (select @deviceId as '@deviceId'
						for xml path ('devices'),TYPE),
						   (select @alternativeEmail as '@alternativeEmail',
						               (select @userId as '@userId',
									           @userName as '@userName'
						              for xml path('user'),TYPE)
				             for xml path ('mdmUser'),TYPE)
							 for xml path ('device'),TYPE)
						for xml path('passCodes'),TYPE)
  	END
ELSE IF @operationType = 2
BEGIN
IF NOT EXISTS(SELECT * FROM MDM_deviceRegistrationInfo with(nolock) WHERE userId = @userId AND otpKey = @otpKey AND @nowTime < (created+1800) )
	BEGIN
	SET	@errorCode = -1;
	SET @errorMessage = 'OTPKey combo is invalid'
	GOTO EXIT_ERROR
	END
SET @policyId = ISNULL((SELECT  policyId from MDM_deviceRegistrationInfo where otpKey = @otpKey)
                         ,0)
DELETE FROM MDM_deviceRegistrationInfo where otpKey=@otpKey
SET @passCodeXML =
						(select (select (select @deviceId as '@deviceId'
						for xml path ('device'),TYPE),
											(select id as '@policyId',
						                           name as '@policyName',
												   refTime as '@created',
													modified as '@modified',
						                          (select attrName as '@name' ,
												   attrType as '@valueType' ,
												   attrVal  as '@value'
										           from MDM_PolicyProp as prop
													where prop.componentNameId=policy.id and prop.modified=0
													for xml path('attributes'),TYPE)
												  from MDM_Policy as policy where policy.id=@policyId
						                      for xml path ('policy'),TYPE),
						    (select (select @userId as '@userId'
						              for xml path('user'),TYPE),
						            (select @alternativeEmail as '@alternativeEmail')
				             for xml path ('mdmUser'),TYPE)
							  for xml path ('device'),TYPE)
						for xml path('passCodes'),TYPE)
END
ELSE IF @operationType = 1
BEGIN
Delete newProp from @attrTable newProp  where newProp.attrVal=
(select  top 1 isnull(oldProp.attrVal,'') from MDM_DeviceProp oldProp where componentNameId=@deviceId and oldProp.attrName=newProp.attrName
and oldProp.modified=0)
update MDM_DeviceProp set modified=@nowTime where componentNameId=@deviceId and attrName in (select attrName from @attrTable)
 select  @deviceId,attrname,attrType,attrVal,@nowTime,0 from @attrTable
INSERT INTO MDM_DeviceProp(componentNameId , attrName , attrType , attrVal , created , modified)
select  @deviceId,attrname,attrType,attrVal,@nowTime,0 from @attrTable
IF EXISTS (Select * from MDM_DeviceProp where componentNameId=@deviceId and modified=0 and attrName like 'lastUpdated')
Begin
 Update MDM_DeviceProp set attrVal=@nowTime where componentNameId=@deviceId and modified=0 and attrName like 'lastUpdated'
 ENd
Else
Begin
     INSERT INTO MDM_DeviceProp(componentNameId , attrName , attrType , attrVal , created , modified)
	  values (@deviceId,'lastUpdated','1',@nowTime,@nowTime,0)
ENd
END
ELSE IF @operationType=3
BEGIN
DELETE MDM_ActionHistory where deviceId in (SELECT deviceId from @deviceTable)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
 SET @errorCode = -1
 SET @errorMessage = 'SP failed to execute properly. Please check Logs for more details'
 GOTO EXIT_ERROR
END CATCH
EXIT_ERROR:
IF @errorCode<>0
   ROLLBACK TRAN
ELSE
   COMMIT TRAN
SET @errorXML = (select @errorCode as '@errorCode',
							@errorMessage as '@errorString'
					for xml path('error'))
SET @out_Xml = (select @errorXML ,@passCodeXML for xml path ('MDM_SetDeviceDetailsResponse'),type)
select @out_Xml
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'MDM_SetDeviceInfo')
	delete from GxQscripts where name = 'MDM_SetDeviceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_SetDeviceInfo')
	delete from GXDBVersions where aliasname = 'MDM_SetDeviceInfo'
GO

insert into GXDBVersions values(2, 'MDM_SetDeviceInfo',  '00010008004000010000', 'MDM_SetDeviceInfo', '00010008004000010000')
GO

