

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MDM_SetActionsPerformed.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MDM_SetActionsPerformed.sp,v $ $Id: MDM_SetActionsPerformed.sp,v 1.3.48.1 2017/02/10 20:21:34 sjohnson Exp $";
-- =============================================
-- Author:		Apoorv Arora
-- Create date: 10/09/2013
-- Description:	setting action History
-- =============================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MDM_SetActionsPerformed <<<'

IF EXISTS (select * from sysobjects where name='MDM_SetActionsPerformed')
	drop procedure MDM_SetActionsPerformed
IF EXISTS (select * from GxQscripts where name='MDM_SetActionsPerformed')
	delete from GxQscripts where name = 'MDM_SetActionsPerformed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_SetActionsPerformed')
	delete from GXDBVersions where aliasname = 'MDM_SetActionsPerformed'
GO
print '... Creating Procedure: MDM_SetActionsPerformed'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MDM_SetActionsPerformed
  @in_Xml XML,
  @out_Xml XML OUTPUT
AS
DECLARE @errorCode INT
DECLARE @errorMessage VARCHAR(MAX)
DECLARE @operationType  INT
DECLARE @actionId INT
DECLARE @errorXML XML
DECLARE @actions XML
DECLARE @attributes XML
DECLARE @nowTime INT
DECLARE @deviceId INT
SET @errorCode = 0
SET @errorMessage = ''
DECLARE @devActionTbl TABLE
(
 id INT,
 userId INT,
 deviceId INT,
 action   INT,
 status   INT,
 actionTime int,
 additionalInfo nvarchar(max)
)
BEGIN TRY
BEGIN TRAN
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
SET @operationType  = ISNULL((select ref.value('@operationType', 'int')
					FROM    @in_Xml.nodes('MDM_SetActionsRequest') R ( ref )),0)
INSERT INTO @devActionTbl (id,deviceId,userId,action,actionTime,status,additionalInfo)
	VALUES( ISNULL((SELECT  ref.value('@actionId', 'int')
						  FROM    @in_Xml.nodes('/MDM_SetActionsRequest/actions') R ( ref )),0),
			ISNULL((SELECT  ref.value('@deviceId', 'int')
						FROM @in_Xml.nodes('/MDM_SetActionsRequest/actions/deviceAssoc/device') R(ref)),0),
			ISNULL((SELECT  ref.value('@userId', 'int')
                         FROM    @in_Xml.nodes('/MDM_SetActionsRequest/actions/deviceAssoc/mdmUser/user') R ( ref )),0),
			 ISNULL((SELECT  ref.value('@mdmActionType', 'int')
                        FROM    @in_Xml.nodes('/MDM_SetActionsRequest/actions/action') R ( ref )),0),
			   ISNULL((SELECT  ref.value('@actionTime', 'int')
						 FROM    @in_Xml.nodes('/MDM_SetActionsRequest/actions') R ( ref )),0),
	           ISNULL((SELECT  ref.value('@status', 'int')
						  FROM    @in_Xml.nodes('/MDM_SetActionsRequest/actions') R ( ref )),0),
				ISNULL(CONVERT(NVARCHAR(MAX),@in_Xml.query('/MDM_SetActionsRequest/actions/action/additionalAttributes'),1),'')
              )
IF @operationType=2
BEGIN
INSERT INTO MDM_ActionHistory
SELECT userId,deviceId,action,actionTime,status,additionalInfo from @devActionTbl
Set @actionID=@@IDENTITY
SET @actions =        (SELECT				ActionTbl.id as '@actionId',
                                            ActionTbl.actionTime as '@actionTime',
                                              ActionTbl.status as '@status',
                                              (SELECT ActionTbl.actionType as '@mdmActionType'
                                                         for XML PATH('action'),TYPE),
                                              (Select(select (select ActionTbl.userId as '@userId'
													           for xml path('user'),TYPE)
												  for xml path ('mdmUser'),TYPE),
												  (select ActionTbl.deviceId as '@deviceId'
												  for xml path ('device'),TYPE)
												   for XML PATH ('device'),TYPE)
									 FROM MDM_ActionHistory as ActionTbl where ActionTbl.id=@actionID
									 for xml Path('actions'),TYPE)
END
ELSE IF @operationType=1
BEGIN
update MDM_DeviceProp set modified=@nowTime where attrName in ('proxRadius','proxLatitude','proxLongitude','proxEnabled')
and componentNameId in ( select deviceID from @devActionTbl where status=1 and id in (select id from MDM_ActionHistory where actionType=19))
select @deviceId=deviceId from @devActionTbl
SELECT @attributes=additionalInfo from MDM_ActionHistory where id =(select top 1 id from @devActionTbl)
INSERT INTO MDM_DeviceProp(componentNameId , attrName , attrType , attrVal , created , modified)
  (SELECT		@deviceId,
                ref.value('@name', 'nvarchar(512)') ,
				ref.value('@valueType', 'int') ,
				ref.value('@value', 'nvarchar(MAX)'),
				@nowTime,
				0
        FROM    @attributes.nodes('additionalAttributes') R(ref))
UPDATE oldHistory
SET oldHistory.status= newHistory.status
from MDM_ActionHistory oldHistory JOIN
@devActionTbl newHistory
on oldHistory.id=newHistory.id
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
 SET @errorCode = @@ERROR
 SET @errorMessage = (SELECT ERROR_MESSAGE())
 GOTO EXIT_ERROR
END CATCH
EXIT_ERROR:
IF @errorCode<>0
   ROLLBACK TRAN
ELSE
   COMMIT TRAN
SET @out_Xml = (select (select @errorCode as '@errorCode',
							@errorMessage as '@errorString'
					for xml path('error'),TYPE),@actions
  for xml path ('MDM_SetActionsResponse'),type)
Select @out_Xml

IF EXISTS (select * from GxQscripts where name = 'MDM_SetActionsPerformed')
	delete from GxQscripts where name = 'MDM_SetActionsPerformed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_SetActionsPerformed')
	delete from GXDBVersions where aliasname = 'MDM_SetActionsPerformed'
GO

insert into GXDBVersions values(2, 'MDM_SetActionsPerformed',  '00010003004800010000', 'MDM_SetActionsPerformed', '00010003004800010000')
GO

