

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MDM_GetPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MDM_GetPolicy.sp,v $ $Id: MDM_GetPolicy.sp,v 1.5.42.1 2017/02/10 20:21:34 sjohnson Exp $";
-- ======================================================================
-- Author:		Puneet Chadha
-- Create date: 10/09/2013
-- Description:	Insert policy info
-- ======================================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MDM_GetPolicy <<<'

IF EXISTS (select * from sysobjects where name='MDM_GetPolicy')
	drop procedure MDM_GetPolicy
IF EXISTS (select * from GxQscripts where name='MDM_GetPolicy')
	delete from GxQscripts where name = 'MDM_GetPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_GetPolicy')
	delete from GXDBVersions where aliasname = 'MDM_GetPolicy'
GO
print '... Creating Procedure: MDM_GetPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MDM_GetPolicy
  @in_Xml XML,
  @out_Xml XML OUTPUT
AS
DECLARE @mdmDeviceXML XML
DECLARE @nowTime INT
DECLARE @errorXML XML
DECLARE @listlevel int
DECLARE @errorCode INT=0
DECLARE @errorMessage NVARCHAR(MAX)=''
DECLARE @policyId INT
DECLARE @userCapsAtCommcell BIGINT=0
DECLARE @userId INT
BEGIN TRY
SET @userId  = ISNULL (( SELECT ref.value('@userId', 'INT')
                                FROM @in_Xml.nodes ('MDM_GetPolicyRequest/processinginstructioninfo/user') R(ref)), 0)
IF object_id('tempdb.dbo.#tempLaptopSecurityObjects') IS NOT Null DROP TABLE #tempLaptopSecurityObjects
	--create table #tempLaptopSecurityObjects ( [capabilities] bigint NOT null, [flag] int NOT null default 0, [commCellId] int NOT null, [clientGroupId] int NOT null, [clientId] int NOT null, [appTypeId] int NOT null, [instanceId] int NOT null, [backupsetId] int NOT null, [subClientId] int NOT null, [mediaAgentId] int NOT null, [libraryId] int NOT null, [archGroupId] int NOT null, [vtContainerId] int NOT null, [vtPolicyId] int NOT null, [vtShelfId] int NOT null, [reviewSetId] int NOT null default 0, [querySetId] int NOT null default 0, [downloadSetId] int NOT null default 0, [ermId] int NOT null default 0, [legalHoldId] int NOT null default 0, [tagId] int NOT null default 0, [cdPolicyId] int NOT null default 0, [complianceReportId] int NOT null default 0, [taskId] int NOT null default 0)
create table  #tempLaptopSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null, [clientGroupId] int	NOT null, [clientId]      int	NOT null, [appTypeId]     int	NOT null, [instanceId]    int	NOT null, [backupsetId]   int	NOT null, [subClientId]   int	NOT null, [mediaAgentId]  int	NOT null, [libraryId]     int	NOT null, [archGroupId]   int	NOT null, [vtContainerId] int	NOT null, [vtPolicyId]    int	NOT null, [vtShelfId]     int	NOT null, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#tempLaptopSecurityObjects'
	SELECT @userCapsAtCommcell = @userCapsAtCommcell | sec.capabilities
		FROM #tempLaptopSecurityObjects sec
		WHERE		commCellId <> 0
					AND clientGroupId = 0 AND clientId = 0 AND appTypeId = 0
					AND instanceId = 0 AND backupsetId = 0 AND subClientId = 0
					AND mediaAgentId = 0 AND libraryId = 0 AND archGroupId = 0
					AND vtPolicyId = 0 AND vtcontainerId = 0 AND vtShelfId = 0
					AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0
					AND tagId = 0 AND legalHoldId = 0 AND ermId = 0
					AND cdPolicyId = 0 AND complianceReportId = 0 AND taskId = 0
					AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0
					AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0
					AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
					AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
IF @userCapsAtCommcell & CAST(POWER(2.0, 1 - 1) AS bigint) = 0
	 BEGIN
	  SET @errorCode=-1
	  SET @errorMessage='User does not have permission'
	  GOTO EXIT_ERROR
	 END
SET @listlevel =    ISNULL((SELECT  ref.value('@levels', 'int')
                         FROM    @in_Xml.nodes('MDM_GetPolicyRequest') R ( ref )),0)
SET @policyId = ISNULL((SELECT  ref.value('@id', 'int')
                         FROM    @in_Xml.nodes('MDM_GetPolicyRequest/policyEntity') R ( ref )),0)
IF @listlevel = 1
SET @policyId = ISNULL((SELECT  ref.value('@id', 'int')
                         FROM    @in_Xml.nodes('MDM_GetPolicyRequest/policyEntity') R ( ref )),0)
IF @listlevel = 1
BEGIN
 SET @mdmDeviceXML =
						             (select id as '@policyId',
						                     name as '@policyName'
						                      from MDM_Policy
						              for xml path ('policies'),TYPE)
END
ELSE IF @listlevel = 10
BEGIN
 SET @mdmDeviceXML =
						             (select id as '@policyId',
						                     name as '@policyName',
						                     refTime as '@created',
						                     modified as '@modified',
											 (select 'deviceCount' as '@name' ,
												   (select count(*) from MDM_DeviceProp where modified=0 and attrName='policyId'
												   and attrVal=policy.id)  as '@value'
													for xml path('attributes'),TYPE)
						                      from MDM_Policy policy
						              for xml path ('policies'),TYPE)
END
ELSE IF @listlevel = 30
BEGIN
 SET @mdmDeviceXML =
						                   (select id as '@policyId',
						                           name as '@policyName',
												   refTime as '@created',
													modified as '@modified',
						                          (select attrName as '@name' ,
												   attrType as '@valueType' ,
												   attrVal  as '@value'
										           from MDM_PolicyProp as prop
													where prop.componentNameId=policy.id and prop.modified=0
													for xml path('attributes'),TYPE),
												  (select device.id as '@deviceId',
														device.name as '@deviceName',
														 (select devprop.attrName as '@name',
														  devprop.attrVal as '@value',
														  devprop.attrType as '@valueType'
														  from MDM_DeviceProp as devprop where devprop.componentNameId=device.id and attrName='gcmId' and devprop.modified=0
														  for XML path('attributes'),TYPE)
														  from APP_Client as device
										          where id in( select componentNameId from MDM_DeviceProp where attrName='policyId'
																and modified=0 and attrVal=@policyId )
												  for xml path ('devices'),TYPE)
												  from MDM_Policy as policy where policy.id =@policyId
						                      for xml path ('policies'),TYPE)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
 SET @errorCode = @@ERROR
 SET @errorMessage = (SELECT ERROR_MESSAGE())
 GOTO EXIT_ERROR
END CATCH
EXIT_ERROR:
SET @errorXML = (select @errorCode as '@errorCode',
							@errorMessage as '@errorString'
					for xml path('error'))
SET @out_Xml = (select @errorXML ,@mdmDeviceXML for xml path ('MDM_GetPolicyResponse'),type)
Select @out_Xml

IF EXISTS (select * from GxQscripts where name = 'MDM_GetPolicy')
	delete from GxQscripts where name = 'MDM_GetPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_GetPolicy')
	delete from GXDBVersions where aliasname = 'MDM_GetPolicy'
GO

insert into GXDBVersions values(2, 'MDM_GetPolicy',  '00010005004200010000', 'MDM_GetPolicy', '00010005004200010000')
GO

