

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MDM_GetDeviceInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MDM_GetDeviceInfo.sp,v $ $Id: MDM_GetDeviceInfo.sp,v 1.9.40.1 2017/02/10 20:21:34 sjohnson Exp $";
-- =============================================
-- Author:		Apoorv Arora
-- Create date: 10/09/2013
-- Description:	Fetching device details
-- =============================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MDM_GetDeviceInfo <<<'

IF EXISTS (select * from sysobjects where name='MDM_GetDeviceInfo')
	drop procedure MDM_GetDeviceInfo
IF EXISTS (select * from GxQscripts where name='MDM_GetDeviceInfo')
	delete from GxQscripts where name = 'MDM_GetDeviceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_GetDeviceInfo')
	delete from GXDBVersions where aliasname = 'MDM_GetDeviceInfo'
GO
print '... Creating Procedure: MDM_GetDeviceInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MDM_GetDeviceInfo
  @in_Xml XML,
  @out_Xml XML OUTPUT
AS
DECLARE @mdmDeviceXML XML
DECLARE @unregDeviceXML XML
DECLARE @nowTime INT
DECLARE @errorXML XML
DECLARE @listlevel int
DECLARE @attributedFlags INT
DECLARE @errorCode INT=0
DECLARE @errorMessage NVARCHAR(MAX)=''
DECLARE @userId int
DECLARE @policyId INT
DECLARE @userCapsAtCommcell BIGINT=0
DECLARE @isAdmin INT =0
declare @deviceIdTbl table
(
userID int,
deviceID int,
deviceName nvarchar(512)
)
BEGIN TRY
SET @userId =    ISNULL((SELECT  ref.value('@userId', 'int')
                         FROM    @in_Xml.nodes('MDM_GetDevicesListRequest/users/mdmUser/user') R ( ref )),1)
SET @policyId =    ISNULL((SELECT  ref.value('@policyId', 'int')
                         FROM    @in_Xml.nodes('MDM_GetDevicesListRequest/users/policy') R ( ref )),0)
SET @listlevel =    ISNULL((SELECT  ref.value('@levels', 'int')
                         FROM    @in_Xml.nodes('MDM_GetDevicesListRequest') R ( ref )),0)
SET @attributedFlags =    ISNULL((SELECT  ref.value('@attributesFlags', 'int')
                         FROM    @in_Xml.nodes('MDM_GetDevicesListRequest') R ( ref )),~0)
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
--userId needs to be changed
--USER SECURITY CHECK--
IF object_id('tempdb.dbo.#tempLaptopSecurityObjects') IS NOT Null DROP TABLE #tempLaptopSecurityObjects
	--create table #tempLaptopSecurityObjects ( [capabilities] bigint NOT null, [flag] int NOT null default 0, [commCellId] int NOT null, [clientGroupId] int NOT null, [clientId] int NOT null, [appTypeId] int NOT null, [instanceId] int NOT null, [backupsetId] int NOT null, [subClientId] int NOT null, [mediaAgentId] int NOT null, [libraryId] int NOT null, [archGroupId] int NOT null, [vtContainerId] int NOT null, [vtPolicyId] int NOT null, [vtShelfId] int NOT null, [reviewSetId] int NOT null default 0, [querySetId] int NOT null default 0, [downloadSetId] int NOT null default 0, [ermId] int NOT null default 0, [legalHoldId] int NOT null default 0, [tagId] int NOT null default 0, [cdPolicyId] int NOT null default 0, [complianceReportId] int NOT null default 0, [taskId] int NOT null default 0)
create table  #tempLaptopSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null, [clientGroupId] int	NOT null, [clientId]      int	NOT null, [appTypeId]     int	NOT null, [instanceId]    int	NOT null, [backupsetId]   int	NOT null, [subClientId]   int	NOT null, [mediaAgentId]  int	NOT null, [libraryId]     int	NOT null, [archGroupId]   int	NOT null, [vtContainerId] int	NOT null, [vtPolicyId]    int	NOT null, [vtShelfId]     int	NOT null, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#tempLaptopSecurityObjects'
	SELECT @userCapsAtCommcell = @userCapsAtCommcell | sec.capabilities
		FROM #tempLaptopSecurityObjects sec
		WHERE		commCellId <> 0
					AND clientGroupId = 0 AND clientId = 0 AND appTypeId = 0
					AND instanceId = 0 AND backupsetId = 0 AND subClientId = 0
					AND mediaAgentId = 0 AND libraryId = 0 AND archGroupId = 0
					AND vtPolicyId = 0 AND vtcontainerId = 0 AND vtShelfId = 0
					AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0
					AND tagId = 0 AND legalHoldId = 0 AND ermId = 0
					AND cdPolicyId = 0 AND complianceReportId = 0 AND taskId = 0
					AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0
					AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0
					AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
					AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
IF (@listlevel = 1 OR @listlevel=10)
BEGIN
IF @userCapsAtCommcell & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0
	 BEGIN
	  SET @isAdmin=1
	  Insert into @deviceIdTbl select userId,id,name from APP_Client Client JOIN UMOwnerCredentials Owner on Client.id=Owner.clientId where status & 0x40000000 =0x40000000
	 END
	ELSE
	 BEGIN
	   Insert into @deviceIdTbl select userId,id,name from APP_Client Client JOIN UMOwnerCredentials Owner on Client.id=Owner.clientId where status & 0x40000000 =0x40000000 and userId=@userId
	 END
if @policyId<>0
BEGIN
	delete  @deviceIdTbl where
	 deviceId not in (Select componentnameid from MDM_DeviceProp where attrName='policyId' and attrVal=@policyId and modified=0)
END
 SET @mdmDeviceXML =    ( select   (select (select usersTbl.id as '@userId',
                                                          usersTbl.login as '@userName'
                                                          from UMUsers as usersTbl where id=devId.userId
						                   for xml path('user'),TYPE)
						              for xml path ('mdmUser'),TYPE),
						              (select deviceId as '@deviceId',
						                     deviceName as '@deviceName',
						                     (select  attrVal  from  MDM_DeviceProp where componentNameId=devId.deviceID
						                       and modified=0 and attrName='lastUpdated')as '@updated',
						                         (select attrName as '@name' ,
												attrType as '@valueType' ,
												attrVal  as '@value'
										  from MDM_DeviceProp as prop
										  where prop.componentNameId=devID.deviceID and modified=0 and attrName in('gcmId','phoneNo','App_Installed_count','deviceType','licenseToken','deviceAdminEnabled')
										  for xml path('attributes'),TYPE)
										   for xml path ('device'),TYPE),
										  (select poltbl.id  as '@policyId',
											 poltbl.name as '@policyName',
											 (select attrName as '@name' ,
												attrType as '@valueType' ,
												@nowTime-(5*attrVal)  as '@value'
										  from MDM_PolicyProp as polProp
										  where polProp.componentNameId=poltbl.id and modified=0 and attrName in('synctime')
										  for xml path('attributes'),TYPE)
										  from MDM_DeviceProp as prop JOIN MDM_Policy as poltbl on prop.attrVal=poltbl.id
										  where prop.componentNameId=devID.deviceID and prop.modified=0 and
										  prop.attrName ='policyId'
										   FOR XML Path('policy'),TYPE)
						              from @deviceIdTbl as devId
						          for xml path('devices'),TYPE)
DELETE FROM MDM_deviceRegistrationInfo where @nowTime > created+1800
if(@isAdmin=1)
BEGIN
if (@policyId<>0)
BEGIN
SET @unregDeviceXML = ( select   (select (select usersTbl.id as '@userId',
                                                          usersTbl.login as '@userName'
                                                          from UMUsers as usersTbl where id=regInfo.userId
						                   for xml path('user'),TYPE)
						              for xml path ('mdmUser'),TYPE),
						              (select 0 as '@deviceId',
						                     'NoDeviceName' as '@deviceName',
						                      regInfo.created as '@updated'
										   for xml path ('device'),TYPE),
										  (select regInfo.policyId  as '@policyId',
											        pol.name as '@policyName'
										  from MDM_Policy as pol
										  where pol.id=regInfo.policyId
										   FOR XML Path('policy'),TYPE)
						              from MDM_DeviceRegistrationInfo as regInfo where policyId=@policyId
						          for xml path('devices'),TYPE)
END
else
BEGIN
SET @unregDeviceXML = ( select   (select (select usersTbl.id as '@userId',
                                                          usersTbl.login as '@userName'
                                                          from UMUsers as usersTbl where id=regInfo.userId
						                   for xml path('user'),TYPE)
						              for xml path ('mdmUser'),TYPE),
						              (select 0 as '@deviceId',
						                     'NoDeviceName' as '@deviceName',
						                      regInfo.created as '@updated'
										   for xml path ('device'),TYPE),
										  (select regInfo.policyId  as '@policyId',
											        pol.name as '@policyName'
										  from MDM_Policy as pol
										  where pol.id=regInfo.policyId
										  FOR XML Path('policy'),TYPE)
						              from MDM_DeviceRegistrationInfo as regInfo
						          for xml path('devices'),TYPE)
END
END
END
ELSE IF (@listlevel=30)
BEGIN
INSERT INTO @deviceIdTbl (userID,deviceId,deviceName)
	                        (SELECT @userId,
								ref.value('@deviceId', 'int') ,
								ref.value('@deviceName', 'nvarchar(512)')
								FROM    @in_Xml.nodes('MDM_GetDevicesListRequest/users/device') R(ref))
Update @deviceIdTbl set deviceName= (select name from APP_Client where id=deviceID)
 SET @mdmDeviceXML =  (select (select ( select usersTbl.id as '@userId',
                                                          usersTbl.login as '@userName'
                                                          from UMUsers as usersTbl where id=devId.userId
						                   for xml path('user'),TYPE)
						                    for xml path ('mdmUser'),TYPE),
						                   (select deviceID as '@deviceId',
						                           deviceName as '@deviceName',
						                           (select attrName as '@name' ,
															attrType as '@valueType' ,
															attrVal  as '@value'
													  from MDM_DeviceProp as prop
													  where prop.componentNameId=devID.deviceID and modified=0 and prop.attrName!='applications'
													  for xml path('attributes'),TYPE)
						                      for xml path ('device'),TYPE)
										  from @deviceIdTbl as devID
						          for xml path('devices'),TYPE)
END
ELSE IF (@listlevel=20)
BEGIN
INSERT INTO @deviceIdTbl (userID,deviceId,deviceName)
	                        (SELECT @userId,
								ref.value('@deviceId', 'int') ,
								ref.value('@deviceName', 'nvarchar(512)')
								FROM    @in_Xml.nodes('MDM_GetDevicesListRequest/users/device') R(ref))
Update @deviceIdTbl set deviceName= (select name from APP_Client where id=deviceID)
 SET @mdmDeviceXML =  (select (select ( select usersTbl.id as '@userId',
                                                          usersTbl.login as '@userName'
                                                          from UMUsers as usersTbl where id=devId.userId
						                   for xml path('user'),TYPE)
						                    for xml path ('mdmUser'),TYPE),
						                   (select deviceID as '@deviceId',
						                           deviceName as '@deviceName',
												   (select (CAST (attrval AS XML)) from MDM_DeviceProp as prop where prop.componentNameId=devID.deviceID and
																prop.attrName='applications' and modified=0 and (prop.attrType & @attributedFlags)!=0
												for XML path (''),TYPE),
												(select (CAST (attrval AS XML)) from MDM_DeviceProp as prop where prop.componentNameId=devID.deviceID and
																prop.attrName='RunningServices' and modified=0 and (prop.attrType & @attributedFlags)!=0
												for XML path (''),TYPE)
						                      for xml path ('device'),TYPE)
										  from @deviceIdTbl as devID
						          for xml path('devices'),TYPE)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
 SET @errorCode = @@ERROR
 SET @errorMessage = (SELECT ERROR_MESSAGE())
 GOTO EXIT_ERROR
END CATCH
EXIT_ERROR:
SET @errorXML = (select @errorCode as '@errorCode',
							@errorMessage as '@errorString'
					for xml path('error'))
SET @out_Xml = (select @errorXML ,@mdmDeviceXML,@unregDeviceXML for xml path ('MDM_GetDevicesListResponse'),type)
Select @out_Xml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MDM_GetDeviceInfo')
	delete from GxQscripts where name = 'MDM_GetDeviceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_GetDeviceInfo')
	delete from GXDBVersions where aliasname = 'MDM_GetDeviceInfo'
GO

insert into GXDBVersions values(2, 'MDM_GetDeviceInfo',  '00010009004000010000', 'MDM_GetDeviceInfo', '00010009004000010000')
GO

