

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MDM_GetActionsPerformed.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MDM_GetActionsPerformed.sp,v $ $Id: MDM_GetActionsPerformed.sp,v 1.3.48.1 2017/02/10 20:21:34 sjohnson Exp $";
-- =============================================
-- Author:		Puneet Chadha
-- Create date: 8/5/2014
-- Description:	Fetching device action history
-- =============================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MDM_GetActionsPerformed <<<'

IF EXISTS (select * from sysobjects where name='MDM_GetActionsPerformed')
	drop procedure MDM_GetActionsPerformed
IF EXISTS (select * from GxQscripts where name='MDM_GetActionsPerformed')
	delete from GxQscripts where name = 'MDM_GetActionsPerformed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_GetActionsPerformed')
	delete from GXDBVersions where aliasname = 'MDM_GetActionsPerformed'
GO
print '... Creating Procedure: MDM_GetActionsPerformed'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MDM_GetActionsPerformed
  @in_Xml XML,
  @out_Xml XML OUTPUT
AS
DECLARE @errorCode INT
DECLARE @errorMessage VARCHAR(MAX)
Declare @actions XML
Declare @errorXml XML
SET @errorCode = 0
SET @errorMessage = ''
DECLARE @deviceIdTbl TABLE
(
deviceID int
)
declare @xmlText XML
	SET @xmlText = @in_xml
BEGIN TRY
	INSERT INTO @deviceIdTbl
	      SELECT ISNULL(@xmlText.value('(/MDM_GetActionsRequest/devices/@deviceId)[1]', 'int'), 0)
	DELETE devTbl FROM @deviceIdTbl devTbl where NOT EXISTS (Select * from MDM_ActionHistory as actTbl where actTbl.deviceId=devTbl.deviceId)
    IF NOT EXISTS (SELECT * FROM @deviceIdTbl)
		BEGIN
			SET @errorCode = 1
			SET @errorMessage = 'No Actions found'
			GOTO EXIT_ERROR
         END
	SET @actions =        (SELECT
                                            ActionTbl.actionTime as '@actionTime',
                                              ActionTbl.status as '@status',
                                              (SELECT ActionTbl.actionType as '@mdmActionType'
                                                         for XML PATH('action'),TYPE),
                                              (Select(select (select ActionTbl.userId as '@userId'
													           for xml path('user'),TYPE)
												  for xml path ('mdmUser'),TYPE),
												  (select ActionTbl.deviceId as '@deviceId'
												  for xml path ('device'),TYPE)
												   for XML PATH ('device'),TYPE)
									 FROM MDM_ActionHistory as ActionTbl,@deviceIdTbl as devTbl where ActionTbl.deviceId = devTbl.deviceId order by ActionTbl.actionTime desc
									 for xml Path('actions'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
 SET @errorCode = @@ERROR
 SET @errorMessage = (SELECT ERROR_MESSAGE())
 GOTO EXIT_ERROR
END CATCH
EXIT_ERROR:
SET @errorXML = (select @errorCode as '@errorCode',
							@errorMessage as '@errorString'
					for xml path('error'))
SET @out_Xml = (select @errorXML ,@actions for xml path ('MDM_GetActionsResponse'),type)
Select @out_Xml
IF EXISTS (select * from GxQscripts where name = 'MDM_GetActionsPerformed')
	delete from GxQscripts where name = 'MDM_GetActionsPerformed'

IF EXISTS (select * from GxQscripts where name = 'MDM_GetActionsPerformed')
	delete from GxQscripts where name = 'MDM_GetActionsPerformed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MDM_GetActionsPerformed')
	delete from GXDBVersions where aliasname = 'MDM_GetActionsPerformed'
GO

insert into GXDBVersions values(2, 'MDM_GetActionsPerformed',  '00010003004800010000', 'MDM_GetActionsPerformed', '00010003004800010000')
GO

