

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_UpdateWebPackageAvailability.sp] ---------- 

--  +==============================================================================================================
--  | Stored Procedure: This stored procedure will be called by webconsole after the web.see package is pulled
--  |					from Service commcell webserver
--  |
--  |					returns GenericResponse
--  +==============================================================================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MCC_UpdateWebPackageAvailability')
BEGIN
	print '>>> Drop Stored Procedure: MCC_UpdateWebPackageAvailability <<<'
	drop procedure MCC_UpdateWebPackageAvailability
END
IF EXISTS (select * from GxQscripts where name='MCC_UpdateWebPackageAvailability')
	delete from GxQscripts where name = 'MCC_UpdateWebPackageAvailability'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_UpdateWebPackageAvailability')
	delete from GXDBVersions where aliasname = 'MCC_UpdateWebPackageAvailability'
GO
print '... Creating Procedure: MCC_UpdateWebPackageAvailability'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_UpdateWebPackageAvailability
  @inputXml XML
AS
    SET NOCOUNT ON
	DECLARE @errorCode int = 0
	DECLARE @errorMsg NVARCHAR(510)
BEGIN TRY
	DECLARE @attrWebPackageClientInfo NVARCHAR(30) = N'WebPackageClientInfo'
	DECLARE @webconsoleId INT
	DECLARE @servicecommcellid INT
	DECLARE @SPVersionInfoText NVARCHAR(510)
	DECLARE @adminConsolePackagePath NVARCHAR(510)
	DECLARE @webConsolePackagePath NVARCHAR(510)
	DECLARE @pInfo INT
	SELECT
		@webconsoleId = ref.value('(webconsole/@clientId)[1]', 'INT'),
		@servicecommcellid = ref.value('(webPackageAvailableClientInfo/serviceCommcellClient/@clientId)[1]', 'INT'),
		@adminConsolePackagePath = ref.value('(webPackageAvailableClientInfo/@adminconsolePackagePath)[1]','nvarchar(510)'),
		@webConsolePackagePath = ref.value('(webPackageAvailableClientInfo/@webconsolePackagePath)[1]','nvarchar(510)'),
		@pInfo  = ref.value('(webPackageAvailableClientInfo/@pInfo)[1]','INT'),
		@SPVersionInfoText = ref.value('@spVersionInfoText','nvarchar(510)')
	FROM @inputXml.nodes('App_UpdateWebPackageAvailability') R ( ref )
	-- webPackageClientInfo cross applied result
	IF OBJECT_ID('tempdb.dbo.#webPackageClientInfo') is not null
		DROP TABLE #webPackageClientInfo
	CREATE TABLE #webPackageClientInfo (webconsoleId INT,serviceCommcellClientId INT,adminConsolePackagePath nvarchar(255),webconsolePackagePath nvarchar(510), pInfo int, fwStatus int, packageStatus int, status int )
	IF OBJECT_ID('tempdb.dbo.#webConsoleTbl') is not null
		DROP TABLE #webConsoleTbl
	CREATE TABLE #webConsoleTbl (clientId int, webPackageClientInfo XML DEFAULT(NULL))
	IF NOT EXISTS(SELECT 1 from App_ClientProp (nolock) where componentNameId = @servicecommcellid AND attrName='ServiceCommcell SPVersionInfoText' and attrVal = @SPVersionInfoText)
	BEGIN
		;THROW 51000, N'Failed to located the service commcell with specified SPVersionInfoText', 2
	END
	INSERT INTO #webConsoleTbl values(@webconsoleId,
							      CAST((SELECT TOP 1 attrVal from APP_ExtendedProperties ECP WITH(NOLOCK) where ECP.clientId = @webconsoleId and ECP.attrName = @attrWebPackageClientInfo and ECP.modified = 0) AS XML))
	INSERT INTO #webPackageClientInfo
	SELECT
		clientId,
		t.ref.query('.').value('(webPackageAvailableClients/serviceCommcellClient/@clientId)[1]','INT'),
		t.ref.query('.').value('(webPackageAvailableClients/@adminconsolePackagePath)[1]','nvarchar(255)'),
		t.ref.query('.').value('(webPackageAvailableClients/@webconsolePackagePath)[1]','nvarchar(510)'),
		t.ref.query('.').value('(webPackageAvailableClients/@pInfo)[1]','INT'),
		t.ref.query('.').value('(webPackageAvailableClients/@fwStatus)[1]','INT'),
		t.ref.query('.').value('(webPackageAvailableClients/@packageStatus)[1]','INT'),
		t.ref.query('.').value('(webPackageAvailableClients/@status)[1]','INT')
		from #webConsoleTbl
	OUTER APPLY
	webPackageClientInfo.nodes('./App_WebPackageAvailableClientInfoList/webPackageAvailableClients') as t(ref)
	-- update latest package status across service commcells
    IF EXISTS(SELECT 1 FROM #webPackageClientInfo WHERE serviceCommcellClientId = @servicecommcellid AND pInfo  & 8 > 0) --WQWebConsoleOpType::PULLPACKAGE = 8
	BEGIN
		UPDATE #webPackageClientInfo SET packageStatus = IIF(@pInfo & 8 > 0, 4,3) WHERE adminConsolePackagePath = @adminConsolePackagePath  and webconsolePackagePath = @webConsolePackagePath
	END
	-- update fwstatus and pInfo WQWebConsoleOpType::CONFIGUREFIREWALL = 2
	UPDATE #webPackageClientInfo set pInfo = @pInfo,fwStatus = IIF(pInfo  & 2 > 0 , IIF(@pInfo & 2 > 0, 4/**FAILED**/,3/**COMPLETE**/) , fwstatus) WHERE serviceCommcellClientId = @servicecommcellid
	--if both firewall and packages are available mark them ready so that they can be notified to webconsole.if both are failed, mark them failed.
	UPDATE #webPackageClientInfo SET status = packageStatus
	WHERE adminConsolePackagePath = @adminConsolePackagePath  AND webconsolePackagePath = @webConsolePackagePath AND
	((packageStatus=fwStatus AND  packageStatus=3) OR (packageStatus=fwStatus AND  packageStatus=4))
	-- updating the status
		UPDATE ECP SET ECP.attrVal = CONVERT(NVARCHAR(MAX),tmp.xmlVal )
		FROM
		APP_ExtendedProperties ECP
		INNER JOIN
		(SELECT
			(SELECT
				(SELECT
					WP.adminConsolePackagePath '@adminconsolePackagePath',
					WP.webconsolePackagePath '@webconsolePackagePath',
					WP.packageStatus '@packageStatus',
					WP.fwStatus '@fwStatus',
					WP.pInfo '@pInfo',
					WP.status '@status',
					(SELECT serviceCommcellClientId '@clientId' FOR XML PATH('serviceCommcellClient'),TYPE)
					FROM #webPackageClientInfo WP WHERE WP.webconsoleId = WIP.clientId
				FOR XML PATH('webPackageAvailableClients'),TYPE)
			FOR XML PATH('App_WebPackageAvailableClientInfoList'),TYPE) as xmlVal,
			WIP.clientId
		FROM #webConsoleTbl WIP) tmp
		ON ECP.ClientId = tmp.clientId AND ECP.attrName = @attrWebPackageClientInfo AND ECP.modified=0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMsg ='Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END  CATCH
	SELECT  @errorCode as '@errorCode',
			@errorMsg as  '@errorMessage'
	FOR  XML PATH('App_GenericResp'),TYPE
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_UpdateWebPackageAvailability')
	delete from GxQscripts where name = 'MCC_UpdateWebPackageAvailability'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_UpdateWebPackageAvailability')
	delete from GXDBVersions where aliasname = 'MCC_UpdateWebPackageAvailability'
GO

insert into GXDBVersions values(2, 'MCC_UpdateWebPackageAvailability',  '00000000000000000000', 'MCC_UpdateWebPackageAvailability', '00000000000000000000')
GO

