

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_UpdateServiceCommcellProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |           Procedure : "MCC_UpdateServiceCommcellProperties"
--  |   This Procedure is used to set subscribed cloud service details
--  |   on local CS.
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_UpdateServiceCommcellProperties')
BEGIN
	print '>>> Drop Stored Procedure: MCC_UpdateServiceCommcellProperties <<<'
	drop procedure MCC_UpdateServiceCommcellProperties
END
IF EXISTS (select * from GxQscripts where name='MCC_UpdateServiceCommcellProperties')
	delete from GxQscripts where name = 'MCC_UpdateServiceCommcellProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_UpdateServiceCommcellProperties')
	delete from GXDBVersions where aliasname = 'MCC_UpdateServiceCommcellProperties'
GO
print '... Creating Procedure: MCC_UpdateServiceCommcellProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_UpdateServiceCommcellProperties
  @reqXml XML,
  @userId INT 
AS
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(MAX) = ''
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @redirectUrl nvarchar(MAX)
DECLARE @commcellId INT
DECLARE @commcellGUID nvarchar(MAX)
DECLARE @commcellType INT = 0
DECLARE @commcellClientId INT
BEGIN TRANSACTION
	BEGIN TRY
		DECLARE @canManageCommserver INT = 0
EXEC sec_checkPermissionOnEntity @userId, 1, @canManageCommserver OUTPUT, 1, 2
		IF (@canManageCommserver <> 1)
		BEGIN
			SET @errorCode  = 1
			SET @errorString = 'User does not have permission.'
            GOTO SEND_RESPONSE
		END
		SET @redirectUrl = (SELECT
			ref.value('@webconsoleUrl', 'nvarchar(MAX)')
		FROM    @reqXml.nodes('App_UpdateServiceCommcellPropertiesReq/properties') R ( ref ))
		SET @commcellId = (SELECT
			ISNULL(ref.value('@commCellId', 'nvarchar(MAX)'), '')
		FROM    @reqXml.nodes('App_UpdateServiceCommcellPropertiesReq/properties') R ( ref ))
		Select top 1 @commcellGUID = csguid, @commcellClientId=clientId from app_commcell where id = @commcellId
		SET @commcellType = (Select commcellType from App_CommcellProp where commCellId = @commCellId)
IF (@commcellType & 8= 8
OR @commcellType & 2= 2)
		BEGIN
			IF @redirectUrl IS NOT NULL
			UPDATE App_ThirdPartyApp
						SET props.modify('replace value of (/props/nameValues[@name="RedirectUrl"]/@value)[1] with (sql:variable("@redirectUrl"))')
						WHERE appName = @commcellGUID
		END
IF(@commcellType & 16= 16)
		BEGIN
			IF @redirectUrl IS NOT NULL
Update APP_ClientProp set attrVal = @redirectUrl  where componentNameId = @commcellClientId and attrName = 'Service commcell end point' and modified = 0
		END
	END TRY
	BEGIN CATCH
		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
			PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
			ERROR MESSAGE: ' + ERROR_MESSAGE() + '
			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @errorCode= ERROR_NUMBER()
			SET @errorString = ERROR_MESSAGE()
	END CATCH
SEND_RESPONSE:
	SET @reqXml = (SELECT  @errorCode AS '@errorCode', @errorString AS '@errorString'
                 FOR xml path('App_GenericEntityResponse'), TYPE)
IF(@errorCode<>0)
BEGIN
	ROLLBACK TRANSACTION
END
ELSE
BEGIN
	COMMIT TRANSACTION
END
SELECT @reqXml
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_UpdateServiceCommcellProperties')
	delete from GxQscripts where name = 'MCC_UpdateServiceCommcellProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_UpdateServiceCommcellProperties')
	delete from GXDBVersions where aliasname = 'MCC_UpdateServiceCommcellProperties'
GO

insert into GXDBVersions values(2, 'MCC_UpdateServiceCommcellProperties',  '00000000000000000000', 'MCC_UpdateServiceCommcellProperties', '00000000000000000000')
GO

