

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_UnregisterServiceCommcell.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MCC_UnregisterServiceCommcell')
BEGIN
	print '>>> Drop Stored Procedure: MCC_UnregisterServiceCommcell <<<'
	drop procedure MCC_UnregisterServiceCommcell
END
IF EXISTS (select * from GxQscripts where name='MCC_UnregisterServiceCommcell')
	delete from GxQscripts where name = 'MCC_UnregisterServiceCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_UnregisterServiceCommcell')
	delete from GXDBVersions where aliasname = 'MCC_UnregisterServiceCommcell'
GO
print '... Creating Procedure: MCC_UnregisterServiceCommcell'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_UnregisterServiceCommcell
  @commcellGUID nvarchar(255)
AS
BEGIN TRY
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorStr nvarchar(max)=''
DECLARE @errorCode INT = 0
DECLARE @LocalCommcellType INT = 0
DECLARE @serviceCommcellId int = (Select distinct id from App_commcell where csGUID = @commcellGUID and number > 0)
DECLARE @ServiceCommcellType INT = ISNULL((SELECT commcellType from app_commcellprop where CommCellId = @serviceCommcellId),0)
DECLARE @nowTime INT =  dbo.GetUnixTime(GETUTCDATE())
--Delete all the users for this commcell
Delete from UMUsersServiceCommcell where origCCId=@serviceCommcellId
--Delete the flags present for serviceCommcell
DELETE from APP_ComponentProp where componentType=1048 and componentId = @serviceCommcellId and propertyTypeId = 2
IF NOT EXISTS(Select 1 from APP_ComponentProp where componentType=1048 and propertyTypeId = 2)
BEGIN
DELETE from APP_ComponentProp where componentType = 1048 and componentId = 2 and propertyTypeId = 1
END
--Delete all the redirect rules configured for the serviceCommcell
DELETE from APP_ComponentProp where componentType=1047 and componentId = @serviceCommcellId
--Delete all the properties for the serviceCommcell
DELETE from APP_ComponentProp where componentType=1049 and componentId = @serviceCommcellId
IF ((@ServiceCommcellType & 2) = 2)
SET @ServiceCommcellType = @ServiceCommcellType & ~2
ELSE IF ((@ServiceCommcellType & 8) = 8)
SET @ServiceCommcellType = @ServiceCommcellType & ~8
IF @ServiceCommcellType = 0
	Update app_commcellprop set commcellType = @ServiceCommcellType, webendpoints = NULL where CommCellId = @serviceCommcellId
ELSE
	Update app_commcellprop set commcellType = @ServiceCommcellType where CommCellId = @serviceCommcellId
IF EXISTS(SELECT 1 from APP_CommCellProp WHERE (CommcellType & 2 = 2))
SET @LocalCommcellType = @LocalCommcellType | 1
IF EXISTS(SELECT 1 from APP_CommCellProp WHERE (CommcellType & 8 = 8))
SET @LocalCommcellType = @LocalCommcellType | 4
IF EXISTS(SELECT 1 from APP_CommCellProp WHERE (CommcellType & 8 = 8))
SET @LocalCommcellType = @LocalCommcellType | 4
IF EXISTS(SELECT 1 from APP_CommCellProp WHERE (CommcellType & 16 = 16))
SET @LocalCommcellType = @LocalCommcellType | 32
UPDATE APP_CommCellProp Set CommcellType= @LocalCommcellType WHERE CommCellId = 2
-- insert/update GXGlobalParam: nMultiCommcellRole
IF EXISTS (SELECT 1 from GXGlobalParam where name = 'nMultiCommcellRole')
BEGIN
UPDATE GXGlobalParam SET value = @LocalCommcellType WHERE name = 'nMultiCommcellRole'
END
ELSE
BEGIN
	INSERT INTO GXGlobalParam (name, value, created, modified)
VALUES('nMultiCommcellRole', @LocalCommcellType, @nowTime, 0)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @errorCode =  ERROR_NUMBER()
END CATCH
PROC_EXIT:
Select @errorCode as '@errorCode',@errorStr as '@errorMessage' for xml path('App_GenericResp')
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_UnregisterServiceCommcell')
	delete from GxQscripts where name = 'MCC_UnregisterServiceCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_UnregisterServiceCommcell')
	delete from GXDBVersions where aliasname = 'MCC_UnregisterServiceCommcell'
GO

insert into GXDBVersions values(2, 'MCC_UnregisterServiceCommcell',  '00000000000000000000', 'MCC_UnregisterServiceCommcell', '00000000000000000000')
GO

