

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_UnLinkSubscriberCommcellFromCloudService.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |           Procedure : "MCC_UnLinkSubscriberCommcellFromCloudService"
--  |   This Procedure is used to set subscribed cloud service details
--  |   on local CS.
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_UnLinkSubscriberCommcellFromCloudService')
BEGIN
	print '>>> Drop Stored Procedure: MCC_UnLinkSubscriberCommcellFromCloudService <<<'
	drop procedure MCC_UnLinkSubscriberCommcellFromCloudService
END
IF EXISTS (select * from GxQscripts where name='MCC_UnLinkSubscriberCommcellFromCloudService')
	delete from GxQscripts where name = 'MCC_UnLinkSubscriberCommcellFromCloudService'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_UnLinkSubscriberCommcellFromCloudService')
	delete from GXDBVersions where aliasname = 'MCC_UnLinkSubscriberCommcellFromCloudService'
GO
print '... Creating Procedure: MCC_UnLinkSubscriberCommcellFromCloudService'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_UnLinkSubscriberCommcellFromCloudService
  @xmlText XML,
  @i_userId INT,
  @subscriberCommcellGUID nvarchar(max)
AS
  DECLARE @shouldDeleteMulticommcellApp INT = 0 
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(MAX) = ''
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @redirectUrl nvarchar(MAX)
DECLARE @ownerCompany INT = 0
DECLARE @userRole INT = 0
DECLARE @isSubscriberMSP INT = 0
DECLARE @mspSubscriberCompanyGUID nvarchar(max)=''
DECLARE @mspSubscriberCompanyAlias nvarchar(max)
DECLARE @thirdPartyAppId INT = 0
DECLARE @NameValueMapTable TABLE
								(
								appKey         nvarchar(255),
								appType        integer,
								appName        nvarchar(255),
								name           nvarchar(255),
								val            nvarchar(MAX)
								)
BEGIN TRANSACTION
	BEGIN TRY
			SET @mspSubscriberCompanyGUID = (SELECT 	ref.value('@GUID', 'nvarchar(MAX)')
				FROM    @xmlText.nodes('App_CloudServiceUnsubscriptionReq/subscriberCompany') R ( ref ))
			SET @mspSubscriberCompanyAlias = (SELECT 	ref.value('@providerDomainName', 'nvarchar(MAX)')
				FROM    @xmlText.nodes('App_CloudServiceUnsubscriptionReq/subscriberCompany') R ( ref ))
			SET @thirdPartyAppId = (SELECT id from app_thirdpartyapp where appName = @subscriberCommcellGUID)
			SET @ownerCompany = dbo.AppGetOrganizationForUser(@i_userId)
			IF @ownerCompany = 0 OR @ownerCompany IS NULL
			BEGIN
				SET @errorCode  = 1
				SET @errorString = 'User does not have permission'
                		GOTO SEND_RESPONSE
			END
			IF (@mspSubscriberCompanyGUID IS NOT NULL AND @mspSubscriberCompanyGUID <> '')
			BEGIN
				SET @isSubscriberMSP = 1
			END
IF NOT EXISTS(SELECT 1 FROM UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id where UG.groupFlags&0x10000 <> 0 and UU.userId=@i_userId)
AND NOT EXISTS(SELECT 1 FROM UMDSGroupMaps ugm INNER JOIN UMUserGroup uu ON ugm.umDSgroupId = uu.groupId INNER JOIN UMGroups UG ON ug.id=ugm.umgroupId AND UG.groupFlags&0x10000 <> 0 WHERE UU.userId=@i_userId )
			BEGIN
				SET @errorCode  = 1
				SET @errorString = 'User does not have permission'
                		GOTO SEND_RESPONSE
			END
Delete From APP_ComponentProp Where componentType = 1034 and  componentId = @thirdPartyAppId and propertyTypeId = 61 and longlongVal IN (Select id from UMDSProviders where ownerCompany = @ownerCompany) and modified = 0
Delete From APP_ComponentProp Where componentType = 1034 and  componentId = @thirdPartyAppId and propertyTypeId = 61 and longlongVal = @ownerCompany and modified = 0
Delete from App_CompanyProp where componentNameId = @ownerCompany and attrName IN ('Cloud Service Company MSP Subscriber Alias','Cloud Service Company MSP Subscriber Guid')
IF NOT EXISTS(Select top 1 id from APP_ComponentProp Where componentType = 1034 and  componentId = @thirdPartyAppId and propertyTypeId = 61 and modified = 0)
			BEGIN
				SET @shouldDeleteMulticommcellApp = 1
				DECLARE @webDomainsStr NVARCHAR(max) = (SELECT VALUE from GXGlobalParam where name = 'webDomainsWhiteList' and modified = 0)
				IF(@webDomainsStr IS NOT NULL AND @webDomainsStr <> '')
				BEGIN
					-- fetch  webdomains given for third party app only if third party app is for registered on-premise CS
					IF OBJECT_ID('tempdb.dbo.#webdomains') IS NOT NULL DROP TABLE #webdomains
						CREATE TABLE #webdomains( webDomainUrl NVARCHAR(MAX), thirdPartyAppId INT)
					INSERT INTO #webdomains (webDomainUrl, thirdPartyAppId)
					SELECT DBO.GetHostnameFromUrl(TP.PROPS.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(max)')), TP.id FROM App_ComponentProp AC
					INNER JOIN App_thirdPartyApp TP
						ON AC.componentId = TP.id
					WHERE
AC.componentType = 1034 AND AC.propertyTypeId = 5 AND  TP.id = @thirdPartyAppId --this entry is present only for on-premise third party app
					-- if same web domain is used for any other third party app then don't remove it from web domains gxglobalparam
					DELETE WB FROM #webdomains WB INNER JOIN App_ThirdPartyApp TP ON
					TP.id <> WB.thirdPartyAppId AND WB.webDomainUrl = DBO.GetHostnameFromUrl(TP.PROPS.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(max)'))
					IF EXISTS(SELECT TOP 1 1 FROM #webdomains)
					BEGIN
						UPDATE #webdomains SET webDomainUrl = 'https://' + LOWER(webDomainUrl) + ':443'
						IF OBJECT_ID('tempdb.dbo.#webdomainsDB') IS NOT NULL DROP TABLE #webdomainsDB
						CREATE TABLE #webdomainsDB( webDomainUrl NVARCHAR(MAX))
						INSERT INTO #webdomainsDB
						SELECT Data FROM dbo.split(@webDomainsStr, ',')
						DELETE wDB FROM #webdomainsDB wDB
						INNER JOIN #webdomains WB ON wDB.webDomainUrl COLLATE SQL_Latin1_General_CP1_CS_AS = WB.webDomainUrl
						SELECT @webDomainsStr =  ISNULL(STUFF((SELECT ', ' + CONVERT(NVARCHAR(MAX), webDomainUrl) FROM #webdomainsDB FOR xml path('')), 1, 1, ''), '')
						UPDATE GXGlobalParam SET VALUE = @webDomainsStr WHERE NAME = 'webDomainsWhiteList'
					END
				END
IF EXISTS(SELECT 1 from APP_CommCellProp WHERE CommCellId = 2 AND (CommcellType & 16 = 16))
				BEGIN
Update APP_CommCellProp SET CommcellType = CommcellType &~16 where CommCellId = 2
				END
IF EXISTS (SELECT 1 from GXGlobalParam where name = 'nMultiCommcellRole')
				BEGIN
UPDATE GXGlobalParam SET value = value &~ 16 WHERE name = 'nMultiCommcellRole'
                END
			END
	END TRY
	BEGIN CATCH
		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
			PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
			ERROR MESSAGE: ' + ERROR_MESSAGE() + '
			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @errorCode= ERROR_NUMBER()
			SET @errorString = ERROR_MESSAGE()
	END CATCH
SEND_RESPONSE:
	SET @xmlText = (SELECT  @errorCode AS '@errorCode', @errorString AS '@errorString'
                 FOR xml path('App_GenericEntityResponse'), TYPE)
IF(@errorCode<>0)
BEGIN
	ROLLBACK TRANSACTION
END
ELSE
BEGIN
	COMMIT TRANSACTION
END
SELECT @xmlText,@shouldDeleteMulticommcellApp
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_UnLinkSubscriberCommcellFromCloudService')
	delete from GxQscripts where name = 'MCC_UnLinkSubscriberCommcellFromCloudService'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_UnLinkSubscriberCommcellFromCloudService')
	delete from GXDBVersions where aliasname = 'MCC_UnLinkSubscriberCommcellFromCloudService'
GO

insert into GXDBVersions values(2, 'MCC_UnLinkSubscriberCommcellFromCloudService',  '00000000000000000000', 'MCC_UnLinkSubscriberCommcellFromCloudService', '00000000000000000000')
GO

