

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_SetMultiCCMappingsandSecurity.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MCC_SetMultiCCMappingsandSecurity <<<'

IF EXISTS (select * from sysobjects where name='MCC_SetMultiCCMappingsandSecurity')
	drop procedure MCC_SetMultiCCMappingsandSecurity
IF EXISTS (select * from GxQscripts where name='MCC_SetMultiCCMappingsandSecurity')
	delete from GxQscripts where name = 'MCC_SetMultiCCMappingsandSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_SetMultiCCMappingsandSecurity')
	delete from GXDBVersions where aliasname = 'MCC_SetMultiCCMappingsandSecurity'
GO
print '... Creating Procedure: MCC_SetMultiCCMappingsandSecurity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_SetMultiCCMappingsandSecurity
  @XMLTEXT xml,
  @USERID int
AS
begin try
declare @operationType int
declare @appid int
declare @errorCode int = 0
declare @errorMessage nvarchar(max) = 'SUCCESS'
set @appid = ISNULL((select id from App_ThirdPartyApp where appName = @xmlText.value('(/App_ClientThirdPartyAppProp/@appName)[1]','nvarchar(max)')),0)
if @appid = 0
begin
	set @errorCode = 2
	set @errorMessage = 'This app not present yet'
	goto RETURN_RESPONSE
end
SET @operationType  = @xmlText.value('(/App_ClientThirdPartyAppProp/UserMappings/@opType)[1]', 'INT')
if @operationType > 0
begin
declare @tempusermappings table (tokenuser nvarchar(255), mappeduserid int)
INSERT INTO @tempusermappings (tokenuser, mappeduserid)
SELECT 	ISNULL(val.value('@userfromToken','NVARCHAR(100)'),''),
		ISNULL(val.value('(localuser/@userId)[1]','INT'),0)
FROM @xmlText.nodes('//App_ClientThirdPartyAppProp/UserMappings/userslist') x(val)
--delete the invalid rows
delete @tempusermappings where mappeduserid=0 or tokenuser=''
----------------------------------------overwrite operation ----------------------------------
if @operationType = 1
begin
	delete t1 from
	App_ThirdPartyUserMappings t1 left join
	@tempusermappings t2 on  t1.MappedUserId = t2.mappeduserid and t1.TokenUser=t2.tokenuser
	where t1.IssuerId = @appid and t2.tokenuser is null and t2.mappeduserid is null
end
----------------------------------------add operation ----------------------------------
if @operationType = 2 or @operationType = 1
begin
	delete tum
	from @tempusermappings tum
	join App_ThirdPartyUserMappings atpum
	on atpum.IssuerId = @appid and atpum.MappedUserId = tum.mappeduserid and tum.tokenuser = atpum.TokenUser
	INSERT INTO App_ThirdPartyUserMappings(IssuerId,MappedUserId,TokenUser)
	SELECT @appid,t2.mappeduserid,t2.tokenuser FROM @tempusermappings T2
end
----------------------------------------delete operation--------------------------------------
if @operationType = 3
begin
	delete Atpum
	from @tempusermappings tum
	join App_ThirdPartyUserMappings Atpum
	on atpum.IssuerId = @appid and atpum.MappedUserId = tum.mappeduserid and tum.tokenuser = atpum.TokenUser
end
end
-----------------------------------------security -------------------------------------------------------
declare @secxml xml
set @secxml =(select @xmlText.query('/App_ClientThirdPartyAppProp/assocTree'))
if @secxml is not null
	begin
		exec dbo.[MCC_ConfigureMulticcappUserAssoc]  'SET',@secxml ,@appid,@errorCode OUT , @errorMessage OUT
	end
end try
BEGIN CATCH
	SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END catch
RETURN_RESPONSE:
SET @xmlText = ( SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString'
                 FOR xml path('error'),ROOT('App_SetClientThirdPartyAppPropResp'))
SELECT @xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_SetMultiCCMappingsandSecurity')
	delete from GxQscripts where name = 'MCC_SetMultiCCMappingsandSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_SetMultiCCMappingsandSecurity')
	delete from GXDBVersions where aliasname = 'MCC_SetMultiCCMappingsandSecurity'
GO

insert into GXDBVersions values(2, 'MCC_SetMultiCCMappingsandSecurity',  '00000000000000000000', 'MCC_SetMultiCCMappingsandSecurity', '00000000000000000000')
GO

