

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_SetDefaultCommcellConfiguration.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_SetDefaultCommcellConfiguration')
BEGIN
	print '>>> Drop Stored Procedure: MCC_SetDefaultCommcellConfiguration <<<'
	drop procedure MCC_SetDefaultCommcellConfiguration
END
IF EXISTS (select * from GxQscripts where name='MCC_SetDefaultCommcellConfiguration')
	delete from GxQscripts where name = 'MCC_SetDefaultCommcellConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_SetDefaultCommcellConfiguration')
	delete from GXDBVersions where aliasname = 'MCC_SetDefaultCommcellConfiguration'
GO
print '... Creating Procedure: MCC_SetDefaultCommcellConfiguration'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_SetDefaultCommcellConfiguration
  @inputXml XML
AS
BEGIN TRY
  DECLARE @errorCode INT = 0
  DECLARE @errorStr NVARCHAR(MAX)=''
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
		DECLARE @mqAllNicIpAddress NVARCHAR(1024)
		DECLARE @mqConfiguration NVARCHAR(1024)
		DECLARE @mqHostname NVARCHAR(256)
		DECLARE @wsAllNicIpAddress NVARCHAR(1024)
		DECLARE @wsHostname NVARCHAR(256)
		DECLARE @wcAllNicIpAddress NVARCHAR(1024)
		DECLARE @wcHostname NVARCHAR(256)
		DECLARE @csAllNicIpAddress NVARCHAR(1024)
		DECLARE @webConsoleUrl NVARCHAR(2083)
		DECLARE @csGuid NVARCHAR(40)
		DECLARE @thirdPartyAppId INT
		DECLARE @clientId INT
		DECLARE @outputTable TABLE (errorCode INT, hasChanged  INT, propId INT, errString NVARCHAR(2048))
		DECLARE @curUtcDateTime BIGINT = dbo.GetUnixTime(GETUTCDATE())
		DECLARE @webServiceUrl NVARCHAR(2048)
		DECLARE @webServerport INT
		DECLARE @webServerClientId INT
		DECLARE @webServerName NVARCHAR(510)
		DECLARE @webServerHostName NVARCHAR(510)
		DECLARE @release INT
		DECLARE @SP INT
		DECLARE @hotfix INT
		DECLARE @transactionID INT
		DECLARE @SPVersionInfoText NVARCHAR(510)
		DECLARE @creUrl NVARCHAR(2048)
		DECLARE @crePort INT
		DECLARE @creClientId INT
		DECLARE @creClientName NVARCHAR(510)
		DECLARE @creHostName NVARCHAR(510)
		DECLARE @tppmWebServerport INT
		DECLARE @tppmCrePort INT
		DECLARE @webServerURLs nvarchar(1024)
		DECLARE @commcellId INT
		DECLARE @WebEndpointsXML XML
		DECLARE @WebEndpoints TABLE (webConsoleUrl NVARCHAR(MAX),webServerUrl NVARCHAR(MAX))
		DECLARE @nowTime    integer
		SET                @nowTime        = dbo.GetUnixTime (GetUTCdate())
		SELECT
			@webConsoleUrl = ref.value('@webConsoleUrl', 'NVARCHAR(2083)'),
			@mqConfiguration = ref.value('@mqConfiguration', 'NVARCHAR(1024)'),
			@csAllNicIpAddress = ref.value('@csAllNicIpAddress', 'NVARCHAR(1024)'),
			@mqAllNicIpAddress = ref.value('(mqClient/@allNicIpAddress)[1]', 'NVARCHAR(1024)') ,
			@mqHostname = ref.value('(mqClient/client/@hostName)[1]', 'NVARCHAR(256)'),
			@wsAllNicIpAddress = ref.value('(webServerClient/@allNicIpAddress)[1]', 'NVARCHAR(1024)') ,
			@wsHostname = ref.value('(webServerClient/client/@hostName)[1]', 'NVARCHAR(256)'),
			@wcAllNicIpAddress = ref.value('(webConsoleClient/@allNicIpAddress)[1]', 'NVARCHAR(1024)') ,
			@wcHostname = ref.value('(webConsoleClient/client/@hostName)[1]', 'NVARCHAR(256)'),
			@csGuid = ref.value('(commcell/@csGUID)[1]', 'NVARCHAR(40)'),
			@webServiceUrl = ref.value('(webserverInfo/@webServiceUrl)[1]', 'NVARCHAR(2048)'),
			@webServerport = ref.value('(webserverInfo/@webServerport)[1]', 'INT'),
			@webServerClientId = ref.value('(webserverInfo/webServerEntity/@clientId)[1]', 'INT'),
			@webServerName = ref.value('(webserverInfo/webServerEntity/@webServerName)[1]', 'NVARCHAR(510)'),
			@webServerHostName = ref.value('(webserverInfo/webServerEntity/@webServerHostName)[1]', 'NVARCHAR(510)'),
			@release = ref.value('(webserverInfo/spVersion/@release)[1]', 'INT'),
			@SP = ref.value('(webserverInfo/spVersion/@SP)[1]', 'INT'),
			@hotfix = ref.value('(webserverInfo/spVersion/@hotfix)[1]', 'INT'),
			@transactionID = ref.value('(webserverInfo/spVersion/@transactionID)[1]', 'INT'),
			@SPVersionInfoText = ref.value('(webserverInfo/spVersion/@SPVersionInfoText)[1]', 'NVARCHAR(510)'),
			@creUrl = ref.value('(webserverInfo/cre/@creUrl)[1]', 'NVARCHAR(2048)'),
			@crePort = ref.value('(webserverInfo/cre/@crePort)[1]', 'INT'),
			@creClientId = ref.value('(webserverInfo/cre/client/@clientId)[1]', 'INT'),
			@creClientName = ref.value('(webserverInfo/cre/client/@clientName)[1]', 'NVARCHAR(510)'),
			@creHostName = ref.value('(webserverInfo/cre/client/@hostName)[1]', 'NVARCHAR(510)'),
			@tppmCrePort = ref.value('(webserverInfo/cre/@tppmCrePort)[1]', 'INT'),
			@tppmWebServerport = ref.value('(webserverInfo/@tppmWebServerport)[1]', 'INT'),
			@webServerURLs = ref.value('@webServerURLs', 'NVARCHAR(1024)')
		FROM @inputXml.nodes('App_ConfigurationDetailsForMCC') R ( ref )
		SELECT @thirdPartyAppId = id FROM App_ThirdPartyApp WHERE appName = @csGuid
		SELECT @clientId = clientId FROM APP_CommCell WHERE csGUID = @csGuid
		SELECT @commcellId = id FROM APP_CommCell WHERE csGUID = @csGuid
		IF(LEN(@webServerURLs) > 0)
		BEGIN
IF NOT EXISTS(SELECT 1 FROM APP_ComponentProp WHERE componentType = 1 AND componentId = @commcellId AND propertyTypeId = 17)
            			INSERT INTO APP_ComponentProp (componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)
VALUES (1, @commcellId, 17, 1, 0, 0, @webServerURLs, @curUtcDateTime, 0)
            	ELSE
               		UPDATE APP_ComponentProp
              		SET stringVal = @webServerURLs
WHERE componentType = 1 AND componentId = @commcellId AND propertyTypeId = 17 AND stringVal != @webServerURLs
		END
		IF @thirdPartyAppId IS NULL OR @clientId IS NULL
			THROW 51000, N'Failed to obtain remote commcell info from DB.', 2
		IF @webConsoleUrl IS NOT NULL
		BEGIN
			INSERT INTO @outputTable
			EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'Default WebUrl', 1, @webConsoleUrl
			UPDATE App_ThirdPartyApp
				SET props.modify('replace value of (/props/nameValues[@name="RedirectUrl"]/@value)[1] with (sql:variable("@webConsoleUrl"))')
				WHERE id = @thirdPartyAppId
			DECLARE @httpsWebConsoleUrl nvarchar(max) = NULL
			IF(@webConsoleUrl like 'http://%')
			BEGIN
				SET @httpsWebConsoleUrl= 'https://' + LOWER(DBO.GetHostnameFromUrl(@webConsoleUrl)) +':443'
			END
			IF @httpsWebConsoleUrl IS NOT NULL AND @httpsWebConsoleUrl <> ''
			BEGIN
				IF NOT EXISTS( SELECT 1 from GXGlobalParam where name = 'webDomainsWhiteList' and value like '%'+@httpsWebConsoleUrl+'%')
				BEGIN
					DECLARE @webdomains NVARCHAR(max) = (SELECT VALUE from GXGlobalParam where name = 'webDomainsWhiteList' and modified = 0)
					IF(@webdomains IS NULL)
						INSERT INTO GXGlobalParam VALUES ('webDomainsWhiteList',@httpsWebConsoleUrl,@nowTime,0)
					ELSE IF(@webdomains = '')
						UPDATE gxglobalparam SET VALUE = @httpsWebConsoleUrl WHERE NAME = 'webDomainsWhiteList'
					ELSE
						UPDATE gxglobalparam SET VALUE = @webdomains + ','+@httpsWebConsoleUrl WHERE NAME = 'webDomainsWhiteList'
				END
			END
		END
		IF OBJECT_ID('tempdb.dbo.#CommcellTypeForMultiCommcell') IS NOT NULL
		DROP TABLE #CommcellTypeForMultiCommcell
		CREATE TABLE #CommcellTypeForMultiCommcell (commcellType nvarchar(255),globalCommcellName nvarchar(255),globalCommcellRedirectUrl nvarchar(255),errorCode INT, errorMessage nvarchar(max))
		INSERT INTO #CommcellTypeForMultiCommcell
		EXEC MCC_GetCommcellTypeForMultiCommcell
		SELECT	@errorCode = errorCode,
				@errorStr = errorMessage
		FROM #CommcellTypeForMultiCommcell
		IF(@errorCode <> 0)
			THROW @errorCode, @errorStr, 1
		-- Below updates are intented only for master commcell
		IF EXISTS (SELECT 1 FROM #CommcellTypeForMultiCommcell WHERE commcellType = 'ROUTERCOMMCELL_AS_GLOBALIDP')
		BEGIN
			IF @webServiceUrl IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell WebServiceUrl',1,@webServiceUrl
			IF @webServerport IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell WebServerport',7,@webServerport
			IF @tppmWebServerport IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell TppmWebServerport',7,@tppmWebServerport
			IF @webServerClientId IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell WebServerClientId',7,@webServerClientId
			IF @webServerName IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell WebServerName',1,@webServerName
			IF @webServerHostName IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell WebServerHostName',1,@webServerHostName
			IF @release IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell Release',7,@release
			IF @SP IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell SP',7,@SP
			IF @hotfix IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell Hotfix',7,@hotfix
			IF @transactionID IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell TransactionID',7,@transactionID
			IF @creUrl IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell CreUrl',1,@creUrl
			IF @crePort IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell CrePort',7,@crePort
			IF @tppmCrePort IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell TppmCrePort',7,@tppmCrePort
			IF @creClientId IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell CreClientId',7,@creClientId
			IF @creClientName IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell CreClientName',1,@creClientName
			IF @creHostName IS NOT NULL
				INSERT INTO @outputTable
				EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell CreHostName',1,@creHostName
		END
		ELSE IF EXISTS (SELECT 1 FROM #CommcellTypeForMultiCommcell WHERE commcellType = 'SERVICECOMMCELL')
		BEGIN
			DECLARE @isGlobalWebconsoleConfigured INT = (SELECT props.value('(/props/nameValues[@name="IsGlobalWebConsoleConfigured"]/@value)[1]','INT')
																FROM App_ThirdPartyApp(NOLOCK) WHERE id = @thirdPartyAppId)
			DECLARE @isSPSupported INT = (SELECT TOP 1 1
											FROM simInstalledPackages s(nolock) INNER JOIN  PatchSPVersion v(nolock) ON s.spversionid=v.id
											WHERE clientid=2 AND v.spmajor >=22)
			IF(@isGlobalWebconsoleConfigured = 1 AND @isSPSupported = 1)
			BEGIN
				DECLARE @gxWebConsoleURL NVARCHAR(MAX)
				DECLARE @serviceCommcellWebConsoleURL NVARCHAR(MAX) = @webConsoleUrl+'-'+(SELECT aliasName from APP_CommCell where clientId = 2)
				IF EXISTS (SELECT 1 FROM GXGlobalParam(NOLOCK) WHERE name='WebConsoleURL' and modified=0)
				BEGIN
					SELECT @gxWebConsoleURL=value FROM GXGlobalParam(NOLOCK) WHERE name='WebConsoleURL' and modified=0
					SET @serviceCommcellWebConsoleURL = @serviceCommcellWebConsoleURL +SUBSTRING(@gxWebConsoleURL,(CHARINDEX('/clientDetails',@gxWebConsoleURL)),len(@gxWebConsoleURL))
					UPDATE GXGlobalParam SET value = @ServiceCommcellWebConsoleURL WHERE name='WebConsoleURL'
					IF NOT EXISTS(SELECT 1 FROM GXGlobalParam(NOLOCK) WHERE name='WebConsoleURL_Original' and modified=0)
					BEGIN
						INSERT INTO GXGlobalParam VALUES ('WebConsoleURL_Original',@gxWebConsoleURL, @curUtcDateTime, 0);
					END
				END
				ELSE
				BEGIN
					SET @serviceCommcellWebConsoleURL = @serviceCommcellWebConsoleURL+'/clientDetails/fsDetails.do?clientName=CLIENTNAME'
					INSERT INTO GXGlobalParam VALUES ('WebConsoleURL',@serviceCommcellWebConsoleURL, @curUtcDateTime, 0);
				END
				DECLARE @globalparamUrlSetVal NVARCHAR(MAX) = NULL
				SELECT @globalparamUrlSetVal = value FROM GXGlobalParam(NOLOCK) WHERE name='IsGlobalWebConsoleUrlSet' and modified=0
				IF @globalparamUrlSetVal IS NULL
				BEGIN
					INSERT INTO GXGlobalParam VALUES ('IsGlobalWebConsoleUrlSet',N'1', @curUtcDateTime, 0);
				END
				ELSE IF @globalparamUrlSetVal <> N'1'
				BEGIN
					UPDATE GXGlobalParam SET value = N'1' WHERE name='IsGlobalWebConsoleUrlSet'
				END
			END
		END
		IF @SPVersionInfoText IS NOT NULL
			INSERT INTO @outputTable
			EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'ServiceCommcell SPVersionInfoText',1,@SPVersionInfoText
		IF @mqAllNicIpAddress IS NOT NULL
			INSERT INTO @outputTable
			EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'Default Message Queue Client AllNicIpAddress', 1, @mqAllNicIpAddress
		IF @mqHostname IS NOT NULL
			INSERT INTO @outputTable
			EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'Default Message Queue Hostname', 1, @mqHostname
		IF @wsAllNicIpAddress IS NOT NULL
			INSERT INTO @outputTable
			EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'Default Web Server Client AllNicIpAddress', 1, @wsAllNicIpAddress
		IF @wsHostname IS NOT NULL
			INSERT INTO @outputTable
			EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'Default WebServer Hostname', 1, @wsHostname
		IF @wcAllNicIpAddress IS NOT NULL
			INSERT INTO @outputTable
			EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'Default Web Console Client AllNicIpAddress', 1, @wcAllNicIpAddress
		IF @wcHostname IS NOT NULL
			INSERT INTO @outputTable
			EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'Default Web Console Hostname', 1, @wcHostname
		IF @mqConfiguration IS NOT NULL
			INSERT INTO @outputTable
			EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'Message Queue Config', 1, @mqConfiguration
		IF @csAllNicIpAddress IS NOT NULL
			INSERT INTO @outputTable
			EXEC DBO.AppInsertClientProp @clientId, 0, 0,  'AllNicIpAddress', 1, @csAllNicIpAddress
		IF EXISTS (SELECT 1 FROM #CommcellTypeForMultiCommcell WHERE commcellType = 'ROUTERCOMMCELL_AS_GLOBALIDP' OR commcellType = 'ROUTERCOMMCELL' )
		BEGIN
			INSERT INTO @WebEndpoints VALUES(@webConsoleUrl,NULL)
			INSERT INTO @WebEndpoints
			SELECT NULL,_ID FROM dbo.SplitStringByDelimiter(@webServerUrls,',')
			DECLARE @currentWebEndpoints xml = (SELECT top 1 WebEndpoints FROM APP_CommCellProp WHERE CommCellId = @commcellId)
			INSERT INTO @WebEndpoints
			SELECT
			ref.value('.','nvarchar(max)'),NULL
			FROM @inputXml.nodes('App_WebEndPoints/webconsoleUrls') R ( ref )
			INSERT INTO @WebEndpoints
			SELECT
			NULL,ref.value('.','nvarchar(max)')
			FROM @inputXml.nodes('App_WebEndPoints/webserverUrls') R ( ref )
			SET @WebEndpointsXML = (SELECT DISTINCT  webConsoleUrl as 'webconsoleUrls', webServerUrl as 'webserverUrls'
									FROM @webEndpoints  for xml path (''), root('App_WebEndPoints'))
			IF EXISTS (SELECT 1 FROM APP_CommCellProp WHERE CommCellId = @commcellId)
			BEGIN
				UPDATE APP_CommCellProp SET WebEndpoints = @WebEndpointsXML WHERE CommCellId = @commcellId
			END
		END
		SELECT @errorCode, @errorStr
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @errorCode =  ERROR_NUMBER()
	SELECT @errorCode, @errorStr
END CATCH
PROC_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_SetDefaultCommcellConfiguration')
	delete from GxQscripts where name = 'MCC_SetDefaultCommcellConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_SetDefaultCommcellConfiguration')
	delete from GXDBVersions where aliasname = 'MCC_SetDefaultCommcellConfiguration'
GO

insert into GXDBVersions values(2, 'MCC_SetDefaultCommcellConfiguration',  '00000000000000000000', 'MCC_SetDefaultCommcellConfiguration', '00000000000000000000')
GO

