

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_SetCloudServiceDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |           Procedure : "MCC_SetCloudServiceDetails"
--  |   This Procedure is used to set subscribed cloud service details
--  |   on local CS.
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_SetCloudServiceDetails')
BEGIN
	print '>>> Drop Stored Procedure: MCC_SetCloudServiceDetails <<<'
	drop procedure MCC_SetCloudServiceDetails
END
IF EXISTS (select * from GxQscripts where name='MCC_SetCloudServiceDetails')
	delete from GxQscripts where name = 'MCC_SetCloudServiceDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_SetCloudServiceDetails')
	delete from GXDBVersions where aliasname = 'MCC_SetCloudServiceDetails'
GO
print '... Creating Procedure: MCC_SetCloudServiceDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_SetCloudServiceDetails
  @xmlText XML,
  @userId INT 
AS
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(MAX) = ''
DECLARE @nowTime INT = 0
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
DECLARE @operationType int = 0
DECLARE @redirectUrl nvarchar(MAX)
DECLARE @commcellName nvarchar(MAX)
DECLARE @companyId INT
DECLARE @companyName nvarchar(MAX)
DECLARE @companyAlias nvarchar(MAX)
DECLARE @companyGUID nvarchar(MAX)
DECLARE @WebEndpointsXML XML
DECLARE @onPrimCompanyId INT = 0
DECLARE @cid INT = 0
DECLARE @isCommcellAdmin INT = 0
DECLARE @isTenantAdmin INT = 0
DECLARE @userRole INT = 0
DECLARE @hostName NVARCHAR(MAX) = ''
DECLARE @httpsWebUrl NVARCHAR(MAX) = ''
DECLARE @webdomains NVARCHAR(MAX) = ''
DECLARE @removeFromWebDomains INT = 0
BEGIN TRANSACTION
	BEGIN TRY
		/*
		operationType:
		UNKNOWN = 0,
		GET = 1,
		MODIFY = 2,
		ADD = 3,
		DELETE = 4
		*/
exec Sec_checkPermissionOnEntity @userId, 1, @isCommCellAdmin OUTPUT, 1, 2
		IF(@isCommcellAdmin = 0)
		BEGIN
IF  EXISTS(SELECT 1 FROM UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id where UG.groupFlags&0x10000 <> 0 and UU.userId=@userId)
OR  EXISTS(SELECT 1 FROM UMDSGroupMaps ugm INNER JOIN UMUserGroup uu ON ugm.umDSgroupId = uu.groupId INNER JOIN UMGroups UG ON ug.id=ugm.umgroupId AND UG.groupFlags&0x10000 <> 0 WHERE UU.userId=@userId )
			BEGIN
				SET @isTenantAdmin = 1
			END
		END
		IF(@isCommcellAdmin = 0 AND @isTenantAdmin = 0)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'User does not have permission'
			GOTO SEND_RESPONSE
		END
		SET @operationType = (SELECT
			ISNULL(ref.value('@opType', 'int'), 0)
		FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq') R ( ref ))
		SET @redirectUrl = (SELECT
			ISNULL(ref.value('@redirectUrl', 'nvarchar(MAX)'), '')
		FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/cloudServiceDetails/cloudService') R ( ref ))
		SET @commcellName = (SELECT
			ISNULL(ref.value('@commcellName', 'nvarchar(MAX)'), '')
		FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/cloudServiceDetails/cloudService') R ( ref ))
		SET @companyId = (SELECT
			ISNULL(ref.value('@companyId', 'nvarchar(MAX)'), '')
		FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/cloudServiceDetails/associatedCompany') R ( ref ))
		SET @companyName = (SELECT
			ISNULL(ref.value('@companyName', 'nvarchar(MAX)'), '')
		FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/cloudServiceDetails/associatedCompany') R ( ref ))
		SET @companyAlias = (SELECT
			ISNULL(ref.value('@companyAlias', 'nvarchar(MAX)'), '')
		FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/cloudServiceDetails/associatedCompany') R ( ref ))
		SET @companyGUID = (SELECT
			ISNULL(ref.value('@GUID', 'nvarchar(MAX)'), '')
		FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/cloudServiceDetails/associatedCompany') R ( ref ))
		SET @onPrimCompanyId = (SELECT
			ISNULL(ref.value('@providerId', 'int'), 0)
		FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/subscriberCompany') R ( ref ))
		IF @isTenantAdmin = 1
		BEGIN
			SET @onPrimCompanyId = dbo.AppGetOrganizationForUser(@userId)
		END
		IF @onPrimCompanyId IS NULL
		BEGIN
			SET @onPrimCompanyId = 0
		END
		DECLARE @csID INT = 0
		DECLARE @csClientID INT = 0
		DECLARE @userIdLink INT = 0 -- user used for linking to metallic
		DECLARE @masterUserGroupId INT = dbo.GetMasterGroupID()
		DECLARE @viewRoleId int = (SELECT  id from UMRoles where name like 'View')
		DECLARE @csGUID nvarchar(80)= ISNULL((SELECT  GGF.value('(commcellInfo/commCell/@csGUID)[1]', 'NVARCHAR(80)') as csGuid
								FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/cloudServiceDetails') GFI ( GGF ) ),'')
		DECLARE @setup nvarchar(MAX) = '"METALLIC"' +  ':true'
		DECLARE @localAppId INT = 0
		SET @localAppId = ISNULL((SELECT ATP.id FROM App_ThirdPartyApp ATP INNER JOIN App_Commcell AC ON
									ATP.appName = AC.csGUID AND ATP.appType = 4/*LOCALIDP*/), 0)
		IF (@operationType = 3 AND @onPrimCompanyId > 0)
		BEGIN
IF EXISTS (Select Top 1 id from App_Companyprop where componentNameId = @onPrimCompanyId and attrName='Cloud Service Company Guid' and modified = 0)
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Cloud Service already linked.'
			END
		END
		--ADD
		IF (@operationType = 3)
		BEGIN
IF EXISTS (Select top 1 id from umdsproviders where serviceType = 5 AND (@onPrimCompanyId IS NULL OR @onPrimCompanyId <=0))
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Not supported, Company not selected.'
			END
			-- INSERT VALUES IF NOT EXIST
			SELECT @csID = id FROM App_Commcell AC WHERE AC.csGUID = @csGUID
			BEGIN
				-- ADD entry in App_Commcell table for cloud service CS
				-- Get Commcell Information (i.e. cloud Service)
				IF object_id('tempdb.dbo.#CommcellInfo') IS NOT Null DROP TABLE #CommcellInfo
				CREATE TABLE #CommcellInfo
				(
					commcellName nvarchar(512),
					csGUID nvarchar(80),
					encNumber nvarchar(512),
					number int,
					flags int,
					userName nvarchar(512),
					userPassword nvarchar(2048),
					smtpServer nvarchar(512),
					timeZone nvarchar(2048),
					ipAddress nvarchar(50),
					drIpAddress nvarchar(50),
					ccOpMode int
				)
				INSERT INTO #CommcellInfo (csGUID, encNumber, commcellName, number, flags, userName, userPassword, smtpServer, timeZone, ipAddress, drIpAddress, ccOpMode)
				SELECT  GGF.value('(commcellInfo/commCell/@csGUID)[1]', 'NVARCHAR(80)') as csGuid, GGF.value('(commcellInfo/@encNumber)[1]', 'nvarchar(512)') as encNumber, GGF.value('(commcellInfo/commCell/@commCellName)[1]', 'NVARCHAR(512)') as commcellName,  GGF.value('(commcellInfo/@number)[1]', 'int') as number,
				GGF.value('(commcellInfo/@flags)[1]', 'int') as flags, GGF.value('(commcellInfo/@userName)[1]', 'NVARCHAR(512)') as userName, GGF.value('(commcellInfo/@passWord)[1]', 'NVARCHAR(2048)') as userPassword,
				GGF.value('(commcellInfo/@smtpServer)[1]', 'NVARCHAR(512)') as smtpServer, GGF.value('(commcellInfo/@TimeZone)[1]', 'NVARCHAR(2048)') as timeZone,  GGF.value('(commcellInfo/@IPAddress)[1]', 'NVARCHAR(50)') as ipAddress, GGF.value('(commcellInfo/@drIpAddress)[1]', 'NVARCHAR(50)') as drIpAddress,
				GGF.value('(commcellInfo/@ccOpMode)[1]', 'int') as ccOpMode
				FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/cloudServiceDetails') GFI ( GGF )
				IF(@csID = 0)
				BEGIN
					INSERT INTO APP_CommCell(number, clientId, parentId, aliasName, flags, refTime, userName, userPassword, smtpServer, timeZone, ipAddress, modified, ccOpMode, type, drIpAddress, encNumber, csGUID)
					SELECT ISNULL(number, 0), 0, 1, ISNULL(commcellName, ''), ISNULL(flags, 0), 0, ISNULL(userName, ''), ISNULL(userPassword, ''), ISNULL(smtpServer, ''), ISNULL(timeZone, ''), ISNULL(ipAddress, ''), 0, ISNULL(ccOpMode, 0), 1, ISNULL(drIpAddress, ''), ISNULL(encNumber, ''), csGUID FROM #CommcellInfo
					SET @csID  = (SELECT id FROM APP_COMMCELL INNER JOIN #CommcellInfo ON APP_CommCell.csGUID = #CommcellInfo.csGUID)
				END
				ELSE
				BEGIN
					UPDATE App_CommCell SET
					number = ISNULL(cs.number, 0), aliasName = ISNULL(cs.commcellName, ''), smtpServer = ISNULL(cs.smtpServer, ''), timeZone = ISNULL(cs.timeZone, ''), drIpAddress = ISNULL(cs.drIpAddress, ''), encNumber = ISNULL(cs.encNumber, '')
					FROM #CommcellInfo cs WHERE id = @csID
				END
				-- set initial security association for newly created Service Commcell
				DECLARE @userName NVARCHAR(MAX) = (SELECT
								ISNULL(ref.value('(userOrGroup/@userName)[1]', 'nvarchar(MAX)'), '')
								FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/associations') R ( ref ))
				IF (@onPrimCompanyId = 0)
				BEGIN
					SELECT @userIdLink = id from UMUsers WHERE email = @userName
					IF(@userIdLink <> 0)
					BEGIN
IF NOT EXISTS(SELECT TOP 1 1 FROM UMSecurityAssociations WHERE roleId = @viewRoleId AND permissionId = 0 AND userOrGroupId = @userIdLink AND isUser = 1 AND entityType1 = 194 AND entityId1 = @csID)
							INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator)
VALUES(@viewRoleId, 0, @userIdLink, 1, 194, @csID, 0)
					END
IF NOT EXISTS(SELECT TOP 1 1 FROM UMSecurityAssociations WHERE roleId = @viewRoleId AND permissionId = 0 AND userOrGroupId = @masterUserGroupId AND isUser = 0 AND entityType1 = 194 AND entityId1 = @csID)
						INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator)
VALUES(@viewRoleId, 0, @masterUserGroupId, 0, 194, @csID, 0)
				END
				ELSE
				BEGIN
IF NOT EXISTS(SELECT TOP 1 1 FROM UMSecurityAssociations WHERE roleId = @viewRoleId AND permissionId = 0 AND userOrGroupId = @onPrimCompanyId AND isUser = 2 AND entityType1 = 194 AND entityId1 = @csID)
						INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator)
VALUES(@viewRoleId, 0, @onPrimCompanyId, 2, 194, @csID, 0)
				END
				SELECT @csClientID = clientId FROM App_Commcell WHERE id = @csID
				IF(@csClientId = 0)
				BEGIN
					-- Insert into App_Client and add proper CS Id as well
					INSERT INTO APP_Client (name, simOperatingSystemId, net_hostname, client_password, refTime, modified, offlineEntity, offlineTimeStamp, csHostName, clientDescription, jobResultDir, clientSkewTime, cvdPort, evmgrcPort, status, releaseId, spaceCheckFlags, ccpId, ccpTime, origCCId, GUID, specialClientFlags, displayName)
					SELECT  GGF.value('(csClient/client/clientEntity/@clientName)[1]', 'NVARCHAR(510)'),
					ISNULL(GGF.value('(csClient/client/osInfo/@osId)[1]', 'INT'), 0),
					GGF.value('(csClient/client/clientEntity/@hostName)[1]', 'NVARCHAR(510)'),
					ISNULL(GGF.value('(csClient/client/@clientPassword)[1]', 'NVARCHAR(510)'), ''),
					0,0,
					ISNULL(GGF.value('(csClient/client/@offlineEntity)[1]', 'INT'), 0),
					ISNULL(GGF.value('(csClient/client/@offlineTimeStamp)[1]', 'INT'), 0),
					ISNULL(GGF.value('(csClient/client/clientEntity/@commCellName)[1]', 'NVARCHAR(510)'), ''),
					ISNULL(GGF.value('(csClient/client/@clientDescription)[1]', 'NVARCHAR(MAX)'), ''),
					ISNULL(GGF.value('(csClient/client/jobResulsDir/@path)[1]', 'NVARCHAR(510)'), ''),
					ISNULL(GGF.value('(csClient/client/@ClockSkewInSeconds)[1]', 'INT'), 0),
					ISNULL(GGF.value('(csClient/client/@cvdPort)[1]', 'INT'), 0),
					ISNULL(GGF.value('(csClient/client/@evmgrcPort)[1]', 'INT'), 0),
					ISNULL(GGF.value('(csClient/client/@Status)[1]', 'INT'), 0),
					ISNULL(GGF.value('(csClient/client/versionInfo/@version)[1]', 'INT'), 0),
					ISNULL(GGF.value('(csClient/client/@spaceCheckFlags)[1]', 'INT'), 0),
					0,0,@csID,
					GGF.value('(csClient/client/clientEntity/@clientGUID)[1]', 'UNIQUEIDENTIFIER'),
					ISNULL(GGF.value('(csClient/clientProps/@specialClientFlags)[1]', 'INT'), 0),
					GGF.value('(csClient/client/clientEntity/@displayName)[1]', 'NVARCHAR(510)')
					FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/cloudServiceDetails') GFI ( GGF )
					SELECT @csClientID = id FROM APP_Client WHERE name = (SELECT  GGF.value('(csClient/client/clientEntity/@clientName)[1]', 'NVARCHAR(510)') FROM @xmlText.nodes('App_SetCloudServiceDetailsReq/cloudServiceDetails') GFI ( GGF ) )
					UPDATE APP_COMMCELL SET clientId = @csClientID WHERE id = @csID
				END
				ELSE
				BEGIN
					UPDATE App_Client SET
					name =  GGF.value('(csClient/client/clientEntity/@clientName)[1]', 'NVARCHAR(510)'),
					simOperatingSystemId = ISNULL(GGF.value('(csClient/client/osInfo/@osId)[1]', 'INT'), 0),
					net_hostname = GGF.value('(csClient/client/clientEntity/@hostName)[1]', 'NVARCHAR(510)'),
					client_password = ISNULL(GGF.value('(csClient/client/@clientPassword)[1]', 'NVARCHAR(510)'), ''),
					refTime = 0, modified = 0,
					offlineEntity = ISNULL(GGF.value('(csClient/client/@offlineEntity)[1]', 'INT'), 0),
					offlineTimeStamp = ISNULL(GGF.value('(csClient/client/@offlineTimeStamp)[1]', 'INT'), 0),
					csHostName = ISNULL(GGF.value('(csClient/client/clientEntity/@commCellName)[1]', 'NVARCHAR(510)'), ''),
					clientDescription = ISNULL(GGF.value('(csClient/client/@clientDescription)[1]', 'NVARCHAR(MAX)'), ''),
					jobResultDir = ISNULL(GGF.value('(csClient/client/jobResulsDir/@path)[1]', 'NVARCHAR(510)'), ''),
					clientSkewTime = ISNULL(GGF.value('(csClient/client/@ClockSkewInSeconds)[1]', 'INT'), 0),
					cvdPort = ISNULL(GGF.value('(csClient/client/@cvdPort)[1]', 'INT'), 0),
					evmgrcPort = ISNULL(GGF.value('(csClient/client/@evmgrcPort)[1]', 'INT'), 0),
					status = ISNULL(GGF.value('(csClient/client/@Status)[1]', 'INT'), 0),
					releaseId = ISNULL(GGF.value('(csClient/client/versionInfo/@version)[1]', 'INT'), 0),
					spaceCheckFlags = ISNULL(GGF.value('(csClient/client/@spaceCheckFlags)[1]', 'INT'), 0),
					ccpId = 0, ccpTime = 0, origCCId = @csID,
					GUID = GGF.value('(csClient/client/clientEntity/@clientGUID)[1]', 'UNIQUEIDENTIFIER'),
					specialClientFlags = ISNULL(GGF.value('(csClient/clientProps/@specialClientFlags)[1]', 'INT'), 0),
					displayName = GGF.value('(csClient/client/clientEntity/@displayName)[1]', 'NVARCHAR(510)')
					FROM    @xmlText.nodes('App_SetCloudServiceDetailsReq/cloudServiceDetails') GFI ( GGF )
					WHERE id = @csClientID
				END
				-- insert properties
				IF(@onPrimCompanyId = 0)
				BEGIN
IF NOT EXISTS(SELECT 1 FROM App_ClientProp WHERE componentNameId=@csClientId AND attrName='Service commcell end point' AND attrType = 1)
						INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES (@csClientId, 'Service commcell end point', 1, @redirectUrl, @nowTime, 0, 0)
					ELSE
UPDATE App_ClientProp SET attrVal = @redirectUrl WHERE componentNameId = @csClientId AND attrName='Service commcell end point' AND attrType = 1
IF NOT EXISTS(SELECT 1 FROM App_ClientProp WHERE componentNameId=@csClientId AND attrName='Commcell role' AND attrType = 2)
						INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES (@csClientId, 'Commcell role', 2, CAST(5 AS NVARCHAR(2048)), @nowTime, 0, 0)
					ELSE
UPDATE App_ClientProp SET attrVal = CAST(5 AS NVARCHAR(2048)) WHERE componentNameId = @csClientId AND attrName='Commcell role' AND attrType = 2
IF NOT EXISTS(SELECT 1 FROM App_ClientProp WHERE componentNameId=@csClientId AND attrName='Cloud Service Company Alias' AND attrType = 1)
						INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES (@csClientId, 'Cloud Service Company Alias', 1, @companyAlias, @nowTime, 0, 0)
					ELSE
UPDATE App_ClientProp SET attrVal = @companyAlias WHERE componentNameId = @csClientId AND attrName='Cloud Service Company Alias' AND attrType = 1
IF NOT EXISTS(SELECT 1 FROM App_ClientProp WHERE componentNameId=@csClientId AND attrName='Cloud Service Company Guid' AND attrType = 1)
						INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES (@csClientId, 'Cloud Service Company Guid', 1, @companyGUID, @nowTime, 0, 0)
					ELSE
UPDATE App_ClientProp SET attrVal = @companyGUID WHERE componentNameId = @csClientId AND attrName='Cloud Service Company Guid' AND attrType = 1
IF NOT EXISTS(SELECT 1 FROM App_ClientProp WHERE componentNameId=@csClientId AND attrName='Cloud Service Company Name' AND attrType = 1)
						INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES (@csClientId, 'Cloud Service Company Name', 1, @companyName, @nowTime, 0, 0)
					ELSE
UPDATE App_ClientProp SET attrVal = @companyName WHERE componentNameId = @csClientId AND attrName='Cloud Service Company Name' AND attrType = 1
				END
				ELSE IF(@onPrimCompanyId > 0)
				BEGIN
IF NOT EXISTS(SELECT 1 FROM App_ClientProp WHERE componentNameId=@csClientId AND attrName='Commcell role' AND attrType = 2)
						INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES (@csClientId, 'Commcell role', 2, CAST(5 AS NVARCHAR(2048)), @nowTime, 0, 0)
					ELSE
UPDATE App_ClientProp SET attrVal = CAST(5 AS NVARCHAR(2048)) WHERE componentNameId = @csClientId AND attrName='Commcell role' AND attrType = 2
IF NOT EXISTS(SELECT 1 FROM App_ClientProp WHERE componentNameId=@csClientId AND attrName='Cloud Service For MSP' AND attrType = 2)
						INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
VALUES (@csClientId, 'Cloud Service For MSP', 2, 1, @nowTime, 0, 0)
					ELSE
UPDATE App_ClientProp SET attrVal = 1 WHERE componentNameId = @csClientId AND attrName='Cloud Service For MSP' AND attrType = 2
IF NOT EXISTS(SELECT 1 FROM App_CompanyProp WHERE componentNameId = @onPrimCompanyId AND attrName = 'Cloud Service Company Alias' AND attrType = 7)
 						INSERT INTO App_CompanyProp(componentNameId,attrName,attrVal,attrType,created,modified,attrValInt)
VALUES (@onPrimCompanyId, 'Cloud Service Company Alias', @companyAlias,7, @nowTime, 0, 0)
					ELSE
UPDATE App_CompanyProp SET attrVal = @companyAlias WHERE componentNameId = @onPrimCompanyId AND attrName = 'Cloud Service Company Alias' AND attrType = 7
IF NOT EXISTS(SELECT 1 FROM App_CompanyProp WHERE componentNameId = @onPrimCompanyId AND attrName = 'Cloud Service Company Guid' AND attrType = 7)
 						INSERT INTO App_CompanyProp(componentNameId,attrName,attrVal,attrType,created,modified,attrValInt)
VALUES (@onPrimCompanyId, 'Cloud Service Company Guid', @companyGUID,7, @nowTime, 0, 0)
					ELSE
UPDATE App_CompanyProp SET attrVal = @companyGUID WHERE componentNameId = @onPrimCompanyId AND attrName = 'Cloud Service Company Guid' AND attrType = 7
IF NOT EXISTS(SELECT 1 FROM App_CompanyProp WHERE componentNameId = @onPrimCompanyId AND attrName = 'Cloud Service Company Name' AND attrType = 7)
 						INSERT INTO App_CompanyProp(componentNameId,attrName,attrVal,attrType,created,modified,attrValInt)
VALUES(@onPrimCompanyId, 'Cloud Service Company Name',@companyName,7, @nowTime, 0, 0)
					ELSE
UPDATE App_CompanyProp SET attrVal = @companyName WHERE componentNameId = @onPrimCompanyId AND attrName = 'Cloud Service Company Name' AND attrType = 7
IF NOT EXISTS(SELECT 1 FROM App_CompanyProp WHERE componentNameId = @onPrimCompanyId AND attrName = 'Cloud Service ClientId' AND attrType = 7)
 						INSERT INTO App_CompanyProp(componentNameId,attrName,attrVal,attrType,created,modified,attrValInt)
VALUES(@onPrimCompanyId, 'Cloud Service ClientId',@csClientID,7, @nowTime, 0,@csClientID )
					ELSE
UPDATE App_CompanyProp SET attrVal = @csClientID WHERE componentNameId = @onPrimCompanyId AND attrName = 'Cloud Service ClientId' AND attrType = 7
IF NOT EXISTS(SELECT 1 FROM App_CompanyProp WHERE componentNameId = @onPrimCompanyId AND attrName = 'Service commcell end point' AND attrType = 7)
		                        	INSERT INTO App_CompanyProp(componentNameId,attrName,attrVal,attrType,created,modified,attrValInt)
VALUES(@onPrimCompanyId, 'Service commcell end point',@redirectUrl,7, @nowTime, 0,@csClientID )
		                    	ELSE
UPDATE App_CompanyProp SET attrVal = @redirectUrl,attrValInt = @csClientID  WHERE componentNameId = @onPrimCompanyId AND attrName = 'Service commcell end point' AND attrType = 7
				END
				-- insert into app_commcellProp, commcellRoles and WebEndpoint XML
				SET @WebEndpointsXML = (SELECT  @redirectUrl as 'webconsoleUrls'
				                        for xml path (''), root('App_WebEndPoints'))
				IF EXISTS (SELECT 1 FROM APP_CommCellProp WHERE CommCellId = @csID)
				BEGIN
UPDATE APP_CommCellProp SET CommcellType = 16 , WebEndpoints = @WebEndpointsXML WHERE CommCellId = @csID
				END
				ELSE
				BEGIN
					INSERT into APP_CommCellProp (CommCellId,LastEventID,LastEventUpdateTime,LastJobUpdateTime,LastCompletedJobUpdateTime,LastMaxChunkId,CommcellType,WebEndpoints)
VALUES(@csID,0,NULL,NULL,NULL,0,16,@WebEndpointsXML)
				END
IF EXISTS(SELECT 1 FROM App_CommcellProp WHERE CommcellId = 2)
				BEGIN
UPDATE APP_CommCellProp SET CommcellType = CommcellType | 32 WHERE CommCellId = 2
				END
				ELSE
					INSERT into APP_CommCellProp (CommCellId,LastEventID,LastEventUpdateTime,LastJobUpdateTime,LastCompletedJobUpdateTime,LastMaxChunkId,CommcellType,WebEndpoints)
VALUES(2,0,NULL,NULL,NULL,0,32,NULL)
				-- insert/update GXGlobalParam: nMultiCommcellRole
IF EXISTS (SELECT 1 from GXGlobalParam where name = 'nMultiCommcellRole')
				BEGIN
UPDATE GXGlobalParam SET value = value | 32 WHERE name = 'nMultiCommcellRole'
				END
				ELSE
				BEGIN
					INSERT INTO GXGlobalParam (name, value, created, modified)
VALUES('nMultiCommcellRole', 32, dbo.GetUnixTime(GetUTCdate()), 0)
				END
				-- enable all user association in Local IDP app
				IF(@localAppId <> 0)
				BEGIN
					-- enable app if it is not enabled
					UPDATE App_ThirdPartyApp SET isEnabled = 1 WHERE id = @localAppId AND isEnabled <> 1
					IF(@onPrimCompanyId = 0)
					BEGIN
					    --associate app for all users
IF NOT EXISTS(SELECT 1 from APP_ComponentProp where componentType = 1034 and  componentId = @localAppId and propertyTypeId = 12 and longlongVal = 0 and modified = 0)
						BEGIN
							INSERT INTO APP_COMPONENTPROP
SELECT 1034, @localAppId, 12, 1, 0,0,'',@nowTime,0
						END
					END
					ELSE
					BEGIN
					    --associate only for this company
IF NOT EXISTS(SELECT 1 from APP_ComponentProp where componentType = 1034 and  componentId = @localAppId and propertyTypeId = 61 and longlongVal = @onPrimCompanyId and modified = 0)
						BEGIN
							INSERT INTO APP_COMPONENTPROP
SELECT 1034, @localAppId, 61, 1, 0,@onPrimCompanyId,'',@nowTime,0
						END
					END
				END
				-- insert into webdomains
				SELECT @hostName = LOWER(DBO.GetHostnameFromUrl(@redirectUrl))
				IF @hostName IS NOT NULL AND @hostName <> ''
				BEGIN
					SET @httpsWebUrl = 'https://' + @hostname +':443'
					IF NOT EXISTS( SELECT 1 from GXGlobalParam where name = 'webDomainsWhiteList' and value like '%'+@httpsWebUrl+'%')
					BEGIN
						SET @webdomains = (SELECT VALUE from GXGlobalParam where name = 'webDomainsWhiteList' and modified = 0)
						IF(@webdomains IS NULL)
							INSERT INTO GXGlobalParam VALUES ('webDomainsWhiteList',@httpsWebUrl,@nowTime,0)
						ELSE IF(@webdomains = '')
							UPDATE GXGlobalParam SET VALUE = @httpsWebUrl WHERE NAME = 'webDomainsWhiteList'
						ELSE
							UPDATE GXGlobalParam SET VALUE = @webdomains + ', '+@httpsWebUrl WHERE NAME = 'webDomainsWhiteList'
					END
				END
			END
		END
		IF (@operationType = 4) --DELETE
		BEGIN
			IF(@onPrimCompanyId = 0)
			BEGIN
SET @csClientId = ISNULL((SELECT componentNameId FROM App_ClientProp WHERE attrName = 'Service commcell end point' AND attrVal = @redirectUrl), 0)
				IF(@csClientId = 0)
				BEGIN
					SET @errorCode = 1
					SET @errorString = 'Failed to delete cloud service details, redirectUrl not present'
					GOTO SEND_RESPONSE
				END
				-- get CSID to delete from app_commcell
				SET @csID = ISNULL((SELECT id FROM App_Commcell WHERE clientId = @csClientId), 0)
DELETE FROM UMSecurityAssociations WHERE entityType1 = 194 and entityId1 = @csID
				DELETE from APP_ClientProp WHERE componentNameId = @csClientID
				DELETE FROM App_Client WHERE id = @csClientID
				DELETE FROM APP_CommCellProp WHERE CommCellId = @csID
				DELETE FROM App_Commcell WHERE id = @csID
				--Update commcellRole for current CS
IF EXISTS(SELECT 1 FROM App_CommcellProp WHERE CommcellId = 2 and ((commcellType & 32) = 32))
				BEGIN
UPDATE APP_CommCellProp SET CommcellType = CommcellType & ~32 WHERE CommCellId = 2
				END
				--Delete on-prim commcellRole for current CS in GXGlobalParam
IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'nMultiCommcellRole' and ((value & 32) = 32))
				BEGIN
UPDATE GXGlobalParam SET value = value & ~32 WHERE name = 'nMultiCommcellRole'
				END
				-- remove "METALLIC":true from completed setups when unlink & set cloud service details from rest API
SET @cid = (select id from GXGlobalParam where name = 'completedSetups' and CHARINDEX(','+@setup, value)>0)
				IF (@cid > 0)
					update gxglobalparam set value = (REPLACE(value, ','+@setup, '')) where id = @cid
				ELSE
				BEGIN
SET @cid = (select id from GXGlobalParam where name = 'completedSetups' and CHARINDEX(@setup, value)>0)
					IF(@cid > 0)
						update gxglobalparam set value = (REPLACE(value, @setup, '')) where id = @cid
				END
				SET @removeFromWebDomains = 1
			END
			ELSE IF(@onPrimCompanyId > 0)
			BEGIN
SET @csClientId = ISNULL((SELECT top 1 attrValInt FROM App_CompanyProp WHERE attrName = 'Cloud Service ClientId' AND componentNameId = @onPrimCompanyId), 0)
				IF(@csClientId = 0)
				BEGIN
					SET @errorCode = 1
					SET @errorString = 'Failed to delete cloud service details, cloud service not present'
					GOTO SEND_RESPONSE
				END
				DELETE FROM App_CompanyProp WHERE componentNameId = @onPrimCompanyId AND attrname IN
('Cloud Service Company Alias','Cloud Service Company Guid','Cloud Service Company Name','Cloud Service ClientId','Service commcell end point')
				-- get CSID to delete from app_commcell
				SET @csID = ISNULL((SELECT id FROM App_Commcell WHERE clientId = @csClientId), 0)
DELETE FROM UMSecurityAssociations WHERE entityType1 = 194 and entityId1 = @csID and userOrGroupId = @onPrimCompanyId and isUser = 2
DELETE FROM APP_ComponentProp where componentType = 1034 and  componentId = @localAppId and propertyTypeId = 61 and longlongVal = @onPrimCompanyId and modified = 0
IF NOT EXISTS(select 1 from app_companyprop where attrName = 'Cloud Service ClientId' and attrValInt = @csClientID)
				BEGIN
					DELETE from APP_ClientProp WHERE componentNameId = @csClientID
					DELETE FROM App_Client WHERE id = @csClientID
					DELETE FROM APP_CommCellProp WHERE CommCellId = @csID
					DELETE FROM App_Commcell WHERE id = @csID
					--Update commcellRole for current CS
IF EXISTS(SELECT 1 FROM App_CommcellProp WHERE CommcellId = 2 and ((commcellType & 32) = 32))
					BEGIN
UPDATE APP_CommCellProp SET CommcellType = CommcellType & ~32 WHERE CommCellId = 2
					END
IF EXISTS(SELECT 1 FROM App_CommcellProp WHERE CommcellId = @csID and ((commcellType & 16) = 16))
					BEGIN
UPDATE APP_CommCellProp SET CommcellType = CommcellType & ~16 WHERE CommCellId = @csID
					END
					--Delete on-prim commcellRole for current CS in GXGlobalParam
IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'nMultiCommcellRole' and ((value & 32) = 32))
					BEGIN
UPDATE GXGlobalParam SET value = value & ~32 WHERE name = 'nMultiCommcellRole'
					END
					-- remove "METALLIC":true from completed setups when unlink & set cloud service details from rest API
SET @cid = (select id from GXGlobalParam where name = 'completedSetups' and CHARINDEX(','+@setup, value)>0)
					IF (@cid > 0)
						UPDATE gxglobalparam set value = (REPLACE(value, ','+@setup, '')) where id = @cid
					ELSE
					BEGIN
SET @cid = (select id from GXGlobalParam where name = 'completedSetups' and CHARINDEX(@setup, value)>0)
						IF(@cid > 0)
							UPDATE gxglobalparam set value = (REPLACE(value, @setup, '')) where id = @cid
					END
					SET @removeFromWebDomains = 1
				END
			END
			IF (@removeFromWebDomains = 1)
			BEGIN
				SELECT @hostName = LOWER(DBO.GetHostnameFromUrl(@redirectUrl))
				IF @hostName IS NOT NULL AND @hostName <> ''
				BEGIN
					SET @httpsWebUrl = 'https://' + @hostname +':443'
					IF EXISTS( SELECT 1 from GXGlobalParam where name = 'webDomainsWhiteList' and value like '%'+@httpsWebUrl+'%')
					BEGIN
						SET @webdomains = (SELECT VALUE from GXGlobalParam where name = 'webDomainsWhiteList' and modified = 0)
						IF OBJECT_ID('tempdb.dbo.#webdomainsDB') IS NOT NULL DROP TABLE #webdomainsDB
							CREATE TABLE #webdomainsDB( webDomainUrl NVARCHAR(MAX))
							INSERT INTO #webdomainsDB
							SELECT Data FROM dbo.split(@webdomains, ',')
							DELETE wDB FROM #webdomainsDB wDB where LOWER(wDB.webDomainUrl) = LOWER(@httpsWebUrl)
							SELECT @webdomains =  ISNULL(STUFF((SELECT ', ' + CONVERT(NVARCHAR(MAX), webDomainUrl) FROM #webdomainsDB FOR xml path('')), 1, 1, ''), '')
							UPDATE GXGlobalParam SET VALUE = @webdomains WHERE NAME = 'webDomainsWhiteList'
					END
				END
			END
		END
	END TRY
	BEGIN CATCH
		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
			PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
			ERROR MESSAGE: ' + ERROR_MESSAGE() + '
			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @errorCode= ERROR_NUMBER()
			SET @errorString = ERROR_MESSAGE()
	END CATCH
SEND_RESPONSE:
SET @xmlText = (SELECT  @errorCode AS '@errorCode', @errorString AS '@errorString'
                 FOR xml path('App_GenericEntityResponse'), TYPE)
IF(@errorCode<>0)
BEGIN
	ROLLBACK TRANSACTION
END
ELSE
BEGIN
	COMMIT TRANSACTION
END
SELECT @xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_SetCloudServiceDetails')
	delete from GxQscripts where name = 'MCC_SetCloudServiceDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_SetCloudServiceDetails')
	delete from GXDBVersions where aliasname = 'MCC_SetCloudServiceDetails'
GO

insert into GXDBVersions values(2, 'MCC_SetCloudServiceDetails',  '00000000000000000000', 'MCC_SetCloudServiceDetails', '00000000000000000000')
GO

