

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_ServiceCommcellCleanup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MCC_ServiceCommcellCleanup.sp,v $ $Id: MCC_ServiceCommcellCleanup.sp,v 1.1.2.1 2020/08/15 23:46:24 nramalingam Exp $";
--
--  +================================================================================================+
--  |   Procedure:  MCC_ServiceCommcellCleanup()
--  |
--  | Description:  SP for cleaning up db entries of service commcell client during unregister
--  |
--  |       Input:  client entity XML containing service commcell client id
--  |
--  |      Output:  Generic response
--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	SP for cleaning up db entries of service commcell client during unregister
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MCC_ServiceCommcellCleanup')
BEGIN
	print '>>> Drop Stored Procedure: MCC_ServiceCommcellCleanup <<<'
	drop procedure MCC_ServiceCommcellCleanup
END
IF EXISTS (select * from GxQscripts where name='MCC_ServiceCommcellCleanup')
	delete from GxQscripts where name = 'MCC_ServiceCommcellCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_ServiceCommcellCleanup')
	delete from GXDBVersions where aliasname = 'MCC_ServiceCommcellCleanup'
GO
print '... Creating Procedure: MCC_ServiceCommcellCleanup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_ServiceCommcellCleanup
  @i_xml XML	
AS
SET NOCOUNT ON
DECLARE @serviceCommcellClientId INT = 0
DECLARE @errorCode int = 0
DECLARE @errorMsg NVARCHAR(510)
BEGIN TRY
	BEGIN TRANSACTION
	SET @serviceCommcellClientId = (SELECT  ref.value('(serviceCommcellClient/@clientId)[1]', 'int') FROM    @i_xml.nodes('Api_CleanUpServiceCommcellClientEntry') R ( ref ))
	IF (@serviceCommcellClientId IS NULL OR @serviceCommcellClientId = 0 )
    BEGIN
		RAISERROR ('ServiceCommcell Client Id is mandatory to proceed with cleanup.', 16, 1 )
	END
	-- webpackageInfo
	IF OBJECT_ID('tempdb.dbo.#WebpackageAvailabilityTbl') is not null
		DROP TABLE #WebpackageAvailabilityTbl
	CREATE TABLE #WebpackageAvailabilityTbl (clientId int, webPackageClientInfo XML DEFAULT(NULL))
	INSERT INTO #WebpackageAvailabilityTbl
	SELECT ClientId,attrVal from APP_ExtendedProperties(nolock) WHERE attrname=N'WebPackageClientInfo'
	UPDATE #WebpackageAvailabilityTbl SET webPackageClientInfo.modify('delete (/App_WebPackageAvailableClientInfoList/webPackageAvailableClients[serviceCommcellClient/@clientId=sql:variable("@serviceCommcellClientId")])')
    UPDATE EX SET attrVal = CAST(WP.webPackageClientInfo AS NVARCHAR(MAX))
	FROM APP_ExtendedProperties EX
	INNER JOIN #WebpackageAvailabilityTbl WP
	ON EX.clientId = WP.clientId AND attrname=N'WebPackageClientInfo'
	-- Clean up prop table
	DELETE APP_ClientProp WHERE attrName IN (   N'ServiceCommcell WebServiceUrl',
												N'ServiceCommcell WebServerport',
												N'ServiceCommcell WebServerClientId',
												N'ServiceCommcell WebServerName',
												N'ServiceCommcell WebServerHostName',
												N'ServiceCommcell Release',
												N'ServiceCommcell SP',
												N'ServiceCommcell Hotfix',
												N'ServiceCommcell TransactionID',
												N'ServiceCommcell SPVersionInfoText',
												N'ServiceCommcell CreUrl',
												N'ServiceCommcell CrePort',
												N'ServiceCommcell CreClientId',
												N'ServiceCommcell CreClientName',
												N'ServiceCommcell CreHostName',
												N'ServiceCommcell TppmWebServerport',
												N'IsGlobalWebConsoleConfigured')
	AND componentNameId = @serviceCommcellClientId AND modified =0
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMsg ='Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END  CATCH
SELECT  @errorCode as '@errorCode',
        @errorMsg as  '@errorMessage'
FOR  XML PATH('Api_GenericResp'),TYPE
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_ServiceCommcellCleanup')
	delete from GxQscripts where name = 'MCC_ServiceCommcellCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_ServiceCommcellCleanup')
	delete from GXDBVersions where aliasname = 'MCC_ServiceCommcellCleanup'
GO

insert into GXDBVersions values(2, 'MCC_ServiceCommcellCleanup',  '00010001000200010000', 'MCC_ServiceCommcellCleanup', '00010001000200010000')
GO

