

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_ServiceCS_preProcessUpdateEntitySecurityXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MCC_ServiceCS_preProcessUpdateEntitySecurityXML.sp,v $ $Id: MCC_ServiceCS_preProcessUpdateEntitySecurityXML.sp,v 1.1.2.1 2019/09/30 16:54:20 saggarwal Exp $";
--
--  +========================================================================+
--  | Stored Procedure: MCC_ServiceCS_preProcessUpdateEntitySecurityXML
--  |
--  | Description:
--  | This sp takes role properties input from Router CS and updateEntitySecurityXML done on Service Commcell. updateEntitySecurityXMl will have all the ids from global CS, which should be updated to local.
--	|  It will create roles and permissions from i_RoleXMl and update the role id in updateSEcurityXMl
--  |	properties
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Seema  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MCC_ServiceCS_preProcessUpdateEntitySecurityXML')
BEGIN
	print '>>> Drop Stored Procedure: MCC_ServiceCS_preProcessUpdateEntitySecurityXML <<<'
	drop procedure MCC_ServiceCS_preProcessUpdateEntitySecurityXML
END
IF EXISTS (select * from GxQscripts where name='MCC_ServiceCS_preProcessUpdateEntitySecurityXML')
	delete from GxQscripts where name = 'MCC_ServiceCS_preProcessUpdateEntitySecurityXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_ServiceCS_preProcessUpdateEntitySecurityXML')
	delete from GXDBVersions where aliasname = 'MCC_ServiceCS_preProcessUpdateEntitySecurityXML'
GO
print '... Creating Procedure: MCC_ServiceCS_preProcessUpdateEntitySecurityXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_ServiceCS_preProcessUpdateEntitySecurityXML
  @i_RoleXML XML,
  @updateSecurityXML XML
AS
  DECLARE @oRolesXMLText XML
DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(1024)
	SET @errorCode = 0						--be optimistic
	SET @errorString = 'Successful'
	DECLARE @nowtime AS INT
	SET @nowtime = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @invalidChar NVARCHAR(MAX) = N''
	DECLARE @localeId INT
	DECLARE @processHiddenPermissions INT =0
	DECLARE @isServiceCommcell INT=0
	--Read inputs
	DECLARE @associationsOperationType AS INT
	SET @associationsOperationType = ISNULL((SELECT ref.value('@associationsOperationType','INT') AS role
										FROM @updateSecurityXML.nodes('App_UpdateSecurityAssociationRequest/securityAssociations') R (ref)),0)
	DECLARE @entityAssociatedXML XML =  (SELECT Entity.query('.')
        FROM @updateSEcurityXMl.nodes('App_UpdateSecurityAssociationRequest/entityAssociated') AS Input(Entity))
	DECLARE @inputTempTable TABLE
	(
		userId INT,
		userName NVARCHAR(MAX),
		userGroupId INT,
		userGroupName NVARCHAR(MAX),
		providerId INT,
		providerName NVARCHAR(MAX),
		roleId INT,
		roleName NVARCHAR(MAX),
		permissionId INT,
		permissionName NVARCHAR(MAX),
		customRoleXML XML
	)
	INSERT INTO @inputTempTable (userId, userName, userGroupId, userGroupName, providerId, providerName, roleId, roleName, permissionId, permissionName)
		SELECT ISNULL(UG.value('(@userId)[1]', 'INT'), 0),
			   ISNULL(UG.value('(@userName)[1]', 'NVARCHAR(MAX)'), N''),
			   CASE WHEN UG.value('(@userGroupId)[1]', 'INT') IS NOT NULL THEN UG.value('(@userGroupId)[1]', 'INT')
					WHEN UG.value('(@groupId)[1]', 'INT') IS NOT NULL THEN UG.value('(@groupId)[1]', 'INT')
					ELSE 0
			   END,
			   CASE WHEN UG.value('(@userGroupName)[1]', 'NVARCHAR(MAX)') IS NOT NULL THEN UG.value('(@userGroupName)[1]', 'NVARCHAR(MAX)')
					WHEN UG.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)') IS NOT NULL THEN UG.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)')
					ELSE N''
			   END,
			   ISNULL(UG.value('(@providerId)[1]', 'INT'), 0),
			   ISNULL(UG.value('(@providerDomainName)[1]', 'NVARCHAR(MAX)'), N''),
			   ISNULL(R.value('(@roleId)[1]', 'INT'), 0),
			   ISNULL(R.value('(@roleName)[1]', 'NVARCHAR(MAX)'), N''),
			   0,
			   N''
		FROM @updateSecurityXML.nodes('App_UpdateSecurityAssociationRequest/securityAssociations/associations/userOrGroup') AS Input(UG)
		CROSS APPLY
		Input.UG.nodes('../properties/role') AS Role(R)
	--If categoryPermissionXMl is user/userGroup combination than we should not process individual permission for same. This is needed until we have not change all application layer code.
DECLARE @mapRoleId INT=(SELECT TOP 1 id from UMROles where flags& 2048<>0 )
	--MultiCommcell feature
				--its a local CS, so request will have userId, groupId , roleId of global CS
				INSERT INTO UMUsers([name]
                ,[description]
                ,[login]
                ,[password]
                ,[email]
                ,[datePasswordSet]
                ,[dateExpires]
                ,[policy]
                ,[enabled]
                ,[flags]
                ,[modified]
                ,[pVer]
                ,[Pager]
                ,[lastLogInTime]
                ,[credSetTime]
                ,[umDSproviderId]
                ,[userGuid]
                ,[origUserGuid])
	SELECT  userName,'From Global CS',userName,'dummy password','update later',0,0,0,1,1,0,0,0,0,0,providerId,NewId(),''
	from
	(SELECT DISTINCT userNAme,Prov.id as providerId FROM @inputTempTable Tbl JOIN UMDSProviders Prov ON  SUBSTRING(userName, 1, CHARINDEX('\', userName, 1)-1) = Prov.domainName LEFT  JOIN UMUsers Users on Users.login=userName
	where USers.id IS NULL and Tbl.userName <> N''
	and CHARINDEX('\', userName, 1)<>0) tbl
		 INSERT INTO UMUsers([name]
                ,[description]
                ,[login]
                ,[password]
                ,[email]
                ,[datePasswordSet]
                ,[dateExpires]
                ,[policy]
                ,[enabled]
                ,[flags]
                ,[modified]
                ,[pVer]
                ,[Pager]
                ,[lastLogInTime]
                ,[credSetTime]
                ,[umDSproviderId]
                ,[userGuid]
                ,[origUserGuid])
	SELECT DISTINCT userName,'From Global CS',userName,'dummy password','update later',0,0,0,1,1,0,0,0,0,0,0,NewId(),''
		from
	(SELECT DISTINCT userNAme FROM @inputTempTable Tbl  LEFT  JOIN UMUsers Users on Users.login=userName
	where USers.id IS NULL and Tbl.userName <> N''
	and CHARINDEX('\', userName, 1)=0) tbl
		 INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, email, GUID, umdsProviderId, origCCId)
 SELECT 1 , 0, 0, 1,userGroupName, 'Auto-Created group for Multicommcell', '', NEWID(), PROVIDERiD, 2
 from
 (select distinct userGroupName,PROVIDERiD
 FROM @inputTempTable member LEFT JOIN UMGroups UG  on member.userGroupName=UG.name  LEFT JOIN UMDSpRoviders P ON P.id=member.providerId Or P.domainName=member.providerName
 WHERE UG.id is NULL and member.userGroupName <> N'') AS TBL
	DELETE tbl
	FrOM @inputTempTable tbl
	WHERE permissionId<>0 and exists( SELECT 1 FROM @inputTempTable tbl2 WHERE  tbl.userId=tbl2.userId and tbl.userGroupId=tbl2.userGroupId and tbl2.customRoleXML.exist('categoryPermission')<>0)
	UPDATE Tbl
	SET Tbl.userId = Users.id
	FROM @inputTempTable Tbl INNER JOIN UMUsers Users
	ON Tbl.userName = Users.login
	WHERE Tbl.userName <> N'' AND Tbl.userID <= 0
	--user groups that came as external group entity
	UPDATE Tbl
	SET Tbl.userGroupId = Groups.id
	FROM @inputTempTable Tbl INNER JOIN UMGroups Groups
	ON Tbl.userGroupName = Groups.name AND Tbl.providerId = Groups.umdsProviderId
	WHERE Tbl.userGroupName <> N'' AND CHARINDEX('\', userGroupName, 1) <= 0 AND Tbl.userGroupId <= 0
	--user groups that came as user group entity
	UPDATE Tbl
	SET Tbl.userGroupId = Groups.id, Tbl.providerID = Groups.umdsProviderID
	FROM @inputTempTable Tbl INNER JOIN UMDSProviders Prov
	ON SUBSTRING(userGroupName, 1, CHARINDEX('\', userGroupName, 1)-1) = Prov.domainName
	INNER JOIN UMGroups Groups
	ON SUBSTRING(userGroupName, CHARINDEX('\', userGroupName, 1)+1, LEN(userGroupName)) = Groups.name AND Prov.id = Groups.umdsProviderId
	WHERE Tbl.userGroupName <> N'' AND CHARINDEX('\', userGroupName, 1) > 0 AND Tbl.userGroupId <= 0
	--if AD users/groups are hidden and coming in input xml, then the caller wants to explicitly add them - meaning unhide them.
	UPDATE UMUsers
SET flags = flags & ~(CAST(0x004 AS INT))
	FROM @inputTempTable
	WHERE id = userID AND userID <> 0 AND UMUsers.umdsProviderID <> 0
	UPDATE UMGroups
SET groupflags = groupflags & ~(CAST(0x0020 AS INT))
	FROM @inputTempTable
	WHERE id = userGroupId AND userGroupId <> 0 --AND UMGroups.umdsProviderID IN (SELECT FROM UMDSProviders WHERE serviceType = UMDS_PROVIDER_ACTIVE_DIR)
	--Roles
	DECLARE @RoleTBl TABLE (globalRoleId int,localRoleId INT,roleNAme nvarchar(MAX))
	INSERT INTO @RoleTbl(globalRoleId,roleNAme)
	SELECT ref.value('@roleId','INT'),
			ref.value('@roleName','NVARCHAR(MAX)')
	FROM @i_RoleXML.nodes('Security_GetRolesPropertiesResponse/roleProperties/role')R (ref)
				INSERT INTO UMRoles (commcellId,name,description,disabled,isPrivate,flags,ownerId,created,modified,GUID,xmlProperties,capabilitiesBitMask,permissionsString)
				SELECT DISTINCT 2,roleName,'Inherited from CS',0,1,1,-1,1437163696,0,NEWID(),'',0,''
				FROM @RoleTbl LEFT JOIN UMRoles ON name=roleName
				WHERE name is NULL
				INSERT INTO UMRoleProp (componentNameId,attrName,attrType,attrVal,created,modified)
				SELECT R.id,'Global roleId',1,globalRoleId,1,0
				FROM @RoleTbl JOIN UMRoles R on R.name =roleNAme
				LEFT JOIN UMRoleProp ON attrVal=R.id and attrName='Global roleId'
				WHERE attrVal is null
				UPDATE TBL
				set localRoleId=id
				FROM @RoleTBl TBL JOIN UMRoles ON
				name=roleName
	UPDATE TBL
	set roleId=localRoleId
	FROM @inputTempTable TBL JOIN @RoleTBl ON globalRoleId=roleId
	if object_id('tempdb.dbo.#categoryPermissionAssociationFromRouterCS') is not null
        DROP TABLE #categoryPermissionAssociationFromRouterCS
	   CREATE TABLE #categoryPermissionAssociationFromRouterCS
    (
        roleId INT,
        [categoryId] INT,
        [permissionId] INT
    )
	 	INSERT INTO #categoryPermissionAssociationFromRouterCS (roleId,categoryId,permissionId)
		SELECT ISNULL(UG.value('(role/@roleId)[1]', 'INT'), 0),
		ISNULL(R.value('(@categoryId)[1]', 'INT'), 0)	,
			ISNULL(R.value('(@permissionId)[1]', 'INT'), 0)
		FROM @i_RoleXML .nodes('Security_GetRolesPropertiesResponse/roleProperties') AS Input(UG)
		CROSS APPLY
		Input.UG.nodes('categoryPermission/categoriesPermissionList') AS Role(R)
		UPDATE TBL
		set TBL.roleId=localRoleId
		FROM #categoryPermissionAssociationFromRouterCS TBL JOIN @RoleTBl ON globalRoleId=TBL.roleId
		DELETE FROM UMRolesPermissions where roleID in (SELECT roleId from #categoryPermissionAssociationFromRouterCS)
		DELETE FROM UMRolesWithPermissionsExpanded where roleId in (SELECT roleId from #categoryPermissionAssociationFromRouterCS)
		INSERT INTO UMRolesPermissions( roleId,hierarchyLevel,categoryId,permissionId,excludeCategory,excludePermission)
		SELECT roleId, 122,categoryId, permissionId,0,0 FROM #categoryPermissionAssociationFromRouterCS
		INSERT INTO UMRolesWithPermissionsExpanded( roleId,categoryId,permissionId)
		SELECT roleId,categoryId, permissionId FROM #categoryPermissionAssociationFromRouterCS
	--now frame update security XML with updated values
	SET @updateSecurityXML= (SELECT  (SELECT @entityAssociatedXML.query('.') FOR XML PATH(''),TYPE),
								(SELECT @associationsOperationType as '@associationsOperationType',
									 (SELECT (SELECT CASE WHEN userId <> 0 THEN userId END AS '@userId',
                                   CASE WHEN userGroupId <> 0 THEN userGroupId END AS '@userGroupId',
                                   CASE WHEN userId <> 0 THEN userName END AS '@userName',
                                   CASE WHEN userGroupId <> 0 THEN userGroupName END AS '@userGroupName',
                                   CASE WHEN providerId <> 0 THEN providerId END AS '@providerId',
                                   CASE WHEN providerId <> 0 THEN providerName END AS '@providerDomainName',
                                       CASE WHEN userId <> 0 THEN 13 WHEN userGroupId <> 0 THEN 15 ELSE 61 END AS '@_type_'
                            FOR XML PATH ('userOrGroup'), TYPE),
							(SELECT
                                 (SELECT roleId AS '@roleId',
                                        roleName AS '@roleName',
                                       120  AS '@_type_'
                                FOR XML PATH ('role'), TYPE)
                            FOR XML PATH ('properties'), TYPE)
                        FROM @inputTempTable
                        FOR XML PATH ('associations'), TYPE)
						FOR XML PATH('securityAssociations'),TYPE)
						FOR XML PATH('App_UpdateSecurityAssociationRequest'))
	END_PROCESSING:
SELECT @updateSecurityXML as 'oRolesXMLText'
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_ServiceCS_preProcessUpdateEntitySecurityXML')
	delete from GxQscripts where name = 'MCC_ServiceCS_preProcessUpdateEntitySecurityXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_ServiceCS_preProcessUpdateEntitySecurityXML')
	delete from GXDBVersions where aliasname = 'MCC_ServiceCS_preProcessUpdateEntitySecurityXML'
GO

insert into GXDBVersions values(2, 'MCC_ServiceCS_preProcessUpdateEntitySecurityXML',  '00010001000200010000', 'MCC_ServiceCS_preProcessUpdateEntitySecurityXML', '00010001000200010000')
GO

