

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_SaveRedirectsForRouterCS.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_SaveRedirectsForRouterCS')
BEGIN
	print '>>> Drop Stored Procedure: MCC_SaveRedirectsForRouterCS <<<'
	drop procedure MCC_SaveRedirectsForRouterCS
END
IF EXISTS (select * from GxQscripts where name='MCC_SaveRedirectsForRouterCS')
	delete from GxQscripts where name = 'MCC_SaveRedirectsForRouterCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_SaveRedirectsForRouterCS')
	delete from GXDBVersions where aliasname = 'MCC_SaveRedirectsForRouterCS'
GO
print '... Creating Procedure: MCC_SaveRedirectsForRouterCS'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_SaveRedirectsForRouterCS
  @redirectRulesXML XML,
  @commcellGUID nvarchar(255),
  @isRouterCommcellGlobalIDP INT,
  @iUserId INT,
  @remoteUserName nvarchar(255),
  @redirectUrl varchar(255)
AS
BEGIN TRY
DECLARE @rulesTbl table(redirectRule nvarchar(255),ruleType int)
DECLARE @errorStr nvarchar(max)=''
DECLARE @errorCode INT = 0
DECLARE @commcellId INT = 0
DECLARE @nowTime            INT
DECLARE	@multicommcellUserId INT
DECLARE @localcommcellAppId INT = 0
DECLARE @viewRoleID INT = (Select id from UMRoles where name='View')
DECLARE @LocalCommcellRole INT = 0
DECLARE @RemoteCommcellRole INT = 0
DECLARE @remoteUserId INT = 0
DECLARE @WebEndpointsXML XML = NULL
DECLARE @shouldAllowAllUsers INT = @isRouterCommcellGlobalIDP
DECLARE @allowRouterPlusPlus nvarchar(10) = 'false'
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
Set @commcellId = (Select id from APP_CommCell where csGUID=@commcellGUID)
Set @localcommcellAppId = (Select top 1 id from App_ThirdPartyApp where appType = 4)
SET @remoteUserId = ISNULL((SELECT id from UMUSERS where login = @remoteUserName),0)
--Enable local Multicommcell App if it's not enabled.
Update App_ThirdPartyApp set isEnabled = 1 where id = @localcommcellAppId and appType = 4
INSERT into @rulesTbl
SELECT R.ref.query('.').value('(/rules/@val)[1]','nvarchar(255)'),1 from @redirectRulesXML.nodes('App_RedirectRules/rules') R(ref)
UNION
SELECT R.ref.query('.').value('(/domains/@val)[1]','nvarchar(255)'),2 from @redirectRulesXML.nodes('App_RedirectRules/domains') R(ref)
DELETE from APP_ComponentProp where componentType = 1047 and componentId = @commcellId and propertyTypeId in (1,2)
INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longval,longlongVal,stringVal,created,modified)
( Select 1047,@commcellId,ruleType,0,0,0,redirectRule, @nowTime, 0 from @rulesTbl)
IF NOT EXISTS (select 1 from umusers where login = '_+_MulticommcellPublicUser_')
BEGIN
INSERT INTO UMUsers(
			[name]
            ,[description]
            ,[login]
            ,[password]
            ,[email]
            ,[datePasswordSet]
            ,[dateExpires]
            ,[policy]
            ,[enabled]
            ,[flags]
            ,[modified]
            ,[pVer]
            ,[Pager]
            ,[lastLogInTime]
            ,[credSetTime]
            ,[umDSproviderId]
            ,[userGuid]
            ,[origUserGuid])
            VALUES(
'Multicommcell Public User', --name
'Auto-Created user for Multicommcell',
'_+_MulticommcellPublicUser_', -- login
            'Password Disabled',
            'No Email',--email
            0,--datePWDset
            0,--dateExpires
            0,--policy
            1,--enabled
            1|2|4,--flags
            0,--modified
            0,--pVer
            0,--Pager
            0,--lastLogInTime
            0,--credSetTime
            0,--umDSproviderId
            NEWID(),--userGUID
            ''--origUserGuid
            )
			-- Giving view-all permission on users for this user
END
IF @shouldAllowAllUsers = 0
SET @allowRouterPlusPlus = ISNULL((select top 1 value from APP_AdvanceSettings where keyName = 'showRouterForServiceCommcell' and relativePath = 'WebConsole' and type = 'BOOLEAN' and enabled = 1 and deleted = 0),'false')
IF @shouldAllowAllUsers = 0 AND @allowRouterPlusPlus = 'true'
	SET @shouldAllowAllUsers = 1
SET @multicommcellUserId = (SELECT id from umusers where login = '_+_MulticommcellPublicUser_')
IF NOT EXISTS (SELECT 1 from UMSecurityAssociations where roleid = @viewRoleID and userOrGroupId = @multicommcellUserId and isUser=1 and entityType1 = 13)
BEGIN
	INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, isCreator, authorId)
VALUES (@viewRoleID, 0, @multicommcellUserId, 1, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1)
END
IF @shouldAllowAllUsers = 1 AND NOT EXISTS (SELECT 1 from UMSecurityAssociations where roleid = @viewRoleID and userOrGroupId = @iUserId and isUser=1 and entityType1 = 194 and entityId1 = @commcellId)
BEGIN
	INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator)
VALUES(@viewRoleID, 0, @iUserId, 1,194, @commcellId, 0)
END
IF @shouldAllowAllUsers = 1 AND @remoteUserId > 0 AND NOT EXISTS (SELECT 1 from UMSecurityAssociations where roleid = @viewRoleID and userOrGroupId = @remoteUserId and isUser=1 and entityType1 = 194 and entityId1 = @commcellId)
BEGIN
	INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator)
VALUES(@viewRoleID, 0, @remoteUserId, 1,194, @commcellId, 0)
END
IF NOT EXISTS (SELECT 1 from APP_ComponentProp where componentType = 1034 and propertyTypeId = 13 and longlongVal=@multicommcellUserId and componentId = @localcommcellAppId )
BEGIN
	INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,created,modified)
VALUES(1034,@localcommcellAppId,13,1,0,@multicommcellUserId,@nowTime,0)
END
IF @shouldAllowAllUsers = 1 AND NOT EXISTS (select 1 from APP_ComponentProp WHERE componentId = @localCommcellAppId and componentType = 1034 and propertyTypeId = 12 and longlongVal = 0)
BEGIN
	INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,created,modified)
VALUES(1034, @localCommcellAppId, 12, 0, 0, 0, @nowTime, 0)
END
IF NOT EXISTS (Select 1 from App_componentprop where componentType=1048 and propertyTypeId=1)
BEGIN
	INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,created,modified)
VALUES(1048, 2, 1, 1, 1, @isRouterCommcellGlobalIDP, @nowTime, 0)
END
IF EXISTS( Select 1 from APP_ComponentProp where componentId = @commcellId and componentType = 1048 and propertyTypeId = 2 and longVal = 1 and longlongVal <> @isRouterCommcellGlobalIDP)
BEGIN
Delete from APP_ComponentProp Where componentType = 1049 and componentId=@commcellId and propertyTypeId = 1
END
IF NOT EXISTS (Select 1 from App_componentprop where componentType=1048 and componentId=@commcellId)
BEGIN
	INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,created,modified)
VALUES(1048, @commcellId, 2, 1, 1, @isRouterCommcellGlobalIDP, @nowTime, 0)
END
ELSE
BEGIN
UPDATE APP_ComponentProp set longVal = 1 , longlongVal = @isRouterCommcellGlobalIDP where componentType=1048 and propertyTypeId=2 and componentId=@commcellId
END
IF(@isRouterCommcellGlobalIDP = 1)
BEGIN
SET @LocalCommcellRole = 4
SET @RemoteCommcellRole = 8
END
ELSE
BEGIN
SET @LocalCommcellRole = 1
SET @RemoteCommcellRole = 2
END
IF LEN(@redirectUrl) > 0
	SET @WebEndpointsXML = (SELECT   @redirectUrl as 'webconsoleUrls'  for xml path (''), root('App_WebEndPoints'))
IF EXISTS (SELECT 1 FROM APP_CommCellProp WHERE CommCellId = @commcellId)
BEGIN
		UPDATE APP_CommCellProp SET CommcellType = CommcellType | @RemoteCommcellRole,WebEndpoints =@WebEndpointsXML   WHERE CommCellId = @commcellId
END
ELSE
BEGIN
		INSERT into APP_CommCellProp (CommCellId,LastEventID,LastEventUpdateTime,LastJobUpdateTime,LastCompletedJobUpdateTime,LastMaxChunkId,CommcellType,WebEndpoints)
					VALUES(@commcellId,0,NULL,NULL,NULL,0,@RemoteCommcellRole,@WebEndpointsXML)
END
IF EXISTS (SELECT 1 FROM APP_CommCellProp WHERE CommCellId = 2)
BEGIN
UPDATE APP_CommCellProp SET CommcellType = CommcellType | @LocalCommcellRole , WebEndpoints = NULL WHERE CommCellId = 2
END
ELSE
BEGIN
		INSERT into APP_CommCellProp (CommCellId,LastEventID,LastEventUpdateTime,LastJobUpdateTime,LastCompletedJobUpdateTime,LastMaxChunkId,CommcellType,WebEndpoints)
VALUES(2,0,NULL,NULL,NULL,0,@LocalCommcellRole,NULL)
END
-- insert/update GXGlobalParam: nMultiCommcellRole
IF EXISTS (SELECT 1 from GXGlobalParam where name = 'nMultiCommcellRole')
BEGIN
UPDATE GXGlobalParam SET value = value | @LocalCommcellRole WHERE name = 'nMultiCommcellRole'
END
ELSE
BEGIN
	INSERT INTO GXGlobalParam (name, value, created, modified)
VALUES('nMultiCommcellRole', @LocalCommcellRole, @nowTime, 0)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @errorCode =  ERROR_NUMBER()
END CATCH
PROC_EXIT:
Select @errorCode as '@errorCode',@errorStr as '@errorMessage' for xml path('App_GenericResp')
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_SaveRedirectsForRouterCS')
	delete from GxQscripts where name = 'MCC_SaveRedirectsForRouterCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_SaveRedirectsForRouterCS')
	delete from GXDBVersions where aliasname = 'MCC_SaveRedirectsForRouterCS'
GO

insert into GXDBVersions values(2, 'MCC_SaveRedirectsForRouterCS',  '00000000000000000000', 'MCC_SaveRedirectsForRouterCS', '00000000000000000000')
GO

