

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_PullServiceCommcellWebPackage.sp] ---------- 

--  +====================================================================================================
--  | Stored Procedure: This stored procedure is executed by Master Commserver and pushes worktoken
--  |					to  associated webconsoles  to pull web package from service commcell.
--  |					Before this stored procedure is called service commcell should be registered
--  |                   and its webserver properties, tppm port confgured and available on Master CS.
--  |
--  |					returns GenericResponse
--  +====================================================================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MCC_PullServiceCommcellWebPackage')
BEGIN
	print '>>> Drop Stored Procedure: MCC_PullServiceCommcellWebPackage <<<'
	drop procedure MCC_PullServiceCommcellWebPackage
END
IF EXISTS (select * from GxQscripts where name='MCC_PullServiceCommcellWebPackage')
	delete from GxQscripts where name = 'MCC_PullServiceCommcellWebPackage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_PullServiceCommcellWebPackage')
	delete from GXDBVersions where aliasname = 'MCC_PullServiceCommcellWebPackage'
GO
print '... Creating Procedure: MCC_PullServiceCommcellWebPackage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_PullServiceCommcellWebPackage
  @webserverInfo XML
AS
    SET NOCOUNT ON
	DECLARE @errorCode int = 0
	DECLARE @errorMsg NVARCHAR(1024)
BEGIN TRY
-- enable transaction
	DECLARE @webconsolePackageWindows varchar(50)
	DECLARE @webconsolePackageUnix varchar(50)
	DECLARE @webserverClientIdParam varchar(50)
	DECLARE @webserverInfoXml XML
	DECLARE @webServiceUrl NVARCHAR(2048)
	DECLARE @webServerport INT
	DECLARE @webServerClientId INT
	DECLARE @webServerName NVARCHAR(510)
	DECLARE @webServerHostName NVARCHAR(510)
	DECLARE @release INT
	DECLARE @SP INT
	DECLARE @hotfix INT
	DECLARE @transactionID INT
	DECLARE @SPVersionInfoText NVARCHAR(510)
	DECLARE @creUrl NVARCHAR(2048)
	DECLARE @crePort INT
	DECLARE @creClientId INT
	DECLARE @creClientName NVARCHAR(510)
	DECLARE @creHostName NVARCHAR(510)
	DECLARE @tppmWebServerport INT
	DECLARE @tppmCrePort INT
	DECLARE @csGUID NVARCHAR(100)
	DECLARE @clientId INT
	DECLARE @thirdPartyAppId INT
	DECLARE @adminConsolePackagePath NVARCHAR(510)
	DECLARE @webConsolePackagePath NVARCHAR(510)
	DECLARE @currentWebServiceUrl NVARCHAR(2048)
	DECLARE @currentCreUrl NVARCHAR(2048)
	DECLARE @currentTppmWebServerport INT
	DECLARE @currentSPVersionInfoText NVARCHAR(510)
	DECLARE @attrWebPackageClientInfo NVARCHAR(30) = N'WebPackageClientInfo'
	DECLARE @outputTable TABLE (errorCode INT, hasChanged  INT, propId INT, errString NVARCHAR(2048))
	DECLARE @curUtcDateTime BIGINT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @rowCount INT =0
	DECLARE @webserverChangeDetected INT = 0
	DECLARE @configMode INT = 0
	DECLARE @isRegisterOrUpgrade INT = 0
	DECLARE @commcellName NVARCHAR(512)
	DECLARE @oldWebserverName  NVARCHAR(512)
	-- available webservers
	IF OBJECT_ID('tempdb.dbo.#webserverTbl') is not null
		DROP TABLE #webserverTbl
	CREATE TABLE #webserverTbl (clientId int PRIMARY KEY)
	-- webconsoles associated to webservers
	IF OBJECT_ID('tempdb.dbo.#webConsoleTbl') is not null
		DROP TABLE #webConsoleTbl
	CREATE TABLE #webConsoleTbl (clientId int, webPackageClientInfo XML DEFAULT(NULL), pushPackage INT DEFAULT (0), skipProcessing INT DEFAULT (0), pushFirewall INT DEFAULT (0))
	-- webconsole package and webserverclientId attribute
	IF OBJECT_ID('tempdb.dbo.#clientPropTbl') is not null
		DROP TABLE #clientPropTbl
	CREATE TABLE #clientPropTbl (id int,componentNameId int, attrName nvarchar(2048), attrVal nvarchar(2048))
	-- webPackageClientInfo cross applied result
	IF OBJECT_ID('tempdb.dbo.#webPackageClientInfo') is not null
		DROP TABLE #webPackageClientInfo
		CREATE TABLE #webPackageClientInfo (webconsoleId INT,serviceCommcellClientId INT,adminConsolePackagePath nvarchar(255), webconsolePackagePath nvarchar(510), packageStatus int, fwStatus int, pInfo int, status INT)
	-- used by add/delete webconsole mode
	IF OBJECT_ID('tempdb.dbo.#inputWebConsoles') is not null
		DROP TABLE #inputWebConsoles
	CREATE TABLE #inputWebConsoles (clientId INT)
	-- servicecommcell clients to process wq is intended for
	IF OBJECT_ID('tempdb.dbo.#inputserviceCommcells') is not null
		DROP TABLE #inputserviceCommcells
	CREATE TABLE #inputserviceCommcells (clientId INT, spVersionText NVARCHAR(510) DEFAULT (NULL))
	-- availableServiceCommcells
    IF OBJECT_ID('tempdb.dbo.#availableServiceCommcells') is not null
        DROP TABLE #availableServiceCommcells
    CREATE TABLE #availableServiceCommcells (commcellId int,redirectURL NVARCHAR(255), commcellRole INT, UNIQUE CLUSTERED(commcellID))
	-- storing the values that might be lost after commit
    IF OBJECT_ID('tempdb.dbo.#prefetchedPropertiesTbl') is not null
        DROP TABLE #prefetchedPropertiesTbl
    CREATE TABLE #prefetchedPropertiesTbl (serviceCommcellClientId int PRIMARY KEY,commcellName NVARCHAR(510), webserverName NVARCHAR(510))
    DECLARE @adminUser INT = (SELECT TOP 1 id FROM UMUsers WITH(NOLOCK) WHERE flags & (0x040) <> 0) --USERS_ADMIN
    -- Get all servicecommcells
    EXEC MCC_IDP_GetServiceCommcellListForUser @adminUser,1
	SELECT
		@configMode = ref.value('(@configMode)[1]', 'INT')
	FROM @webserverInfo.nodes('App_ConfigureServiceCommcell') R ( ref )
	IF @configMode NOT IN (1,2,3,4,5)
		THROW 51000, N'Not a valid config mode.', 2;
	INSERT INTO #inputserviceCommcells(clientId)
	SELECT
		ref.value('(@clientId)', 'INT')
	FROM @webserverInfo.nodes('App_ConfigureServiceCommcell/serviceCommcellClientList') R ( ref )
	INSERT INTO #inputWebConsoles(clientId)
	SELECT
		ref.value('(@clientId)', 'INT')
	FROM @webserverInfo.nodes('App_ConfigureServiceCommcell/webconsoleClientList') R ( ref )
	--UPGRADE = 1,
	--REGISTER = 2,
	--ADDWEBCONSOLE = 3,
	--DELETEWEBCONSOLE = 4,
	--UNREGISTER = 5
-- Get default Webconsoles Start
BEGIN
/*
Get Default webconsoles
*/
	SET @webconsolePackageWindows = 'PackageStateForId 726'
	SET @webconsolePackageUnix = 'PackageStateForId 1135'
    SET @webserverClientIdParam = 'WebServerClientId'
	-- Get webservers
    INSERT INTO #webserverTbl(clientId)
    SELECT cl.id
	FROM APP_Client AS CL WITH(NOLOCK)
		INNER JOIN SimInstalledpackages SIM WITH(NOLOCK) ON SIM.ClientId = CL.id AND sim.simPackageID in (252,1174)
	--Get client props
	INSERT INTO #clientPropTbl(id ,componentNameId , attrName , attrVal )
    SELECT
    (CASE
        WHEN attrName=@webserverClientIdParam THEN 1
        WHEN attrName=@webconsolePackageWindows OR attrName=@webconsolePackageUnix THEN 2
    END) as id,
    componentNameId, attrName, attrval
    FROM APP_ClientProp WITH(NOLOCK) WHERE attrName in (@webserverClientIdParam, @webconsolePackageWindows,@webconsolePackageUnix)
	-- #1 webconsole should have attrName 'WebServerClientId' with attrVal as WebserverID
    -- #2 webconsole should have attrName 'PackageStateForId 726' with attrVal=1
	INSERT INTO #webConsoleTbl(clientId)
	SELECT distinct cpTbl2.componentNameId
        FROM #clientPropTbl cpTbl1
        INNER JOIN #webserverTbl wsTbl ON cpTbl1.attrVal = wsTbl.clientId
        INNER JOIN #clientPropTbl cpTbl2 ON cpTbl2.componentNameId = cpTbl1.componentNameId
        WHERE cpTbl1.id = 1 --@webserverClientId
        AND cpTbl2.id = 2 /**@webServerAttribute**/ AND cpTbl2.attrVal = 1
	--remove webconsoles that do not participate in dynamic load
	DELETE WC
	FROM #webConsoleTbl WC
	LEFT OUTER JOIN APP_ClientProp CP ON WC.clientId = CP.componentNameId
	AND attrName =N'Side by Side Loading of Multiple SP Instance Enabled' and attrVal=N'1' and modified =0
	WHERE CP.componentNameId IS NULL
END
-- Get default Webconsoles End
	IF @configMode = 1 -- UPGRADE
	BEGIN
	-- read the webserverinformation passed by service commcell
		SELECT
				@webServiceUrl = ref.value('(webserverInfo/@webServiceUrl)[1]', 'NVARCHAR(2048)'),
				@webServerport = ref.value('(webserverInfo/@webServerport)[1]', 'INT'),
				@webServerClientId = ref.value('(webserverInfo/webServerEntity/@clientId)[1]', 'INT'),
				@webServerName = ref.value('(webserverInfo/webServerEntity/@webServerName)[1]', 'NVARCHAR(510)'),
				@webServerHostName = ref.value('(webserverInfo/webServerEntity/@webServerHostName)[1]', 'NVARCHAR(510)'),
				@release = ref.value('(webserverInfo/spVersion/@release)[1]', 'INT'),
				@SP = ref.value('(webserverInfo/spVersion/@SP)[1]', 'INT'),
				@hotfix = ref.value('(webserverInfo/spVersion/@hotfix)[1]', 'INT'),
				@transactionID = ref.value('(webserverInfo/spVersion/@transactionID)[1]', 'INT'),
				@SPVersionInfoText = ref.value('(webserverInfo/spVersion/@SPVersionInfoText)[1]', 'NVARCHAR(510)'),
				@creUrl = ref.value('(webserverInfo/cre/@creUrl)[1]', 'NVARCHAR(2048)'),
				@crePort = ref.value('(webserverInfo/cre/@crePort)[1]', 'INT'),
				@creClientId = ref.value('(webserverInfo/cre/client/@clientId)[1]', 'INT'),
				@creClientName = ref.value('(webserverInfo/cre/client/@clientName)[1]', 'NVARCHAR(510)'),
				@creHostName = ref.value('(webserverInfo/cre/client/@hostName)[1]', 'NVARCHAR(510)'),
				@tppmCrePort = ref.value('(webserverInfo/cre/@tppmCrePort)[1]', 'INT'),
				@tppmWebServerport = ref.value('(webserverInfo/@tppmWebServerport)[1]', 'INT'),
				@csGUID = ref.value('(webserverInfo/@csGUID)[1]', 'NVARCHAR(100)')
			FROM @webserverInfo.nodes('App_ConfigureServiceCommcell') R ( ref )
			SELECT @thirdPartyAppId				= id
			FROM App_ThirdPartyApp WHERE appName = @csGuid
			SELECT @clientId = clientId FROM APP_CommCell (NOLOCK) WHERE csGUID = @csGuid
			SELECT @currentWebServiceUrl=attrVal FROM App_ClientProp (NOLOCK) WHERE attrName='ServiceCommcell WebServiceUrl' AND componentnameId = @clientId AND modified = 0
			SELECT @currentCreUrl=attrVal FROM App_ClientProp (NOLOCK) WHERE attrName='ServiceCommcell CreUrl' AND componentnameId = @clientId AND modified = 0
			SELECT @currentTppmWebServerport=CAST(attrVal AS INT) FROM App_ClientProp (NOLOCK) WHERE attrName='ServiceCommcell TppmWebServerport' AND componentnameId = @clientId AND modified = 0
			SELECT @currentSPVersionInfoText = attrVal FROM App_ClientProp (NOLOCK) WHERE attrName='ServiceCommcell SPVersionInfoText' AND componentnameId = @clientId AND modified = 0
			IF @thirdPartyAppId IS NULL OR @clientId IS NULL
				THROW 51000, N'Failed to obtain remote commcell info from DB.', 2
			IF @currentWebServiceUrl IS NULL OR @currentWebServiceUrl='' OR  @currentCreUrl IS NULL OR @currentCreUrl=''
				THROW 51000, N'Webserver/CRE information not available on Master Commserver.', 2
			INSERT INTO #inputserviceCommcells(clientId) VALUES(@clientId)
			IF @currentWebServiceUrl <> @webServiceUrl OR  @currentCreUrl <> @creUrl
			BEGIN
				--Webserver/CRE information changed, so we need delete old firewall config and create new one
				SET @webserverChangeDetected = 1
				--GET old websrver information tp delete firewall before setting up new one
				SET @commcellName = (SELECT TOP 1 aliasName from APP_CommCell(nolock) WHERE clientId = @clientId)
				SET @oldWebserverName = (SELECT TOP 1 attrVal from APP_ClientProp(nolock) WHERE componentNameId = @clientId and attrName = 'ServiceCommcell WebServerName' and modified = 0)
				INSERT INTO #prefetchedPropertiesTbl values(@clientId,@commcellName,@oldWebserverName)
				-- we will now update thwe webserver and CRE properties
				--webserver properties
				IF @webServerClientId IS NOT NULL
				BEGIN
					UPDATE App_ClientProp SET attrval = CAST(@webServerClientId AS NVARCHAR(12)) WHERE attrname = 'ServiceCommcell WebServerClientId' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell WebServerClientId', 7, CAST(@webServerClientId AS NVARCHAR(12)), @curUtcDateTime, 0, 0)
				END
				IF @webServerport IS NOT NULL
				BEGIN
					UPDATE App_ClientProp SET attrval = CAST(@webServerport AS NVARCHAR(12)) WHERE attrname = 'ServiceCommcell WebServerport' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell WebServerport', 7, CAST(@webServerport AS NVARCHAR(12)), @curUtcDateTime, 0, 0)
				END
				IF @webServerHostName IS NOT NULL
				BEGIN
					UPDATE App_ClientProp SET attrval = @webServerHostName WHERE attrname = 'ServiceCommcell WebServerHostName' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell WebServerHostName', 1, @webServerHostName, @curUtcDateTime, 0, 0)
				END
				IF @webServerName IS NOT NULL
				BEGIN
					UPDATE App_ClientProp SET attrval = @webServerName WHERE attrname = 'ServiceCommcell WebServerName' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell WebServerName', 1, @webServerName, @curUtcDateTime, 0, 0)
				END
				IF @webServiceUrl IS NOT NULL
				BEGIN
					UPDATE App_ClientProp SET attrval = @webServiceUrl WHERE attrname = 'ServiceCommcell WebServiceUrl' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell WebServiceUrl', 1, @webServiceUrl, @curUtcDateTime, 0, 0)
				END
				--cre info
				IF @creClientId IS NOT NULL
				BEGIN
					UPDATE App_ClientProp SET attrval = CAST(@creClientId AS NVARCHAR(12)) WHERE attrname = 'ServiceCommcell CreClientId' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell CreClientId', 7, CAST(@creClientId AS NVARCHAR(12)), @curUtcDateTime, 0, 0)
				END
				IF @creport IS NOT NULL
				BEGIN
					UPDATE App_ClientProp SET attrval = CAST(@creport AS NVARCHAR(12)) WHERE attrname = 'ServiceCommcell CrePort' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell CrePort', 7, CAST(@creport AS NVARCHAR(12)), @curUtcDateTime, 0, 0)
				END
				IF @creHostName IS NOT NULL
				BEGIN
					UPDATE App_ClientProp SET attrval = @creHostName WHERE attrname = 'ServiceCommcell CreHostName' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell CreHostName', 1, @creHostName, @curUtcDateTime, 0, 0)
				END
				IF @creClientName IS NOT NULL
				BEGIN
					UPDATE App_ClientProp SET attrval = @creClientName WHERE attrname = 'ServiceCommcell CreClientName' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell CreClientName', 1, @creClientName, @curUtcDateTime, 0, 0)
				END
				IF @creUrl IS NOT NULL
				BEGIN
					UPDATE App_ClientProp SET attrval = @creUrl WHERE attrname = 'ServiceCommcell CreUrl' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell CreUrl', 1, @creUrl, @curUtcDateTime, 0, 0)
				END
			END
			 --This insert/update is to update service pack information of webserver as it might have been upgraded
			IF @release IS NOT NULL
			BEGIN
					UPDATE App_ClientProp SET attrval = CAST(@release AS NVARCHAR(12)) WHERE attrname = 'ServiceCommcell Release' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell Release', 7, CAST(@release AS NVARCHAR(12)), @curUtcDateTime, 0, 0)
			END
			IF @SP IS NOT NULL
			BEGIN
					UPDATE App_ClientProp SET attrval = CAST(@SP AS NVARCHAR(12)) WHERE attrname = 'ServiceCommcell SP' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell SP', 7, CAST(@SP AS NVARCHAR(12)), @curUtcDateTime, 0, 0)
			END
			IF @hotfix IS NOT NULL
			BEGIN
					UPDATE App_ClientProp SET attrval = CAST(@hotfix AS NVARCHAR(12)) WHERE attrname = 'ServiceCommcell Hotfix' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell Hotfix', 7, CAST(@hotfix AS NVARCHAR(12)), @curUtcDateTime, 0, 0)
			END
			IF @transactionID IS NOT NULL
			BEGIN
					UPDATE App_ClientProp SET attrval = CAST(@transactionID AS NVARCHAR(12)) WHERE attrname = 'ServiceCommcell TransactionID' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell TransactionID', 7, CAST(@transactionID AS NVARCHAR(12)), @curUtcDateTime, 0, 0)
			END
			IF @SPVersionInfoText IS NOT NULL
			BEGIN
					UPDATE App_ClientProp SET attrval = @SPVersionInfoText WHERE attrname = 'ServiceCommcell SPVersionInfoText' AND componentNameId = @clientId AND modified=0
					SET @rowCount = @@ROWCOUNT
					IF(@rowCount = 0)
						INSERT INTO App_ClientProp VALUES(@clientId, 'ServiceCommcell SPVersionInfoText', 1, @SPVersionInfoText, @curUtcDateTime, 0, 0)
			END
			SET @isRegisterOrUpgrade = 1
	END
	IF @configMode = 2 -- REGISTER
	BEGIN
	-- only one servicecommcell id can be passed
		IF EXISTS(SELECT 1 WHERE (SELECT COUNT(1)cnt from #inputserviceCommcells) <> 1)
			THROW 51000, N'Only one Service Commcell can be registered at a time.', 2;
		SELECT @clientId = clientId FROM #inputserviceCommcells
		IF NOT EXISTS (SELECT  1 FROM #availableServiceCommcells SCC INNER JOIN APP_CommCell CC(nolock) ON SCC.commcellId = CC.ID AND CC.clientId = @clientId)
			THROW 51000, N'ClientId passed is not a valid ServiceCommcell.', 2;
		--set this property by default.
		UPDATE App_ClientProp SET attrval = '1' WHERE attrname = 'IsGlobalWebConsoleConfigured' AND componentNameId = @clientId AND modified=0
		SET @rowCount = @@ROWCOUNT
		IF(@rowCount = 0)
			INSERT INTO App_ClientProp VALUES(@clientId, 'IsGlobalWebConsoleConfigured', 2, '1', @curUtcDateTime, 0, 0)
		SELECT @SPVersionInfoText = attrVal FROM App_ClientProp (NOLOCK) WHERE attrName='ServiceCommcell SPVersionInfoText' AND componentnameId = @clientId AND modified = 0
		SET @isRegisterOrUpgrade = 1
	END
	--ServiceCommcell Package Level check
	DELETE ISC
	FROM #inputserviceCommcells ISC
	INNER JOIN APP_ClientProp SCP(NOLOCK) ON ISC.clientId = SCP.componentNameId AND SCP.attrName=N'ServiceCommcell SP'
	AND CAST(SCP.attrVal AS INT) < 22 AND SCP.modified = 0 -- we process only service commcell that are SP22 and above
	IF NOT EXISTS(SELECT 1 from #inputserviceCommcells)
	BEGIN
		SET @errorMsg	= 'No valid service commcells to process.'
		GOTO EXITPROC
	END
	IF @configMode = 3 -- ADDWEBCONSOLE
	BEGIN
	-- INITIATED, CREATE WEBPACKAGE XML AND UPDATE AND PUSH, no pinfo lookup
	--#inputWebConsoles contains newly added webconsoles
		--remove webconsoles that do not participate in dynamic load
		DELETE WC
		FROM #webConsoleTbl WC
		LEFT OUTER JOIN #inputWebConsoles I ON WC.clientId = I.clientId
		WHERE I.clientId IS NULL
		UPDATE SC SET spVersionText = CP.attrVal
		FROM #inputserviceCommcells SC
		INNER JOIN App_ClientProp CP ON SC.clientId = CP.componentNameId AND  CP.attrName='ServiceCommcell SPVersionInfoText' AND CP.modified = 0
		DECLARE @scWebPackage XML =
									(SELECT
										(SELECT
												'CVChildCommcells\'+spVersionText+'_AdminConsole' '@adminconsolePackagePath',
												'CVChildCommcells\'+spVersionText+'_WebConsole' '@webconsolePackagePath',
												10 '@pInfo', -- configure firewall and pull
												1 '@fwStatus',
												1 '@packageStatus',
												1 '@status',
												(SELECT sc.clientId '@clientId' FOR XML PATH('serviceCommcellClient'),TYPE)
											FROM #inputserviceCommcells SC
											FOR XML PATH('webPackageAvailableClients'),TYPE)
										FOR XML PATH('App_WebPackageAvailableClientInfoList'),TYPE)
		-- This is the first time we are setting the webconsole. so if any stale webpackagavailability is present, overwrite it
		-- App_ExtendedProperties is used as App_ClientProp cannot hold larger xml. This properties has the webpackage status of servicecommcell on a webconsole
	   MERGE APP_ExtendedProperties t USING #inputWebConsoles s
		ON (t.clientId = s.clientId AND t.attrName = @attrWebPackageClientInfo AND t.modified=0)
		WHEN MATCHED THEN
			UPDATE SET attrVal =  CONVERT(NVARCHAR(MAX),@scWebPackage)
		WHEN NOT MATCHED THEN
			INSERT (clientId,appTypeId,instance,backupSet,subclientId,attrType,attrName,attrVal,MD5,created,modified,ccpId)
			Values( s.clientId,0,0,0,0,129,@attrWebPackageClientInfo,CONVERT(NVARCHAR(MAX),@scWebPackage),'',@curUtcDateTime,0,0);
	END
	IF @configMode = 4 -- DELETEWEBCONSOLE
	BEGIN
	--#inputWebConsoles contains deleted webconsoles
	-- -- Delete Firewall (no querying ServiceCommcell in cpp, only prefetched respone)
	-- no update webpackage availability needed but MQ needed
		DELETE #webConsoleTbl
		-- we need only process on the webconsoles deleted
		INSERT INTO #webConsoleTbl(clientId)
		SELECT clientId FROM #inputWebConsoles
		--delete webpackage availablity info on the webconsole client
		DELETE ECP
		FROM APP_ExtendedProperties ECP
		INNER JOIN #inputWebConsoles I on ECP.clientId = I.clientId AND ECP.attrName = @attrWebPackageClientInfo AND ECP.modified=0
		INSERT INTO #prefetchedPropertiesTbl
		SELECT
			SC.clientId,
			CC.aliasName,
			CP1.attrVal
		FROM #inputserviceCommcells SC
		INNER JOIN APP_CommCell(nolock) CC ON  SC.clientId = CC.clientId
		INNER JOIN  APP_ClientProp(nolock) CP1 ON CP1.componentNameId = SC.clientId and CP1.attrName = 'ServiceCommcell WebServerName' and CP1.modified = 0
	END
	IF @configMode = 5 -- UNREGISTER
	BEGIN
	-- Delete Firewall (no querying ServiceCommcell in cpp, only prefetched respone)
	-- CleanUp DB
	-- MQ
	-- only one servicecommcell id can be passed
		IF EXISTS(SELECT 1 WHERE (SELECT COUNT(1)cnt from #inputserviceCommcells) <> 1)
			THROW 51000, N'Only one Service Commcell can be registered at a time.', 2;
		SELECT @clientId = clientId FROM #inputserviceCommcells
	SET @commcellName = (SELECT TOP 1 aliasName from APP_CommCell(nolock) WHERE clientId = @clientId)
	SET @oldWebserverName  = (SELECT TOP 1 attrVal from APP_ClientProp(nolock) WHERE componentNameId = @clientId and attrName = 'ServiceCommcell WebServerName' and modified = 0)
	INSERT INTO #prefetchedPropertiesTbl values(@clientId,@commcellName,@oldWebserverName)
	-- cleanup db only now
	--will call from server.
	END
	IF(@isRegisterOrUpgrade = 1)
	BEGIN
	---- package name to be created on webconsole/adminconsole
		SET @adminConsolePackagePath = 'CVChildCommcells\'+@SPVersionInfoText+'_AdminConsole'
		SET @webconsolePackagePath  = 'CVChildCommcells\'+@SPVersionInfoText+'_WebConsole'
		DECLARE @defaultWebPackage XML =
								(SELECT
									(SELECT
										@adminConsolePackagePath '@adminconsolePackagePath',
										@webconsolePackagePath '@webconsolePackagePath',
										0 '@pInfo',
										0 '@fwStatus',
										0 '@packageStatus',
										0 '@status',
										(SELECT @clientId '@clientId' FOR XML PATH('serviceCommcellClient'),TYPE)
									FOR XML PATH('webPackageAvailableClients'),TYPE)
								FOR XML PATH('App_WebPackageAvailableClientInfoList'),TYPE)
		DECLARE @defaultWebPackageClient XML = (select @defaultWebPackage.query('App_WebPackageAvailableClientInfoList/webPackageAvailableClients'))
		--Get prop value WebPackageClientInfo
		UPDATE wc SET webPackageClientInfo = CAST(ECP.attrVal AS XML)
		FROM #webConsoleTbl wc
		LEFT OUTER JOIN APP_ExtendedProperties ECP  WITH(NOLOCK) ON wc.clientId = ECP.clientId AND ECP.attrName = @attrWebPackageClientInfo AND ECP.modified = 0
		WHERE ECP.clientId IS NOT NULL
		-- update default value if prop not found
		UPDATE #webConsoleTbl set webPackageClientInfo = @defaultWebPackage WHERE webPackageClientInfo IS NULL	OR webPackageClientInfo.value('count(/App_WebPackageAvailableClientInfoList/webPackageAvailableClients/serviceCommcellClient)', 'int') = 0
		--- update if ServiceCommcellId is not found in the prop
		UPDATE wc SET webPackageClientInfo.modify('insert sql:variable("@defaultWebPackageClient") as first into (/App_WebPackageAvailableClientInfoList)[1]')
		FROM #webConsoleTbl wc
		LEFT OUTER JOIN
		(
			SELECT
				clientId
			 from #webConsoleTbl
			CROSS APPLY
			webPackageClientInfo.nodes('./App_WebPackageAvailableClientInfoList/webPackageAvailableClients') as t(ref)
			WHERE (t.ref.query('.').value('(webPackageAvailableClients/serviceCommcellClient/@clientId)[1]','INT') = @clientId)
	   ) as tmp
	   ON wc.clientId = tmp.clientId
	   WHERE tmp.clientId IS NULL
	   -- update the prop in Extended client prop
	   -- App_ExtendedProperties is used as App_ClientProp cannot hold larger xml. This properties has the webpackage status of servicecommcell on a webconsole
	   MERGE APP_ExtendedProperties t USING #webConsoleTbl s
		ON (t.clientId = s.clientId AND t.attrName = @attrWebPackageClientInfo AND t.modified=0)
		WHEN MATCHED THEN
			UPDATE SET attrVal =  CONVERT(NVARCHAR(MAX),s.webPackageClientInfo)
		WHEN NOT MATCHED THEN
			INSERT (clientId,appTypeId,instance,backupSet,subclientId,attrType,attrName,attrVal,MD5,created,modified,ccpId)
			Values( s.clientId,0,0,0,0,129,@attrWebPackageClientInfo,CONVERT(NVARCHAR(MAX),s.webPackageClientInfo),'',@curUtcDateTime,0,0);
	   -- stored the apply result
	   INSERT INTO #webPackageClientInfo
		SELECT
			clientId,
			t.ref.query('.').value('(webPackageAvailableClients/serviceCommcellClient/@clientId)[1]','INT'),
			t.ref.query('.').value('(webPackageAvailableClients/@adminconsolePackagePath)[1]','nvarchar(255)'),
			t.ref.query('.').value('(webPackageAvailableClients/@webconsolePackagePath)[1]','nvarchar(510)'),
			t.ref.query('.').value('(webPackageAvailableClients/@packageStatus)[1]','INT'),
			t.ref.query('.').value('(webPackageAvailableClients/@fwStatus)[1]','INT'),
			t.ref.query('.').value('(webPackageAvailableClients/@pInfo)[1]','INT'),
			t.ref.query('.').value('(webPackageAvailableClients/@status)[1]','INT')
		 from #webConsoleTbl
		OUTER APPLY
		webPackageClientInfo.nodes('./App_WebPackageAvailableClientInfoList/webPackageAvailableClients') as t(ref)
		-- update push package to webconsole that dont have the webconsole and adminconsole package(per ServiceCommcell Webserver) and packageStatus is not complete
		-- ignore webconsole that do not participates in MCC (attr)
		UPDATE WC SET pushPackage = 1
		FROM #webConsoleTbl WC
		INNER JOIN #webPackageClientInfo WP ON WC.clientId = WP.webconsoleId
		WHERE serviceCommcellClientId = @clientId
		AND (adminConsolePackagePath<>@adminConsolePackagePath OR webconsolePackagePath <>@webConsolePackagePath OR packageStatus<>3/**Complete**/)
		-- if same package is already inprocess by webconsole, we will update only packageStatus and submit another request to webconsole to process
		UPDATE WC SET skipProcessing = 1
		FROM #webConsoleTbl WC
		INNER JOIN #webPackageClientInfo WP ON WC.clientId = WP.webconsoleId
		WHERE (adminConsolePackagePath=@adminConsolePackagePath AND webconsolePackagePath = @webConsolePackagePath AND packageStatus in (1,2)) --INITIATED,PREPARING
		-- When there is webserver change detected or firewall push status is not started or failed, initiate push of firewall
		UPDATE WC SET pushFirewall = 1
		FROM #webConsoleTbl WC
		INNER JOIN #webPackageClientInfo WP ON WC.clientId = WP.webconsoleId
		WHERE serviceCommcellClientId = @clientId
		AND (@webserverChangeDetected = 1 OR fwStatus in (0,4)/**Not started or failed **/)
		-- if there are webconsoles to push, change packageStatus to initiated, modify url with TPPM Port and push workqueue
		IF EXISTS (SELECT 1 FROM #webConsoleTbl WIP WHERE WIP.pushPackage=1 OR WIP.pushFirewall=1)
		BEGIN
		-- if there are webconsoles to push, change packageStatus to initiated
			-- set pInfo and updating client prop
			--could not do simply xml modify as it involves bitwise or of multiple attributes
			UPDATE ECP SET attrVal = CONVERT(NVARCHAR(MAX),tmp.xmlVal)
			FROM
			APP_ExtendedProperties ECP
			INNER JOIN
			(SELECT
				(SELECT
					(SELECT
						IIF(serviceCommcellClientId = @clientId,@adminConsolePackagePath,WP.adminConsolePackagePath) '@adminconsolePackagePath',
						IIF(serviceCommcellClientId = @clientId,@webconsolePackagePath,WP.webconsolePackagePath) '@webconsolePackagePath',
						IIF(serviceCommcellClientId = @clientId AND WIP.pushPackage=1,1/**INITIATED**/,WP.packageStatus) '@packageStatus',
						IIF(serviceCommcellClientId = @clientId AND WIP.pushFirewall=1,1/**INITIATED**/,WP.fwStatus) '@fwStatus',
						IIF(serviceCommcellClientId = @clientId,(IIF(WIP.pushFirewall = 1,2,0) | IIF(@webserverChangeDetected = 1,4,0) | IIF(WIP.skipProcessing = 0,8,0)),0) '@pInfo',
						IIF(serviceCommcellClientId = @clientId,1 ,WP.status) '@status',
						(SELECT serviceCommcellClientId '@clientId' FOR XML PATH('serviceCommcellClient'),TYPE)
						FROM #webPackageClientInfo WP WHERE WP.webconsoleId = WIP.clientId
					FOR XML PATH('webPackageAvailableClients'),TYPE)
				FOR XML PATH('App_WebPackageAvailableClientInfoList'),TYPE) as xmlVal,
				WIP.clientId
			FROM #webConsoleTbl WIP WHERE WIP.pushPackage=1 OR WIP.pushFirewall=1) tmp
			ON ECP.clientId = tmp.clientId AND ECP.attrName = @attrWebPackageClientInfo AND ECP.modified=0
	END
		DELETE #webConsoleTbl WHERE (pushpackage <> 1 OR skipProcessing=1) AND pushFirewall <> 1
	END
	--Push Worktoken to webconsole
	IF EXISTS (SELECT 1 FROM #webConsoleTbl)
	BEGIN
		--- send worktoken to pull
		DECLARE @workQueueResponse XML
		DECLARE @workQueueTokenParam XML = 	(SELECT
												2 '@serverType', -- AppMsg::WQProcessServerType webconsole
												@configMode '@configMode',
												(SELECT
														(SELECT
															PF.commcellName '@commcellName',
															(SELECT
																	(SELECT	PF.webserverName AS '@webServerName' FOR XML PATH('webServerEntity'), TYPE)
															FOR XML PATH('webserverInfo'),TYPE)
														FROM #prefetchedPropertiesTbl PF
														FOR XML PATH('serviceCommcells'), TYPE)
													FOR XML PATH('serviceCommcellListProperties'), TYPE), --prefetchedProperties used by firewall delete
												(SELECT clientId '@clientId' FROM #inputserviceCommcells FOR XML PATH('serviceCommcellClientList'),TYPE)
											FOR XML PATH('App_PullSCCWebPackageWorkQueueReq'), TYPE)
		DECLARE @workQueueTokenParamText NVARCHAR(MAX) = CAST(@workQueueTokenParam AS NVARCHAR(MAX))
		--- WQ request
		DECLARE @workQueueReq XML =	(	SELECT	59  '@workToken',  -- WORK_TOKEN_PULL_SERVICECOMMCELL_WEB_PACKAGE
													@workQueueTokenParamText '@workTokenParams',
												(SELECT clientId '@clientId'
													FROM #webConsoleTbl
												FOR XML PATH('entityList'),TYPE)
										FOR XML PATH('App_SubmitWorkQueueReq')
									)
		EXEC AppWorkQueueSubmitRequestXMLOUTPUT @workQueueReq,@workQueueResponse output
		SELECT
			@errorCode = ISNULL(ref.value('@errorCode', 'INT'),0),
			@errorMsg = ref.value('@errorMessage', 'NVARCHAR(1024)')
		FROM @workQueueResponse.nodes('App_GenericResp') R ( ref )
		IF @errorCode <> 0
		BEGIN
			-- update status to error for each webconsole
			;
			THROW 51000, N'Failed to send workqueue to webconsole.', 2
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMsg ='Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END  CATCH
EXITPROC:
	SELECT  @errorCode as '@errorCode',
			@errorMsg as  '@errorMessage'
	FOR  XML PATH('App_GenericResp'),TYPE
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_PullServiceCommcellWebPackage')
	delete from GxQscripts where name = 'MCC_PullServiceCommcellWebPackage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_PullServiceCommcellWebPackage')
	delete from GXDBVersions where aliasname = 'MCC_PullServiceCommcellWebPackage'
GO

insert into GXDBVersions values(2, 'MCC_PullServiceCommcellWebPackage',  '00000000000000000000', 'MCC_PullServiceCommcellWebPackage', '00000000000000000000')
GO

