

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_LinkSubscriberCommcellToCloudService.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |           Procedure : "MCC_LinkSubscriberCommcellToCloudService"
--  |   This Procedure is used to set subscribed cloud service details
--  |   on local CS.
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_LinkSubscriberCommcellToCloudService')
BEGIN
	print '>>> Drop Stored Procedure: MCC_LinkSubscriberCommcellToCloudService <<<'
	drop procedure MCC_LinkSubscriberCommcellToCloudService
END
IF EXISTS (select * from GxQscripts where name='MCC_LinkSubscriberCommcellToCloudService')
	delete from GxQscripts where name = 'MCC_LinkSubscriberCommcellToCloudService'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_LinkSubscriberCommcellToCloudService')
	delete from GXDBVersions where aliasname = 'MCC_LinkSubscriberCommcellToCloudService'
GO
print '... Creating Procedure: MCC_LinkSubscriberCommcellToCloudService'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_LinkSubscriberCommcellToCloudService
  @xmlText XML,
  @i_userId INT,
  @subscriberCommcellGUID nvarchar(max)
AS
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(MAX) = ''
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @redirectUrl nvarchar(MAX)
DECLARE @ownerCompany INT = 0
DECLARE @userRole INT = 0
DECLARE @isSubscriberMSP INT = 0
DECLARE @mspSubscriberCompanyGUID nvarchar(max)=''
DECLARE @mspSubscriberCompanyAlias nvarchar(max)
DECLARE @thirdPartyAppId INT = 0
DECLARE @NameValueMapTable TABLE
								(
								appKey         nvarchar(255),
								appType        integer,
								appName        nvarchar(255),
								name           nvarchar(255),
								val            nvarchar(MAX)
								)
BEGIN TRANSACTION
	BEGIN TRY
			SET @mspSubscriberCompanyGUID = (SELECT 	ref.value('@GUID', 'nvarchar(MAX)')
				FROM    @xmlText.nodes('App_CloudServiceSubscriptionRequest/subscriberCompany') R ( ref ))
			SET @mspSubscriberCompanyAlias = (SELECT 	ref.value('@providerDomainName', 'nvarchar(MAX)')
				FROM    @xmlText.nodes('App_CloudServiceSubscriptionRequest/subscriberCompany') R ( ref ))
			SET @thirdPartyAppId = (SELECT id from app_thirdpartyapp where appName = @subscriberCommcellGUID)
			SET @ownerCompany = dbo.AppGetOrganizationForUser(@i_userId)
			IF @ownerCompany = 0 OR @ownerCompany IS NULL
			BEGIN
				SET @errorCode  = 1
				SET @errorString = 'User does not have permission'
                		GOTO SEND_RESPONSE
			END
			IF (@mspSubscriberCompanyGUID IS NOT NULL AND @mspSubscriberCompanyGUID <> '')
			BEGIN
				SET @isSubscriberMSP = 1
			END
IF NOT EXISTS(SELECT 1 FROM UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id where UG.groupFlags&0x10000 <> 0 and UU.userId=@i_userId)
AND NOT EXISTS(SELECT 1 FROM UMDSGroupMaps ugm INNER JOIN UMUserGroup uu ON ugm.umDSgroupId = uu.groupId INNER JOIN UMGroups UG ON ug.id=ugm.umgroupId AND UG.groupFlags&0x10000 <> 0 WHERE UU.userId=@i_userId )
			BEGIN
				SET @errorCode  = 1
				SET @errorString = 'User does not have permission'
                		GOTO SEND_RESPONSE
			END
			IF(@isSubscriberMSP = 1)
			BEGIN
IF EXISTS(Select top 1 id from App_CompanyProp where attrName = 'Cloud Service Company MSP Subscriber Guid' and componentNameId = @ownerCompany and modified = 0)
				BEGIN
					SET @errorCode = 2
					SET @errorString = 'Cloud service already subscribed.'
				END
IF EXISTS (Select top 1 id from App_CompanyProp where attrName = 'Cloud Service Company MSP Subscriber Guid' and attrVal = @mspSubscriberCompanyGUID and modified = 0)
				BEGIN
					SET @errorCode = 2
					SET @errorString = 'Cloud service already subscribed.'
				END
			END
			INSERT INTO @NameValueMapTable
					SELECT  ISNULL(ref.value('../../@appKey' , 'nvarchar(255)'),''),
							ISNULL(ref.value('../../@appType' ,'int'),0),
							ISNULL(ref.value('../../@appName' ,'nvarchar(255)'),''),
							ISNULL(ref.value('@name' , 'nvarchar(255)'),''),
							ISNULL(ref.value('@value' , 'nvarchar(MAX)') , '')
						FROM   @xmlText.nodes('App_CloudServiceSubscriptionRequest/thirdpartyAppReq/clientThirdPartyApps/props/nameValues') R ( ref )
IF NOT EXISTS(SELECT top 1 id from APP_ComponentProp where componentType = 1034 and  componentId = @thirdPartyAppId and propertyTypeId = 61 and longlongVal = @ownerCompany and modified = 0)
				INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,created,modified)
VALUES(1034,@thirdPartyAppId, 61, 1, 0, @ownerCompany, @nowTime, 0)
IF NOT EXISTS(SELECT top 1 id from APP_ComponentProp where componentType = 1034 and  componentId = @thirdPartyAppId and propertyTypeId = 5 and modified = 0)
				INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,created,modified)
VALUES(1034,@thirdPartyAppId, 5, 1, 0, 0, @nowTime, 0)
			-- insert/update commcellRole in App_CommcellProps table for cloud service
IF EXISTS(SELECT 1 FROM App_CommcellProp WHERE CommcellId = 2)
UPDATE APP_CommCellProp SET CommcellType = CommcellType | 16 WHERE CommCellId = 2 AND ((CommcellType & 16) <> 16)
            ELSE
				INSERT into APP_CommCellProp (CommCellId,LastEventID,LastEventUpdateTime,LastJobUpdateTime,LastCompletedJobUpdateTime,LastMaxChunkId,CommcellType,WebEndpoints)
VALUES(2,0,NULL,NULL,NULL,0,16,NULL)
			-- insert/update commcellRole in GXGlobalParam table for cloud service
IF EXISTS (SELECT 1 from GXGlobalParam where name = 'nMultiCommcellRole')
			BEGIN
UPDATE GXGlobalParam SET value = value | 16 WHERE name = 'nMultiCommcellRole'
            END
            ELSE
            BEGIN
				INSERT INTO GXGlobalParam (name, value, created, modified)
VALUES('nMultiCommcellRole', 16, dbo.GetUnixTime(GetUTCdate()), 0)
            END
            -- insert into webdomains
            DECLARE @hostName nvarchar(MAX) = ''
            SELECT @hostName = LOWER(DBO.GetHostnameFromUrl(val)) FROM @NameValueMapTable WHERE name = 'RedirectUrl'
            IF @hostName IS NOT NULL AND @hostName <> ''
            BEGIN
				DECLARE @httpsWebUrl NVARCHAR(MAX) = 'https://' + @hostname +':443'
                IF NOT EXISTS( SELECT 1 from GXGlobalParam where name = 'webDomainsWhiteList' and value like '%'+@httpsWebUrl+'%')
                BEGIN
					DECLARE @webdomains NVARCHAR(max) = (SELECT VALUE from GXGlobalParam where name = 'webDomainsWhiteList' and modified = 0)
					IF(@webdomains IS NULL)
						INSERT INTO GXGlobalParam VALUES ('webDomainsWhiteList',@httpsWebUrl,@nowTime,0)
                    ELSE IF(@webdomains = '')
                        UPDATE GXGlobalParam SET VALUE = @httpsWebUrl WHERE NAME = 'webDomainsWhiteList'
                    ELSE
                        UPDATE GXGlobalParam SET VALUE = @webdomains + ', '+@httpsWebUrl WHERE NAME = 'webDomainsWhiteList'
                END
            END
			IF(@isSubscriberMSP = 1)
			BEGIN
				INSERT INTO App_CompanyProp(componentNameId,attrName,attrVal,attrType,created,modified,attrValInt)
VALUES (@ownerCompany, 'Cloud Service Company MSP Subscriber Alias', @mspSubscriberCompanyAlias,7, @nowTime, 0, 0)
				INSERT INTO App_CompanyProp(componentNameId,attrName,attrVal,attrType,created,modified,attrValInt)
VALUES(@ownerCompany, 'Cloud Service Company MSP Subscriber Guid', @mspSubscriberCompanyGUID,7, @nowTime, 0, 0)
			END
	END TRY
	BEGIN CATCH
		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
			PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
			ERROR MESSAGE: ' + ERROR_MESSAGE() + '
			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @errorCode= ERROR_NUMBER()
			SET @errorString = ERROR_MESSAGE()
	END CATCH
SEND_RESPONSE:
	SET @xmlText = (SELECT  @errorCode AS '@errorCode', @errorString AS '@errorString'
                 FOR xml path('App_GenericEntityResponse'), TYPE)
IF(@errorCode<>0)
BEGIN
	ROLLBACK TRANSACTION
END
ELSE
BEGIN
	COMMIT TRANSACTION
END
SELECT @xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_LinkSubscriberCommcellToCloudService')
	delete from GxQscripts where name = 'MCC_LinkSubscriberCommcellToCloudService'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_LinkSubscriberCommcellToCloudService')
	delete from GXDBVersions where aliasname = 'MCC_LinkSubscriberCommcellToCloudService'
GO

insert into GXDBVersions values(2, 'MCC_LinkSubscriberCommcellToCloudService',  '00000000000000000000', 'MCC_LinkSubscriberCommcellToCloudService', '00000000000000000000')
GO

