

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_LinkCommvaultIdInCloud.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MCC_LinkCommvaultIdInCloud <<<'

IF EXISTS (select * from sysobjects where name='MCC_LinkCommvaultIdInCloud')
	drop procedure MCC_LinkCommvaultIdInCloud
IF EXISTS (select * from GxQscripts where name='MCC_LinkCommvaultIdInCloud')
	delete from GxQscripts where name = 'MCC_LinkCommvaultIdInCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_LinkCommvaultIdInCloud')
	delete from GXDBVersions where aliasname = 'MCC_LinkCommvaultIdInCloud'
GO
print '... Creating Procedure: MCC_LinkCommvaultIdInCloud'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_LinkCommvaultIdInCloud
  @commvaultId NVARCHAR(250),
  @commcellId INT ,
  @userEntity XML 
AS
DECLARE @XMLOUT XML
DECLARE @ERRORCODE INT = 0
DECLARE @ERRORSTRING NVARCHAR(MAX) = 'SUCCESS'
DEClARE @userGUID NVARCHAR(255)
DECLARE @id INT=0
DECLARE @componentId INT =0
DECLARE @cloudIDPAppID INT =0
DECLARE @prevLinkedCommvaultId INT = 0
DECLARE @providerId INT = 0
DECLARE @providerType INT = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @appId INT
SELECT @appId=id FROM App_ThirdPartyApp WHERE appType = 3 AND PROPS.value('(/props/nameValues[@name="CommcellId"]/@value)[1]','INT') = @commcellId
IF @appId = 0
	BEGIN
	SET @ERRORCODE=1
	SET @ERRORSTRING='Could not find application for the given commcellId'
	GOTO PROC_EXIT
	END
SET @userGUID=ISNULL((Select ref.value('@userGUID','NVARCHAR(255)') From @userEntity.nodes('CvEntities_UserEntity') R(ref) ),0)
SELECT @componentId = id, @providerId = umDSproviderId FROM UMUSERS WHERE login=@commvaultId or email=@commvaultId
IF @componentId = 0
	BEGIN
	SET @ERRORCODE=1
	SET @ERRORSTRING='Invalid CommvaultId'
	GOTO PROC_EXIT
	END
--check association in the Cloud IDP whether token can be issued for this user -
select @cloudIDPAppID=id from App_thirdPartyApp where apptype=4
DECLARE @OUTPUT TABLE (USERSTATUS INT)
INSERT INTO @OUTPUT EXEC DBO.[MCC_ComputeMulticcappUserAssoc] @componentId , @cloudIDPAppID
DECLARE @USER_STATUS INT = (SELECT USERSTATUS FROM @OUTPUT)
IF @USER_STATUS <> 1 --1 INCLUDE
	BEGIN
	SET @ERRORCODE=1
	SET @ERRORSTRING='User not eligible to perform this operation'
	GOTO PROC_EXIT
	END
delete from   @OUTPUT
--check association in the respective application
--if not found add, if excluded dont allow user to link
INSERT INTO @OUTPUT EXEC DBO.[MCC_ComputeMulticcappUserAssoc] @componentId , @appId
SET @USER_STATUS = (SELECT USERSTATUS FROM @OUTPUT)
IF @USER_STATUS = 2 --EXCLUDE
	BEGIN
	SET @ERRORCODE=1
	SET @ERRORSTRING='User Excluded from application hence, not eligible to perform this operation'
	GOTO PROC_EXIT
	END
-- AD user cannot be used as commvaultId
IF @providerId > 0
IF (SELECT serviceType FROM UMDSProviders WHERE id = @providerId) != 5
	BEGIN
		SET @ERRORCODE=1
		SET @ERRORSTRING='Cannot link to an External user'
		GOTO PROC_EXIT
	END
select @id = id , @prevLinkedCommvaultId = componentId from APP_ComponentProp  where
componentType=17 and
propertyTypeId=1 and
					longVal=@commcellId	and
					(cast(stringVal as xml)).value('(/CvEntities_UserEntity/@userGUID)[1]','VARCHAR(MAX)')=@userGUID
IF(@id <> 0)
	BEGIN
		UPDATE APP_ComponentProp SET componentId=@componentId, stringVal=CAST(@userEntity as NVARCHAR(MAX)) where @id=id
		--remove the previous association
		IF @prevLinkedCommvaultId<>@componentId
			DELETE from app_componentProp WHERE
componentType = 1034 and componentId = @appId and
propertyTypeId = 13 and longlongVal = @prevLinkedCommvaultId
	END
ELSE
	BEGIN
insert into APP_ComponentProp(componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,stringVal,created,modified) values(17,@componentId,1,'1',@commcellId,0,CAST(@userEntity as nvarchar(MAX)),dbo.GetUnixTime(GETUTCDATE()),0)
	END
--set user association
IF @USER_STATUS <> 1
	INSERT INTO APP_ComponentProp
SELECT 1034,@appId, 13, 1,0,@componentId,'', dbo.GetUnixTime(GETUTCDATE()),0
SET @XMLOUT=(select login as '@commvaultId',salt as '@salt', userGuid as '@commvaultIdGuid' ,email as '@email'
				from umusers where  id=@componentId for xml path('LinkCommvaultIdResp'))
PROC_EXIT:
IF @ERRORCODE<>0
	BEGIN
		SET @XMLOUT = (
		SELECT @ERRORCODE AS '@errorCode',
				@ERRORSTRING AS '@errorMessage'
				FOR xml path('error'),root('LinkCommvaultIdResp'))
	END
Select @XMLOUT

IF EXISTS (select * from GxQscripts where name = 'MCC_LinkCommvaultIdInCloud')
	delete from GxQscripts where name = 'MCC_LinkCommvaultIdInCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_LinkCommvaultIdInCloud')
	delete from GXDBVersions where aliasname = 'MCC_LinkCommvaultIdInCloud'
GO

insert into GXDBVersions values(2, 'MCC_LinkCommvaultIdInCloud',  '00000000000000000000', 'MCC_LinkCommvaultIdInCloud', '00000000000000000000')
GO

