

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_LinkCommvaultId.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MCC_LinkCommvaultId')
BEGIN
	print '>>> Drop Stored Procedure: MCC_LinkCommvaultId <<<'
	drop procedure MCC_LinkCommvaultId
END
IF EXISTS (select * from GxQscripts where name='MCC_LinkCommvaultId')
	delete from GxQscripts where name = 'MCC_LinkCommvaultId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_LinkCommvaultId')
	delete from GXDBVersions where aliasname = 'MCC_LinkCommvaultId'
GO
print '... Creating Procedure: MCC_LinkCommvaultId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MCC_LinkCommvaultId
  @localUserId INT,
  @commvaultId NVARCHAR(255),
  @commvaultIdEmail NVARCHAR(255),
  @commvaultIdGuid NVARCHAR(255),
  @commvaultIdPassword NVARCHAR(255),
  @commvaultIdSalt NVARCHAR(255)
AS
  DECLARE @errorStr NVARCHAR(100)=''
  DECLARE @errorCode Int = 0
SET QUOTED_IDENTIFIER ON
DECLARE @userId INT = 0
DECLARE @localIdpAppId INT = 0
DECLARE @cloudAppId INT = 0
DECLARE @prevLinkedCloudId INT
-- the commvaultId user might have been already created by another linked user
SELECT @userId = id from UMUsers where userGuid = @commvaultIdGuid
BEGIN TRANSACTION
		IF @userId=0
		BEGIN
			INSERT INTO UMUsers(name,description,login,password,email,datePasswordSet,dateExpires,policy, enabled,flags,modified,pVer,lastLogInTime,credSetTime,umDSproviderId,userGuid,origCCId,salt)
values('','linked commvaultId user',@commvaultId,@commvaultIdPassword,@commvaultIdEmail,dbo.GetUnixTime(GETUTCDATE()),0,0,1,convert(int,0x004)|convert(int,0X010),0,50,0,dbo.GetUnixTime(GETUTCDATE()),0,@commvaultIdGuid,2,@commvaultIdSalt)
			IF @@ERROR > 0
			BEGIN
				SET @errorStr = 'MCC_LinkCommvaultId -- error in creating hidden cloud user'
				SET @errorCode = 1
				GOTO PROC_EXIT
			END
			SET @userId = SCOPE_IDENTITY()
		END
		--add associations in localIdp
		SELECT @localIdpAppId = id FROM App_ThirdPartyApp WHERE appType = 4
		DECLARE @OUTPUT TABLE (USERSTATUS INT)
		INSERT INTO @OUTPUT EXEC DBO.[MCC_ComputeMulticcappUserAssoc] @localUserId , @localIdpAppId
		DECLARE @USER_STATUS INT = (SELECT USERSTATUS FROM @OUTPUT)
		IF @USER_STATUS = 2 --EXCLUDE
			BEGIN
				SET @errorCode=1
				SET @errorStr='User Excluded from LocalIDP association hence, not eligible to perform this operation'
				GOTO PROC_EXIT
			END
		ELSE
			BEGIN
				IF @USER_STATUS <> 1 --not included so include
					INSERT INTO APP_ComponentProp
SELECT 1034,@localIdpAppId, 13, 1,0,@localUserId,'', dbo.GetUnixTime(GETUTCDATE()),0
			END
		DELETE FROM  @OUTPUT
		--add associations in cloudIdp
SELECT @cloudAppId = componentId from APP_ComponentProp WHERE componentType=1034 and propertyTypeId=3 and longVal=1
		--check association in the cloud application
		--if not found add, if excluded dont allow user to link
		INSERT INTO @OUTPUT EXEC DBO.[MCC_ComputeMulticcappUserAssoc] @localUserId , @cloudAppId
		SET @USER_STATUS = (SELECT USERSTATUS FROM @OUTPUT)
		IF @USER_STATUS = 2 --EXCLUDE
			BEGIN
				SET @errorCode=1
				SET @errorStr='User Excluded from Cloud association hence, not eligible to perform this operation'
				GOTO PROC_EXIT
			END
		ELSE
			BEGIN
				IF @USER_STATUS <> 1 --not included so include
					INSERT INTO APP_ComponentProp
SELECT 1034,@cloudAppId, 13, 1,0,@localUserId,'', dbo.GetUnixTime(GETUTCDATE()),0
			END
SELECT @prevLinkedCloudId=cast(attrval as INT) FROM UMUsersProp WHERE componentNameId=@localUserId and attrName='Linked CommvaultId'
		IF @prevLinkedCloudId is not null
DELETE FROM UMUsersProp WHERE componentNameId=@localUserId and attrName='Linked CommvaultId'
		--if user is getting linked to another user, remove entry for the old cloud user
		IF(@prevLinkedCloudId <> @userId)
			update umusers set login=login+'(DELETED,'+cast (@prevLinkedCloudId as nvarchar(10))+')' where id =@prevLinkedCloudId
		UPDATE UMUsers set login=@commvaultId, password=@commvaultIdPassword, salt=@commvaultIdSalt, email=@commvaultIdEmail where id=@userId
		INSERT INTO UMUSERSPROP(componentNameId,attrName,attrType,attrVal,created,modified)
VALUES(@localUserId,'Linked CommvaultId',7,@userId,dbo.GetUnixTime(GETUTCDATE()),0)
		--add a flag for linked local user
UPDATE UMUsers set flags = flags|0x4000 where id = @localUserId
		IF @@ERROR > 0
		BEGIN
			SET @errorStr = 'MCC_LinkCommvaultId -- error in adding user Property - Linked CommvaultId '
			SET @errorCode=1
		END
PROC_EXIT:
IF @errorCode = 0
	COMMIT TRANSACTION
ELSE
	ROLLBACK TRANSACTION
	SELECT @errorStr,@errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_LinkCommvaultId')
	delete from GxQscripts where name = 'MCC_LinkCommvaultId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_LinkCommvaultId')
	delete from GXDBVersions where aliasname = 'MCC_LinkCommvaultId'
GO

insert into GXDBVersions values(2, 'MCC_LinkCommvaultId',  '00000000000000000000', 'MCC_LinkCommvaultId', '00000000000000000000')
GO

