

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_IDP_GetServiceCommcellListForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "MCC_IDP_GetServiceCommcellListForUser"
--	|	This Procedure is used to check if a user can login
--	|	This SP to be called from Evmgrs login and web console login too.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_IDP_GetServiceCommcellListForUser')
BEGIN
	print '>>> Drop Stored Procedure: MCC_IDP_GetServiceCommcellListForUser <<<'
	drop procedure MCC_IDP_GetServiceCommcellListForUser
END
IF EXISTS (select * from GxQscripts where name='MCC_IDP_GetServiceCommcellListForUser')
	delete from GxQscripts where name = 'MCC_IDP_GetServiceCommcellListForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_IDP_GetServiceCommcellListForUser')
	delete from GXDBVersions where aliasname = 'MCC_IDP_GetServiceCommcellListForUser'
GO
print '... Creating Procedure: MCC_IDP_GetServiceCommcellListForUser'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_IDP_GetServiceCommcellListForUser
  @userId INT,
  @returnVar INT = 0
AS
  DECLARE @commcellId INT
IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
	DROP TABLE #getMemberUserGroupsHelperOutputTbl
CREATE TABLE #getMemberUserGroupsHelperOutputTbl
(
	isUser INT,
	userOrgroupId INT,
	UNIQUE CLUSTERED(isUser, userOrGroupId)
)
IF OBJECT_ID('tempdb.dbo.#availableServiceCommcells') IS  NULL
BEGIN
	CREATE TABLE #availableServiceCommcells
			(
				commcellID INT,
				redirectURL NVARCHAR(255),
				commcellRole INT,
				UNIQUE CLUSTERED(commcellID)
			)
END
EXEC sec_getMemberUserGroupsHelper @userId
--Insert domain and company also.
DECLARE @companyId INT =0
DECLARE @umdsproviderId INT = (SELECT umdsproviderId from UMUsers where id=@userId)
DECLARE @userName nvarchar(255) = (select login from UMUsers where id=@userId)
DECLARE @ownerCompany INT = dbo.AppGetOrganizationForUser(@userId)
if(@umdsproviderId<>0)
	BEGIN
		SET @companyId = (SELECT ownerCompany from UMDSProviders where id=@umdsproviderId)
		INSERT INTO #getMemberUserGroupsHelperOutputTbl
		SELECT 2,@umdsproviderID
	END
IF(@companyId<>0)
BEGIN
	INSERT INTO #getMemberUserGroupsHelperOutputTbl
		SELECT 2,@companyId
END
INSERT INTO #availableServiceCommcells (commcellID)
	SELECT DISTINCT entityId1
		FROM UMSEcurityAssociations Assoc
	INNER JOIN #getMemberUserGroupsHelperOutputTbl member
		ON Assoc.isUSer = member.isUSer and Assoc.userORGroupId = member.userORGroupId
WHERE entityType1=194
--jupiter
UPDATE #availableServiceCommcells
	SET redirectURL = PROPS.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(max)')
	FROM #availableServiceCommcells commcellList
	INNER JOIN
		APP_CommCell AC on AC.id = commcellList.commcellID
	INNER JOIN App_ThirdPartyApp ATPA on ATPA.appName = AC.csGUID
IF (@ownerCompany = 0)
BEGIN
	--loopy
	UPDATE #availableServiceCommcells
	SET  redirectURL = ACP.attrVal
	FROM #availableServiceCommcells commcellList INNER JOIN APP_CommCell AC
	     ON commcellList.commcellID = AC.id INNER JOIN APP_ClientProp ACP
	     ON ACP.componentNameId = AC.clientId INNER JOIN APP_ClientProp ACP2
ON ACP.componentNameId = ACP2.componentNameId AND ACP2.attrName = 'Commcell role' AND ACP2.attrVal = 5
	WHERE
commcellList.redirectURL IS NULL AND ACP.attrName = 'Service commcell end point'
	    AND ACP.attrType = 1
END
ELSE IF(@ownerCompany > 0)
BEGIN
	UPDATE #availableServiceCommcells
	SET  redirectURL = ACP.attrVal
	FROM #availableServiceCommcells commcellList
		INNER JOIN APP_CommCell AC
	     		ON commcellList.commcellID = AC.id
		INNER JOIN App_Companyprop  ACP
	     		ON ACP.attrValInt = AC.clientId
	WHERE
commcellList.redirectURL IS NULL AND ACP.attrName = 'Service commcell end point'
	    AND ACP.attrType = 7 AND ACP.componentNameId = @ownerCompany
END
Update #availableServiceCommcells
SET commcellRole = ACP.CommcellType
From #availableServiceCommcells commcellList inner join APP_CommCellProp ACP
	on commcellList.commcellID = ACP.CommCellId
IF(@returnVar = 0)
BEGIN
	SELECT commcellId,redirectURL FROM #availableServiceCommcells
END
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_IDP_GetServiceCommcellListForUser')
	delete from GxQscripts where name = 'MCC_IDP_GetServiceCommcellListForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_IDP_GetServiceCommcellListForUser')
	delete from GXDBVersions where aliasname = 'MCC_IDP_GetServiceCommcellListForUser'
GO

insert into GXDBVersions values(2, 'MCC_IDP_GetServiceCommcellListForUser',  '00000000000000000000', 'MCC_IDP_GetServiceCommcellListForUser', '00000000000000000000')
GO

