

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MCC_HandleRedirectsForUser.sp] ---------- 

----> input
	--protocol set Lastused url (0),get lastused url(1),get all available list(2), 3 = 1+2, getGlobalIdp(4)
	--userName -- email or normal
	--AppName (csGuid)-- used with protocol = set Lastused url (0);
	--AppType -- used to query specific AppType
----> output
	/* xml
	<RedirectsForUser />
		<LastUsedIdpUrl redirectUrl = ""/>
		<AvailableRedirects redirectUrl = ""/>
		<AvailableRedirects redirectUrl = ""/>
		<Globalidp  redirectUrl = "" />
		<error/>
	</RedirectsForUser>
	*/
/*
 Usage of App_ComponentProp[Saving here as we have users from umusers and app_thirdpartyUserMappings]
 componenttype		-- CV_COMPONENT_MULTICOMMCELL_USER							-- 1038
 componentid		-- Not Required												-- 0
 propertyTypeId		-- LAST_USED_IDP											-- 1
 datatype			-- PROPERTY_INTEGER											-- 7
 longVal			-- thirdpartyapp(id)										-- last used idp to redirect for authentication
 longlongVal		-- Not Required												-- 0
 stringVal			-- umusers(login) or app_thirdpartyUserMappings(tokenuser)	-- userlogin
  */
  /*
  Commcell Type has two values 0 and 1, default is 0 which is used to denote commcell has been configure for routing
  and 1 represents that the commcell has been configured for IDP. While we should not redirect to commcell that is registered
  or IDP, if we have a saml App that has been synced from Service commcell we have to redirect to service commcell so that
  we can authenticate from service commcell via third party.
  */
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MCC_HandleRedirectsForUser')
BEGIN
	print '>>> Drop Stored Procedure: MCC_HandleRedirectsForUser <<<'
	drop procedure MCC_HandleRedirectsForUser
END
IF EXISTS (select * from GxQscripts where name='MCC_HandleRedirectsForUser')
	delete from GxQscripts where name = 'MCC_HandleRedirectsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_HandleRedirectsForUser')
	delete from GXDBVersions where aliasname = 'MCC_HandleRedirectsForUser'
GO
print '... Creating Procedure: MCC_HandleRedirectsForUser'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MCC_HandleRedirectsForUser
  @USER NVARCHAR(510),
  @PROTOCOL INT = 3,
  @AppName nvarchar(50) = '',
  @AppType INT =0,
  @webconsoleURL NVARCHAR(250),
  @isWebRequest INT = 0,
  @getDistinctSAMLAppType INT = 0
AS
  DECLARE @XMLOUT XML
DECLARE @NR INT = 0 --NOT REQUIRED
DECLARE @CV_COMPONENT_MULTICOMMCELL_USER INT = 1038
DECLARE @PROP_LAST_USED_IDP INT = 1
DECLARE @LAST_USED_IDP INT = 0
DECLARE @ERRORCODE INT = 0
DECLARE @ERRORSTRING NVARCHAR(MAX) = 'SUCCESS'
DECLARE @AVAILABLELIST XML
DECLARE @LAST_USED_IDP_URL XML
DECLARE @GLOBAL_IDP XML
DECLARE @SAML_IDP XML
DECLARE @ERRORXML XML
DECLARE @autoredirectAppId INT
DECLARE @CHECK_FLAG INT = 3  --0: don't check in both local and remote commcell apps, 1: check in local commcell, 2: check in remote commcell, 3 = 2+1 (default): check in both local and remote commcell.
DECLARE @isRouterCommcellConfigureAsGlobalIDP INT = ISNULL((Select top 1 longlongVal from APP_ComponentProp where componentType = 1048 and propertyTypeId = 2 and longVal = 1 and longlongVal = 1),0)
DECLARE @isRouterCommcellConfigured INT = ISNULL((Select top 1 longVal from APP_ComponentProp where componentId = 2 and componentType = 1048 and propertyTypeId = 1 and longVal = 1),0)
DECLARE	@doesDomainExistsOnIDP INT = 0
DECLARE @CCIDS TABLE (ccId int,username nvarchar(510) default '',commcellType int default 0)
DECLARE @isAcsAvailableForRouting INT = 0
DECLARE @multiCommcellAppPresent INT = 0
DECLARE @multiCommcellAppType INT = 2
DECLARE @ownerCompany INT = 0
DECLARE @returnLocalCS INT = 0
IF @getDistinctSAMLAppType = 1
	SET @multiCommcellAppType = 3
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @userId INT = (Select id From UMUsers Where (login=@USER OR email=@USER) and @USER <> '' and enabled = 1)
SET @ownerCompany = dbo.AppGetOrganizationForUser(@userId)
-- check if it is cloud service company user
DECLARE @isCloudServiceCompanyUser INT = 0
SET @isCloudServiceCompanyUser = ISNULL((
						SELECT TOP(1) 1 FROM App_ThirdPartyApp TP
						INNER JOIN APP_ComponentProp ACP
ON ACP.componentType = 1034 AND ACP.componentId = TP.id AND ACP.propertyTypeId = 61  AND TP.isEnabled = 1
						INNER JOIN App_ComponentProp ACP2
ON ACP2.componentType = 1034 AND ACP2.componentId = TP.id AND ACP2.propertyTypeId = 5   --this property is set for cloud service to store customer cs redirectUrl
						INNER JOIN UMUsers UM
							ON UM.login = @USER OR UM.email = @USER
						INNER JOIN UMDSProviders UMDS
							ON UM.umDSproviderId = UMDS.id AND ACP.longlongVal = @ownerCompany
						), 0)
-- Do not set Last used IDP if third party app is created for customer cs subscribed to cloud service
DECLARE @isCloudServiceApp INT = 0
SET @isCloudServiceApp = ISNULL((
							SELECT TOP(1) 1 FROM App_ThirdPArtyApp TP INNER JOIN App_ComponentProp ACP
ON ACP.componentType = 1034 AND ACP.componentId = TP.id AND ACP.propertyTypeId = 5
								WHERE TP.appName = @AppName
							),0)
IF(@AppName <> '' AND @AppName IS NOT NULL AND @PROTOCOL = 0 AND @USER <> '' AND @isCloudServiceApp = 0)-- SET LAST
BEGIN
	SET @LAST_USED_IDP = ISNULL((SELECT ID FROM App_ThirdPartyApp WHERE appName = @AppName), 0)
	IF @LAST_USED_IDP > 0
	BEGIN
		DELETE APP_COMPONENTPROP WHERE COMPONENTTYPE = @CV_COMPONENT_MULTICOMMCELL_USER  AND STRINGVAL = @USER AND PROPERTYTYPEID = @PROP_LAST_USED_IDP
		INSERT INTO APP_COMPONENTPROP VALUES(@CV_COMPONENT_MULTICOMMCELL_USER,0,@PROP_LAST_USED_IDP, 7/*PROPERTY_INTEGER*/,@LAST_USED_IDP ,@NR,@USER,DBO.GETUNIXTIME(GETUTCDATE()),0)
	END
	GOTO PROC_EXIT
END
ELSE
BEGIN
	DECLARE @TPIDS TABLE (TPIDS INT, FROMREMOTECOMMCELL BIT DEFAULT(0),username NVARCHAR(510) DEFAULT(''),commCellType INT)
	DECLARE @USER_ID INT = 0
	DECLARE @USRINFO TABLE (N INT, LOGIN NVARCHAR(300),ID INT , ISOU INT)
	DECLARE @isSamlNonExistingUser int = 0
	DECLARE @domainNamefromCredentials nvarchar(255)
	DECLARE @appCount INT = 0
	DECLARE @isSAMLRedirectRuleConfigured INT = 0
	DECLARE @USER_SUPPLIED NVARCHAR(510)
	DECLARE @localCommcellName NVARCHAR(512) = (SELECT aliasName from APP_CommCell where id = 2)
	DECLARE @localCommcellRedirectURL NVARCHAR(MAX)  = ''
	DECLARE @truncatedUserNameCopy NVARCHAR(510) = ''
	Select @USER=REPLACE(@USER,' ','')
	SET @USER_SUPPLIED = @USER --copying
	DECLARE @userNameForCloudCustomer NVARCHAR(512) = ''
	-- 'Cloud Service User' property is setted for users redirected from customer to cloud. Redirect such users to customer for authentication.
	-- 'Cloud Service User' property is not set for company users created in cloud service. Authentication should be done in cloud service itself.
	DECLARE @autoCreatedUserForCloudSvc INT = 0
	SET @autoCreatedUserForCloudSvc = ISNULL((SELECT TOP(1) UMUP.attrVal FROM UMUsers UM INNER JOIN
UMUsersProp UMUP WITH (NOLOCK) ON UMUP.componentNameId = UM.id AND (UM.email = @USER OR UM.login = @USER) AND UMUP.attrName = 'Cloud service user' AND UMUP.modified = 0 AND UM.enabled = 1 AND @USER <> ''),0)
	IF (CHARINDEX('\',@USER) > 0)
	BEGIN
		SET @domainNamefromCredentials = substring(@USER,0,charindex('\',@USER))
		--There can be conflict between commcellName and any domain name. In that case, honor domain Name. commcellName\username is for ease of use. That should not disturb active domainName\username functionality.
		IF  NOT EXISTS (SELECT 1 from UMDSProviders with (nolock) where domainName = @localCommcellName and enabled = 1)
		BEGIN
			IF (@localCommcellName = @domainNamefromCredentials)
			BEGIN
				--don't check in the remote CS.
				SET @CHECK_FLAG = 1 --check only in the local commcell.
				SET @USER = SUBSTRING(@user,charindex('\',@USER)+1,LEN(@user))
				SET @truncatedUserNameCopy = @USER --@USER subject to change. so copying it.
			END
		END
		IF @isRouterCommcellConfigured = 1 AND EXISTS (SELECT 1 from UMDSProviders where domainName=@domainNamefromCredentials and enabled = 1)
		BEGIN
			SET @doesDomainExistsOnIDP = 1
		END
	END
	IF  NOT EXISTS (Select 1 from umusers with (NOLOCK) where (email=@USER or login = @USER))
	BEGIN
		SET @isSamlNonExistingUser=1
	END
	--DECLARE @specialGetRedirectForNonExistingSAMLUserFlag INT = 0
	--IF @isSamlNonExistingUser = 0
	--BEGIN
		--SET @specialGetRedirectForNonExistingSAMLUserFlag = ISNULL((SELECT 1 from GXGlobalParam with (nolock) where name = 'getRedirectUrlForNonExistingSAMLUser' and value = 'true'),0)
	--END
	IF @PROTOCOL & 11 != 0 AND @CHECK_FLAG & 1 !=0 AND  (@isSamlNonExistingUser = 0)-- OR @specialGetRedirectForNonExistingSAMLUserFlag = 1) --Modified the check to only check for username\email when the protocols are 11(1+2+8)
	BEGIN
		DECLARE @NUMBEROFLOGINS INTEGER  = 0
		IF(@USER <> '') --When we need the user details the username\email should not be empty.
		BEGIN
			INSERT INTO @USRINFO EXEC dbo.sec_getLoginForEmail @USER
			SET @NUMBEROFLOGINS = ISNULL((SELECT N FROM @USRINFO),0)
		END
		IF @NUMBEROFLOGINS = 1
		BEGIN
			SELECT @USER_ID = ID FROM @USRINFO
			IF  EXISTS( Select 1 from UMUsers where id = @USER_ID and enabled=0)
			BEGIN
				SET @CHECK_FLAG = 2 -- check only in remote commcell.
				--don't need to query for other app types. check only on commcell app type and on protocol 2(available redirect for user)
				IF @AppType = 0 OR @AppType = 3
				BEGIN
					SET @AppType = 3
					SET @PROTOCOL = @PROTOCOL & 2
				END
				ELSE  --different apptype other than 3 or 0, had been requested- Since the user is disabled, exit the proc.
				BEGIN
					SET @ERRORCODE = 4
					SET @ERRORSTRING = 'User Disabled'
					GOTO PROC_EXIT
				END
			END
		END
		ELSE IF @NUMBEROFLOGINS > 1
		BEGIN
			SET @ERRORCODE = 2
			SET @ERRORSTRING = 'MULTIPLE USERS WITH SAME EMAIL'
			--fail the flow, as there are multiple users with same Email address in local commcell itself. DOn't need to check in remote commcell.
			GOTO PROC_EXIT
		END
		ELSE IF @NUMBEROFLOGINS = 0
		BEGIN
			--IF(@specialGetRedirectForNonExistingSAMLUserFlag = 1)
			--BEGIN
				--INSERT into @TPIDS Select Top 1 id,0,'',0 from App_ThirdPartyApp with (nolock) where appType=2 and isEnabled = 1
			--END
			IF NOT EXISTS(SELECT 1 FROM App_ThirdPartyUserMappings with (nolock) WHERE TOKENUSER = @USER)
			BEGIN
				SET @CHECK_FLAG = 2 -- check only in remote commcell.
				--don't need to query for other app types. check only on commcell app type and on protocol 2(available redirect for user)
				IF @AppType = 0 OR @AppType = 3
				BEGIN
					SET @AppType = 3
					SET @PROTOCOL = @PROTOCOL & 2
				END
				ELSE
				BEGIN
					SET @ERRORCODE = 3
					SET @ERRORSTRING = 'Invalid User'
					GOTO PROC_EXIT
				END
			END
		END
	END
	IF @PROTOCOL & 1  = 1 AND (@AppType = 0 OR @AppType = 3)-- GET LAST
	BEGIN
	SET @LAST_USED_IDP = ISNULL((SELECT LONGVAL FROM APP_COMPONENTPROP with (nolock) WHERE COMPONENTTYPE = @CV_COMPONENT_MULTICOMMCELL_USER AND  PROPERTYTYPEID = @PROP_LAST_USED_IDP AND STRINGVAL = @USER ),0)
	SET @LAST_USED_IDP_URL = (SELECT CASE
									APPTYPE
										WHEN 2 THEN
										PROPS.value('(/props/nameValues[@name="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect"]/@value)[1]','nvarchar(max)')
										ELSE
										PROPS.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(max)')
										END AS 'redirectUrl',
									APPKEY AS 'appKey',
									 PROPS.value('(/props/nameValues[@name="App Display Name"]/@value)[1]','nvarchar(max)') AS 'commcellName',
									 PROPS.value('(/props/nameValues[@name="WebServiceUrl"]/@value)[1]','nvarchar(max)') AS 'webServiceUrl',
									 APPTYPE as 'appType'
							FROM App_ThirdPartyApp with (nolock) WHERE ID = @LAST_USED_IDP AND isEnabled = 1  AND PROPS.value('(/props/nameValues[@name="Enable Sso Redirect"]/@value)[1]','int') = 1
							FOR XML RAW('LastUsedIdpUrl'))
	END
	IF @PROTOCOL & 2 = 2 AND (@AppType = 0 OR @AppType = 3 OR @AppType = 2)-- GET AVAILABLE REDIRECTS- only for SAML and commcell app.
	BEGIN
	--1. get the domain or company name and check for any saml auto-rdirection rule.
	--2. If present, check for auto-create flag for non-existing users(isSAMLNonExistingFlag)
	--2.1. If auto-create flag is not set, exit the proc
	--3. if not present, check for tree assoc
	IF (@isWebRequest = 1 AND (@AppType = 2 OR @AppType = 0))
	BEGIN
		IF (CHARINDEX('@',@USER) > 0)
		BEGIN
		--Getting the SMTP alias part from @USER.
		SET @domainNamefromCredentials = substring(@USER,charindex('@',@USER)+1,len(@USER))
		--Getting the SAML application count , id if associations match.
		SELECT @appCount=count(distinct longVal),@autoredirectAppId=longVal from APP_ComponentProp ACP with (NOLOCK) where componentType=112
		and (stringVal like @domainNamefromCredentials or stringVal like @domainNamefromCredentials+';%' or stringVal like '%;'+@domainNamefromCredentials+';%' or stringVal like '%;'+@domainNamefromCredentials) and ACP.longVal <> 0 group by (ACP.longVal)
		END
		ELSE IF (CHARINDEX('\',@USER) > 0)
		BEGIN
			--Getting the domain part from @USER.
			SET @domainNamefromCredentials = substring(@USER,0,charindex('\',@USER))
			--Getting the SAML application count, id if domain has been configured under associations.
			SELECT @appCount=count(distinct longVal),@autoredirectAppId=longVal from APP_ComponentProp ACP with (NOLOCK) inner join UMDSProviders UMDS (NOLOCK) on UMDS.id=ACP.componentId where ACP.componentType=112  and UMDS.domainName = @domainNamefromCredentials  and ACP.longVal <> 0 group by (ACP.longVal)
		END
		If (@appCount = 1 ) -- If appCount is 1 we have correctly found out the association.
		BEGIN
			DECLARE @samlAppFlags INT = (SELECT flags from App_ThirdPartyApp as ATP with (NOLOCK) where  ATP.id=@autoredirectAppId and isEnabled = 1)
			IF @samlAppFlags IS NOT NULL
			BEGIN
				IF (@isSamlNonExistingUser = 1)
				BEGIN
IF((@samlAppFlags & 2 = 2) and (@samlAppFlags & 4 = 0))  -- checking for auto-create user flag
					BEGIN
						INSERT INTO @TPIDS(TPIDS,username) VALUES (@autoredirectAppId,@truncatedUserNameCopy)
						SET @isSAMLRedirectRuleConfigured = 1
					END
ELSE IF((@isRouterCommcellConfigureAsGlobalIDP = 1) and (@samlAppFlags & 2 = 2) and (@samlAppFlags & 4 = 4) )
					BEGIN
INSERT INTO @ccids (ccId,username,commcellType) SELECT attrval,'',1 from App_ThirdPartyAppProp where attrname = 'Synced From Service Commcell' and componentNameId=@autoredirectAppId and attrtype = 1
					END
					ELSE
						GOTO PROC_EXIT
				END
				ELSE
				BEGIN
IF ((@samlAppFlags & 4 = 0))
					BEGIN
						INSERT INTO @TPIDS(TPIDS,username) VALUES (@autoredirectAppId,@truncatedUserNameCopy)
						SET @isSAMLRedirectRuleConfigured = 1
					END
ELSE IF ((@isRouterCommcellConfigureAsGlobalIDP = 1) and (@samlAppFlags & 4 = 4))
					BEGIN
INSERT into  @ccids (ccId,username,commcellType) select attrval,'',1 from app_thirdpartyappprop where attrname = 'Synced From Service Commcell' and componentNameId=@autoredirectAppId and attrtype = 1
					END
				END
			END
		END
	END
	--To check for commcell app/saml apps based on association tree.
	-- avoid cursor for cloud service user to improve performance
	IF(@USER_ID > 0 and @isSAMLRedirectRuleConfigured = 0 and @isCloudServiceCompanyUser = 0) --USER_ID > 0, means it is a valid local user.
	BEGIN
	-- list all the multicommcell application which can authenticate this user( will need optimization if the thirdparty list grows big)
		DECLARE @ID INT
		DECLARE @ISALLOWED TABLE(ISA INT)
DECLARE TPLIST CURSOR FOR SELECT ID FROM App_ThirdPartyApp with (nolock) WHERE isEnabled = 1 AND PROPS.value('(/props/nameValues[@name="Enable Sso Redirect"]/@value)[1]','int') = 1   AND ((@AppType<>0 AND appType=@AppType) OR (@AppType=0)) AND (flags & 4 = 0)
		OPEN TPLIST
		FETCH NEXT FROM TPLIST INTO @ID
		WHILE @@FETCH_STATUS = 0
			BEGIN
				INSERT INTO @ISALLOWED EXEC DBO.MCC_ComputeMulticcappUserAssoc @USER_ID, @ID
				IF(SELECT ISA FROM @ISALLOWED) = 1
					BEGIN
					INSERT INTO @TPIDS(TPIDS,username) VALUES (@ID,@truncatedUserNameCopy)
					END
				FETCH NEXT FROM TPLIST INTO @ID
				DELETE FROM @ISALLOWED
			END
		CLOSE TPLIST
		DEALLOCATE TPLIST
	END
	-- instead of executing above cursor for cloud service user, find redirects list directly
	IF(@isCloudServiceCompanyUser = 1)
	BEGIN
		-- fetch the company to which user belongs and fetch third party apps associated to that company
		-- if user is a valid company user then fetch third party apps associated with this company
		IF(@ownerCompany <> 0)
			INSERT INTO @TPIDS (TPIDS, username)
			SELECT AC.componentId, @truncatedUserNameCopy FROM APP_ComponentProp AC
				INNER JOIN App_ThirdPartyApp AT ON AT.id = AC.componentId AND AT.isEnabled = 1
WHERE AC.longlongVal = @ownerCompany AND AC.componentType = 1034 AND AC.propertyTypeId = 61
	END
	-- Avoid TOKENUSER = @USER check for TP apps created for customer-cs subscription to cloud service
	-- we can remove App_ComponentProp check, once we stop saving data in App_ThirdPartyUserMappings for cloud service : -- TODO
	BEGIN
		INSERT INTO @TPIDS SELECT ISSUERID,0,@truncatedUserNameCopy,0 FROM App_ThirdPartyUserMappings
						JOIN App_ThirdPartyApp ON ID = IssuerId
LEFT JOIN App_ComponentProp ACP ON ACP.componentType = 1034 AND ACP.componentId = IssuerId and ACP.propertyTypeId = 5
						WHERE TOKENUSER = @USER AND isEnabled = 1 AND PROPS.value('(/props/nameValues[@name="Enable Sso Redirect"]/@value)[1]','int') = 1 AND ACP.componentId IS NULL
	END
	IF(@CHECK_FLAG & 2 !=0 AND @isWebRequest = 1) --For remote commcell. Umusers.origccid > 2. TODO. Once nikhil's changes are done.
	BEGIN
		--fetch redirect rules for remote commcell redirection- this commcell being the router commcell!
		--If there is an exact match, include them.
		----query on disabled users as well. If user is disabled at Service commcell. webconsole login will show user is disabled. The same logic is being used by user polling logic
		--Let the redirection happen from router commcell and user be shown as disabled in service commcell's webconsole.
			insert into @CCIDS SELECT DISTINCT UM.origCCId,'',0 FROM UMUsersServiceCommcell UM with (NOLOCK) WHERE (UM.email = @USER_SUPPLIED OR UM.login = @USER_SUPPLIED)
		IF (CHARINDEX('\',@USER_SUPPLIED) > 0)--domainName(or commcellName)\myID@smtp.com : only domainName will be taken into consideration for redirection.
		BEGIN
			--matching domain names
			SET @domainNamefromCredentials = substring(@USER_SUPPLIED,0,charindex('\',@USER_SUPPLIED))
			--IF there is a match for domainName, don't check for commcell\username. else, check for commcell\username case
IF EXISTS (SELECT 1 from APP_ComponentProp with (nolock) where stringVal = @domainNamefromCredentials and componentType = 1047 and propertyTypeId = 2)
			BEGIN
insert into @CCIDS SELECT DISTINCT componentId,'',0 from APP_ComponentProp with (nolock) where stringVal = @domainNamefromCredentials and componentType = 1047 and propertyTypeId = 2
			END
			ELSE IF EXISTS (SELECT 1 from APP_CommCell with (nolock) where aliasName = @domainNamefromCredentials and id >2) --query only in remote commcells.
			BEGIN
				--get the remote commcell id and redirect if that commcell is registered for routing. TODO. waiting on NIkhil's changes.
				insert into @CCIDS SELECT id,SUBSTRING(@USER_SUPPLIED,charindex('\',@USER_SUPPLIED)+1,LEN(@USER_SUPPLIED)),0 from APP_CommCell with (nolock) where aliasName = @domainNamefromCredentials and id >2
			END
		END
		ELSE IF (CHARINDEX('@',@USER_SUPPLIED) > 0)
		BEGIN
			--matching smtp address
			--Getting the SMTP alias part from @USER_SUPPLIED.
			SET @domainNamefromCredentials = substring(@USER_SUPPLIED,charindex('@',@USER_SUPPLIED)+1,len(@USER_SUPPLIED))
insert into @CCIDS select DISTINCT componentId,'',0 from APP_ComponentProp with (nolock) where stringVal = @domainNamefromCredentials and componentType = 1047 and propertyTypeId = 1
		END
		INSERT INTO @TPIDS SELECT DISTINCT ATP.id,1,C.username,ACP.longlongVal FROM App_ThirdPartyApp ATP with (NOLOCK)
							INNER JOIN APP_CommCell ACC ON ATP.appName = ACC.csGUID
							INNER JOIN @CCIDS C ON C.ccId = ACC.id
							INNER JOIN APP_ComponentProp ACP on ACP.componentId = ACC.id
WHERE ATP.isEnabled  = 1 AND ATP.props.value('(/props/nameValues[@name="Enable Sso Redirect"]/@value)[1]','int') = 1 AND ATP.id NOT IN(SELECT TPIDS FROM @TPIDS) and ACP.componentType = 1048 and ACP.longVal = 1 and (ACP.longlongVal = 0 or C.commCellType = 1)
	END
	--Todo
	--both thirdparty and multicommcell should use same attribute name.
	IF @isCloudServiceCompanyUser = 1
	BEGIN
		-- In case of local user created in company in cloud service, 'Cloud service user' property won't be present in UMUsersProp table with value = 1.
		-- So remove commcell redirect option, leave either okta or saml option to user.
		DELETE TPID
		FROM @TPIDS TPID
		INNER JOIN APP_THIRDPARTYAPP TAPP WITH (NOLOCK) ON TPID.TPIDS = TAPP.ID and TAPP.isEnabled = 1 AND TAPP.APPTYPE = 3
		AND @autoCreatedUserForCloudSvc = 0
		-- In cloud Service: send username with redirects if needed to login in customer cs
		IF(@autoCreatedUserForCloudSvc = 1)
		BEGIN
			-- update username only for direct company users & not for domain users inside company
			IF EXISTS(SELECT TOP(1) 1 FROM UMUsers UM INNER JOIN UMDSProviders UMDS ON
UM.login = @USER AND UM.umdsProviderId = UMDS.id AND UMDS.serviceType = 5)
			BEGIN
				SET @userNameForCloudCustomer = SUBSTRING(@USER,charindex('\',@USER)+1,LEN(@USER))
				UPDATE @TPIDS SET username = @userNameForCloudCustomer FROM @TPIDS TP
			END
		END
		ELSE IF (@autoCreatedUserForCloudSvc = 2 AND CHARINDEX('\',@USER) > 0 )
		BEGIN
IF EXISTS (Select top 1 UM.id from UMUsers UM inner join UMDSProviders UMDS on UM.umDSproviderId = UMDS.id where UM.id = @userId and UMDS.serviceType = 5 )
				BEGIN
					IF(@ownerCompany IS NOT NULL AND @ownerCompany > 0)
					BEGIN
DECLARE @subscriberCompanyAlias nvarchar(max) = ISNULL((SELECT attrval from app_companyprop where attrname = 'Cloud Service Company MSP Subscriber Alias' and componentNameId = @ownerCompany),'')
						IF(@subscriberCompanyAlias <> '')
							SET @userNameForCloudCustomer = @subscriberCompanyAlias + '\'+SUBSTRING(@USER,charindex('\',@USER)+1,LEN(@USER))
							UPDATE @TPIDS SET username = @userNameForCloudCustomer FROM @TPIDS TP
					END
				END
		END
	END
	SET @multiCommcellAppPresent = (SELECT TOP(1) 1 FROM APP_ThirdPartyApp
									   JOIN @TPIDS tpids
									   ON tpids.TPIDS = ID and isEnabled = 1 AND APPTYPE = 3)
	SET @AVAILABLELIST = (SELECT DISTINCT CASE
								APPTYPE
										WHEN 2 THEN
										PROPS.value('(/props/nameValues[@name="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect"]/@value)[1]','nvarchar(max)')
										ELSE
										PROPS.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(max)')
										END AS 'redirectUrl',
								APPKEY AS 'appKey',
								PROPS.value('(/props/nameValues[@name="App Display Name"]/@value)[1]','nvarchar(max)') AS 'commcellName',
								CASE WHEN APPTYPE = 3 AND @getDistinctSAMLAppType = 0 THEN 2 ELSE APPTYPE END as 'appType',
								tpids.FROMREMOTECOMMCELL as 'oneWayRedirectFlag',
								tpids.username as 'username',
								tpids.commCellType as 'commCellType'
								FROM APP_THIRDPARTYAPP
								JOIN @TPIDS tpids ON tpids.TPIDS = ID and isEnabled = 1 AND ((APPTYPE = 2 AND PROPS.value('(/props/nameValues[@name="webAppType"]/@value)[1]','INT') = 1) OR APPTYPE = 3)
								FOR XML RAW ('AvailableRedirects'))
	IF NOT EXISTS (SELECT 1 FROM UMusers where id =@USER_ID and enabled =1)
		SET @USER_ID  = 0
	IF @USER_ID = 0 and  (CHARINDEX('@',@USER) > 0)
	BEGIN
		IF EXISTS (SELECT 1 FROM UMUsersServiceCommcell WHERE email = @USER)
		BEGIN
			SET @USER_ID = (SELECT UMUsers.id FROM UMUSERS INNER JOIN UMUsersServiceCommcell ON UMUsersServiceCommcell.login = UMUsers.login WHERE UMUsersServiceCommcell.email = @USER)
		END
	END
	/*
	Filling up the local commcell redirect only when the commcell is configured as router commcell and there is atleast one Service
	Commcell that has been configured for routing.
	*/
	Select @isAcsAvailableForRouting = 1
	From @CCIDS CC Inner Join APP_ComponentProp ACP On
		CC.ccId = ACP.componentId
where ACP.componentType = 1048 and ACP.longVal = 1 and ACP.longlongVal = 0
	IF(@isRouterCommcellConfigured = 1 AND @isAcsAvailableForRouting = 1)
	BEGIN
		SET @returnLocalCS = 1
		IF EXISTS(Select top 1 tpids.TPIDS from @TPIDS tpids inner join App_ThirdPartyApp ATP on ATP.id = tpids.TPIDS where appType = 2)
			SET @returnLocalCS = 0
	END
    	IF (@returnLocalCS = 1)
	BEGIN
		DECLARE @tempAppKey NVARCHAR(MAX) = ''
		IF(LEN(@truncatedUserNameCopy)= 0) -- means the supplied user is not commcell\username format.
			BEGIN
				--if there is any appType 3, and if there is a local user, then show then the local option.
				IF((@USER_ID > 0 OR @doesDomainExistsOnIDP = 1) AND @multiCommcellAppPresent = 1)
				BEGIN
					SELECT @localCommcellRedirectURL = PROPS.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(max)')  , @tempAppKey = appKey  FROM APP_THIRDPARTYAPP where appType = 4
					SET @AVAILABLELIST.modify('
					insert <AvailableRedirects isLocalCommcell="1" appKey="{sql:variable("@tempAppKey")}" appType="{sql:variable("@multiCommcellAppType")}" username="{sql:variable("@USER_SUPPLIED")}" commcellName="{sql:variable("@localCommcellName")}" redirectUrl="{sql:variable("@localCommcellRedirectURL")}" commCellType="0" />
					as first
					into (/)[1]')
				END
			END
		ELSE IF (@USER_ID > 0)
		BEGIN
			-- @truncatedUserNameCopy is present. that means localcommcell\username is supplied.
			--here always fill the isLocallCommcell entry directly.
			IF ( @AVAILABLELIST.exist('/AvailableRedirects') IS NULL )
			BEGIN
				SET @AVAILABLELIST = (SELECT 1 as '@isLocalCommcell', @multiCommcellAppType as '@appType'
									FOR XML PATH('AvailableRedirects') )
				SET @AVAILABLELIST.modify('
					insert attribute username {sql:variable("@truncatedUserNameCopy")}
					into (/AvailableRedirects)[1]')
			END
			ELSE
				SELECT @localCommcellRedirectURL =  PROPS.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(max)'), @tempAppKey = appKey  FROM APP_THIRDPARTYAPP where appType = 4
				SET @AVAILABLELIST.modify('
					insert <AvailableRedirects isLocalCommcell="1" appKey="{sql:variable("@tempAppKey")}" appType="{sql:variable("@multiCommcellAppType")}" username="{sql:variable("@truncatedUserNameCopy")}" commcellName="{sql:variable("@localCommcellName")}" redirectUrl="{sql:variable("@localCommcellRedirectURL")}" commCellType="0" />
					as first
					into (/)[1]')
		END
	END
	END
	IF @PROTOCOL & 4 = 4 AND (@AppType = 0 OR @AppType = 3)
	BEGIN
	SET  @GLOBAL_IDP = (SELECT  PROPS.value('(/props/nameValues[@name="RedirectUrl"]/@value)[1]','nvarchar(max)') AS 'redirectUrl',
								APPKEY AS 'appKey',
								PROPS.value('(/props/nameValues[@name="App Display Name"]/@value)[1]','nvarchar(max)') AS 'commcellName',
								APPTYPE as 'appType'
								FROM APP_THIRDPARTYAPP
								WHERE  isEnabled = 1 AND PROPS.value('(/props/nameValues[@name="Global IDP Commcell"]/@value)[1]','int') = 1 AND APPTYPE = 3
								FOR XML RAW ('Globalidp'))
	END
	IF @PROTOCOL & 8 = 8 AND (@AppType = 0 OR @AppType = 5)-- GET AVAILABLE OpenId Connect CLIENT IDs for
	BEGIN
		IF(@USER_ID > 0)
		BEGIN
			--List all OIDC Applications which the given user is associated with in the User mapping section
			DECLARE @AppID INT
			DECLARE @doAllowAccess TABLE(ISAllowed INT)
			DECLARE TPLIST CURSOR FOR SELECT ID FROM App_ThirdPartyApp WHERE isEnabled = 1 AND APPTYPE = 5	--OIDC
			OPEN TPLIST
			FETCH NEXT FROM TPLIST INTO @AppID
			WHILE @@FETCH_STATUS = 0
				BEGIN
					INSERT INTO @doAllowAccess EXEC DBO.MCC_ComputeMulticcappUserAssoc @USER_ID, @AppID
					IF(SELECT ISAllowed FROM @doAllowAccess) = 1
						BEGIN
						INSERT INTO @TPIDS(TPIDS) VALUES (@AppID)
						END
					FETCH NEXT FROM TPLIST INTO @AppID
					DELETE FROM @doAllowAccess
				END
			CLOSE TPLIST
			DEALLOCATE TPLIST
		END
		INSERT INTO @TPIDS SELECT ISSUERID,0,'',0 FROM App_ThirdPartyUserMappings
										   JOIN App_ThirdPartyApp ON ID = IssuerId AND APPTYPE = 5	--OIDC
							WHERE TOKENUSER = @USER AND isEnabled = 1;
		SET @AVAILABLELIST = (SELECT DISTINCT PROPS.value('(/props/nameValues[@name="clientId"]/@value)[1]','nvarchar(max)') as 'redirectUrl'
									FROM APP_THIRDPARTYAPP
									JOIN @TPIDS ON TPIDS = ID and isEnabled = 1
									for xml RAW ('AvailableRedirects'))
	END
	IF @PROTOCOL & 16 = 16 AND @webconsoleURL <> '' AND (@AppType = 0 OR @AppType = 2)  --Checking if SAML application details are queried using the webconsole URL.
	BEGIN
	SET  @SAML_IDP = (SELECT  PROPS.value('(/props/nameValues[@name="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect"]/@value)[1]','nvarchar(max)') as 'redirectUrl' ,
								APPKEY AS 'appKey',
								PROPS.value('(/props/nameValues[@name="App Display Name"]/@value)[1]','nvarchar(max)') AS 'commcellName',
								APPTYPE as 'appType'
								FROM APP_THIRDPARTYAPP
								WHERE  isEnabled = 1 AND flags & 1 = 1 AND APPTYPE = 2 AND @webconsoleURL=PROPS.value('(/props/nameValues[@name="webAppTypeVal"]/@value)[1]','nvarchar(max)')
								FOR XML RAW ('SAMLAppUrlPair'))
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @ERRORCODE     = ERROR_NUMBER()
    SET @ERRORSTRING  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
PROC_EXIT:
SET @ERRORXML = (SELECT @ERRORCODE AS '@errorCode' , @ERRORSTRING as  '@errorMessage' for xml path ('error'))
SET @XMLOUT = (SELECT  @isRouterCommcellConfigureAsGlobalIDP as '@isRouterCommcellConfigureAsGlobalIDP' ,@LAST_USED_IDP_URL , @AVAILABLELIST ,@GLOBAL_IDP,@SAML_IDP,@ERRORXML FOR XML PATH ('RedirectsForUser'))
SELECT @XMLOUT
GO

IF EXISTS (select * from GxQscripts where name = 'MCC_HandleRedirectsForUser')
	delete from GxQscripts where name = 'MCC_HandleRedirectsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MCC_HandleRedirectsForUser')
	delete from GXDBVersions where aliasname = 'MCC_HandleRedirectsForUser'
GO

insert into GXDBVersions values(2, 'MCC_HandleRedirectsForUser',  '00000000000000000000', 'MCC_HandleRedirectsForUser', '00000000000000000000')
GO

